/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.sound;

import com.cobblemon.mod.common.client.sound.instances.BattleMusicInstance;
import com.cobblemon.mod.common.util.SoundExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\r\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u0003R$\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/client/sound/BattleMusicController;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/client/sound/instances/BattleMusicInstance;", "newMusic", "", "initializeMusic", "(Lcom/cobblemon/mod/common/client/sound/instances/BattleMusicInstance;)V", "switchMusic", "endMusic", "value", "music", "Lcom/cobblemon/mod/common/client/sound/instances/BattleMusicInstance;", "getMusic", "()Lcom/cobblemon/mod/common/client/sound/instances/BattleMusicInstance;", "", "Lnet/minecraft/sounds/SoundSource;", "filteredCategories", "Ljava/util/List;", "getFilteredCategories", "()Ljava/util/List;", "Lnet/minecraft/client/sounds/SoundManager;", "kotlin.jvm.PlatformType", "manager", "Lnet/minecraft/client/sounds/SoundManager;", "common"})
@SourceDebugExtension(value={"SMAP\nBattleMusicController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleMusicController.kt\ncom/cobblemon/mod/common/client/sound/BattleMusicController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1869#2,2:61\n*S KotlinDebug\n*F\n+ 1 BattleMusicController.kt\ncom/cobblemon/mod/common/client/sound/BattleMusicController\n*L\n44#1:61,2\n*E\n"})
public final class BattleMusicController {
    @NotNull
    public static final BattleMusicController INSTANCE = new BattleMusicController();
    @NotNull
    private static BattleMusicInstance music;
    @NotNull
    private static final List<SoundSource> filteredCategories;
    private static final SoundManager manager;

    private BattleMusicController() {
    }

    @NotNull
    public final BattleMusicInstance getMusic() {
        return music;
    }

    @NotNull
    public final List<SoundSource> getFilteredCategories() {
        return filteredCategories;
    }

    public final void initializeMusic(@NotNull BattleMusicInstance newMusic) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMusic), (String)"newMusic");
        music = newMusic;
        manager.play((SoundInstance)music);
        if (manager.isActive((SoundInstance)music)) {
            Iterable $this$forEach$iv = filteredCategories;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SoundSource it = (SoundSource)element$iv;
                boolean bl = false;
                SoundManager soundManager = manager;
                Intrinsics.checkNotNullExpressionValue((Object)soundManager, (String)"manager");
                SoundExtensionsKt.pauseSounds(soundManager, null, it);
            }
            SoundManager soundManager = manager;
            Intrinsics.checkNotNullExpressionValue((Object)soundManager, (String)"manager");
            SoundExtensionsKt.resumeSounds(soundManager, music.getLocation(), SoundSource.MUSIC);
        }
    }

    public final void switchMusic(@NotNull BattleMusicInstance newMusic) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMusic), (String)"newMusic");
        manager.stop((SoundInstance)music);
        music = newMusic;
        manager.play((SoundInstance)music);
    }

    public final void endMusic() {
        music.setFade();
    }

    static {
        SoundEvent soundEvent = SoundEvents.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"EMPTY");
        music = new BattleMusicInstance(soundEvent, 0.0f, 0.0f);
        Object[] objectArray = new SoundSource[]{SoundSource.AMBIENT, SoundSource.MUSIC, SoundSource.RECORDS};
        filteredCategories = CollectionsKt.listOf((Object[])objectArray);
        manager = Minecraft.getInstance().getSoundManager();
    }
}

