/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockBoneTimeline;
import com.cobblemon.mod.common.client.render.models.blockbench.bedrock.animation.BedrockEffectKeyframe;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Bone;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011JE\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJe\u0010\u001c\u001a\u00020\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020 0\t2\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010$J/\u0010)\u001a\u00020\u000f2\b\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u0016\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010+\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010-\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b-\u0010.J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b/\u00100J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0003\u00a2\u0006\u0004\b1\u00102JJ\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0001\u00a2\u0006\u0004\b3\u00104J\u001a\u00106\u001a\u00020\u00022\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b6\u00107J\u0010\u00109\u001a\u000208H\u00d6\u0001\u00a2\u0006\u0004\b9\u0010:J\u0010\u0010;\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b;\u0010<R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010=\u001a\u0004\b>\u0010,R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010?\u001a\u0004\b@\u0010.R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010A\u001a\u0004\bB\u00100R#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010C\u001a\u0004\bD\u00102R\"\u0010E\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010<\"\u0004\bH\u0010I\u00a8\u0006J"}, d2={"Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "", "", "shouldLoop", "", "animationLength", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockEffectKeyframe;", "effects", "", "", "Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockBoneTimeline;", "boneTimelines", "<init>", "(ZDLjava/util/List;Ljava/util/Map;)V", "", "checkForErrors", "()V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "model", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "", "animationSeconds", "limbSwing", "limbSwingAmount", "ageInTicks", "intensity", "run", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FFFFF)Z", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lnet/minecraft/client/model/geom/ModelPart;", "relevantPartsByName", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;", "rootPart", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;Ljava/util/Map;Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FFFFF)Z", "Lnet/minecraft/world/entity/Entity;", "entity", "previousSeconds", "newSeconds", "applyEffects", "(Lnet/minecraft/world/entity/Entity;Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;FF)V", "component1", "()Z", "component2", "()D", "component3", "()Ljava/util/List;", "component4", "()Ljava/util/Map;", "copy", "(ZDLjava/util/List;Ljava/util/Map;)Lcom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Z", "getShouldLoop", "D", "getAnimationLength", "Ljava/util/List;", "getEffects", "Ljava/util/Map;", "getBoneTimelines", "name", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "common"})
@SourceDebugExtension(value={"SMAP\nBedrockAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BedrockAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n216#2,2:400\n216#2,2:402\n774#3:404\n865#3,2:405\n1869#3,2:407\n*S KotlinDebug\n*F\n+ 1 BedrockAnimation.kt\ncom/cobblemon/mod/common/client/render/models/blockbench/bedrock/animation/BedrockAnimation\n*L\n138#1:400,2\n201#1:402,2\n262#1:404\n262#1:405,2\n262#1:407,2\n*E\n"})
public final class BedrockAnimation {
    private final boolean shouldLoop;
    private final double animationLength;
    @NotNull
    private final List<BedrockEffectKeyframe> effects;
    @NotNull
    private final Map<String, BedrockBoneTimeline> boneTimelines;
    @NotNull
    private String name;

    public BedrockAnimation(boolean shouldLoop, double animationLength, @NotNull List<? extends BedrockEffectKeyframe> effects, @NotNull Map<String, BedrockBoneTimeline> boneTimelines) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(boneTimelines, (String)"boneTimelines");
        this.shouldLoop = shouldLoop;
        this.animationLength = animationLength;
        this.effects = effects;
        this.boneTimelines = boneTimelines;
        this.name = "";
    }

    public final boolean getShouldLoop() {
        return this.shouldLoop;
    }

    public final double getAnimationLength() {
        return this.animationLength;
    }

    @NotNull
    public final List<BedrockEffectKeyframe> getEffects() {
        return this.effects;
    }

    @NotNull
    public final Map<String, BedrockBoneTimeline> getBoneTimelines() {
        return this.boneTimelines;
    }

    public final void checkForErrors() {
        Map<String, BedrockBoneTimeline> $this$forEach$iv = this.boneTimelines;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BedrockBoneTimeline>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BedrockBoneTimeline> element$iv;
            Map.Entry<String, BedrockBoneTimeline> entry = element$iv = iterator.next();
            boolean bl = false;
            BedrockBoneTimeline timeline = entry.getValue();
            if (!timeline.getPosition().isEmpty()) {
                timeline.getPosition().resolve(2.0, MoLangExtensionsKt.getGenericRuntime());
            }
            if (!timeline.getRotation().isEmpty()) {
                timeline.getRotation().resolve(2.0, MoLangExtensionsKt.getGenericRuntime());
            }
            if (timeline.getScale().isEmpty()) continue;
            timeline.getScale().resolve(2.0, MoLangExtensionsKt.getGenericRuntime());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public final boolean run(@NotNull PosableModel model, @NotNull PosableState state, float animationSeconds, float limbSwing, float limbSwingAmount, float ageInTicks, float intensity) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.run(model.getContext(), model.getRelevantPartsByName(), model.getRootPart(), state, animationSeconds, limbSwing, limbSwingAmount, ageInTicks, intensity);
    }

    public final boolean run(@Nullable RenderContext context, @NotNull Map<String, ModelPart> relevantPartsByName, @Nullable Bone rootPart, @NotNull PosableState state, float animationSeconds, float limbSwing, float limbSwingAmount, float ageInTicks, float intensity) {
        Intrinsics.checkNotNullParameter(relevantPartsByName, (String)"relevantPartsByName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        float animationSeconds2 = 0.0f;
        animationSeconds2 = animationSeconds;
        if (this.shouldLoop) {
            animationSeconds2 %= (float)this.animationLength;
        } else if ((double)animationSeconds2 > this.animationLength && this.animationLength > 0.0) {
            return false;
        }
        MoLangRuntime runtime = state.getRuntime();
        runtime.getEnvironment().setSimpleVariable("limb_swing", new DoubleValue(limbSwing));
        runtime.getEnvironment().setSimpleVariable("limb_swing_amount", new DoubleValue(limbSwingAmount));
        runtime.getEnvironment().setSimpleVariable("age_in_ticks", new DoubleValue(ageInTicks));
        Map<String, BedrockBoneTimeline> $this$forEach$iv = this.boneTimelines;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, BedrockBoneTimeline>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            ModelPart modelPart;
            ModelPart part;
            Map.Entry<String, BedrockBoneTimeline> element$iv;
            Map.Entry<String, BedrockBoneTimeline> entry = element$iv = iterator.next();
            boolean bl = false;
            String boneName = entry.getKey();
            BedrockBoneTimeline timeline = entry.getValue();
            Object object = relevantPartsByName.get(boneName);
            if (object == null) {
                object = Intrinsics.areEqual((Object)boneName, (Object)"root_part") ? (rootPart instanceof ModelPart ? (ModelPart)rootPart : null) : null;
            }
            if ((part = object) == null) continue;
            if (!timeline.getPosition().isEmpty()) {
                Vec3 position = timeline.getPosition().resolve(animationSeconds2, runtime).scale((double)intensity);
                ModelPart $this$run_u24lambda_u240_u240 = modelPart = part;
                boolean bl2 = false;
                $this$run_u24lambda_u240_u240.x += (float)position.x;
                $this$run_u24lambda_u240_u240.y += (float)position.y;
                $this$run_u24lambda_u240_u240.z += (float)position.z;
            }
            if (!timeline.getRotation().isEmpty()) {
                try {
                    Vec3 rotation = timeline.getRotation().resolve(animationSeconds2, runtime).scale((double)intensity);
                    ModelPart $this$run_u24lambda_u240_u241 = modelPart = part;
                    boolean bl3 = false;
                    $this$run_u24lambda_u240_u241.xRot += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.x));
                    $this$run_u24lambda_u240_u241.yRot += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.y));
                    $this$run_u24lambda_u240_u241.zRot += AngleExtensionsKt.toRadians(Float.valueOf((float)rotation.z));
                }
                catch (Exception e) {
                    Object object2 = context;
                    if (object2 == null || (object2 = ((RenderContext)object2).request(RenderContext.Companion.getENTITY())) == null || (object2 = EntityExtensionsKt.effectiveName((Entity)object2)) == null || (object2 = object2.getString()) == null) {
                        object2 = "unknown entity (riding animation?)";
                    }
                    IllegalStateException exception = new IllegalStateException("Bad animation for entity: " + (String)object2, e);
                    CrashReport crash = new CrashReport("Cobblemon encountered an unexpected crash", (Throwable)exception);
                    CrashReportCategory section = crash.addCategory("Animation Details");
                    String string = state.getCurrentPose();
                    Intrinsics.checkNotNull((Object)string);
                    section.setDetail("Pose", (Object)string);
                    section.setDetail("Bone", (Object)boneName);
                    throw new ReportedException(crash);
                }
            }
            if (timeline.getScale().isEmpty()) continue;
            Vec3 scale = timeline.getScale().resolve(animationSeconds2, runtime);
            if (Intrinsics.areEqual((Object)scale, (Object)Vec3.ZERO) && (double)intensity >= 0.5) {
                ModelPart e = part;
                e.xScale *= (float)scale.x;
                e = part;
                e.yScale *= (float)scale.y;
                e = part;
                e.zScale *= (float)scale.z;
                continue;
            }
            Vec3 deviation = scale.scale(-1.0).add(1.0, 1.0, 1.0);
            Vec3 weakenedDeviation = deviation.scale((double)intensity);
            Vec3 vec3 = weakenedDeviation.subtract(1.0, 1.0, 1.0).scale(-1.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
            scale = vec3;
            ModelPart modelPart2 = part;
            modelPart2.xScale *= (float)scale.x;
            modelPart2 = part;
            modelPart2.yScale *= (float)scale.y;
            modelPart2 = part;
            modelPart2.zScale *= (float)scale.z;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void applyEffects(@Nullable Entity entity, @NotNull PosableState state, float previousSeconds, float newSeconds) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Function1 effectCondition = previousSeconds > newSeconds ? arg_0 -> BedrockAnimation.applyEffects$lambda$0(previousSeconds, newSeconds, arg_0) : arg_0 -> BedrockAnimation.applyEffects$lambda$1(previousSeconds, newSeconds, arg_0);
        Iterable $this$filter$iv = this.effects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)effectCondition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BedrockEffectKeyframe it = (BedrockEffectKeyframe)element$iv;
            boolean bl = false;
            it.run(entity, state);
        }
    }

    public final boolean component1() {
        return this.shouldLoop;
    }

    public final double component2() {
        return this.animationLength;
    }

    @NotNull
    public final List<BedrockEffectKeyframe> component3() {
        return this.effects;
    }

    @NotNull
    public final Map<String, BedrockBoneTimeline> component4() {
        return this.boneTimelines;
    }

    @NotNull
    public final BedrockAnimation copy(boolean shouldLoop, double animationLength, @NotNull List<? extends BedrockEffectKeyframe> effects, @NotNull Map<String, BedrockBoneTimeline> boneTimelines) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(boneTimelines, (String)"boneTimelines");
        return new BedrockAnimation(shouldLoop, animationLength, effects, boneTimelines);
    }

    public static /* synthetic */ BedrockAnimation copy$default(BedrockAnimation bedrockAnimation, boolean bl, double d, List list, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            bl = bedrockAnimation.shouldLoop;
        }
        if ((n & 2) != 0) {
            d = bedrockAnimation.animationLength;
        }
        if ((n & 4) != 0) {
            list = bedrockAnimation.effects;
        }
        if ((n & 8) != 0) {
            map = bedrockAnimation.boneTimelines;
        }
        return bedrockAnimation.copy(bl, d, list, map);
    }

    @NotNull
    public String toString() {
        return "BedrockAnimation(shouldLoop=" + this.shouldLoop + ", animationLength=" + this.animationLength + ", effects=" + this.effects + ", boneTimelines=" + this.boneTimelines + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.shouldLoop);
        result = result * 31 + Double.hashCode(this.animationLength);
        result = result * 31 + ((Object)this.effects).hashCode();
        result = result * 31 + ((Object)this.boneTimelines).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BedrockAnimation)) {
            return false;
        }
        BedrockAnimation bedrockAnimation = (BedrockAnimation)other;
        if (this.shouldLoop != bedrockAnimation.shouldLoop) {
            return false;
        }
        if (Double.compare(this.animationLength, bedrockAnimation.animationLength) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.effects, bedrockAnimation.effects)) {
            return false;
        }
        return Intrinsics.areEqual(this.boneTimelines, bedrockAnimation.boneTimelines);
    }

    private static final boolean applyEffects$lambda$0(float $previousSeconds, float $newSeconds, BedrockEffectKeyframe it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSeconds() >= $previousSeconds || it.getSeconds() <= $newSeconds;
    }

    private static final boolean applyEffects$lambda$1(float $previousSeconds, float $newSeconds, BedrockEffectKeyframe it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        float f = it.getSeconds();
        return $previousSeconds <= f ? f <= $newSeconds : false;
    }
}

