/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.entity;

import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.riding.Rideable;
import com.cobblemon.mod.common.client.MountedPokemonAnimationRenderController;
import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/client/render/entity/MountedLivingEntityRenderer;", "", "<init>", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemon", "Lcom/mojang/blaze3d/vertex/PoseStack;", "stack", "", "bob", "yBodyRot", "partialTicks", "i", "", "render", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/mojang/blaze3d/vertex/PoseStack;FFFF)V", "common"})
public final class MountedLivingEntityRenderer {
    @NotNull
    public static final MountedLivingEntityRenderer INSTANCE = new MountedLivingEntityRenderer();

    private MountedLivingEntityRenderer() {
    }

    public final void render(@NotNull LivingEntity entity, @NotNull PokemonEntity pokemon, @NotNull PoseStack stack, float bob, float yBodyRot, float partialTicks, float i) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!(entity.getVehicle() instanceof Rideable)) {
            return;
        }
        Matrix4f matrix = stack.last().pose();
        PokemonSideDelegate pokemonSideDelegate = pokemon.getDelegate();
        Intrinsics.checkNotNull((Object)pokemonSideDelegate, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.client.entity.PokemonClientDelegate");
        PokemonClientDelegate delegate = (PokemonClientDelegate)pokemonSideDelegate;
        MatrixWrapper locator = delegate.getLocatorStates().get(delegate.getSeatLocator((Entity)entity));
        if (locator != null) {
            MountedPokemonAnimationRenderController.INSTANCE.setup(pokemon, partialTicks);
            Vec3 playerPos = new Vec3(Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY()), Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ()));
            Vec3 entityPos = new Vec3(Mth.lerp((double)partialTicks, (double)pokemon.xOld, (double)pokemon.getX()), Mth.lerp((double)partialTicks, (double)pokemon.yOld, (double)pokemon.getY()), Mth.lerp((double)partialTicks, (double)pokemon.zOld, (double)pokemon.getZ()));
            matrix.translate((Vector3fc)playerPos.subtract(entityPos).toVector3f().negate());
            matrix.translate((Vector3fc)locator.getMatrix().getTranslation(new Vector3f()));
            Vector3f offset = new Vector3f(0.0f, entity.getBbHeight() / (float)2, 0.0f).mul(-1.0f);
            matrix.rotate(locator.getMatrix().getRotation(new AxisAngle4f()));
            matrix.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)180 + yBodyRot));
            matrix.translate((Vector3fc)offset);
            matrix.translate((Vector3fc)new Vector3f(0.0f, 0.35f, 0.0f));
        }
    }
}

