/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.boat;

import com.cobblemon.mod.common.entity.boat.CobblemonBoatEntity;
import com.cobblemon.mod.common.entity.boat.CobblemonBoatType;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ?\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0019RH\u0010\u001f\u001a6\u0012\u0004\u0012\u00020\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001c0\u001aj\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001c`\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/client/render/boat/CobblemonBoatRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "ctx", "", "hasChest", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V", "entity", "Lnet/minecraft/resources/ResourceLocation;", "getTextureLocation", "(Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;)Lnet/minecraft/resources/ResourceLocation;", "", "yaw", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "", "render", "(Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "Z", "Ljava/util/HashMap;", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "Lkotlin/Pair;", "Lnet/minecraft/client/model/BoatModel;", "Lkotlin/collections/HashMap;", "boatModels", "Ljava/util/HashMap;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonBoatRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonBoatRenderer.kt\ncom/cobblemon/mod/common/client/render/boat/CobblemonBoatRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n13805#2,2:91\n*S KotlinDebug\n*F\n+ 1 CobblemonBoatRenderer.kt\ncom/cobblemon/mod/common/client/render/boat/CobblemonBoatRenderer\n*L\n34#1:91,2\n*E\n"})
public final class CobblemonBoatRenderer
extends EntityRenderer<CobblemonBoatEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasChest;
    @NotNull
    private final HashMap<CobblemonBoatType, Pair<ResourceLocation, BoatModel>> boatModels;

    public CobblemonBoatRenderer(@NotNull EntityRendererProvider.Context ctx, boolean hasChest) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.hasChest = hasChest;
        this.boatModels = new HashMap();
        this.shadowRadius = 0.8f;
        CobblemonBoatType[] $this$forEach$iv = CobblemonBoatType.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            CobblemonBoatType element$iv;
            CobblemonBoatType type = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ((Map)this.boatModels).put(type, TuplesKt.to((Object)CobblemonBoatRenderer.Companion.generateTextureIdentifier(type, this.hasChest), (Object)CobblemonBoatRenderer.Companion.generateBoatModel(ctx, type, this.hasChest)));
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CobblemonBoatEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Pair<ResourceLocation, BoatModel> pair = this.boatModels.get((Object)entity.getBoatType());
        Intrinsics.checkNotNull(pair);
        return (ResourceLocation)pair.getFirst();
    }

    public void render(@NotNull CobblemonBoatEntity entity, float yaw, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light) {
        float k;
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        matrices.pushPose();
        matrices.translate(0.0f, 0.375f, 0.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        float h = (float)entity.getHurtTime() - tickDelta;
        float j = RangesKt.coerceAtLeast((float)(entity.getDamage() - tickDelta), (float)0.0f);
        if (h > 0.0f) {
            matrices.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)h) * h * j / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(k = entity.getBubbleAngle(tickDelta)), (float)0.0f)) {
            matrices.mulPose(new Quaternionf().setAngleAxis(entity.getBubbleAngle(tickDelta) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> pair = this.boatModels.get((Object)entity.getBoatType());
        Intrinsics.checkNotNull(pair);
        Pair<ResourceLocation, BoatModel> pair2 = pair;
        ResourceLocation identifier2 = (ResourceLocation)pair2.component1();
        BoatModel entityModel = (BoatModel)pair2.component2();
        matrices.scale(-1.0f, -1.0f, 1.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        entityModel.setupAnim((Boat)entity, tickDelta, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(entityModel.renderType(identifier2));
        entityModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        if (!entity.isUnderWater()) {
            VertexConsumer vertexConsumer2 = vertexConsumers.getBuffer(RenderType.waterMask());
            entityModel.waterPatch().render(matrices, vertexConsumer2, light, OverlayTexture.NO_OVERLAY);
        }
        matrices.popPose();
        super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/client/render/boat/CobblemonBoatRenderer$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;", "type", "", "hasChest", "Lnet/minecraft/resources/ResourceLocation;", "generateTextureIdentifier", "(Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;Z)Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "ctx", "Lnet/minecraft/client/model/BoatModel;", "generateBoatModel", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;Z)Lnet/minecraft/client/model/BoatModel;", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBoatModelLayer$common", "(Lcom/cobblemon/mod/common/entity/boat/CobblemonBoatType;Z)Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBoatModelLayer", "common"})
    public static final class Companion {
        private Companion() {
        }

        private final ResourceLocation generateTextureIdentifier(CobblemonBoatType type, boolean hasChest) {
            String boatSubPath = hasChest ? "chest_boat" : "boat";
            String string = type.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String path = "textures/entity/" + boatSubPath + "/" + string + ".png";
            return MiscUtilsKt.cobblemonResource(path);
        }

        private final BoatModel generateBoatModel(EntityRendererProvider.Context ctx, CobblemonBoatType type, boolean hasChest) {
            ModelLayerLocation modelLayer = this.createBoatModelLayer$common(type, hasChest);
            ModelPart modelPart = ctx.bakeLayer(modelLayer);
            return hasChest ? (BoatModel)new ChestBoatModel(modelPart) : new BoatModel(modelPart);
        }

        @NotNull
        public final ModelLayerLocation createBoatModelLayer$common(@NotNull CobblemonBoatType type, boolean hasChest) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            String boatSubPath = hasChest ? "chest_boat" : "boat";
            String string = type.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String path = boatSubPath + "/" + string;
            return new ModelLayerLocation(MiscUtilsKt.cobblemonResource(path), "main");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

