/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.ModAPI;
import com.cobblemon.mod.common.block.entity.LecternBlockEntity;
import com.cobblemon.mod.common.item.PokedexItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Unique;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/client/render/block/LecternBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/cobblemon/mod/common/block/entity/LecternBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "ctx", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "blockEntity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "multiBufferSource", "", "light", "overlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/LecternBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "", "MODEL_PATH", "Ljava/lang/String;", "common"})
public final class LecternBlockEntityRenderer
implements BlockEntityRenderer<LecternBlockEntity> {
    @Unique
    @NotNull
    private final String MODEL_PATH;

    public LecternBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.MODEL_PATH = Cobblemon.INSTANCE.getImplementation().getModAPI() == ModAPI.FABRIC ? "fabric_resource" : "standalone";
    }

    public void render(@NotNull LecternBlockEntity blockEntity, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)multiBufferSource, (String)"multiBufferSource");
        if (!blockEntity.isEmpty()) {
            BlockState blockState;
            if (blockEntity.getLevel() != null) {
                blockState = blockEntity.getBlockState();
            } else {
                Object object = CobblemonBlocks.CAMPFIRE.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
                blockState = (BlockState)object;
            }
            BlockState blockState2 = blockState;
            float yRot = ((Direction)blockState2.getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot();
            poseStack.pushPose();
            poseStack.translate(0.5, 1.17, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(-yRot));
            poseStack.mulPose(Axis.XP.rotationDegrees(22.5f));
            poseStack.translate(0.0, 0.0, 0.13);
            if (blockEntity.getItemStack().getItem() instanceof PokedexItem) {
                Item item = blockEntity.getItemStack().getItem();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.item.PokedexItem");
                ResourceLocation resourceLocation = ((PokedexItem)item).getType().getItemModelPath(blockEntity.hasViewer() ? "flat" : "flat_off");
                BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager().getModel(new ModelResourceLocation(resourceLocation, this.MODEL_PATH));
                Minecraft.getInstance().getItemRenderer().render(blockEntity.getItemStack(), ItemDisplayContext.GROUND, false, poseStack, multiBufferSource, light, overlay, model);
            } else {
                Minecraft.getInstance().getItemRenderer().renderStatic(blockEntity.getItemStack(), ItemDisplayContext.GROUND, light, overlay, poseStack, multiBufferSource, blockEntity.getLevel(), 0);
            }
            poseStack.popPose();
        }
    }
}

