/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.block.DisplayCaseBlock;
import com.cobblemon.mod.common.block.entity.DisplayCaseBlockEntity;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.RenderContext;
import com.cobblemon.mod.common.item.PokedexItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001e\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/client/render/block/DisplayCaseRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/cobblemon/mod/common/block/entity/DisplayCaseBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "ctx", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "entity", "", "tickDelta", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lnet/minecraft/client/renderer/MultiBufferSource;", "vertexConsumers", "", "light", "overlay", "", "render", "(Lcom/cobblemon/mod/common/block/entity/DisplayCaseBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "context", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "getContext", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/RenderContext;", "Lnet/minecraft/world/item/ItemStack;", "coinPouchStack$delegate", "Lkotlin/Lazy;", "getCoinPouchStack", "()Lnet/minecraft/world/item/ItemStack;", "coinPouchStack", "Companion", "PositioningType", "common"})
@SourceDebugExtension(value={"SMAP\nDisplayCaseRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayCaseRenderer.kt\ncom/cobblemon/mod/common/client/render/block/DisplayCaseRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public final class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderContext context;
    @NotNull
    private final Lazy coinPouchStack$delegate;
    @NotNull
    private static final List<Item> mobHeads;

    /*
     * WARNING - void declaration
     */
    public DisplayCaseRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        void it;
        RenderContext renderContext;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RenderContext renderContext2 = renderContext = new RenderContext();
        DisplayCaseRenderer displayCaseRenderer = this;
        boolean bl = false;
        it.put(RenderContext.Companion.getRENDER_STATE(), RenderContext.RenderState.WORLD);
        displayCaseRenderer.context = renderContext;
        this.coinPouchStack$delegate = LazyKt.lazy(DisplayCaseRenderer::coinPouchStack_delegate$lambda$0);
    }

    @NotNull
    public final RenderContext getContext() {
        return this.context;
    }

    @NotNull
    public final ItemStack getCoinPouchStack() {
        Lazy lazy = this.coinPouchStack$delegate;
        return (ItemStack)lazy.getValue();
    }

    public void render(@NotNull DisplayCaseBlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        ItemStack stack = entity.getStack().is((Item)CobblemonItems.RELIC_COIN_POUCH) ? this.getCoinPouchStack() : entity.getStack();
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        Level world = level;
        PositioningType posType = DisplayCaseRenderer.Companion.getPositioningType(stack, world);
        BlockState blockState = entity.getLevel() != null ? entity.getBlockState() : (BlockState)CobblemonBlocks.DISPLAY_CASE.defaultBlockState().setValue((Property)DisplayCaseBlock.Companion.getITEM_DIRECTION(), (Comparable)Direction.NORTH);
        float yRot = posType == PositioningType.ITEM_MODEL ? ((Direction)blockState.getValue((Property)DisplayCaseBlock.Companion.getITEM_DIRECTION())).getOpposite().toYRot() : ((Direction)blockState.getValue((Property)DisplayCaseBlock.Companion.getITEM_DIRECTION())).toYRot();
        matrices.pushPose();
        matrices.translate(0.5f, 0.4f, 0.5f);
        matrices.scale(posType.getScaleX(), posType.getScaleY(), posType.getScaleZ());
        matrices.translate(posType.getTransX(), posType.getTransY(), posType.getTransZ());
        matrices.mulPose(Axis.YP.rotationDegrees(-yRot));
        matrices.mulPose(Axis.YP.rotationDegrees(posType.getRotY()));
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, light, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
        matrices.popPose();
    }

    private static final ItemStack coinPouchStack_delegate$lambda$0() {
        ItemStack itemStack;
        ItemStack it = itemStack = new ItemStack((ItemLike)CobblemonItems.RELIC_COIN_POUCH);
        boolean bl = false;
        it.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        return itemStack;
    }

    static {
        Object[] objectArray = new Item[7];
        Intrinsics.checkNotNullExpressionValue((Object)Items.SKELETON_SKULL, (String)"SKELETON_SKULL");
        Intrinsics.checkNotNullExpressionValue((Object)Items.WITHER_SKELETON_SKULL, (String)"WITHER_SKELETON_SKULL");
        Intrinsics.checkNotNullExpressionValue((Object)Items.ZOMBIE_HEAD, (String)"ZOMBIE_HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)Items.PIGLIN_HEAD, (String)"PIGLIN_HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)Items.PLAYER_HEAD, (String)"PLAYER_HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)Items.DRAGON_HEAD, (String)"DRAGON_HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)Items.CREEPER_HEAD, (String)"CREEPER_HEAD");
        mobHeads = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/cobblemon/mod/common/client/render/block/DisplayCaseRenderer$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/Level;", "world", "Lcom/cobblemon/mod/common/client/render/block/DisplayCaseRenderer$PositioningType;", "getPositioningType", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;)Lcom/cobblemon/mod/common/client/render/block/DisplayCaseRenderer$PositioningType;", "", "Lnet/minecraft/world/item/Item;", "mobHeads", "Ljava/util/List;", "common"})
    public static final class Companion {
        private Companion() {
        }

        private final PositioningType getPositioningType(ItemStack stack, Level world) {
            return mobHeads.contains(stack.getItem()) ? PositioningType.MOB_HEAD : (stack.getItem() instanceof BedItem ? PositioningType.BED : (stack.getItem() instanceof BannerItem ? PositioningType.BANNER : (stack.is(CobblemonItemTags.POKE_BALLS) ? PositioningType.POKE_BALL : (stack.getItem() instanceof PokedexItem ? PositioningType.POKEDEX : (Intrinsics.areEqual((Object)stack.getItem(), (Object)CobblemonItems.RELIC_COIN_POUCH) ? PositioningType.COIN_POUCH : (Intrinsics.areEqual((Object)stack.getItem(), (Object)CobblemonItems.PASTURE) ? PositioningType.PASTURE : (Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.SHIELD) ? PositioningType.SHIELD : (Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.DECORATED_POT) ? PositioningType.MOB_HEAD : (Minecraft.getInstance().getItemRenderer().getModel(stack, world, null, 0).isGui3d() ? PositioningType.BLOCK_MODEL : PositioningType.ITEM_MODEL)))))))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u0007\n\u0002\b\u001d\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BC\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\f\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\f\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\f\u001a\u0004\b\u0012\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\f\u001a\u0004\b\u0013\u0010\u000eR\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\f\u001a\u0004\b\u0014\u0010\u000ej\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lcom/cobblemon/mod/common/client/render/block/DisplayCaseRenderer$PositioningType;", "", "", "scaleX", "scaleY", "scaleZ", "transX", "transY", "transZ", "rotY", "<init>", "(Ljava/lang/String;IFFFFFFF)V", "F", "getScaleX", "()F", "getScaleY", "getScaleZ", "getTransX", "getTransY", "getTransZ", "getRotY", "POKE_BALL", "POKEDEX", "BLOCK_MODEL", "ITEM_MODEL", "BED", "BANNER", "MOB_HEAD", "SHIELD", "PASTURE", "COIN_POUCH", "common"})
    private static final class PositioningType
    extends Enum<PositioningType> {
        private final float scaleX;
        private final float scaleY;
        private final float scaleZ;
        private final float transX;
        private final float transY;
        private final float transZ;
        private final float rotY;
        public static final /* enum */ PositioningType POKE_BALL = new PositioningType("POKE_BALL", 0, 1.0f, 1.0f, 1.0f, 0.0f, 0.04f, 0.0f, 0.0f, 64, null);
        public static final /* enum */ PositioningType POKEDEX = new PositioningType(1.0f, 1.0f, 1.0f, 0.0f, 0.04f, 0.0f, 180.0f);
        public static final /* enum */ PositioningType BLOCK_MODEL = new PositioningType("BLOCK_MODEL", 2, 1.0f, 1.0f, 1.0f, 0.0f, -0.15f, 0.0f, 0.0f, 64, null);
        public static final /* enum */ PositioningType ITEM_MODEL = new PositioningType("ITEM_MODEL", 3, 1.0f, 1.0f, 1.0f, 0.0f, 0.04f, 0.0f, 0.0f, 64, null);
        public static final /* enum */ PositioningType BED = new PositioningType("BED", 4, 1.0f, 1.0f, 1.0f, 0.0f, -0.02f, 0.0f, 0.0f, 64, null);
        public static final /* enum */ PositioningType BANNER = new PositioningType(1.0f, 1.0f, 1.0f, 0.0f, -0.02f, 0.0f, 180.0f);
        public static final /* enum */ PositioningType MOB_HEAD = new PositioningType(1.0f, 1.0f, 1.0f, 0.0f, -0.025f, 0.0f, 180.0f);
        public static final /* enum */ PositioningType SHIELD = new PositioningType(1.0f, 1.0f, 1.0f, 0.0f, -0.045f, 0.0f, 180.0f);
        public static final /* enum */ PositioningType PASTURE = new PositioningType("PASTURE", 8, 1.0f, 1.0f, 1.0f, 0.0f, 0.0375f, 0.0f, 0.0f, 64, null);
        public static final /* enum */ PositioningType COIN_POUCH = new PositioningType("COIN_POUCH", 9, 1.0f, 1.0f, 1.0f, 0.0f, 0.415f, 0.0f, 0.0f, 64, null);
        private static final /* synthetic */ PositioningType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PositioningType(float scaleX, float scaleY, float scaleZ, float transX, float transY, float transZ, float rotY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
            this.transX = transX;
            this.transY = transY;
            this.transZ = transZ;
            this.rotY = rotY;
        }

        /* synthetic */ PositioningType(String string, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x40) != 0) {
                f7 = 0.0f;
            }
            this(f, f2, f3, f4, f5, f6, f7);
        }

        public final float getScaleX() {
            return this.scaleX;
        }

        public final float getScaleY() {
            return this.scaleY;
        }

        public final float getScaleZ() {
            return this.scaleZ;
        }

        public final float getTransX() {
            return this.transX;
        }

        public final float getTransY() {
            return this.transY;
        }

        public final float getTransZ() {
            return this.transZ;
        }

        public final float getRotY() {
            return this.rotY;
        }

        public static PositioningType[] values() {
            return (PositioningType[])$VALUES.clone();
        }

        public static PositioningType valueOf(String value) {
            return Enum.valueOf(PositioningType.class, value);
        }

        @NotNull
        public static EnumEntries<PositioningType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positioningTypeArray = new PositioningType[]{PositioningType.POKE_BALL, PositioningType.POKEDEX, PositioningType.BLOCK_MODEL, PositioningType.ITEM_MODEL, PositioningType.BED, PositioningType.BANNER, PositioningType.MOB_HEAD, PositioningType.SHIELD, PositioningType.PASTURE, PositioningType.COIN_POUCH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

