/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render;

import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.client.render.ModelAssetVariation;
import com.cobblemon.mod.common.client.render.ModelLayer;
import com.cobblemon.mod.common.client.render.ModelTextureSupplier;
import com.cobblemon.mod.common.client.render.SpriteType;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Bone;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.util.adapters.ExpressionLikeAdapter;
import com.cobblemon.mod.common.util.adapters.IdentifierAdapter;
import com.cobblemon.mod.common.util.adapters.ModelTextureSupplierAdapter;
import com.cobblemon.mod.common.util.adapters.SpriteTypeAdapter;
import com.cobblemon.mod.common.util.adapters.Vector3fAdapter;
import com.cobblemon.mod.common.util.adapters.Vector4fAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0001=B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\fJ\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J:\u0010\u0017\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u00132\u0006\u0010\n\u001a\u00020\t2\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0014\u00a2\u0006\u0002\b\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020%2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b(\u0010\fJ\u001b\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b)\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010,R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010-\u001a\u0004\b.\u0010/R\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b!\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u0010$R/\u00106\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000205\u0012\u0004\u0012\u00020%048\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R#\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020:048\u0006\u00a2\u0006\f\n\u0004\b;\u00107\u001a\u0004\b<\u00109\u00a8\u0006>"}, d2={"Lcom/cobblemon/mod/common/client/render/VaryingRenderableResolver;", "", "Lnet/minecraft/resources/ResourceLocation;", "name", "", "Lcom/cobblemon/mod/common/client/render/ModelAssetVariation;", "variations", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/List;)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;", "state", "getResolvedPoser", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Lnet/minecraft/resources/ResourceLocation;", "getResolvedModel", "getResolvedTexture", "Lcom/cobblemon/mod/common/client/render/SpriteType;", "type", "getSprite", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;Lcom/cobblemon/mod/common/client/render/SpriteType;)Lnet/minecraft/resources/ResourceLocation;", "T", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "selector", "getVariationValue", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "Lcom/cobblemon/mod/common/client/render/ModelLayer;", "getResolvedLayers", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Ljava/lang/Iterable;", "", "getAllModels", "()Ljava/util/Set;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;", "repository", "", "initialize", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;)V", "Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "getPoser", "(Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableState;)Lcom/cobblemon/mod/common/client/render/models/blockbench/PosableModel;", "getTexture", "getLayers", "Lnet/minecraft/resources/ResourceLocation;", "getName", "()Lnet/minecraft/resources/ResourceLocation;", "Ljava/util/List;", "getVariations", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;", "getRepository", "()Lcom/cobblemon/mod/common/client/render/models/blockbench/repository/VaryingModelRepository;", "setRepository", "", "Lkotlin/Pair;", "posers", "Ljava/util/Map;", "getPosers", "()Ljava/util/Map;", "Lcom/cobblemon/mod/common/client/render/models/blockbench/pose/Bone;", "models", "getModels", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nVaryingRenderableResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VaryingRenderableResolver.kt\ncom/cobblemon/mod/common/client/render/VaryingRenderableResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n543#2,6:299\n774#2:305\n865#2,2:306\n1869#2,2:308\n*S KotlinDebug\n*F\n+ 1 VaryingRenderableResolver.kt\ncom/cobblemon/mod/common/client/render/VaryingRenderableResolver\n*L\n65#1:299,6\n78#1:305\n78#1:306,2\n108#1:308,2\n*E\n"})
public final class VaryingRenderableResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation name;
    @NotNull
    private final List<ModelAssetVariation> variations;
    public VaryingModelRepository repository;
    @NotNull
    private final Map<Pair<ResourceLocation, ResourceLocation>, PosableModel> posers;
    @NotNull
    private final Map<ResourceLocation, Bone> models;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)ResourceLocation.class), (Object)IdentifierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Vector3f.class), (Object)Vector3fAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Vector4f.class), (Object)Vector4fAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ModelTextureSupplier.class), (Object)ModelTextureSupplierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ExpressionLike.class), (Object)ExpressionLikeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)SpriteType.class), (Object)SpriteTypeAdapter.INSTANCE).disableHtmlEscaping().setLenient().create();

    public VaryingRenderableResolver(@NotNull ResourceLocation name, @NotNull List<ModelAssetVariation> variations) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(variations, (String)"variations");
        this.name = name;
        this.variations = variations;
        this.posers = new LinkedHashMap();
        this.models = new LinkedHashMap();
    }

    @NotNull
    public final ResourceLocation getName() {
        return this.name;
    }

    @NotNull
    public final List<ModelAssetVariation> getVariations() {
        return this.variations;
    }

    @NotNull
    public final VaryingModelRepository getRepository() {
        VaryingModelRepository varyingModelRepository = this.repository;
        if (varyingModelRepository != null) {
            return varyingModelRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
        return null;
    }

    public final void setRepository(@NotNull VaryingModelRepository varyingModelRepository) {
        Intrinsics.checkNotNullParameter((Object)varyingModelRepository, (String)"<set-?>");
        this.repository = varyingModelRepository;
    }

    @NotNull
    public final Map<Pair<ResourceLocation, ResourceLocation>, PosableModel> getPosers() {
        return this.posers;
    }

    @NotNull
    public final Map<ResourceLocation, Bone> getModels() {
        return this.models;
    }

    @NotNull
    public final ResourceLocation getResolvedPoser(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ResourceLocation resourceLocation = (ResourceLocation)this.getVariationValue(state, VaryingRenderableResolver::getResolvedPoser$lambda$0);
        if (resourceLocation == null) {
            throw new IllegalStateException("Unable to find a poser for " + this.name + " with aspects " + CollectionsKt.joinToString$default((Iterable)state.getCurrentAspects(), null, null, null, (int)0, null, null, (int)63, null) + ". This shouldn't be possible if you've defined the fallback variation.");
        }
        return resourceLocation;
    }

    @NotNull
    public final ResourceLocation getResolvedModel(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ResourceLocation resourceLocation = (ResourceLocation)this.getVariationValue(state, VaryingRenderableResolver::getResolvedModel$lambda$0);
        if (resourceLocation == null) {
            throw new IllegalStateException("Unable to find a model for " + this.name + " with aspects " + CollectionsKt.joinToString$default((Iterable)state.getCurrentAspects(), null, null, null, (int)0, null, null, (int)63, null) + ". This shouldn't be possible if you've defined the fallback variation.");
        }
        return resourceLocation;
    }

    @NotNull
    public final ResourceLocation getResolvedTexture(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ModelTextureSupplier modelTextureSupplier = (ModelTextureSupplier)this.getVariationValue(state, VaryingRenderableResolver::getResolvedTexture$lambda$0);
        if (modelTextureSupplier == null || (modelTextureSupplier = modelTextureSupplier.invoke(state)) == null) {
            throw new IllegalStateException("Unable to find a texture for " + this.name + " with aspects " + CollectionsKt.joinToString$default((Iterable)state.getCurrentAspects(), null, null, null, (int)0, null, null, (int)63, null) + ". This shouldn't be possible if you've defined the fallback variation.");
        }
        return modelTextureSupplier;
    }

    @Nullable
    public final ResourceLocation getSprite(@NotNull PosableState state, @NotNull SpriteType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Map map = (Map)this.getVariationValue(state, VaryingRenderableResolver::getSprite$lambda$0);
        return map != null ? (ResourceLocation)map.get((Object)type) : null;
    }

    private final <T> T getVariationValue(PosableState state, Function1<? super ModelAssetVariation, ? extends T> selector) {
        ModelAssetVariation modelAssetVariation;
        block1: {
            List<ModelAssetVariation> $this$lastOrNull$iv = this.variations;
            boolean $i$f$lastOrNull = false;
            ListIterator<ModelAssetVariation> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                ModelAssetVariation element$iv;
                ModelAssetVariation it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it.fits(state) && selector.invoke((Object)it) != null)) continue;
                modelAssetVariation = element$iv;
                break block1;
            }
            modelAssetVariation = null;
        }
        ModelAssetVariation modelAssetVariation2 = modelAssetVariation;
        return (T)(modelAssetVariation2 != null ? selector.invoke((Object)modelAssetVariation2) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<ModelLayer> getResolvedLayers(@NotNull PosableState state) {
        void $this$filterTo$iv$iv;
        Iterable<ModelLayer> layers;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map layerMaps = new LinkedHashMap();
        for (ModelAssetVariation variation : this.variations) {
            layers = variation.getLayers();
            if (layers == null || !variation.fits(state)) continue;
            for (ModelLayer layer : layers) {
                layerMaps.put(layer.getName(), layer);
            }
        }
        Iterable $this$filter$iv = layerMaps.values();
        boolean $i$f$filter = false;
        layers = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModelLayer p0 = (ModelLayer)element$iv$iv;
            boolean bl = false;
            if (!p0.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Set<ResourceLocation> getAllModels() {
        Set models = new LinkedHashSet();
        for (ModelAssetVariation variation : this.variations) {
            if (variation.getModel() == null) continue;
            models.add(variation.getModel());
        }
        return models;
    }

    public final void initialize(@NotNull VaryingModelRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.setRepository(repository);
        this.posers.clear();
        Iterable $this$forEach$iv = this.getAllModels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceLocation identifier2 = (ResourceLocation)element$iv;
            boolean bl = false;
            try {
                Bone bone = repository.getTexturedModels().get(identifier2);
                Intrinsics.checkNotNull((Object)bone);
                this.models.put(identifier2, bone);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load model " + identifier2 + " for " + this.name, e);
            }
        }
    }

    @NotNull
    public final PosableModel getPoser(@NotNull PosableState state) {
        PosableModel posableModel;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ResourceLocation poserName = this.getResolvedPoser(state);
        Function1<Bone, PosableModel> function1 = this.getRepository().getPosers().get(poserName);
        if (function1 == null) {
            throw new IllegalStateException("No poser found for name: " + poserName + " for " + this.name);
        }
        Function1<Bone, PosableModel> poserSupplier = function1;
        ResourceLocation modelName = this.getResolvedModel(state);
        PosableModel existingEntityModel = this.posers.get(TuplesKt.to((Object)poserName, (Object)modelName));
        if (existingEntityModel != null) {
            posableModel = existingEntityModel;
        } else {
            Bone bone = this.models.get(modelName);
            Intrinsics.checkNotNull((Object)bone);
            Bone model = bone;
            PosableModel entityModel = (PosableModel)poserSupplier.invoke((Object)model);
            entityModel.initializeLocatorAccess();
            entityModel.registerPoses();
            this.posers.put((Pair<ResourceLocation, ResourceLocation>)TuplesKt.to((Object)poserName, (Object)modelName), entityModel);
            posableModel = entityModel;
        }
        return posableModel;
    }

    @NotNull
    public final ResourceLocation getTexture(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getRepository().getPosers().get(this.getResolvedPoser(state)) == null) {
            throw new IllegalStateException("No poser for " + this.name);
        }
        return this.getResolvedTexture(state);
    }

    @NotNull
    public final Iterable<ModelLayer> getLayers(@NotNull PosableState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getRepository().getPosers().get(this.getResolvedPoser(state)) == null) {
            throw new IllegalStateException("No poser for " + this.name);
        }
        return this.getResolvedLayers(state);
    }

    private static final ResourceLocation getResolvedPoser$lambda$0(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getPoser();
    }

    private static final ResourceLocation getResolvedModel$lambda$0(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getModel();
    }

    private static final ModelTextureSupplier getResolvedTexture$lambda$0(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getTexture();
    }

    private static final Map getSprite$lambda$0(ModelAssetVariation $this$getVariationValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getVariationValue, (String)"$this$getVariationValue");
        return $this$getVariationValue.getSprites();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/client/render/VaryingRenderableResolver$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final Gson getGSON() {
            return GSON;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

