/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.render;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.ModAPI;
import com.cobblemon.mod.common.api.snowstorm.MoLangCurve;
import com.cobblemon.mod.common.api.snowstorm.ParticleCameraMode;
import com.cobblemon.mod.common.api.snowstorm.ParticleCollision;
import com.cobblemon.mod.common.api.snowstorm.ParticleMaterial;
import com.cobblemon.mod.common.api.snowstorm.ParticleViewDirection;
import com.cobblemon.mod.common.api.snowstorm.SimpleEventTrigger;
import com.cobblemon.mod.common.api.snowstorm.UVDetails;
import com.cobblemon.mod.common.client.particle.ParticleStorm;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.Matrix4fExtensionsKt;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 \u0093\u00012\u00020\u0001:\u0002\u0093\u0001BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0017\u0010\u0015J\r\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0015J\r\u0010\u0019\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u0015J\r\u0010\u001a\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001a\u0010\u0015J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010'\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u001e\u00a2\u0006\u0004\b)\u0010 J\u000f\u0010*\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b*\u0010 J'\u0010.\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\u001e\u00a2\u0006\u0004\b0\u0010 J\u0017\u00102\u001a\u00020\n2\u0006\u00101\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b2\u00103J\u000f\u00104\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b4\u0010 J\u000f\u00106\u001a\u000205H\u0016\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b8\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00109\u001a\u0004\b:\u0010;R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010<\u001a\u0004\b=\u0010>R\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010?\u001a\u0004\b@\u0010AR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u0017\u0010G\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010\u001dR\u0017\u0010J\u001a\u0002058\u0006\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u00107R\"\u0010M\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010\u0015\"\u0004\bP\u0010QR\"\u0010R\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010B\u001a\u0004\bS\u0010D\"\u0004\bT\u0010FR\"\u0010V\u001a\u00020U8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bV\u0010W\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\"\u0010\\\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\\\u0010N\u001a\u0004\b]\u0010\u0015\"\u0004\b^\u0010QR\"\u0010_\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010N\u001a\u0004\b`\u0010\u0015\"\u0004\ba\u0010QR\"\u0010b\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bb\u0010N\u001a\u0004\bc\u0010\u0015\"\u0004\bd\u0010QR\"\u0010f\u001a\u00020e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bf\u0010g\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR\"\u0010l\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bl\u0010N\u001a\u0004\bm\u0010\u0015\"\u0004\bn\u0010QR\"\u0010o\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bo\u0010N\u001a\u0004\bp\u0010\u0015\"\u0004\bq\u0010QR\"\u0010r\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\br\u0010N\u001a\u0004\bs\u0010\u0015\"\u0004\bt\u0010QR\"\u0010u\u001a\u00020e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bu\u0010g\u001a\u0004\bv\u0010i\"\u0004\bw\u0010kR\u0017\u0010y\u001a\u00020x8\u0006\u00a2\u0006\f\n\u0004\by\u0010z\u001a\u0004\b{\u0010|R#\u0010}\u001a\u00020x8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0013\n\u0004\b}\u0010z\u001a\u0004\b~\u0010|\"\u0005\b\u007f\u0010\u0080\u0001R'\u0010\u0081\u0001\u001a\u00020x8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0005\b\u0081\u0001\u0010z\u001a\u0005\b\u0082\u0001\u0010|\"\u0006\b\u0083\u0001\u0010\u0080\u0001R\u001d\u0010\u0085\u0001\u001a\u00030\u0084\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0085\u0001\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R2\u0010\u008a\u0001\u001a\u000b \u0089\u0001*\u0004\u0018\u00010\n0\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u008a\u0001\u0010\u008b\u0001\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001\"\u0006\b\u008e\u0001\u0010\u008f\u0001R)\u0010\u0090\u0001\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0090\u0001\u0010\u008b\u0001\u001a\u0006\b\u0091\u0001\u0010\u008d\u0001\"\u0006\b\u0092\u0001\u0010\u008f\u0001\u00a8\u0006\u0094\u0001"}, d2={"Lcom/cobblemon/mod/common/client/render/SnowstormParticle;", "Lnet/minecraft/client/particle/Particle;", "Lcom/cobblemon/mod/common/client/particle/ParticleStorm;", "storm", "Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "", "x", "y", "z", "Lnet/minecraft/world/phys/Vec3;", "initialVelocity", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "runtime", "Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "matrixWrapper", "", "invisible", "<init>", "(Lcom/cobblemon/mod/common/client/particle/ParticleStorm;Lnet/minecraft/client/multiplayer/ClientLevel;DDDLnet/minecraft/world/phys/Vec3;Lcom/bedrockk/molang/runtime/MoLangRuntime;Lcom/cobblemon/mod/common/client/render/MatrixWrapper;Z)V", "getX", "()D", "getY", "getZ", "getVelocityX", "getVelocityY", "getVelocityZ", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getSpriteFromAtlas", "()Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "", "applyRandoms", "()V", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vertexConsumer", "Lnet/minecraft/client/Camera;", "camera", "", "tickDelta", "render", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/client/Camera;F)V", "runExpirationEvents", "tick", "dx", "dy", "dz", "move", "(DDD)V", "updatePosition", "movement", "checkCollision", "(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "setParticleAgeInRuntime", "Lnet/minecraft/client/particle/ParticleRenderType;", "getRenderType", "()Lnet/minecraft/client/particle/ParticleRenderType;", "remove", "Lcom/cobblemon/mod/common/client/particle/ParticleStorm;", "getStorm", "()Lcom/cobblemon/mod/common/client/particle/ParticleStorm;", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "getRuntime", "()Lcom/bedrockk/molang/runtime/MoLangRuntime;", "Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "getMatrixWrapper", "()Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "Z", "getInvisible", "()Z", "setInvisible", "(Z)V", "sprite", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "getSprite", "particleTextureSheet", "Lnet/minecraft/client/particle/ParticleRenderType;", "getParticleTextureSheet", "angularVelocity", "D", "getAngularVelocity", "setAngularVelocity", "(D)V", "colliding", "getColliding", "setColliding", "Lnet/minecraft/resources/ResourceLocation;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "setTexture", "(Lnet/minecraft/resources/ResourceLocation;)V", "localX", "getLocalX", "setLocalX", "localY", "getLocalY", "setLocalY", "localZ", "getLocalZ", "setLocalZ", "Lorg/joml/Vector3d;", "rotatedLocal", "Lorg/joml/Vector3d;", "getRotatedLocal", "()Lorg/joml/Vector3d;", "setRotatedLocal", "(Lorg/joml/Vector3d;)V", "prevLocalX", "getPrevLocalX", "setPrevLocalX", "prevLocalY", "getPrevLocalY", "setPrevLocalY", "prevLocalZ", "getPrevLocalZ", "setPrevLocalZ", "prevRotatedLocal", "getPrevRotatedLocal", "setPrevRotatedLocal", "Lorg/joml/AxisAngle4d;", "currentRotation", "Lorg/joml/AxisAngle4d;", "getCurrentRotation", "()Lorg/joml/AxisAngle4d;", "oldAxisRotation", "getOldAxisRotation", "setOldAxisRotation", "(Lorg/joml/AxisAngle4d;)V", "axisRotation", "getAxisRotation", "setAxisRotation", "Lcom/cobblemon/mod/common/api/snowstorm/UVDetails;", "uvDetails", "Lcom/cobblemon/mod/common/api/snowstorm/UVDetails;", "getUvDetails", "()Lcom/cobblemon/mod/common/api/snowstorm/UVDetails;", "kotlin.jvm.PlatformType", "viewDirection", "Lnet/minecraft/world/phys/Vec3;", "getViewDirection", "()Lnet/minecraft/world/phys/Vec3;", "setViewDirection", "(Lnet/minecraft/world/phys/Vec3;)V", "originPos", "getOriginPos", "setOriginPos", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nSnowstormParticle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnowstormParticle.kt\ncom/cobblemon/mod/common/client/render/SnowstormParticle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1869#2,2:538\n1869#2,2:540\n1869#2,2:543\n1869#2,2:545\n1#3:542\n*S KotlinDebug\n*F\n+ 1 SnowstormParticle.kt\ncom/cobblemon/mod/common/client/render/SnowstormParticle\n*L\n121#1:538,2\n143#1:540,2\n238#1:543,2\n248#1:545,2\n*E\n"})
public final class SnowstormParticle
extends Particle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParticleStorm storm;
    @NotNull
    private final MoLangRuntime runtime;
    @NotNull
    private final MatrixWrapper matrixWrapper;
    private boolean invisible;
    @NotNull
    private final TextureAtlasSprite sprite;
    @NotNull
    private final ParticleRenderType particleTextureSheet;
    private double angularVelocity;
    private boolean colliding;
    @NotNull
    private ResourceLocation texture;
    private double localX;
    private double localY;
    private double localZ;
    @NotNull
    private Vector3d rotatedLocal;
    private double prevLocalX;
    private double prevLocalY;
    private double prevLocalZ;
    @NotNull
    private Vector3d prevRotatedLocal;
    @NotNull
    private final AxisAngle4d currentRotation;
    @NotNull
    private AxisAngle4d oldAxisRotation;
    @NotNull
    private AxisAngle4d axisRotation;
    @NotNull
    private final UVDetails uvDetails;
    private Vec3 viewDirection;
    @NotNull
    private Vec3 originPos;
    public static final double MAXIMUM_DISTANCE_CHANGE_PER_TICK_FOR_FRICTION = 0.005;

    public SnowstormParticle(@NotNull ParticleStorm storm, @NotNull ClientLevel world, double x, double y, double z, @NotNull Vec3 initialVelocity, @NotNull MoLangRuntime runtime, @NotNull MatrixWrapper matrixWrapper, boolean invisible) {
        Intrinsics.checkNotNullParameter((Object)((Object)storm), (String)"storm");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)initialVelocity, (String)"initialVelocity");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)matrixWrapper, (String)"matrixWrapper");
        super(world, x, y, z);
        this.storm = storm;
        this.runtime = runtime;
        this.matrixWrapper = matrixWrapper;
        this.invisible = invisible;
        this.sprite = this.getSpriteFromAtlas();
        this.texture = this.storm.getEffect().getParticle().getTexture();
        this.localX = x - this.storm.getX();
        this.localY = y - this.storm.getY();
        this.localZ = z - this.storm.getZ();
        this.rotatedLocal = new Vector3d(this.localX, this.localY, this.localZ);
        this.prevLocalX = this.localX;
        this.prevLocalY = this.localY;
        this.prevLocalZ = this.localZ;
        this.prevRotatedLocal = new Vector3d(this.localX, this.localY, this.localZ);
        this.currentRotation = new AxisAngle4d(0.0, 0.0, 1.0, 0.0);
        this.oldAxisRotation = new AxisAngle4d(0.0, 0.0, 1.0, 0.0);
        this.axisRotation = new AxisAngle4d(0.0, 0.0, 1.0, 0.0);
        this.uvDetails = new UVDetails();
        this.viewDirection = Vec3.ZERO;
        this.originPos = new Vec3(this.storm.getX(), this.storm.getY(), this.storm.getZ());
        this.setParticleSpeed(initialVelocity.x, initialVelocity.y, initialVelocity.z);
        this.oRoll = this.roll = -((float)this.storm.getEffect().getParticle().getRotation().getInitialRotation(this.runtime));
        this.angularVelocity = this.storm.getEffect().getParticle().getRotation().getInitialAngularVelocity(this.runtime);
        this.friction = 1.0f;
        this.lifetime = (int)(MoLangExtensionsKt.resolveDouble$default(this.runtime, this.storm.getEffect().getParticle().getMaxAge(), null, 2, null) * (double)20);
        this.storm.getParticles().add(this);
        this.gravity = 0.0f;
        ParticleRenderType particleRenderType = this.invisible ? ParticleRenderType.NO_RENDER : ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNull((Object)particleRenderType);
        this.particleTextureSheet = particleRenderType;
        Iterable $this$forEach$iv = this.storm.getEffect().getParticle().getCreationEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleEventTrigger it = (SimpleEventTrigger)element$iv;
            boolean bl = false;
            it.trigger(this.storm, this);
        }
    }

    public /* synthetic */ SnowstormParticle(ParticleStorm particleStorm, ClientLevel clientLevel, double d, double d2, double d3, Vec3 vec3, MoLangRuntime moLangRuntime, MatrixWrapper matrixWrapper, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            bl = false;
        }
        this(particleStorm, clientLevel, d, d2, d3, vec3, moLangRuntime, matrixWrapper, bl);
    }

    @NotNull
    public final ParticleStorm getStorm() {
        return this.storm;
    }

    @NotNull
    public final MoLangRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final MatrixWrapper getMatrixWrapper() {
        return this.matrixWrapper;
    }

    public final boolean getInvisible() {
        return this.invisible;
    }

    public final void setInvisible(boolean bl) {
        this.invisible = bl;
    }

    @NotNull
    public final TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    @NotNull
    public final ParticleRenderType getParticleTextureSheet() {
        return this.particleTextureSheet;
    }

    public final double getAngularVelocity() {
        return this.angularVelocity;
    }

    public final void setAngularVelocity(double d) {
        this.angularVelocity = d;
    }

    public final boolean getColliding() {
        return this.colliding;
    }

    public final void setColliding(boolean bl) {
        this.colliding = bl;
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    public final void setTexture(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.texture = resourceLocation;
    }

    public final double getLocalX() {
        return this.localX;
    }

    public final void setLocalX(double d) {
        this.localX = d;
    }

    public final double getLocalY() {
        return this.localY;
    }

    public final void setLocalY(double d) {
        this.localY = d;
    }

    public final double getLocalZ() {
        return this.localZ;
    }

    public final void setLocalZ(double d) {
        this.localZ = d;
    }

    @NotNull
    public final Vector3d getRotatedLocal() {
        return this.rotatedLocal;
    }

    public final void setRotatedLocal(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.rotatedLocal = vector3d;
    }

    public final double getPrevLocalX() {
        return this.prevLocalX;
    }

    public final void setPrevLocalX(double d) {
        this.prevLocalX = d;
    }

    public final double getPrevLocalY() {
        return this.prevLocalY;
    }

    public final void setPrevLocalY(double d) {
        this.prevLocalY = d;
    }

    public final double getPrevLocalZ() {
        return this.prevLocalZ;
    }

    public final void setPrevLocalZ(double d) {
        this.prevLocalZ = d;
    }

    @NotNull
    public final Vector3d getPrevRotatedLocal() {
        return this.prevRotatedLocal;
    }

    public final void setPrevRotatedLocal(@NotNull Vector3d vector3d) {
        Intrinsics.checkNotNullParameter((Object)vector3d, (String)"<set-?>");
        this.prevRotatedLocal = vector3d;
    }

    @NotNull
    public final AxisAngle4d getCurrentRotation() {
        return this.currentRotation;
    }

    @NotNull
    public final AxisAngle4d getOldAxisRotation() {
        return this.oldAxisRotation;
    }

    public final void setOldAxisRotation(@NotNull AxisAngle4d axisAngle4d) {
        Intrinsics.checkNotNullParameter((Object)axisAngle4d, (String)"<set-?>");
        this.oldAxisRotation = axisAngle4d;
    }

    @NotNull
    public final AxisAngle4d getAxisRotation() {
        return this.axisRotation;
    }

    public final void setAxisRotation(@NotNull AxisAngle4d axisAngle4d) {
        Intrinsics.checkNotNullParameter((Object)axisAngle4d, (String)"<set-?>");
        this.axisRotation = axisAngle4d;
    }

    @NotNull
    public final UVDetails getUvDetails() {
        return this.uvDetails;
    }

    public final Vec3 getViewDirection() {
        return this.viewDirection;
    }

    public final void setViewDirection(Vec3 vec3) {
        this.viewDirection = vec3;
    }

    @NotNull
    public final Vec3 getOriginPos() {
        return this.originPos;
    }

    public final void setOriginPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.originPos = vec3;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getVelocityX() {
        return this.xd;
    }

    public final double getVelocityY() {
        return this.yd;
    }

    public final double getVelocityZ() {
        return this.zd;
    }

    @NotNull
    public final TextureAtlasSprite getSpriteFromAtlas() {
        TextureAtlas atlas = Minecraft.getInstance().particleEngine.textureAtlas;
        TextureAtlasSprite sprite = atlas.getSprite(this.storm.getEffect().getParticle().getTexture());
        Intrinsics.checkNotNull((Object)sprite);
        return sprite;
    }

    private final void applyRandoms() {
        this.runtime.getEnvironment().setSimpleVariable("emitter_random_1", new DoubleValue(Random.Default.nextDouble()));
        this.runtime.getEnvironment().setSimpleVariable("emitter_random_2", new DoubleValue(Random.Default.nextDouble()));
        this.runtime.getEnvironment().setSimpleVariable("emitter_random_3", new DoubleValue(Random.Default.nextDouble()));
        this.runtime.getEnvironment().setSimpleVariable("emitter_random_4", new DoubleValue(Random.Default.nextDouble()));
    }

    public void render(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float tickDelta) {
        Vector3d vector3d;
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        if (this.invisible) {
            return;
        }
        if (Cobblemon.INSTANCE.getImplementation().getModAPI() != ModAPI.FORGE && !Minecraft.getInstance().levelRenderer.cullingFrustum.isVisible(this.getBoundingBox())) {
            return;
        }
        this.applyRandoms();
        this.setParticleAgeInRuntime();
        Iterable $this$forEach$iv = this.storm.getEffect().getCurves();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MoLangCurve it = (MoLangCurve)element$iv;
            boolean bl = false;
            it.apply(this.runtime);
        }
        this.runtime.execute(this.storm.getEffect().getParticle().getRenderExpressions());
        switch (WhenMappings.$EnumSwitchMapping$0[this.storm.getEffect().getParticle().getMaterial().ordinal()]) {
            case 1: {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                break;
            }
            case 2: {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                break;
            }
            case 3: {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                break;
            }
            case 4: {
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Vec3 vec3d = camera.getPosition();
        double interpLocalX = Mth.lerp((double)tickDelta, (double)this.prevLocalX, (double)this.localX);
        double interpLocalY = Mth.lerp((double)tickDelta, (double)this.prevLocalY, (double)this.localY);
        double interpLocalZ = Mth.lerp((double)tickDelta, (double)this.prevLocalZ, (double)this.localZ);
        if (this.storm.getEffect().getSpace().getLocalRotation()) {
            AxisAngle4d axisAngle4d;
            double interpRotation = Mth.lerp((double)tickDelta, (double)0.0, (double)this.currentRotation.angle);
            Vector3d vec = new Vector3d(interpLocalX, interpLocalY, interpLocalZ);
            this.oldAxisRotation.transform(vec);
            AxisAngle4d it = axisAngle4d = this.currentRotation.get(new AxisAngle4d());
            boolean bl = false;
            it.angle = interpRotation;
            vector3d = axisAngle4d.transform(vec);
        } else {
            vector3d = new Vector3d(interpLocalX, interpLocalY, interpLocalZ);
        }
        Vector3d pos = vector3d;
        float f = (float)(pos.x + this.originPos.x - vec3d.x());
        float g = (float)(pos.y + this.originPos.y - vec3d.y());
        float h = (float)(pos.z + this.originPos.z - vec3d.z());
        ParticleCameraMode particleCameraMode = this.storm.getEffect().getParticle().getCameraMode();
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        Vec3 vec32 = camera.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getPosition(...)");
        Quaternionf quaternionf = camera.rotation();
        Intrinsics.checkNotNullExpressionValue((Object)quaternionf, (String)"rotation(...)");
        float f2 = camera.getYRot();
        float f3 = camera.getXRot();
        Vec3 vec33 = this.viewDirection;
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"viewDirection");
        Quaternionf quaternion = particleCameraMode.getRotation(this.matrixWrapper, this.oRoll, this.roll, tickDelta, vec3, vec32, quaternionf, f2, f3, vec33);
        float xSize = (float)MoLangExtensionsKt.resolveDouble$default(this.runtime, this.storm.getEffect().getParticle().getSizeX(), null, 2, null) / 1.5f;
        float ySize = (float)MoLangExtensionsKt.resolveDouble$default(this.runtime, this.storm.getEffect().getParticle().getSizeY(), null, 2, null) / 1.5f;
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(xSize, -ySize, 0.0f), new Vector3f(xSize, ySize, 0.0f), new Vector3f(-xSize, ySize, 0.0f), new Vector3f(-xSize, -ySize, 0.0f)};
        Vector3f[] particleVertices = vector3fArray;
        for (int k = 0; k < 4; ++k) {
            Vector3f vertex = particleVertices[k];
            vertex.rotate((Quaternionfc)quaternion);
            vertex.add(f, g, h);
        }
        UVDetails uvs = this.storm.getEffect().getParticle().getUvMode().get(this.runtime, (double)this.age / 20.0, (double)this.lifetime / 20.0, this.uvDetails);
        Vector4f vector4f = (Vector4f)this.storm.getGetParticleColor().invoke();
        if (vector4f == null) {
            vector4f = this.storm.getEffect().getParticle().getTinting().getTint(this.runtime);
        }
        Vector4f colour = vector4f;
        float spriteURange = this.sprite.getU1() - this.sprite.getU0();
        float spriteVRange = this.sprite.getV1() - this.sprite.getV0();
        float minU = uvs.getStartU() * spriteURange + this.sprite.getU0();
        float maxU = uvs.getEndU() * spriteURange + this.sprite.getU0();
        float minV = uvs.getStartV() * spriteVRange + this.sprite.getV0();
        float maxV = uvs.getEndV() * spriteVRange + this.sprite.getV0();
        int p = this.storm.getEffect().getParticle().getEnvironmentLighting() ? this.getLightColor(tickDelta) : 0xF000F0;
        vertexConsumer.addVertex(particleVertices[0].x, particleVertices[0].y, particleVertices[0].z).setUv(maxU, maxV).setColor(colour.x, colour.y, colour.z, colour.w).setLight(p);
        vertexConsumer.addVertex(particleVertices[1].x, particleVertices[1].y, particleVertices[1].z).setUv(maxU, minV).setColor(colour.x, colour.y, colour.z, colour.w).setLight(p);
        vertexConsumer.addVertex(particleVertices[2].x, particleVertices[2].y, particleVertices[2].z).setUv(minU, minV).setColor(colour.x, colour.y, colour.z, colour.w).setLight(p);
        vertexConsumer.addVertex(particleVertices[3].x, particleVertices[3].y, particleVertices[3].z).setUv(minU, maxV).setColor(colour.x, colour.y, colour.z, colour.w).setLight(p);
    }

    public final void runExpirationEvents() {
        Iterable $this$forEach$iv = this.storm.getEffect().getParticle().getExpirationEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleEventTrigger it = (SimpleEventTrigger)element$iv;
            boolean bl = false;
            it.trigger(this.storm, this);
        }
    }

    public void tick() {
        if (this.storm.getEffect().getSpace().getLocalPosition()) {
            this.originPos = this.matrixWrapper.getOrigin();
        }
        this.applyRandoms();
        this.setParticleAgeInRuntime();
        Iterable $this$forEach$iv = this.storm.getEffect().getCurves();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MoLangCurve it = (MoLangCurve)element$iv;
            boolean bl = false;
            it.apply(this.runtime);
        }
        this.runtime.execute(this.storm.getEffect().getParticle().getUpdateExpressions());
        this.angularVelocity = this.storm.getEffect().getParticle().getRotation().getAngularVelocity(this.runtime, -((double)this.roll), this.angularVelocity) / (double)20;
        if (this.age >= this.lifetime || MoLangExtensionsKt.resolveBoolean$default(this.runtime, this.storm.getEffect().getParticle().getKillExpression(), null, 2, null)) {
            this.runExpirationEvents();
            this.remove();
            return;
        }
        Vec3 velocity = this.storm.getEffect().getParticle().getMotion().getVelocity(this.runtime, this, new Vec3(this.xd, this.yd, this.zd));
        this.xd = velocity.x;
        this.yd = velocity.y;
        this.zd = velocity.z;
        this.oRoll = this.roll;
        this.roll = this.oRoll - (float)this.angularVelocity;
        ParticleViewDirection particleViewDirection = this.storm.getEffect().getParticle().getViewDirection();
        Vec3 vec3 = this.viewDirection;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"viewDirection");
        this.viewDirection = particleViewDirection.getDirection(this.runtime, vec3, new Vec3(this.xd, this.yd, this.zd)).normalize();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.prevLocalX = this.localX;
        this.prevLocalY = this.localY;
        this.prevLocalZ = this.localZ;
        this.oldAxisRotation = this.axisRotation;
        Vector3d vector3d = this.oldAxisRotation.transform(new Vector3d(this.prevLocalX, this.prevLocalY, this.prevLocalZ));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"transform(...)");
        this.prevRotatedLocal = vector3d;
        AxisAngle4d axisAngle4d = this.storm.getEffect().getSpace().getLocalRotation() ? this.storm.getAttachedMatrix().getMatrix().getRotation(this.axisRotation) : this.matrixWrapper.getMatrix().getRotation(this.axisRotation);
        Vector3d vector3d2 = this.axisRotation.transform(new Vector3d(this.prevLocalX, this.prevLocalY, this.prevLocalZ));
        Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"transform(...)");
        this.rotatedLocal = vector3d2;
        new Quaterniond().rotateTo((Vector3dc)this.prevRotatedLocal, (Vector3dc)this.rotatedLocal).get(this.currentRotation);
        int n = this.age;
        this.age = n + 1;
        this.move(this.xd, this.yd, this.zd);
        this.storm.getEffect().getParticle().getTimeline().check(this.storm, this, (double)(this.age - 1) / 20.0, (double)this.age / 20.0);
    }

    public void move(double dx, double dy, double dz) {
        ParticleCollision collision = this.storm.getEffect().getParticle().getCollision();
        double radius = MoLangExtensionsKt.resolveDouble$default(this.runtime, collision.getRadius(), null, 2, null);
        this.setBoundingBox(AABB.ofSize((Vec3)new Vec3(this.x, this.y, this.z), (double)radius, (double)radius, (double)radius));
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            this.updatePosition();
            return;
        }
        double dx2 = dx;
        double dy2 = dy;
        double dz2 = dz;
        if (MoLangExtensionsKt.resolveBoolean$default(this.runtime, collision.getEnabled(), null, 2, null) && radius > 0.0 && !this.storm.getEffect().getSpace().isLocalSpace()) {
            this.hasPhysics = true;
            Vec3 newMovement = this.checkCollision(new Vec3(dx2, dy2, dz2));
            if (this.removed) {
                return;
            }
            dx2 = newMovement.x;
            dy2 = newMovement.y;
            dz2 = newMovement.z;
            if (!(dx2 == 0.0 && dy2 == 0.0 && dz2 == 0.0)) {
                this.setBoundingBox(this.getBoundingBox().move(dx2, dy2, dz2));
                this.localX += dx2;
                this.localY += dy2;
                this.localZ += dz2;
            }
        } else {
            this.hasPhysics = false;
            if (!(dx2 == 0.0 && dy2 == 0.0 && dz2 == 0.0)) {
                this.localX += dx2;
                this.localY += dy2;
                this.localZ += dz2;
            }
        }
        this.updatePosition();
    }

    public final void updatePosition() {
        Vec3 localVector = this.storm.getEffect().getSpace().getLocalRotation() ? Matrix4fExtensionsKt.transformDirection(this.storm.getAttachedMatrix().getMatrix(), new Vec3(this.localX, this.localY, this.localZ)) : new Vec3(this.localX, this.localY, this.localZ);
        this.x = localVector.x + this.originPos.x;
        this.y = localVector.y + this.originPos.y;
        this.z = localVector.z + this.originPos.z;
    }

    private final Vec3 checkCollision(Vec3 movement) {
        boolean mostlyIsZMovement;
        ParticleCollision collision = this.storm.getEffect().getParticle().getCollision();
        AABB box = this.getBoundingBox();
        double bounciness = MoLangExtensionsKt.resolveDouble$default(this.runtime, collision.getBounciness(), null, 2, null);
        double friction = MoLangExtensionsKt.resolveDouble$default(this.runtime, collision.getFriction(), null, 2, null);
        boolean expiresOnContact = collision.getExpiresOnContact();
        Iterable collisions = this.level.getBlockCollisions(null, box.expandTowards(movement));
        Intrinsics.checkNotNull((Object)collisions);
        if (CollectionsKt.none((Iterable)collisions)) {
            this.colliding = false;
            return movement;
        }
        if (expiresOnContact) {
            this.runExpirationEvents();
            this.remove();
            return movement;
        }
        double xMovement = movement.x;
        double yMovement = movement.y;
        double zMovement = movement.z;
        boolean bouncing = false;
        boolean sliding = false;
        if (!(yMovement == 0.0)) {
            if (!((yMovement = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)box, (Iterable)collisions, (double)yMovement)) == 0.0)) {
                box = box.move(0.0, 0.0, zMovement);
            } else if (bounciness > 0.0 && Math.abs(movement.y) > 0.005) {
                this.yd *= (double)-1 * bounciness;
                yMovement = (double)-1 * bounciness * movement.y;
                bouncing = true;
            } else if (friction > 0.0) {
                sliding = true;
                this.yd = 0.0;
            } else {
                this.yd = 0.0;
            }
        }
        boolean bl = mostlyIsZMovement = Math.abs(xMovement) < Math.abs(zMovement);
        if (mostlyIsZMovement && !(zMovement == 0.0)) {
            if (!((zMovement = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)box, (Iterable)collisions, (double)zMovement)) == 0.0)) {
                box = box.move(0.0, 0.0, zMovement);
            } else if (bounciness > 0.0 && Math.abs(movement.z) > 0.005) {
                this.zd *= (double)-1 * bounciness;
                zMovement = (double)-1 * bounciness * movement.z;
                bouncing = true;
            } else if (friction > 0.0) {
                sliding = true;
                this.zd = 0.0;
            } else {
                this.zd = 0.0;
            }
        }
        if (!(xMovement == 0.0)) {
            xMovement = Shapes.collide((Direction.Axis)Direction.Axis.X, (AABB)box, (Iterable)collisions, (double)xMovement);
            if (!mostlyIsZMovement && !(xMovement == 0.0)) {
                box = box.move(xMovement, 0.0, 0.0);
            } else if (bounciness > 0.0 && Math.abs(movement.x) > 0.005) {
                this.xd *= (double)-1 * bounciness;
                xMovement = (double)-1 * bounciness * movement.x;
                bouncing = true;
            } else if (friction > 0.0) {
                sliding = true;
                this.zd = 0.0;
            } else {
                this.zd = 0.0;
            }
        }
        if (!mostlyIsZMovement && !(zMovement == 0.0) && (zMovement = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)box, (Iterable)collisions, (double)zMovement)) == 0.0) {
            if (bounciness > 0.0 && Math.abs(movement.z) > 0.005) {
                this.zd *= (double)-1 * bounciness;
                zMovement = (double)-1 * bounciness * movement.z;
                bouncing = true;
            } else if (friction > 0.0) {
                sliding = true;
                this.zd = 0.0;
            } else {
                this.zd = 0.0;
            }
        }
        Vec3 newMovement = new Vec3(xMovement, yMovement, zMovement);
        if (sliding && !bouncing) {
            Vec3 vec3 = newMovement.length() * (double)20 < friction ? Vec3.ZERO : newMovement.subtract(newMovement.normalize().scale(friction / (double)20));
            Intrinsics.checkNotNull((Object)vec3);
            newMovement = vec3;
            Vec3 velocity = new Vec3(this.xd, this.yd, this.zd);
            if (velocity.length() * (double)20 < friction) {
                this.setParticleSpeed(0.0, 0.0, 0.0);
            } else {
                Vec3 vec32 = velocity.subtract(velocity.normalize().scale(friction / (double)20));
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"subtract(...)");
                velocity = vec32;
                this.setParticleSpeed(velocity.x, velocity.y, velocity.z);
            }
        }
        return newMovement;
    }

    private final void setParticleAgeInRuntime() {
        this.runtime.getEnvironment().variable.setDirectly("particle_age", new DoubleValue((double)this.age / 20.0));
        this.runtime.getEnvironment().variable.setDirectly("particle_lifetime", new DoubleValue((double)this.lifetime / 20.0));
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.particleTextureSheet;
    }

    public void remove() {
        super.remove();
        this.storm.getParticles().remove((Object)this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cobblemon/mod/common/client/render/SnowstormParticle$Companion;", "", "<init>", "()V", "", "MAXIMUM_DISTANCE_CHANGE_PER_TICK_FOR_FRICTION", "D", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParticleMaterial.values().length];
            try {
                nArray[ParticleMaterial.ALPHA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleMaterial.OPAQUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleMaterial.BLEND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleMaterial.ADD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

