/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.particle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.snowstorm.BedrockParticleOptions;
import com.cobblemon.mod.common.particle.SnowstormParticleReader;
import com.cobblemon.mod.common.util.IdentifierExtensionsKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u001c\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/client/particle/BedrockParticleOptionsRepository;", "", "<init>", "()V", "Lnet/minecraft/server/packs/resources/ResourceManager;", "resourceManager", "", "loadEffects", "(Lnet/minecraft/server/packs/resources/ResourceManager;)V", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lcom/cobblemon/mod/common/api/snowstorm/BedrockParticleOptions;", "getEffect", "(Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/api/snowstorm/BedrockParticleOptions;", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "", "effects", "Ljava/util/Map;", "common"})
public final class BedrockParticleOptionsRepository {
    @NotNull
    public static final BedrockParticleOptionsRepository INSTANCE = new BedrockParticleOptionsRepository();
    private static final Gson GSON = new GsonBuilder().create();
    @NotNull
    private static final Map<ResourceLocation, BedrockParticleOptions> effects = new LinkedHashMap();

    private BedrockParticleOptionsRepository() {
    }

    public final void loadEffects(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Cobblemon.LOGGER.info("Loading particle effects...");
        effects.clear();
        resourceManager.listResources("bedrock/particles", BedrockParticleOptionsRepository::loadEffects$lambda$0).forEach((arg_0, arg_1) -> BedrockParticleOptionsRepository.loadEffects$lambda$2(BedrockParticleOptionsRepository::loadEffects$lambda$1, arg_0, arg_1));
        Cobblemon.LOGGER.info("Loaded " + effects.size() + " particle effects");
    }

    @Nullable
    public final BedrockParticleOptions getEffect(@NotNull ResourceLocation identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        return effects.get(identifier2);
    }

    private static final boolean loadEffects$lambda$0(ResourceLocation path) {
        Intrinsics.checkNotNull((Object)path);
        return IdentifierExtensionsKt.endsWith(path, ".particle.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit loadEffects$lambda$1(ResourceLocation identifier2, Resource resource) {
        try {
            Closeable closeable = resource.open();
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray = stream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String json = new String(byArray2, charset2);
                Object object = GSON.fromJson(json, JsonObject.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                BedrockParticleOptions effect = SnowstormParticleReader.INSTANCE.loadEffect((JsonObject)object);
                effects.put(effect.getId(), effect);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Cobblemon.LOGGER.error((Object)e);
        }
        return Unit.INSTANCE;
    }

    private static final void loadEffects$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

