/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.summary.widgets;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.net.messages.server.pokemon.update.SetNicknamePacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ/\u0010$\u001a\u00020\u00102\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J'\u0010)\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b)\u0010*R\"\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010\u0012R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010/\u001a\u0004\b\u000b\u00100R\"\u00101\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u0010\u001fR\"\u00107\u001a\u0002068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lcom/cobblemon/mod/common/client/gui/summary/widgets/NicknameEntryWidget;", "Lnet/minecraft/client/gui/components/EditBox;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "x", "y", "width", "height", "", "isParty", "Lnet/minecraft/network/chat/Component;", "text", "<init>", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;IIIIZLnet/minecraft/network/chat/Component;)V", "", "setSelectedPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "mouseX", "mouseY", "button", "mouseClicked", "(DDI)Z", "focused", "setFocused", "(Z)V", "", "newNickname", "updateNickname", "(Ljava/lang/String;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "delta", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "setPokemon", "Z", "()Z", "pokemonName", "Ljava/lang/String;", "getPokemonName", "()Ljava/lang/String;", "setPokemonName", "", "focusedTime", "J", "getFocusedTime", "()J", "setFocusedTime", "(J)V", "common"})
@SourceDebugExtension(value={"SMAP\nNicknameEntryWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NicknameEntryWidget.kt\ncom/cobblemon/mod/common/client/gui/summary/widgets/NicknameEntryWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class NicknameEntryWidget
extends EditBox
implements CobblemonRenderable {
    @NotNull
    private Pokemon pokemon;
    private final boolean isParty;
    @NotNull
    private String pokemonName;
    private long focusedTime;

    public NicknameEntryWidget(@NotNull Pokemon pokemon, int x, int y, int width, int height, boolean isParty, @NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(Minecraft.getInstance().font, x, y, width, height, text);
        this.pokemon = pokemon;
        this.isParty = isParty;
        this.pokemonName = "";
        this.setMaxLength(12);
        this.setSelectedPokemon(this.pokemon);
        this.focusedTime = Util.getMillis();
    }

    @NotNull
    public final Pokemon getPokemon() {
        return this.pokemon;
    }

    public final void setPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"<set-?>");
        this.pokemon = pokemon;
    }

    public final boolean isParty() {
        return this.isParty;
    }

    @NotNull
    public final String getPokemonName() {
        return this.pokemonName;
    }

    public final void setPokemonName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pokemonName = string;
    }

    public final long getFocusedTime() {
        return this.focusedTime;
    }

    public final void setFocusedTime(long l) {
        this.focusedTime = l;
    }

    public final void setSelectedPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (this.isFocused()) {
            this.setFocused(false);
        }
        this.pokemon = pokemon;
        String string = I18n.get((String)pokemon.getSpecies().getTranslatedName().getString(), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        this.pokemonName = string;
        this.setResponder(arg_0 -> NicknameEntryWidget.setSelectedPokemon$lambda$0(this, arg_0));
        this.setValue(Pokemon.getDisplayName$default(pokemon, false, 1, null).getString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int n = this.getX();
        int n2 = this.getX() + this.width;
        int n3 = (int)mouseX;
        if (n > n3) return false;
        if (n3 > n2) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.getY();
        n2 = this.getY() + this.height;
        n3 = (int)mouseY;
        if (n > n3) return false;
        if (n3 > n2) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        this.setFocused(true);
        return true;
    }

    public void setFocused(boolean focused) {
        CharSequence charSequence;
        super.setFocused(focused);
        this.focusedTime = Util.getMillis();
        NicknameEntryWidget nicknameEntryWidget = this;
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            NicknameEntryWidget nicknameEntryWidget2 = nicknameEntryWidget;
            boolean bl = false;
            charSequence = this.pokemonName;
            nicknameEntryWidget = nicknameEntryWidget2;
        } else {
            charSequence = charSequence2;
        }
        nicknameEntryWidget.setValue((String)charSequence);
        if (!focused) {
            String string2 = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            this.updateNickname(string2);
        }
    }

    private final void updateNickname(String newNickname) {
        block3: {
            block2: {
                if (this.pokemon.getNickname() == null) break block2;
                MutableComponent mutableComponent = this.pokemon.getNickname();
                if (Intrinsics.areEqual((Object)(mutableComponent != null ? mutableComponent.getString() : null), (Object)newNickname)) break block3;
            }
            String effectiveNickname = Intrinsics.areEqual((Object)newNickname, (Object)this.pokemonName) ? null : newNickname;
            UUID uUID = this.pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            UUID uUID2 = uUID;
            boolean bl = this.isParty;
            CobblemonNetwork.sendToServer(new SetNicknamePacket(uUID2, bl, effectiveNickname));
        }
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean showCursor = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L;
        MutableComponent name = TextKt.bold(TextKt.text(this.getValue() + (this.getCursorPosition() == this.getValue().length() && showCursor ? "_" : "")));
        RenderHelperKt.drawScaledText$default(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), name, this.getX(), this.getY(), 0.0f, null, 0, 0, false, true, null, null, 7136, null);
        if (showCursor) {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (!(((CharSequence)string).length() == 0) && this.getCursorPosition() != this.getValue().length()) {
                Font font = Minecraft.getInstance().font;
                String string2 = name.getString(this.getCursorPosition());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                MutableComponent mutableComponent = TextKt.bold(TextKt.text(string2));
                ResourceLocation resourceLocation = CobblemonResources.INSTANCE.getDEFAULT_LARGE();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-DEFAULT_LARGE>(...)");
                int startToCursorWidth = font.width((FormattedText)TextKt.font(mutableComponent, resourceLocation));
                context.fill(RenderType.guiTextHighlight(), this.getX() + startToCursorWidth - 1, this.getY(), this.getX() + startToCursorWidth, this.getY() + 9, -3092272);
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            CharSequence charSequence;
            NicknameEntryWidget nicknameEntryWidget = this;
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                NicknameEntryWidget nicknameEntryWidget2 = nicknameEntryWidget;
                boolean bl = false;
                charSequence = this.pokemonName;
                nicknameEntryWidget = nicknameEntryWidget2;
            } else {
                charSequence = charSequence2;
            }
            nicknameEntryWidget.updateNickname((String)charSequence);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static final void setSelectedPokemon$lambda$0(NicknameEntryWidget this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        if (!StringsKt.isBlank((CharSequence)it)) {
            this$0.updateNickname(it);
        } else {
            this$0.updateNickname(this$0.pokemonName);
        }
    }
}

