/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.interact.wheel;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.interaction.PokemonInteractionGUICreationEvent;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ClientBattleChallenge;
import com.cobblemon.mod.common.client.battle.ClientTeamRequest;
import com.cobblemon.mod.common.client.gui.interact.battleRequest.BattleConfigureGUI;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractTypePokemon;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelGUI;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.cobblemon.mod.common.client.gui.interact.wheel.Orientation;
import com.cobblemon.mod.common.client.trade.ClientTradeRequest;
import com.cobblemon.mod.common.net.messages.client.PlayerInteractOptionsPacket;
import com.cobblemon.mod.common.net.messages.server.battle.SpectateBattlePacket;
import com.cobblemon.mod.common.net.messages.server.pokemon.interact.InteractPokemonPacket;
import com.cobblemon.mod.common.net.messages.server.trade.AcceptTradeRequestPacket;
import com.cobblemon.mod.common.net.messages.server.trade.OfferTradePacket;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a5\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ljava/util/UUID;", "pokemonID", "", "canMountShoulder", "canGiveHeld", "canGiveCosmetic", "canRide", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI;", "createPokemonInteractGui", "(Ljava/util/UUID;ZZZZ)Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI;", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;", "optionsPacket", "createPlayerInteractGui", "(Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket;)Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI;", "Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$OptionStatus;", "status", "", "getLangKey", "(Lcom/cobblemon/mod/common/net/messages/client/PlayerInteractOptionsPacket$OptionStatus;)Ljava/lang/String;", "", "closeGUI", "()V", "common"})
@SourceDebugExtension(value={"SMAP\nInteractWheelGuiFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractWheelGuiFactory.kt\ncom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGuiFactoryKt\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,191:1\n14#2,5:192\n19#2:200\n13805#3:197\n13806#3:199\n14#4:198\n216#5,2:201\n*S KotlinDebug\n*F\n+ 1 InteractWheelGuiFactory.kt\ncom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGuiFactoryKt\n*L\n82#1:192,5\n82#1:200\n82#1:197\n82#1:199\n82#1:198\n141#1:201,2\n*E\n"})
public final class InteractWheelGuiFactoryKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InteractWheelGUI createPokemonInteractGui(@NotNull UUID pokemonID, boolean canMountShoulder, boolean canGiveHeld, boolean canGiveCosmetic, boolean canRide) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)pokemonID, (String)"pokemonID");
        ResourceLocation resourceLocation = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_shoulder.png");
        InteractWheelOption mountShoulder = new InteractWheelOption(resourceLocation, null, canMountShoulder, "cobblemon.ui.interact.mount.shoulder", null, () -> InteractWheelGuiFactoryKt.createPokemonInteractGui$lambda$0(canMountShoulder, pokemonID), 18, null);
        ResourceLocation resourceLocation2 = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_held_item.png");
        InteractWheelOption giveHeldItem = new InteractWheelOption(resourceLocation2, null, canGiveHeld, "cobblemon.ui.interact.give.item", null, () -> InteractWheelGuiFactoryKt.createPokemonInteractGui$lambda$1(canGiveHeld, pokemonID), 18, null);
        ResourceLocation resourceLocation3 = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_cosmetic_item.png");
        InteractWheelOption giveCosmeticItem = new InteractWheelOption(resourceLocation3, null, canGiveCosmetic, "cobblemon.ui.interact.give.cosmetic_item", null, () -> InteractWheelGuiFactoryKt.createPokemonInteractGui$lambda$2(canGiveCosmetic, pokemonID), 18, null);
        ResourceLocation resourceLocation4 = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_ride.png");
        InteractWheelOption ride = new InteractWheelOption(resourceLocation4, null, canRide, "cobblemon.ui.interact.ride", null, () -> InteractWheelGuiFactoryKt.createPokemonInteractGui$lambda$3(canRide, pokemonID), 18, null);
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
        Multimap options = (Multimap)arrayListMultimap;
        options.put((Object)Orientation.NORTH, (Object)giveHeldItem);
        options.put((Object)Orientation.NORTHEAST, (Object)giveCosmeticItem);
        options.put((Object)Orientation.WEST, (Object)ride);
        options.put((Object)Orientation.NORTHWEST, (Object)mountShoulder);
        EventObservable<PokemonInteractionGUICreationEvent> eventObservable = CobblemonEvents.POKEMON_INTERACTION_GUI_CREATION;
        PokemonInteractionGUICreationEvent[] pokemonInteractionGUICreationEventArray = new PokemonInteractionGUICreationEvent[]{new PokemonInteractionGUICreationEvent(pokemonID, canMountShoulder, canGiveHeld, canGiveCosmetic, canRide, (Multimap<Orientation, InteractWheelOption>)options)};
        PokemonInteractionGUICreationEvent[] events$iv = pokemonInteractionGUICreationEventArray;
        boolean $i$f$post = false;
        $this$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
        PokemonInteractionGUICreationEvent[] $this$forEach$iv$iv = events$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            PokemonInteractionGUICreationEvent element$iv$iv;
            PokemonInteractionGUICreationEvent pokemonInteractionGUICreationEvent = element$iv$iv = $this$forEach$iv$iv[i];
            boolean bl = false;
            PokemonInteractionGUICreationEvent it = pokemonInteractionGUICreationEvent;
        }
        MutableComponent mutableComponent = Component.translatable((String)"cobblemon.ui.interact.pokemon");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return new InteractWheelGUI((Multimap<Orientation, InteractWheelOption>)options, (Component)mutableComponent);
    }

    @NotNull
    public static final InteractWheelGUI createPlayerInteractGui(@NotNull PlayerInteractOptionsPacket optionsPacket) {
        Intrinsics.checkNotNullParameter((Object)optionsPacket, (String)"optionsPacket");
        ResourceLocation resourceLocation = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_trade.png");
        ResourceLocation resourceLocation2 = CobblemonClient.INSTANCE.getRequests().getTradeOffers().get(optionsPacket.getTargetId()) != null ? MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_exclamation.png") : null;
        InteractWheelOption trade = new InteractWheelOption(resourceLocation, resourceLocation2, false, "cobblemon.ui.interact.trade", InteractWheelGuiFactoryKt::createPlayerInteractGui$lambda$0, () -> InteractWheelGuiFactoryKt.createPlayerInteractGui$lambda$1(optionsPacket), 4, null);
        ClientBattleChallenge activeBattleRequest = CobblemonClient.INSTANCE.getRequests().getBattleChallenges().get(optionsPacket.getTargetId());
        ClientTeamRequest activeTeamRequest = CobblemonClient.INSTANCE.getRequests().getMultiBattleTeamRequests().get(optionsPacket.getTargetId());
        ResourceLocation resourceLocation3 = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_battle.png");
        ResourceLocation resourceLocation4 = activeBattleRequest != null || activeTeamRequest != null ? MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_exclamation.png") : null;
        InteractWheelOption battle = new InteractWheelOption(resourceLocation3, resourceLocation4, false, "cobblemon.ui.interact.battle", InteractWheelGuiFactoryKt::createPlayerInteractGui$lambda$2, () -> InteractWheelGuiFactoryKt.createPlayerInteractGui$lambda$3(optionsPacket, activeBattleRequest, activeTeamRequest), 4, null);
        resourceLocation4 = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_spectate_battle.png");
        InteractWheelOption spectate = new InteractWheelOption(resourceLocation4, null, false, "cobblemon.ui.interact.spectate", () -> InteractWheelGuiFactoryKt.createPlayerInteractGui$lambda$4(optionsPacket), () -> InteractWheelGuiFactoryKt.createPlayerInteractGui$lambda$5(optionsPacket), 6, null);
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)arrayListMultimap, (String)"create(...)");
        Multimap options = (Multimap)arrayListMultimap;
        boolean hasChallenge = CobblemonClient.INSTANCE.getRequests().getBattleChallenges().get(optionsPacket.getTargetId()) != null;
        boolean hasTeamRequest = CobblemonClient.INSTANCE.getRequests().getMultiBattleTeamRequests().get(optionsPacket.getTargetId()) != null;
        boolean addBattleOption = false;
        Map $this$forEach$iv = optionsPacket.getOptions();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            String string;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            if (!addBattleOption && (hasChallenge || hasTeamRequest || BattleConfigureGUI.Companion.getBattleRequestMap().containsKey(it.getKey()))) {
                if (it.getValue() == PlayerInteractOptionsPacket.OptionStatus.AVAILABLE) {
                    options.put((Object)Orientation.NORTH, (Object)battle);
                    addBattleOption = true;
                } else {
                    ResourceLocation resourceLocation5 = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_battle.png");
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                    string = InteractWheelGuiFactoryKt.getLangKey((PlayerInteractOptionsPacket.OptionStatus)((Object)v));
                    options.put((Object)Orientation.NORTH, (Object)new InteractWheelOption(resourceLocation5, null, false, string, InteractWheelGuiFactoryKt::createPlayerInteractGui$lambda$6$0, InteractWheelGuiFactoryKt::createPlayerInteractGui$lambda$6$1, 4, null));
                }
            }
            if (it.getKey() == PlayerInteractOptionsPacket.Options.SPECTATE_BATTLE && !hasChallenge) {
                options.put((Object)Orientation.NORTH, (Object)spectate);
            }
            if (it.getKey() != PlayerInteractOptionsPacket.Options.TRADE) continue;
            if (it.getValue() == PlayerInteractOptionsPacket.OptionStatus.AVAILABLE) {
                bl = options.put((Object)Orientation.NORTHEAST, (Object)trade);
                continue;
            }
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            String langKey = InteractWheelGuiFactoryKt.getLangKey((PlayerInteractOptionsPacket.OptionStatus)((Object)v));
            string = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_icon_trade.png");
            bl = options.put((Object)Orientation.NORTHEAST, (Object)new InteractWheelOption((ResourceLocation)string, null, false, langKey, InteractWheelGuiFactoryKt::createPlayerInteractGui$lambda$6$2, InteractWheelGuiFactoryKt::createPlayerInteractGui$lambda$6$3, 4, null));
        }
        MutableComponent mutableComponent = Component.translatable((String)"cobblemon.ui.interact.player");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return new InteractWheelGUI((Multimap<Orientation, InteractWheelOption>)options, (Component)mutableComponent);
    }

    private static final String getLangKey(PlayerInteractOptionsPacket.OptionStatus status) {
        return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1 -> "cobblemon.ui.interact.too_far";
            case 2 -> "cobblemon.battle.error.no_pokemon_opponent";
            default -> "cobblemon.ui.interact.unavailable";
        };
    }

    private static final void closeGUI() {
        Minecraft.getInstance().setScreen(null);
    }

    private static final Unit createPokemonInteractGui$lambda$0(boolean $canMountShoulder, UUID $pokemonID) {
        if ($canMountShoulder) {
            new InteractPokemonPacket($pokemonID, InteractTypePokemon.SHOULDER).sendToServer();
            InteractWheelGuiFactoryKt.closeGUI();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPokemonInteractGui$lambda$1(boolean $canGiveHeld, UUID $pokemonID) {
        if ($canGiveHeld) {
            new InteractPokemonPacket($pokemonID, InteractTypePokemon.HELD_ITEM).sendToServer();
            InteractWheelGuiFactoryKt.closeGUI();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPokemonInteractGui$lambda$2(boolean $canGiveCosmetic, UUID $pokemonID) {
        if ($canGiveCosmetic) {
            new InteractPokemonPacket($pokemonID, InteractTypePokemon.COSMETIC_ITEM).sendToServer();
            InteractWheelGuiFactoryKt.closeGUI();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPokemonInteractGui$lambda$3(boolean $canRide, UUID $pokemonID) {
        if ($canRide) {
            new InteractPokemonPacket($pokemonID, InteractTypePokemon.RIDE).sendToServer();
            InteractWheelGuiFactoryKt.closeGUI();
        }
        return Unit.INSTANCE;
    }

    private static final Vector3f createPlayerInteractGui$lambda$0() {
        return null;
    }

    private static final Unit createPlayerInteractGui$lambda$1(PlayerInteractOptionsPacket $optionsPacket) {
        ClientTradeRequest tradeOffer = CobblemonClient.INSTANCE.getRequests().getTradeOffers().get($optionsPacket.getTargetId());
        if (tradeOffer == null) {
            CobblemonNetwork.sendToServer(new OfferTradePacket($optionsPacket.getTargetId()));
        } else {
            CobblemonClient.INSTANCE.getRequests().getTradeOffers().remove($optionsPacket.getTargetId());
            CobblemonNetwork.sendToServer(new AcceptTradeRequestPacket(tradeOffer.getRequestID()));
        }
        InteractWheelGuiFactoryKt.closeGUI();
        return Unit.INSTANCE;
    }

    private static final Vector3f createPlayerInteractGui$lambda$2() {
        return null;
    }

    private static final Unit createPlayerInteractGui$lambda$3(PlayerInteractOptionsPacket $optionsPacket, ClientBattleChallenge $activeBattleRequest, ClientTeamRequest $activeTeamRequest) {
        Minecraft.getInstance().setScreen((Screen)new BattleConfigureGUI($optionsPacket, $activeBattleRequest, $activeTeamRequest));
        return Unit.INSTANCE;
    }

    private static final Vector3f createPlayerInteractGui$lambda$4(PlayerInteractOptionsPacket $optionsPacket) {
        return CobblemonClient.INSTANCE.getRequests().getBattleChallenges().get($optionsPacket.getTargetId()) != null ? new Vector3f(0.0f, 0.6f, 0.0f) : null;
    }

    private static final Unit createPlayerInteractGui$lambda$5(PlayerInteractOptionsPacket $optionsPacket) {
        new SpectateBattlePacket($optionsPacket.getTargetId()).sendToServer();
        InteractWheelGuiFactoryKt.closeGUI();
        return Unit.INSTANCE;
    }

    private static final Vector3f createPlayerInteractGui$lambda$6$0() {
        return new Vector3f(0.5f, 0.5f, 0.5f);
    }

    private static final Unit createPlayerInteractGui$lambda$6$1() {
        return Unit.INSTANCE;
    }

    private static final Vector3f createPlayerInteractGui$lambda$6$2() {
        return new Vector3f(0.5f, 0.5f, 0.5f);
    }

    private static final Unit createPlayerInteractGui$lambda$6$3() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerInteractOptionsPacket.OptionStatus.values().length];
            try {
                nArray[PlayerInteractOptionsPacket.OptionStatus.TOO_FAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerInteractOptionsPacket.OptionStatus.INSUFFICIENT_POKEMON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

