/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.interact.wheel;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.interact.wheel.ArrowButton;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelButton;
import com.cobblemon.mod.common.client.gui.interact.wheel.InteractWheelOption;
import com.cobblemon.mod.common.client.gui.interact.wheel.Orientation;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B#\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ/\u0010!\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170#H\u0002\u00a2\u0006\u0004\b$\u0010%J#\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170#2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J'\u0010-\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020+2\u0006\u0010 \u001a\u00020+2\u0006\u0010,\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b-\u0010.J\u001f\u0010/\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020+2\u0006\u0010 \u001a\u00020+H\u0002\u00a2\u0006\u0004\b/\u00100R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00101R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000203028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00106\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00107\u00a8\u0006:"}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI;", "Lnet/minecraft/client/gui/screens/Screen;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lcom/google/common/collect/Multimap;", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/Orientation;", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelOption;", "options", "Lnet/minecraft/network/chat/Component;", "title", "<init>", "(Lcom/google/common/collect/Multimap;Lnet/minecraft/network/chat/Component;)V", "", "delta", "", "renderBlurredBackground", "(F)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "renderMenuBackground", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "init", "()V", "calculateMaxPage", "", "page", "setPage", "(I)V", "orientation", "option", "addButton", "(Lcom/cobblemon/mod/common/client/gui/interact/wheel/Orientation;Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelOption;)V", "mouseX", "mouseY", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lkotlin/Pair;", "getBasePosition", "()Lkotlin/Pair;", "getButtonPosition", "(Lcom/cobblemon/mod/common/client/gui/interact/wheel/Orientation;)Lkotlin/Pair;", "", "isPauseScreen", "()Z", "", "button", "mouseClicked", "(DDI)Z", "isMouseInCenter", "(DD)Z", "Lcom/google/common/collect/Multimap;", "", "Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelButton;", "buttons", "Ljava/util/List;", "maxPage", "I", "currentPage", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nInteractWheelGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InteractWheelGUI.kt\ncom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,154:1\n1869#2,2:155\n13805#3,2:157\n*S KotlinDebug\n*F\n+ 1 InteractWheelGUI.kt\ncom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI\n*L\n78#1:155,2\n81#1:157,2\n*E\n"})
public final class InteractWheelGUI
extends Screen
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Multimap<Orientation, InteractWheelOption> options;
    @NotNull
    private final List<InteractWheelButton> buttons;
    private int maxPage;
    private int currentPage;
    public static final int SIZE = 170;
    @NotNull
    private static final ResourceLocation backgroundResource = MiscUtilsKt.cobblemonResource("textures/gui/interact/interact_wheel_base.png");

    public InteractWheelGUI(@NotNull Multimap<Orientation, InteractWheelOption> options, @NotNull Component title) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(title);
        this.options = options;
        this.buttons = new ArrayList();
        this.maxPage = 1;
    }

    protected void renderBlurredBackground(float delta) {
    }

    protected void renderMenuBackground(@NotNull GuiGraphics context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    protected void init() {
        this.calculateMaxPage();
        Collection collection = this.options.get((Object)Orientation.NORTH);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        this.addButton(Orientation.NORTH, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection), (int)0));
        Collection collection2 = this.options.get((Object)Orientation.NORTHEAST);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        this.addButton(Orientation.NORTHEAST, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection2), (int)0));
        Collection collection3 = this.options.get((Object)Orientation.EAST);
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"get(...)");
        this.addButton(Orientation.EAST, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection3), (int)0));
        Collection collection4 = this.options.get((Object)Orientation.SOUTHEAST);
        Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"get(...)");
        this.addButton(Orientation.SOUTHEAST, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection4), (int)0));
        Collection collection5 = this.options.get((Object)Orientation.SOUTH);
        Intrinsics.checkNotNullExpressionValue((Object)collection5, (String)"get(...)");
        this.addButton(Orientation.SOUTH, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection5), (int)0));
        Collection collection6 = this.options.get((Object)Orientation.SOUTHWEST);
        Intrinsics.checkNotNullExpressionValue((Object)collection6, (String)"get(...)");
        this.addButton(Orientation.SOUTHWEST, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection6), (int)0));
        Collection collection7 = this.options.get((Object)Orientation.WEST);
        Intrinsics.checkNotNullExpressionValue((Object)collection7, (String)"get(...)");
        this.addButton(Orientation.WEST, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection7), (int)0));
        Collection collection8 = this.options.get((Object)Orientation.NORTHWEST);
        Intrinsics.checkNotNullExpressionValue((Object)collection8, (String)"get(...)");
        this.addButton(Orientation.NORTHWEST, (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection8), (int)0));
        if (this.maxPage > 1) {
            Pair<Integer, Integer> pair = this.getBasePosition();
            int x = ((Number)pair.component1()).intValue();
            int y = ((Number)pair.component2()).intValue();
            this.addRenderableWidget((GuiEventListener)new ArrowButton(x - 14, y + 78, false, arg_0 -> InteractWheelGUI.init$lambda$0(this, arg_0)));
            this.addRenderableWidget((GuiEventListener)new ArrowButton(x + 175, y + 78, true, arg_0 -> InteractWheelGUI.init$lambda$1(this, arg_0)));
        }
    }

    private final void calculateMaxPage() {
        int[] nArray = new int[]{this.options.get((Object)Orientation.NORTHEAST).size(), this.options.get((Object)Orientation.EAST).size(), this.options.get((Object)Orientation.SOUTHEAST).size(), this.options.get((Object)Orientation.SOUTH).size(), this.options.get((Object)Orientation.SOUTHWEST).size(), this.options.get((Object)Orientation.WEST).size(), this.options.get((Object)Orientation.NORTHWEST).size()};
        this.maxPage = ComparisonsKt.maxOf((int)this.options.get((Object)Orientation.NORTH).size(), (int[])nArray);
    }

    private final void setPage(int page) {
        Orientation[] orientations;
        this.currentPage = page;
        Iterable $this$forEach$iv = this.buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InteractWheelButton it = (InteractWheelButton)element$iv;
            boolean bl = false;
            this.removeWidget((GuiEventListener)it);
        }
        this.buttons.clear();
        Orientation[] $this$forEach$iv2 = orientations = Orientation.values();
        boolean $i$f$forEach2 = false;
        int n = $this$forEach$iv2.length;
        for (int i = 0; i < n; ++i) {
            Orientation element$iv;
            Orientation orientation = element$iv = $this$forEach$iv2[i];
            boolean bl = false;
            Collection collection = this.options.get((Object)orientation);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            InteractWheelOption option = (InteractWheelOption)CollectionsKt.getOrNull((List)CollectionsKt.toList((Iterable)collection), (int)page);
            this.addButton(orientation, option);
        }
    }

    private final void addButton(Orientation orientation, InteractWheelOption option) {
        Pair<Integer, Integer> pair = this.getButtonPosition(orientation);
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        Function0 function0 = option;
        Object object = function0 != null ? function0.getIconResource() : null;
        Function0 function02 = option;
        Object object2 = function02 != null ? function02.getSecondaryIconResource() : null;
        Function0 function03 = option;
        String string = function03 != null ? function03.getTooltipText() : null;
        boolean bl = option != null && option.getEnabled();
        Function0 function04 = option;
        if (function04 == null || (function04 = function04.getColour()) == null) {
            function04 = InteractWheelGUI::addButton$lambda$0;
        }
        GuiEventListener guiEventListener = this.addRenderableWidget((GuiEventListener)new InteractWheelButton((ResourceLocation)object, (ResourceLocation)object2, orientation, string, x, y, bl, (Function0<? extends Vector3f>)function04, arg_0 -> InteractWheelGUI.addButton$lambda$1((InteractWheelOption)option, arg_0), (Function2<? super Double, ? super Double, Boolean>)((Function2)(arg_0, arg_1) -> InteractWheelGUI.addButton$lambda$2(this, arg_0, arg_1))));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener, (String)"addRenderableWidget(...)");
        this.buttons.add((InteractWheelButton)guiEventListener);
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pair<Integer, Integer> pair = this.getBasePosition();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        PoseStack poseStack = context.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        PoseStack poseStack2 = poseStack;
        ResourceLocation resourceLocation = backgroundResource;
        GuiUtilsKt.blitk$default(poseStack2, resourceLocation, x, y, 170, 170, null, null, null, null, null, null, null, null, null, false, 0.0f, 131008, null);
        super.render(context, mouseX, mouseY, delta);
    }

    private final Pair<Integer, Integer> getBasePosition() {
        return new Pair((Object)((this.width - 170) / 2), (Object)((this.height - 170) / 2));
    }

    private final Pair<Integer, Integer> getButtonPosition(Orientation orientation) {
        Pair<Integer, Integer> pair = this.getBasePosition();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        return switch (WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
            case 1 -> new Pair((Object)(x + 55), (Object)y);
            case 2 -> new Pair((Object)(x + 109), (Object)(y + 12));
            case 3 -> new Pair((Object)(x + 143), (Object)(y + 55));
            case 4 -> new Pair((Object)(x + 109), (Object)(y + 109));
            case 5 -> new Pair((Object)(x + 55), (Object)(y + 143));
            case 6 -> new Pair((Object)(x + 12), (Object)(y + 109));
            case 7 -> new Pair((Object)x, (Object)(y + 55));
            case 8 -> new Pair((Object)(x + 12), (Object)(y + 12));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseInCenter(mouseX, mouseY)) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMouseInCenter(double mouseX, double mouseY) {
        Pair<Integer, Integer> pair = this.getBasePosition();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        float centerX = x + 44;
        float xMax = centerX + (float)82;
        float centerY = y + 44;
        float yMax = centerY + (float)82;
        float f = (float)mouseX;
        if (!(centerX <= f)) return false;
        if (!(f <= xMax)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = (float)mouseY;
        if (!(centerY <= f)) return false;
        if (!(f <= yMax)) return false;
        return true;
    }

    private static final void init$lambda$0(InteractWheelGUI this$0, Button it) {
        this$0.setPage(this$0.currentPage == 0 ? this$0.maxPage - 1 : this$0.currentPage - 1);
    }

    private static final void init$lambda$1(InteractWheelGUI this$0, Button it) {
        this$0.setPage((this$0.currentPage + 1) % Math.max(1, this$0.maxPage));
    }

    private static final Vector3f addButton$lambda$0() {
        return null;
    }

    private static final void addButton$lambda$1(InteractWheelOption $option, Button it) {
        block0: {
            Function0<Unit> function0 = $option;
            if (function0 == null || (function0 = function0.getOnPress()) == null) break block0;
            function0.invoke();
        }
    }

    private static final boolean addButton$lambda$2(InteractWheelGUI this$0, double a, double b) {
        return !this$0.isMouseInCenter(a, b);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/wheel/InteractWheelGUI$Companion;", "", "<init>", "()V", "", "SIZE", "I", "Lnet/minecraft/resources/ResourceLocation;", "backgroundResource", "Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.NORTHEAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.SOUTHEAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.SOUTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.SOUTHWEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.WEST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.NORTHWEST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

