/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.interact.moveselect;

import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.MoveCategoryIcon;
import com.cobblemon.mod.common.client.gui.TypeIcon;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.math.SimpleMathExtensionsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'BA\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\b\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\t\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\t\u0010 \u001a\u0004\b#\u0010\"R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/moveselect/MoveSlotButton;", "Lnet/minecraft/client/gui/components/Button;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "", "x", "y", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "move", "pp", "ppMax", "", "enabled", "Lnet/minecraft/client/gui/components/Button$OnPress;", "onPress", "<init>", "(IILcom/cobblemon/mod/common/api/moves/MoveTemplate;IIZLnet/minecraft/client/gui/components/Button$OnPress;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "pMouseX", "pMouseY", "", "pPartialTicks", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lnet/minecraft/client/sounds/SoundManager;", "soundManager", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "getMove", "()Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "I", "getPp", "()I", "getPpMax", "Z", "getEnabled", "()Z", "Companion", "common"})
public final class MoveSlotButton
extends Button
implements CobblemonRenderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MoveTemplate move;
    private final int pp;
    private final int ppMax;
    private final boolean enabled;
    @NotNull
    private static final ResourceLocation moveResource = MiscUtilsKt.cobblemonResource("textures/gui/summary/summary_move.png");
    @NotNull
    private static final ResourceLocation moveOverlayResource = MiscUtilsKt.cobblemonResource("textures/gui/summary/summary_move_overlay.png");
    public static final int WIDTH = 108;
    public static final int HEIGHT = 22;

    public MoveSlotButton(int x, int y, @NotNull MoveTemplate move, int pp, int ppMax, boolean enabled, @NotNull Button.OnPress onPress) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        Intrinsics.checkNotNullParameter((Object)onPress, (String)"onPress");
        super(x, y, 108, 22, (Component)Component.literal((String)"Move"), onPress, MoveSlotButton::_init_$lambda$0);
        this.move = move;
        this.pp = pp;
        this.ppMax = ppMax;
        this.enabled = enabled;
    }

    public /* synthetic */ MoveSlotButton(int n, int n2, MoveTemplate moveTemplate, int n3, int n4, boolean bl, Button.OnPress onPress, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x20) != 0) {
            bl = true;
        }
        this(n, n2, moveTemplate, n3, n4, bl, onPress);
    }

    @NotNull
    public final MoveTemplate getMove() {
        return this.move;
    }

    public final int getPp() {
        return this.pp;
    }

    public final int getPpMax() {
        return this.ppMax;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    protected void renderWidget(@NotNull GuiGraphics context, int pMouseX, int pMouseY, float pPartialTicks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.isHovered = pMouseX >= this.getX() && pMouseY >= this.getY() && pMouseX < this.getX() + this.width && pMouseY < this.getY() + this.height && this.enabled;
        MoveTemplate moveTemplate = Moves.getByNameOrDummy(this.move.getName());
        Triple<Double, Double, Double> rgb = SimpleMathExtensionsKt.toRGB(moveTemplate.getElementalType().getHue());
        double alpha = this.enabled ? 1.0 : 0.5;
        PoseStack matrices = context.pose();
        Intrinsics.checkNotNull((Object)matrices);
        PoseStack poseStack = matrices;
        ResourceLocation resourceLocation = moveResource;
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.isHovered ? 22 : 0;
        double d = ((Number)rgb.getFirst()).doubleValue();
        double d2 = ((Number)rgb.getSecond()).doubleValue();
        double d3 = ((Number)rgb.getThird()).doubleValue();
        GuiUtilsKt.blitk$default(poseStack, resourceLocation, n, n2, 22, 108, null, n3, null, 44, null, d, d2, d3, alpha, false, 0.0f, 99648, null);
        poseStack = matrices;
        resourceLocation = moveOverlayResource;
        n = this.getX();
        n2 = this.getY();
        GuiUtilsKt.blitk$default(poseStack, resourceLocation, n, n2, 22, 108, null, null, null, null, null, null, null, null, alpha, false, 0.0f, 114624, null);
        if (this.pp != -1 && this.ppMax != -1) {
            MutableComponent mutableComponent = Component.literal((String)(this.pp + "/" + this.ppMax));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            MutableComponent movePPText = TextKt.bold(mutableComponent);
            if (this.pp <= Mth.floor((float)((float)this.ppMax / 2.0f))) {
                movePPText = this.pp == 0 ? TextKt.red(movePPText) : TextKt.gold(movePPText);
            }
            RenderHelperKt.drawScaledText$default(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), movePPText, this.getX() + 93, this.getY() + 13, 0.0f, null, 0, 0, true, false, null, null, 7648, null);
        }
        new TypeIcon(this.getX() + 2, this.getY() + 2, moveTemplate.getElementalType(), null, false, false, 0.0f, 0.0f, 0.0f, 504, null).render(context);
        new MoveCategoryIcon(this.getX() + 66, (double)this.getY() + 13.5, this.move.getDamageCategory(), 0.0f, 8, null).render(context);
        RenderHelperKt.drawScaledText$default(context, CobblemonResources.INSTANCE.getDEFAULT_LARGE(), TextKt.bold(this.move.getDisplayName()), this.getX() + 28, this.getY() + 2, 0.0f, null, 0, 0, false, true, null, null, 7136, null);
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
    }

    private static final MutableComponent _init_$lambda$0(Supplier it) {
        return TextKt.text("");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/client/gui/interact/moveselect/MoveSlotButton$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "moveResource", "Lnet/minecraft/resources/ResourceLocation;", "moveOverlayResource", "", "WIDTH", "I", "HEIGHT", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

