/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.debug.riding;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.api.riding.stats.RidingStat;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.debug.riding.RideSettingsEditorGUI;
import com.cobblemon.mod.common.client.gui.debug.riding.RidingStatInputWidget;
import com.cobblemon.mod.common.client.gui.debug.riding.SettingsSlider;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.debug.ServerboundUpdateRidingStatRangePacket;
import com.cobblemon.mod.common.net.messages.server.debug.ServerboundUpdateRidingStatsPacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\r\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\tJ\r\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\tJ-\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010$\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010&\u001a\u0004\b'\u0010(R\"\u0010*\u001a\u00020)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0016\u00101\u001a\u0002008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u00020\u000f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u000f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0016\u00106\u001a\u00020\u000f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b6\u00104R\u0016\u00107\u001a\u00020\u000f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b7\u00104R\u0016\u00108\u001a\u00020\u000f8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b8\u00104R\u0016\u00109\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010;\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0016\u0010<\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b<\u0010:R\u0016\u0010=\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b=\u0010:R\u0016\u0010>\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b>\u0010:R\u0016\u0010?\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b?\u0010:R\u0016\u0010@\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b@\u0010:R\u0016\u0010A\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bA\u0010:R\u0016\u0010B\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bB\u0010:R\u0016\u0010C\u001a\u00020\u00118\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bC\u0010:\u00a8\u0006D"}, d2={"Lcom/cobblemon/mod/common/client/gui/debug/riding/RidingStatsDebugGUI;", "Lnet/minecraft/client/gui/screens/Screen;", "Lcom/cobblemon/mod/common/client/gui/CobblemonRenderable;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "init", "()V", "refresh", "saveStats", "saveStatRanges", "Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;", "ridingStat", "Lcom/cobblemon/mod/common/client/gui/debug/riding/SettingsSlider;", "slider", "Lcom/cobblemon/mod/common/client/gui/debug/riding/RidingStatInputWidget;", "minInput", "maxInput", "updateElementsForStat", "(Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;Lcom/cobblemon/mod/common/client/gui/debug/riding/SettingsSlider;Lcom/cobblemon/mod/common/client/gui/debug/riding/RidingStatInputWidget;Lcom/cobblemon/mod/common/client/gui/debug/riding/RidingStatInputWidget;)V", "", "getRidingStat", "(Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;)I", "Lkotlin/ranges/IntRange;", "getRidingStatRange", "(Lcom/cobblemon/mod/common/api/riding/stats/RidingStat;)Lkotlin/ranges/IntRange;", "getScaledWidth", "()I", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "mouseX", "mouseY", "", "partialTick", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getVehicle", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "ridingStyle", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "()Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "setRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/RidingStyle;)V", "Lnet/minecraft/client/gui/components/Button;", "changeRidingStyle", "Lnet/minecraft/client/gui/components/Button;", "speedSlider", "Lcom/cobblemon/mod/common/client/gui/debug/riding/SettingsSlider;", "accelerationSlider", "skillSlider", "jumpSlider", "staminaSlider", "minSpeedInput", "Lcom/cobblemon/mod/common/client/gui/debug/riding/RidingStatInputWidget;", "maxSpeedInput", "minAccelerationInput", "maxAccelerationInput", "minSkillInput", "maxSkillInput", "minJumpInput", "maxJumpInput", "minStaminaInput", "maxStaminaInput", "common"})
public final class RidingStatsDebugGUI
extends Screen
implements CobblemonRenderable {
    @NotNull
    private final PokemonEntity vehicle;
    @NotNull
    private RidingStyle ridingStyle;
    private Button changeRidingStyle;
    private SettingsSlider speedSlider;
    private SettingsSlider accelerationSlider;
    private SettingsSlider skillSlider;
    private SettingsSlider jumpSlider;
    private SettingsSlider staminaSlider;
    private RidingStatInputWidget minSpeedInput;
    private RidingStatInputWidget maxSpeedInput;
    private RidingStatInputWidget minAccelerationInput;
    private RidingStatInputWidget maxAccelerationInput;
    private RidingStatInputWidget minSkillInput;
    private RidingStatInputWidget maxSkillInput;
    private RidingStatInputWidget minJumpInput;
    private RidingStatInputWidget maxJumpInput;
    private RidingStatInputWidget minStaminaInput;
    private RidingStatInputWidget maxStaminaInput;

    public RidingStatsDebugGUI(@NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        super((Component)LocalizationUtilsKt.lang("ui.debug.riding_stats", new Object[0]));
        this.vehicle = vehicle;
        this.ridingStyle = RidingStyle.LAND;
    }

    @NotNull
    public final PokemonEntity getVehicle() {
        return this.vehicle;
    }

    @NotNull
    public final RidingStyle getRidingStyle() {
        return this.ridingStyle;
    }

    public final void setRidingStyle(@NotNull RidingStyle ridingStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)ridingStyle), (String)"<set-?>");
        this.ridingStyle = ridingStyle;
    }

    public void init() {
        super.init();
        this.clearWidgets();
        this.ridingStyle = this.vehicle.ifRidingAvailableSupply(RidingStyle.LAND, RidingStatsDebugGUI::init$lambda$0);
        GuiEventListener guiEventListener = this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)TextKt.text("Riding Style: " + this.ridingStyle)), arg_0 -> RidingStatsDebugGUI.init$lambda$1(this, arg_0)).bounds(10, 10, this.getScaledWidth() - 20, 20).build());
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener, (String)"addRenderableWidget(...)");
        this.changeRidingStyle = (Button)guiEventListener;
        GuiEventListener guiEventListener2 = this.addRenderableWidget((GuiEventListener)new SettingsSlider(10, 60, 200, (Component)TextKt.text("Speed"), 0, 0.0f, 1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener2, (String)"addRenderableWidget(...)");
        this.speedSlider = (SettingsSlider)guiEventListener2;
        GuiEventListener guiEventListener3 = this.addRenderableWidget((GuiEventListener)new SettingsSlider(10, 90, 200, (Component)TextKt.text("Acceleration"), 0, 0.0f, 1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener3, (String)"addRenderableWidget(...)");
        this.accelerationSlider = (SettingsSlider)guiEventListener3;
        GuiEventListener guiEventListener4 = this.addRenderableWidget((GuiEventListener)new SettingsSlider(10, 120, 200, (Component)TextKt.text("Skill"), 0, 0.0f, 1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener4, (String)"addRenderableWidget(...)");
        this.skillSlider = (SettingsSlider)guiEventListener4;
        GuiEventListener guiEventListener5 = this.addRenderableWidget((GuiEventListener)new SettingsSlider(10, 150, 200, (Component)TextKt.text("Jump"), 0, 0.0f, 1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener5, (String)"addRenderableWidget(...)");
        this.jumpSlider = (SettingsSlider)guiEventListener5;
        GuiEventListener guiEventListener6 = this.addRenderableWidget((GuiEventListener)new SettingsSlider(10, 180, 200, (Component)TextKt.text("Stamina"), 0, 0.0f, 1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener6, (String)"addRenderableWidget(...)");
        this.staminaSlider = (SettingsSlider)guiEventListener6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)TextKt.text("Save")), arg_0 -> RidingStatsDebugGUI.init$lambda$2(this, arg_0)).bounds(10, 210, 200, 20).build());
        GuiEventListener guiEventListener7 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 210, 60, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener7, (String)"addRenderableWidget(...)");
        this.minSpeedInput = (RidingStatInputWidget)guiEventListener7;
        GuiEventListener guiEventListener8 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 100, 60, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener8, (String)"addRenderableWidget(...)");
        this.maxSpeedInput = (RidingStatInputWidget)guiEventListener8;
        GuiEventListener guiEventListener9 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 210, 90, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener9, (String)"addRenderableWidget(...)");
        this.minAccelerationInput = (RidingStatInputWidget)guiEventListener9;
        GuiEventListener guiEventListener10 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 100, 90, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener10, (String)"addRenderableWidget(...)");
        this.maxAccelerationInput = (RidingStatInputWidget)guiEventListener10;
        GuiEventListener guiEventListener11 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 210, 120, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener11, (String)"addRenderableWidget(...)");
        this.minSkillInput = (RidingStatInputWidget)guiEventListener11;
        GuiEventListener guiEventListener12 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 100, 120, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener12, (String)"addRenderableWidget(...)");
        this.maxSkillInput = (RidingStatInputWidget)guiEventListener12;
        GuiEventListener guiEventListener13 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 210, 150, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener13, (String)"addRenderableWidget(...)");
        this.minJumpInput = (RidingStatInputWidget)guiEventListener13;
        GuiEventListener guiEventListener14 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 100, 150, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener14, (String)"addRenderableWidget(...)");
        this.maxJumpInput = (RidingStatInputWidget)guiEventListener14;
        GuiEventListener guiEventListener15 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 210, 180, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener15, (String)"addRenderableWidget(...)");
        this.minStaminaInput = (RidingStatInputWidget)guiEventListener15;
        GuiEventListener guiEventListener16 = this.addRenderableWidget((GuiEventListener)new RidingStatInputWidget(this.getScaledWidth() - 100, 180, (Component)TextKt.text("")));
        Intrinsics.checkNotNullExpressionValue((Object)guiEventListener16, (String)"addRenderableWidget(...)");
        this.maxStaminaInput = (RidingStatInputWidget)guiEventListener16;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)TextKt.text("Save")), arg_0 -> RidingStatsDebugGUI.init$lambda$3(this, arg_0)).bounds(this.getScaledWidth() - 210, 220, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)TextKt.text("Edit Ride Settings")), arg_0 -> RidingStatsDebugGUI.init$lambda$4(this, arg_0)).bounds(10, 240, 200, 20).build());
        this.refresh();
    }

    public final void refresh() {
        RidingStatInputWidget ridingStatInputWidget;
        RidingStatInputWidget ridingStatInputWidget2;
        RidingStatInputWidget ridingStatInputWidget3;
        RidingStatInputWidget ridingStatInputWidget4;
        RidingStatInputWidget ridingStatInputWidget5;
        RidingStatInputWidget ridingStatInputWidget6;
        RidingStatInputWidget ridingStatInputWidget7;
        RidingStatInputWidget ridingStatInputWidget8;
        RidingStatInputWidget ridingStatInputWidget9;
        RidingStatInputWidget ridingStatInputWidget10;
        Button button = this.changeRidingStyle;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeRidingStyle");
            button = null;
        }
        button.setMessage((Component)TextKt.text("Riding Style: " + this.ridingStyle));
        SettingsSlider settingsSlider = this.speedSlider;
        if (settingsSlider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"speedSlider");
            settingsSlider = null;
        }
        if ((ridingStatInputWidget10 = this.minSpeedInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minSpeedInput");
            ridingStatInputWidget10 = null;
        }
        if ((ridingStatInputWidget9 = this.maxSpeedInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxSpeedInput");
            ridingStatInputWidget9 = null;
        }
        this.updateElementsForStat(RidingStat.SPEED, settingsSlider, ridingStatInputWidget10, ridingStatInputWidget9);
        SettingsSlider settingsSlider2 = this.accelerationSlider;
        if (settingsSlider2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accelerationSlider");
            settingsSlider2 = null;
        }
        if ((ridingStatInputWidget8 = this.minAccelerationInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minAccelerationInput");
            ridingStatInputWidget8 = null;
        }
        if ((ridingStatInputWidget7 = this.maxAccelerationInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxAccelerationInput");
            ridingStatInputWidget7 = null;
        }
        this.updateElementsForStat(RidingStat.ACCELERATION, settingsSlider2, ridingStatInputWidget8, ridingStatInputWidget7);
        SettingsSlider settingsSlider3 = this.skillSlider;
        if (settingsSlider3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"skillSlider");
            settingsSlider3 = null;
        }
        if ((ridingStatInputWidget6 = this.minSkillInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minSkillInput");
            ridingStatInputWidget6 = null;
        }
        if ((ridingStatInputWidget5 = this.maxSkillInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxSkillInput");
            ridingStatInputWidget5 = null;
        }
        this.updateElementsForStat(RidingStat.SKILL, settingsSlider3, ridingStatInputWidget6, ridingStatInputWidget5);
        SettingsSlider settingsSlider4 = this.jumpSlider;
        if (settingsSlider4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jumpSlider");
            settingsSlider4 = null;
        }
        if ((ridingStatInputWidget4 = this.minJumpInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minJumpInput");
            ridingStatInputWidget4 = null;
        }
        if ((ridingStatInputWidget3 = this.maxJumpInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxJumpInput");
            ridingStatInputWidget3 = null;
        }
        this.updateElementsForStat(RidingStat.JUMP, settingsSlider4, ridingStatInputWidget4, ridingStatInputWidget3);
        SettingsSlider settingsSlider5 = this.staminaSlider;
        if (settingsSlider5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"staminaSlider");
            settingsSlider5 = null;
        }
        if ((ridingStatInputWidget2 = this.minStaminaInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minStaminaInput");
            ridingStatInputWidget2 = null;
        }
        if ((ridingStatInputWidget = this.maxStaminaInput) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxStaminaInput");
            ridingStatInputWidget = null;
        }
        this.updateElementsForStat(RidingStat.STAMINA, settingsSlider5, ridingStatInputWidget2, ridingStatInputWidget);
    }

    public final void saveStats() {
        SettingsSlider settingsSlider = this.speedSlider;
        if (settingsSlider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"speedSlider");
            settingsSlider = null;
        }
        int speed = settingsSlider.getCurrentValue();
        SettingsSlider settingsSlider2 = this.accelerationSlider;
        if (settingsSlider2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"accelerationSlider");
            settingsSlider2 = null;
        }
        int acceleration = settingsSlider2.getCurrentValue();
        SettingsSlider settingsSlider3 = this.skillSlider;
        if (settingsSlider3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"skillSlider");
            settingsSlider3 = null;
        }
        int skill = settingsSlider3.getCurrentValue();
        SettingsSlider settingsSlider4 = this.jumpSlider;
        if (settingsSlider4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jumpSlider");
            settingsSlider4 = null;
        }
        int jump = settingsSlider4.getCurrentValue();
        SettingsSlider settingsSlider5 = this.staminaSlider;
        if (settingsSlider5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"staminaSlider");
            settingsSlider5 = null;
        }
        int stamina = settingsSlider5.getCurrentValue();
        this.vehicle.overrideRideStat$common(this.ridingStyle, RidingStat.SPEED, speed);
        this.vehicle.overrideRideStat$common(this.ridingStyle, RidingStat.ACCELERATION, acceleration);
        this.vehicle.overrideRideStat$common(this.ridingStyle, RidingStat.SKILL, skill);
        this.vehicle.overrideRideStat$common(this.ridingStyle, RidingStat.JUMP, jump);
        this.vehicle.overrideRideStat$common(this.ridingStyle, RidingStat.STAMINA, stamina);
        CobblemonNetwork.sendToServer(new ServerboundUpdateRidingStatsPacket(this.vehicle.getId(), this.ridingStyle, speed, acceleration, skill, jump, stamina));
        this.refresh();
    }

    public final void saveStatRanges() {
        Map<RidingStat, IntRange> map;
        Map<RidingStat, IntRange> map2;
        Map<RidingStat, IntRange> map3;
        Map<RidingStat, IntRange> map4;
        Map<RidingStat, IntRange> map5;
        int maxStamina;
        RidingStatInputWidget ridingStatInputWidget = this.minSpeedInput;
        if (ridingStatInputWidget == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minSpeedInput");
            ridingStatInputWidget = null;
        }
        String string = ridingStatInputWidget.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        int minSpeed = n != null ? n.intValue() : this.getRidingStatRange(RidingStat.SPEED).getFirst();
        RidingStatInputWidget ridingStatInputWidget2 = this.maxSpeedInput;
        if (ridingStatInputWidget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxSpeedInput");
            ridingStatInputWidget2 = null;
        }
        String string2 = ridingStatInputWidget2.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
        Integer n2 = StringsKt.toIntOrNull((String)string2);
        int maxSpeed = n2 != null ? n2.intValue() : this.getRidingStatRange(RidingStat.SPEED).getLast();
        RidingStatInputWidget ridingStatInputWidget3 = this.minAccelerationInput;
        if (ridingStatInputWidget3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minAccelerationInput");
            ridingStatInputWidget3 = null;
        }
        String string3 = ridingStatInputWidget3.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
        Integer n3 = StringsKt.toIntOrNull((String)string3);
        int minAcceleration = n3 != null ? n3.intValue() : this.getRidingStatRange(RidingStat.ACCELERATION).getFirst();
        RidingStatInputWidget ridingStatInputWidget4 = this.maxAccelerationInput;
        if (ridingStatInputWidget4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxAccelerationInput");
            ridingStatInputWidget4 = null;
        }
        String string4 = ridingStatInputWidget4.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getValue(...)");
        Integer n4 = StringsKt.toIntOrNull((String)string4);
        int maxAcceleration = n4 != null ? n4.intValue() : this.getRidingStatRange(RidingStat.ACCELERATION).getLast();
        RidingStatInputWidget ridingStatInputWidget5 = this.minSkillInput;
        if (ridingStatInputWidget5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minSkillInput");
            ridingStatInputWidget5 = null;
        }
        String string5 = ridingStatInputWidget5.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
        Integer n5 = StringsKt.toIntOrNull((String)string5);
        int minSkill = n5 != null ? n5.intValue() : this.getRidingStatRange(RidingStat.SKILL).getFirst();
        RidingStatInputWidget ridingStatInputWidget6 = this.maxSkillInput;
        if (ridingStatInputWidget6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxSkillInput");
            ridingStatInputWidget6 = null;
        }
        String string6 = ridingStatInputWidget6.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getValue(...)");
        Integer n6 = StringsKt.toIntOrNull((String)string6);
        int maxSkill = n6 != null ? n6.intValue() : this.getRidingStatRange(RidingStat.SKILL).getLast();
        RidingStatInputWidget ridingStatInputWidget7 = this.minJumpInput;
        if (ridingStatInputWidget7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minJumpInput");
            ridingStatInputWidget7 = null;
        }
        String string7 = ridingStatInputWidget7.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
        Integer n7 = StringsKt.toIntOrNull((String)string7);
        int minJump = n7 != null ? n7.intValue() : this.getRidingStatRange(RidingStat.JUMP).getFirst();
        RidingStatInputWidget ridingStatInputWidget8 = this.maxJumpInput;
        if (ridingStatInputWidget8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxJumpInput");
            ridingStatInputWidget8 = null;
        }
        String string8 = ridingStatInputWidget8.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getValue(...)");
        Integer n8 = StringsKt.toIntOrNull((String)string8);
        int maxJump = n8 != null ? n8.intValue() : this.getRidingStatRange(RidingStat.JUMP).getLast();
        RidingStatInputWidget ridingStatInputWidget9 = this.minStaminaInput;
        if (ridingStatInputWidget9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"minStaminaInput");
            ridingStatInputWidget9 = null;
        }
        String string9 = ridingStatInputWidget9.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getValue(...)");
        Integer n9 = StringsKt.toIntOrNull((String)string9);
        int minStamina = n9 != null ? n9.intValue() : this.getRidingStatRange(RidingStat.STAMINA).getFirst();
        RidingStatInputWidget ridingStatInputWidget10 = this.maxStaminaInput;
        if (ridingStatInputWidget10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"maxStaminaInput");
            ridingStatInputWidget10 = null;
        }
        String string10 = ridingStatInputWidget10.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getValue(...)");
        Integer n10 = StringsKt.toIntOrNull((String)string10);
        int n11 = maxStamina = n10 != null ? n10.intValue() : this.getRidingStatRange(RidingStat.STAMINA).getLast();
        if (minSpeed < maxSpeed && (map5 = this.vehicle.getRideProp().getBehaviours()) != null && (map5 = map5.get((Object)this.ridingStyle)) != null && (map5 = map5.getStats()) != null) {
            map5.put(RidingStat.SPEED, new IntRange(minSpeed, maxSpeed));
        }
        if (minAcceleration < maxAcceleration && (map4 = this.vehicle.getRideProp().getBehaviours()) != null && (map4 = map4.get((Object)this.ridingStyle)) != null && (map4 = map4.getStats()) != null) {
            map4.put(RidingStat.ACCELERATION, new IntRange(minAcceleration, maxAcceleration));
        }
        if (minSkill < maxSkill && (map3 = this.vehicle.getRideProp().getBehaviours()) != null && (map3 = map3.get((Object)this.ridingStyle)) != null && (map3 = map3.getStats()) != null) {
            map3.put(RidingStat.SKILL, new IntRange(minSkill, maxSkill));
        }
        if (minJump < maxJump && (map2 = this.vehicle.getRideProp().getBehaviours()) != null && (map2 = map2.get((Object)this.ridingStyle)) != null && (map2 = map2.getStats()) != null) {
            map2.put(RidingStat.JUMP, new IntRange(minJump, maxJump));
        }
        if (minStamina < maxStamina && (map = this.vehicle.getRideProp().getBehaviours()) != null && (map = map.get((Object)this.ridingStyle)) != null && (map = map.getStats()) != null) {
            map.put(RidingStat.STAMINA, new IntRange(minStamina, maxStamina));
        }
        CobblemonNetwork.sendToServer(new ServerboundUpdateRidingStatRangePacket(this.vehicle.getId(), this.ridingStyle, minSpeed, maxSpeed, minAcceleration, maxAcceleration, minSkill, maxSkill, minJump, maxJump, minStamina, maxStamina));
        this.refresh();
    }

    public final void updateElementsForStat(@NotNull RidingStat ridingStat, @NotNull SettingsSlider slider, @NotNull RidingStatInputWidget minInput, @NotNull RidingStatInputWidget maxInput) {
        Intrinsics.checkNotNullParameter((Object)((Object)ridingStat), (String)"ridingStat");
        Intrinsics.checkNotNullParameter((Object)((Object)slider), (String)"slider");
        Intrinsics.checkNotNullParameter((Object)((Object)minInput), (String)"minInput");
        Intrinsics.checkNotNullParameter((Object)((Object)maxInput), (String)"maxInput");
        IntRange range = this.getRidingStatRange(ridingStat);
        slider.update(this.getRidingStat(ridingStat), range.getFirst(), range.getLast());
        minInput.setHint((Component)TextKt.text("Min: " + range.getFirst()));
        maxInput.setHint((Component)TextKt.text("Max: " + range.getLast()));
    }

    public final int getRidingStat(@NotNull RidingStat ridingStat) {
        Intrinsics.checkNotNullParameter((Object)((Object)ridingStat), (String)"ridingStat");
        return (int)this.vehicle.getRawRideStat(ridingStat, this.ridingStyle);
    }

    @NotNull
    public final IntRange getRidingStatRange(@NotNull RidingStat ridingStat) {
        Intrinsics.checkNotNullParameter((Object)((Object)ridingStat), (String)"ridingStat");
        Object object = this.vehicle.getRideProp().getBehaviours();
        if (object == null || (object = object.get((Object)this.ridingStyle)) == null || (object = object.getStats()) == null || (object = (IntRange)object.get((Object)ridingStat)) == null) {
            object = new IntRange(0, 0);
        }
        return object;
    }

    public final int getScaledWidth() {
        return Minecraft.getInstance().getWindow().getGuiScaledWidth();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.fill(0, 0, this.width, this.height, new Color(0, 0, 0, 100).getRGB());
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Pokemon Stats Editor"), 10, 40, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Species Stat Range Editor"), this.getScaledWidth() - 210, 40, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Speed"), this.getScaledWidth() - 285, 70, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Acceleration"), this.getScaledWidth() - 285, 100, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Skill"), this.getScaledWidth() - 285, 130, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Jump"), this.getScaledWidth() - 285, 160, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
        RenderHelperKt.drawScaledText$default(guiGraphics, null, TextKt.text("Stamina"), this.getScaledWidth() - 285, 190, 0.0f, null, 0, 0, false, false, null, null, 8162, null);
    }

    private static final RidingStyle init$lambda$0(RidingBehaviour behaviour, RidingBehaviourSettings settings, RidingBehaviourState state) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return behaviour.getRidingStyle(settings, state);
    }

    private static final void init$lambda$1(RidingStatsDebugGUI this$0, Button button) {
        this$0.ridingStyle = switch (WhenMappings.$EnumSwitchMapping$0[this$0.ridingStyle.ordinal()]) {
            case 1 -> RidingStyle.LIQUID;
            case 2 -> RidingStyle.AIR;
            case 3 -> RidingStyle.LAND;
            default -> throw new NoWhenBranchMatchedException();
        };
        this$0.refresh();
    }

    private static final void init$lambda$2(RidingStatsDebugGUI this$0, Button button) {
        this$0.saveStats();
    }

    private static final void init$lambda$3(RidingStatsDebugGUI this$0, Button button) {
        this$0.saveStatRanges();
    }

    private static final void init$lambda$4(RidingStatsDebugGUI this$0, Button button) {
        block1: {
            Object object = this$0.vehicle.getRidingController();
            if (object == null || (object = ((RidingController)object).getBehaviours()) == null || (object = (RidingBehaviourSettings)object.get((Object)this$0.ridingStyle)) == null) {
                return;
            }
            Object rideSettings = object;
            Minecraft minecraft = this$0.minecraft;
            if (minecraft == null) break block1;
            minecraft.setScreen((Screen)new RideSettingsEditorGUI(this$0, this$0.vehicle, this$0.ridingStyle, (RidingBehaviourSettings)rideSettings));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RidingStyle.values().length];
            try {
                nArray[RidingStyle.LAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RidingStyle.LIQUID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RidingStyle.AIR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

