/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client;

import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u0003R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/client/MountedPokemonAnimationRenderController;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemon", "", "partialTickTime", "", "setup", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;F)V", "getPartialTick", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Ljava/lang/Float;", "reset", "", "", "forcedDeltas", "Ljava/util/Map;", "common"})
public final class MountedPokemonAnimationRenderController {
    @NotNull
    public static final MountedPokemonAnimationRenderController INSTANCE = new MountedPokemonAnimationRenderController();
    @NotNull
    private static final Map<Integer, Float> forcedDeltas = new LinkedHashMap();

    private MountedPokemonAnimationRenderController() {
    }

    public final void setup(@NotNull PokemonEntity pokemon, float partialTickTime) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (forcedDeltas.containsKey(pokemon.getId())) {
            return;
        }
        PokemonSideDelegate pokemonSideDelegate = pokemon.getDelegate();
        PokemonClientDelegate pokemonClientDelegate = pokemonSideDelegate instanceof PokemonClientDelegate ? (PokemonClientDelegate)pokemonSideDelegate : null;
        if (pokemonClientDelegate == null) {
            return;
        }
        PokemonClientDelegate delegate = pokemonClientDelegate;
        PosableModel posableModel = delegate.getCurrentModel();
        if (posableModel == null) {
            return;
        }
        PosableModel model = posableModel;
        if (!model.isReadyForAnimation()) {
            return;
        }
        Vec3 entityPos = new Vec3(Mth.lerp((double)partialTickTime, (double)pokemon.xOld, (double)pokemon.getX()), Mth.lerp((double)partialTickTime, (double)pokemon.yOld, (double)pokemon.getY()), Mth.lerp((double)partialTickTime, (double)pokemon.zOld, (double)pokemon.getZ()));
        float f = Mth.rotLerp((float)partialTickTime, (float)pokemon.yBodyRotO, (float)pokemon.yBodyRot);
        float g = Mth.rotLerp((float)partialTickTime, (float)pokemon.yHeadRotO, (float)pokemon.yHeadRot);
        float h = g - f;
        float j = Mth.lerp((float)partialTickTime, (float)pokemon.xRotO, (float)pokemon.getXRot());
        h = Mth.wrapDegrees((float)h);
        float l = 0.0f;
        float m = 0.0f;
        if (!pokemon.isPassenger() && pokemon.isAlive()) {
            l = pokemon.walkAnimation.speed(partialTickTime);
            m = pokemon.walkAnimation.position(partialTickTime);
            if (pokemon.isBaby()) {
                m *= 3.0f;
            }
            if (l > 1.0f) {
                l = 1.0f;
            }
        }
        delegate.updatePartialTicks(partialTickTime);
        delegate.updateLocatorPosition(entityPos);
        PosableModel posableModel2 = delegate.getCurrentModel();
        if (posableModel2 != null) {
            posableModel2.applyAnimations((Entity)pokemon, delegate, l, m, partialTickTime, j, h);
        }
        forcedDeltas.put(pokemon.getId(), Float.valueOf(partialTickTime));
    }

    @Nullable
    public final Float getPartialTick(@NotNull PokemonEntity pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return forcedDeltas.get(pokemon.getId());
    }

    public final void reset() {
        forcedDeltas.clear();
    }
}

