/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u0016\u0018\u0000 82\u00020\u0001:\u00018B%\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010%\u001a\u00020$2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010&J)\u0010*\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020$\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010/\u001a\u00020\f2\u0006\u0010.\u001a\u00020\n\u00a2\u0006\u0004\b/\u0010\u000eJ\r\u00100\u001a\u00020\f\u00a2\u0006\u0004\b0\u00101J\r\u00102\u001a\u00020\f\u00a2\u0006\u0004\b2\u00101R\"\u00103\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u0010\u000e\u00a8\u00069"}, d2={"Lcom/cobblemon/mod/common/block/entity/ViewerCountBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "inRangeViewers", "", "checkUsers", "(I)V", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/world/level/Level;", "level", "state", "updateBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;)V", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "", "isPlayerLookingAt", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;)Z", "pos", "", "range", "getInRangeViewerCount", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;D)I", "hasViewer", "()Z", "amount", "changeViewerCount", "incrementViewerCount", "()V", "decrementViewerCount", "viewerCount", "I", "getViewerCount", "()I", "setViewerCount", "Companion", "common"})
public class ViewerCountBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int viewerCount;
    @NotNull
    private static final BlockEntityTicker<ViewerCountBlockEntity> TICKER = ViewerCountBlockEntity::TICKER$lambda$0;

    public ViewerCountBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(type, blockPos, blockState);
    }

    public final int getViewerCount() {
        return this.viewerCount;
    }

    public final void setViewerCount(int n) {
        this.viewerCount = n;
    }

    private final void checkUsers(int inRangeViewers) {
        if (inRangeViewers < this.viewerCount) {
            this.changeViewerCount(inRangeViewers);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(compoundTag, registryLookup);
        compoundTag.putInt("userAmount", this.viewerCount);
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(compoundTag, registryLookup);
        this.viewerCount = compoundTag.contains("userAmount") ? compoundTag.getInt("userAmount") : 0;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag compoundTag = this.saveWithoutMetadata(registryLookup);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    public void updateBlock(@NotNull Level level, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        level.setBlockAndUpdate(this.getBlockPos(), state);
        this.setChanged();
    }

    private final boolean isPlayerLookingAt(Level world, Player player, BlockPos blockPos) {
        Vec3 vec3 = player.getEyePosition();
        Vec3 vec32 = vec3.add(player.calculateViewVector(player.getXRot(), player.getYRot()).scale(player.blockInteractionRange()));
        BlockHitResult blockHitResult = world.clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player));
        return Intrinsics.areEqual((Object)blockPos, (Object)blockHitResult.getBlockPos());
    }

    private final int getInRangeViewerCount(Level world, BlockPos pos, double range) {
        AABB box = new AABB((double)pos.getX() - range, (double)pos.getY() - range, (double)pos.getZ() - range, (double)(pos.getX() + 1) + range, (double)(pos.getY() + 1) + range, (double)(pos.getZ() + 1) + range);
        return world.getEntities(EntityTypeTest.forClass(Player.class), box, arg_0 -> ViewerCountBlockEntity.getInRangeViewerCount$lambda$1(arg_0 -> ViewerCountBlockEntity.getInRangeViewerCount$lambda$0(this, world, pos, arg_0), arg_0)).size();
    }

    static /* synthetic */ int getInRangeViewerCount$default(ViewerCountBlockEntity viewerCountBlockEntity, Level level, BlockPos blockPos, double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getInRangeViewerCount");
        }
        if ((n & 4) != 0) {
            d = 5.0;
        }
        return viewerCountBlockEntity.getInRangeViewerCount(level, blockPos, d);
    }

    public final boolean hasViewer() {
        return this.viewerCount > 0;
    }

    public final void changeViewerCount(int amount) {
        block0: {
            Level level = this.level;
            if (level == null) break block0;
            Level it = level;
            boolean bl = false;
            this.viewerCount = Math.max(0, amount);
            BlockState blockState = this.getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            this.updateBlock(it, blockState);
        }
    }

    public final void incrementViewerCount() {
        this.changeViewerCount(this.viewerCount + 1);
    }

    public final void decrementViewerCount() {
        this.changeViewerCount(this.viewerCount - 1);
    }

    private static final boolean getInRangeViewerCount$lambda$0(ViewerCountBlockEntity this$0, Level $world, BlockPos $pos, Player player) {
        Player player2 = player;
        Intrinsics.checkNotNull((Object)player2);
        return this$0.isPlayerLookingAt($world, player2, $pos);
    }

    private static final boolean getInRangeViewerCount$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void TICKER$lambda$0(Level world, BlockPos blockPos, BlockState blockState, ViewerCountBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        Intrinsics.checkNotNull((Object)((Object)blockEntity));
        Intrinsics.checkNotNull((Object)world);
        BlockPos blockPos2 = blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        blockEntity.checkUsers(ViewerCountBlockEntity.getInRangeViewerCount$default(blockEntity, world, blockPos2, 0.0, 4, null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/block/entity/ViewerCountBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lcom/cobblemon/mod/common/block/entity/ViewerCountBlockEntity;", "TICKER", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTICKER$common", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<ViewerCountBlockEntity> getTICKER$common() {
            return TICKER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

