/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.api.fossil.NaturalMaterials;
import com.cobblemon.mod.common.api.multiblock.MultiblockStructure;
import com.cobblemon.mod.common.api.multiblock.builder.MultiblockStructureBuilder;
import com.cobblemon.mod.common.block.entity.FossilMultiblockEntity;
import com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;", "Lcom/cobblemon/mod/common/block/entity/FossilMultiblockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;", "multiblockBuilder", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/multiblock/builder/MultiblockStructureBuilder;)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity$RestorationTankInventory;", "inv", "Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity$RestorationTankInventory;", "getInv", "()Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity$RestorationTankInventory;", "RestorationTankInventory", "common"})
public final class RestorationTankBlockEntity
extends FossilMultiblockEntity {
    @NotNull
    private final RestorationTankInventory inv;

    public RestorationTankBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull MultiblockStructureBuilder multiblockBuilder) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)multiblockBuilder, (String)"multiblockBuilder");
        super(pos, state, multiblockBuilder, CobblemonBlockEntities.RESTORATION_TANK);
        this.inv = new RestorationTankInventory(this);
    }

    @NotNull
    public final RestorationTankInventory getInv() {
        return this.inv;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inv.getItems(), (HolderLookup.Provider)registryLookup);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(nbt, registryLookup);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inv.getItems(), (HolderLookup.Provider)registryLookup);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u001f\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010\bJ\u0017\u0010\"\u001a\u00020\f2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b'\u0010(J)\u0010*\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00102\b\u0010)\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0004\b*\u0010+J'\u0010-\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010,\u001a\u00020$H\u0016\u00a2\u0006\u0004\b-\u0010+R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010.\u001a\u0004\b/\u00100R\u001d\u00102\u001a\b\u0012\u0004\u0012\u00020\u0010018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\u00a8\u00066"}, d2={"Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity$RestorationTankInventory;", "Lnet/minecraft/world/WorldlyContainer;", "Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;", "tankEntity", "<init>", "(Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;)V", "", "clearContent", "()V", "", "getContainerSize", "()I", "", "isEmpty", "()Z", "slot", "Lnet/minecraft/world/item/ItemStack;", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "stack", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/item/Item;", "returnItem", "count", "storeReturnItem", "(Lnet/minecraft/world/item/Item;I)V", "setChanged", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "direction", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "dir", "canTakeItemThroughFace", "Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;", "getTankEntity", "()Lcom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity;", "Lnet/minecraft/core/NonNullList;", "items", "Lnet/minecraft/core/NonNullList;", "getItems", "()Lnet/minecraft/core/NonNullList;", "common"})
    @SourceDebugExtension(value={"SMAP\nRestorationTankBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestorationTankBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity$RestorationTankInventory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1740#2,3:155\n295#2,2:158\n1#3:160\n*S KotlinDebug\n*F\n+ 1 RestorationTankBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/RestorationTankBlockEntity$RestorationTankInventory\n*L\n59#1:155,3\n98#1:158,2\n*E\n"})
    public static final class RestorationTankInventory
    implements WorldlyContainer {
        @NotNull
        private final RestorationTankBlockEntity tankEntity;
        @NotNull
        private final NonNullList<ItemStack> items;

        public RestorationTankInventory(@NotNull RestorationTankBlockEntity tankEntity) {
            Intrinsics.checkNotNullParameter((Object)((Object)tankEntity), (String)"tankEntity");
            this.tankEntity = tankEntity;
            NonNullList nonNullList = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
            this.items = nonNullList;
        }

        @NotNull
        public final RestorationTankBlockEntity getTankEntity() {
            return this.tankEntity;
        }

        @NotNull
        public final NonNullList<ItemStack> getItems() {
            return this.items;
        }

        public void clearContent() {
            int n = ((Collection)this.items).size();
            for (int i = 0; i < n; ++i) {
                this.items.set(i, (Object)ItemStack.EMPTY);
            }
        }

        public int getContainerSize() {
            return 8;
        }

        public boolean isEmpty() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = (Iterable)this.items;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)ItemStack.EMPTY)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        @NotNull
        public ItemStack getItem(int slot) {
            if (slot == -1 || slot >= this.getContainerSize()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            Object object = this.items.get(slot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (ItemStack)object;
        }

        @NotNull
        public ItemStack removeItem(int slot, int amount) {
            if (slot < 0 || slot >= this.getContainerSize()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            ItemStack result = ((ItemStack)this.items.get(slot)).split(amount);
            if (((ItemStack)this.items.get(slot)).getCount() == 0) {
                this.items.set(slot, (Object)ItemStack.EMPTY);
            }
            Intrinsics.checkNotNull((Object)result);
            return result;
        }

        @NotNull
        public ItemStack removeItemNoUpdate(int slot) {
            return this.removeItem(slot, 1);
        }

        public void setItem(int slot, @NotNull ItemStack stack) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                MultiblockStructure multiblockStructure = this.tankEntity.getMultiblockStructure();
                FossilMultiblockStructure struct2 = multiblockStructure instanceof FossilMultiblockStructure ? (FossilMultiblockStructure)multiblockStructure : null;
                Level level = this.tankEntity.level;
                if (level == null) break block2;
                Level it = level;
                boolean bl = false;
                FossilMultiblockStructure fossilMultiblockStructure = struct2;
                if (fossilMultiblockStructure != null) {
                    fossilMultiblockStructure.insertOrganicMaterial(stack, it);
                }
                ResourceLocation returnIdentifier = NaturalMaterials.getReturnItem(stack);
                if (returnIdentifier != null) {
                    Object object = BuiltInRegistries.ITEM.get(returnIdentifier);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    Item returnItem = (Item)object;
                    this.storeReturnItem(returnItem, stack.getCount());
                }
            }
        }

        private final void storeReturnItem(Item returnItem, int count) {
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)((Iterable)this.items));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    IndexedValue it = (IndexedValue)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getValue(), (Object)ItemStack.EMPTY) || ((ItemStack)it.getValue()).getCount() < ((ItemStack)it.getValue()).getMaxStackSize() && Intrinsics.areEqual((Object)((ItemStack)it.getValue()).getItem(), (Object)returnItem))) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            IndexedValue destStack = v0;
            if (destStack != null) {
                if (Intrinsics.areEqual((Object)destStack.getValue(), (Object)ItemStack.EMPTY)) {
                    this.items.set(destStack.getIndex(), (Object)new ItemStack((ItemLike)returnItem, 1));
                } else {
                    ((ItemStack)destStack.getValue()).grow(count);
                }
            }
        }

        public void setChanged() {
            block1: {
                Level level = this.tankEntity.level;
                if (level == null) break block1;
                Level it = level;
                boolean bl = false;
                MultiblockStructure multiblockStructure = this.tankEntity.getMultiblockStructure();
                if (multiblockStructure != null) {
                    multiblockStructure.markDirty(it);
                }
            }
        }

        public boolean stillValid(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return false;
        }

        @NotNull
        public int[] getSlotsForFace(@NotNull Direction side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
            return nArray;
        }

        public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (this.tankEntity.getMultiblockStructure() instanceof FossilMultiblockStructure && direction != Direction.DOWN) {
                MultiblockStructure multiblockStructure = this.tankEntity.getMultiblockStructure();
                Intrinsics.checkNotNull((Object)multiblockStructure, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure");
                FossilMultiblockStructure structure = (FossilMultiblockStructure)multiblockStructure;
                ItemStack it = stack;
                boolean bl = false;
                boolean canUtilize = NaturalMaterials.isNaturalMaterial(it) && structure.getOrganicMaterialInside() < 128 && !structure.getHasCreatedPokemon();
                ResourceLocation resourceLocation = NaturalMaterials.getReturnItem(stack);
                if (resourceLocation == null) {
                    return canUtilize;
                }
                ResourceLocation returnItem = resourceLocation;
                if (canUtilize) {
                    int n = ((Collection)this.items).size();
                    for (int i = 0; i < n; ++i) {
                        if (!Intrinsics.areEqual((Object)this.items.get(i), (Object)ItemStack.EMPTY) && (((ItemStack)this.items.get(i)).getCount() >= ((ItemStack)this.items.get(i)).getMaxStackSize() || !Intrinsics.areEqual((Object)((ItemStack)this.items.get(i)).getItem(), (Object)BuiltInRegistries.ITEM.get(returnItem)))) continue;
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction dir) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            return dir == Direction.DOWN && slot >= 0 && slot < this.getContainerSize();
        }
    }
}

