/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pasture.PastureLink;
import com.cobblemon.mod.common.api.pasture.PastureLinkManager;
import com.cobblemon.mod.common.api.scheduling.SchedulingFunctionsKt;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.PastureBlock;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.effect.SpawnSnowstormEntityParticlePacket;
import com.cobblemon.mod.common.net.messages.client.pasture.ClosePasturePacket;
import com.cobblemon.mod.common.net.messages.client.pasture.OpenPasturePacket;
import com.cobblemon.mod.common.net.messages.client.pasture.PokemonPasturedPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.DistributionUtilsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 ]2\u00020\u0001:\u0002^]B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ%\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0018\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\u0018\u00a2\u0006\u0004\b'\u0010&J\u0015\u0010*\u001a\u00020\u00182\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b*\u0010+J\u001b\u0010.\u001a\b\u0012\u0004\u0012\u00020(0-2\u0006\u0010,\u001a\u00020(\u00a2\u0006\u0004\b.\u0010/J)\u00102\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\b2\u00103J\u0017\u00104\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b4\u00105J\u001f\u0010:\u001a\u00020\u00182\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208H\u0014\u00a2\u0006\u0004\b:\u0010;J\u001f\u0010<\u001a\u00020\u00182\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u000208H\u0014\u00a2\u0006\u0004\b<\u0010;R\"\u0010=\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010\n\"\u0004\b@\u0010AR\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020C0B8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR\"\u0010H\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\"\u0010N\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010I\u001a\u0004\bO\u0010K\"\u0004\bP\u0010MR$\u0010Q\u001a\u0004\u0018\u00010(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010T\"\u0004\bU\u0010+R\"\u0010W\u001a\u00020V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\\u00a8\u0006_"}, d2={"Lcom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "getMaxTethered", "()I", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "maxPerPlayer", "", "canAddPokemon", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;I)Z", "Lnet/minecraft/core/Direction;", "directionToBehind", "tether", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/core/Direction;)Z", "on", "", "togglePastureOn", "(Z)V", "Lnet/minecraft/world/level/Level;", "world", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "isSafeFloor", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lnet/minecraft/world/phys/AABB;", "box", "makeSuitableY", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/phys/AABB;)Lnet/minecraft/core/BlockPos;", "checkPokemon", "()V", "onBroken", "Ljava/util/UUID;", "pokemonId", "releasePokemon", "(Ljava/util/UUID;)V", "playerId", "", "releaseAllPokemon", "(Ljava/util/UUID;)Ljava/util/List;", "", "range", "getInRangeViewerCount", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;D)I", "isPlayerViewing", "(Lnet/minecraft/server/level/ServerPlayer;)Z", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "loadAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "saveAdditional", "ticksUntilCheck", "I", "getTicksUntilCheck", "setTicksUntilCheck", "(I)V", "", "Lcom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity$Tethering;", "tetheredPokemon", "Ljava/util/List;", "getTetheredPokemon", "()Ljava/util/List;", "minRoamPos", "Lnet/minecraft/core/BlockPos;", "getMinRoamPos", "()Lnet/minecraft/core/BlockPos;", "setMinRoamPos", "(Lnet/minecraft/core/BlockPos;)V", "maxRoamPos", "getMaxRoamPos", "setMaxRoamPos", "ownerId", "Ljava/util/UUID;", "getOwnerId", "()Ljava/util/UUID;", "setOwnerId", "", "ownerName", "Ljava/lang/String;", "getOwnerName", "()Ljava/lang/String;", "setOwnerName", "(Ljava/lang/String;)V", "Companion", "Tethering", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonPastureBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonPastureBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1788#2,4:401\n1869#2,2:406\n1869#2,2:408\n1869#2,2:410\n774#2:412\n865#2,2:413\n1869#2,2:415\n774#2:417\n865#2,2:418\n1#3:405\n*S KotlinDebug\n*F\n+ 1 PokemonPastureBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity\n*L\n139#1:401,4\n294#1:406,2\n302#1:408,2\n309#1:410,2\n323#1:412\n323#1:413,2\n323#1:415,2\n109#1:417\n109#1:418,2\n*E\n"})
public final class PokemonPastureBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int ticksUntilCheck;
    @NotNull
    private final List<Tethering> tetheredPokemon;
    @NotNull
    private BlockPos minRoamPos;
    @NotNull
    private BlockPos maxRoamPos;
    @Nullable
    private UUID ownerId;
    @NotNull
    private String ownerName;
    @NotNull
    private static final BlockEntityTicker<PokemonPastureBlockEntity> TICKER = PokemonPastureBlockEntity::TICKER$lambda$0;

    public PokemonPastureBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(CobblemonBlockEntities.PASTURE, pos, state);
        this.ticksUntilCheck = Cobblemon.INSTANCE.getConfig().getPastureBlockUpdateTicks();
        this.tetheredPokemon = new ArrayList();
        this.ownerName = "";
        int radius = Cobblemon.INSTANCE.getConfig().getPastureMaxWanderDistance();
        BlockPos blockPos = pos.subtract(new Vec3i(radius, radius, radius));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"subtract(...)");
        this.minRoamPos = blockPos;
        BlockPos blockPos2 = pos.offset(new Vec3i(radius, radius, radius));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"offset(...)");
        this.maxRoamPos = blockPos2;
    }

    public final int getTicksUntilCheck() {
        return this.ticksUntilCheck;
    }

    public final void setTicksUntilCheck(int n) {
        this.ticksUntilCheck = n;
    }

    @NotNull
    public final List<Tethering> getTetheredPokemon() {
        return this.tetheredPokemon;
    }

    @NotNull
    public final BlockPos getMinRoamPos() {
        return this.minRoamPos;
    }

    public final void setMinRoamPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.minRoamPos = blockPos;
    }

    @NotNull
    public final BlockPos getMaxRoamPos() {
        return this.maxRoamPos;
    }

    public final void setMaxRoamPos(@NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"<set-?>");
        this.maxRoamPos = blockPos;
    }

    @Nullable
    public final UUID getOwnerId() {
        return this.ownerId;
    }

    public final void setOwnerId(@Nullable UUID uUID) {
        this.ownerId = uUID;
    }

    @NotNull
    public final String getOwnerName() {
        return this.ownerName;
    }

    public final void setOwnerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ownerName = string;
    }

    public final int getMaxTethered() {
        return Cobblemon.INSTANCE.getConfig().getDefaultPasturedPokemonLimit();
    }

    public final boolean canAddPokemon(@NotNull ServerPlayer player, @NotNull Pokemon pokemon, int maxPerPlayer) {
        int forThisPlayer;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Iterable $this$count$iv = this.tetheredPokemon;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v0 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Tethering it = (Tethering)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPlayerId(), (Object)player.getUUID()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = forThisPlayer = count$iv;
        }
        if (forThisPlayer >= maxPerPlayer || this.tetheredPokemon.size() >= this.getMaxTethered() || pokemon.isFainted()) {
            return false;
        }
        double radius = Cobblemon.INSTANCE.getConfig().getPastureMaxWanderDistance();
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Vec3 bottom = BlockPosExtensionsKt.toVec3d(blockPos).multiply(1.0, 0.0, 1.0);
        List list = player.level().getEntitiesOfClass(PokemonEntity.class, AABB.ofSize((Vec3)bottom, (double)radius, (double)99999.0, (double)radius), arg_0 -> PokemonPastureBlockEntity.canAddPokemon$lambda$2(PokemonPastureBlockEntity::canAddPokemon$lambda$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        int pokemonWithinPastureWander = ((Collection)list).size();
        double chunkDiameter = radius / (double)16 * (double)2;
        if ((double)pokemonWithinPastureWander >= (double)Cobblemon.INSTANCE.getConfig().getPastureMaxPerChunk() * chunkDiameter * chunkDiameter) {
            CobblemonNetwork.INSTANCE.sendPacket(player, new ClosePasturePacket());
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("pasture.too_many_nearby", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            player.sendSystemMessage((Component)TextKt.red(mutableComponent), true);
            return false;
        }
        return true;
    }

    public final boolean tether(@NotNull ServerPlayer player, @NotNull Pokemon pokemon, @NotNull Direction directionToBehind) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)directionToBehind, (String)"directionToBehind");
        Level level = this.level;
        if (level == null) {
            return false;
        }
        Level world = level;
        PokemonEntity entity = new PokemonEntity(world, pokemon, null, 4, null);
        entity.refreshDimensions();
        double width = entity.getBoundingBox().getXsize();
        BlockPos idealPlace = this.getBlockPos().offset(directionToBehind.getNormal().multiply((int)Math.ceil(width) + 1));
        AABB box = entity.getDimensions(Pose.STANDING).makeBoundingBox(idealPlace.getCenter().subtract(0.0, 0.5, 0.0));
        for (int i = 0; i < 6; ++i) {
            box = box.move((double)directionToBehind.getNormal().getX(), 0.0, (double)directionToBehind.getNormal().getZ());
            BlockPos blockPos = idealPlace.offset(directionToBehind.getNormal().multiply(i + 1));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            AABB aABB = box;
            Intrinsics.checkNotNull((Object)aABB);
            BlockPos fixedPosition = this.makeSuitableY(world, blockPos, entity, aABB);
            if (fixedPosition == null) continue;
            entity.setPos(fixedPosition.getCenter().subtract(0.0, 0.5, 0.0));
            PCStore pc = Cobblemon.INSTANCE.getStorage().getPC(player);
            entity.setBeamMode(2);
            SchedulingFunctionsKt.afterOnServer(0.5f, (Function0<Unit>)((Function0)() -> PokemonPastureBlockEntity.tether$lambda$0(entity)));
            if (world.addFreshEntity((Entity)entity)) {
                UUID uUID = player.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
                String string = player.getGameProfile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                UUID uUID2 = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
                UUID uUID3 = pokemon.getUuid();
                Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"<get-uuid>(...)");
                UUID uUID4 = pc.getUuid();
                int n = entity.getId();
                BlockPos blockPos2 = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                Tethering tethering = new Tethering(this.minRoamPos, this.maxRoamPos, uUID, string, uUID2, uUID3, uUID4, n, blockPos2);
                pokemon.setTetheringId(tethering.getTetheringId());
                this.tetheredPokemon.add(tethering);
                entity.setTethering(tethering);
                OpenPasturePacket.PasturePokemonDataDTO pasturePokemonDataDTO = tethering.toDTO(player);
                if (pasturePokemonDataDTO != null) {
                    OpenPasturePacket.PasturePokemonDataDTO it = pasturePokemonDataDTO;
                    boolean bl = false;
                    CobblemonNetwork.INSTANCE.sendPacket(player, new PokemonPasturedPacket(it));
                }
                this.setChanged();
                CobblemonCriteria.PASTURE_USE.trigger(player, pokemon);
                return true;
            }
            Cobblemon.LOGGER.warn("Couldn't spawn pastured Pok\u00e9mon for some reason");
            break;
        }
        return false;
    }

    private final void togglePastureOn(boolean on) {
        Block block = this.getBlockState().getBlock();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.PastureBlock");
        PastureBlock pastureBlock = (PastureBlock)block;
        Level level = this.level;
        if (level != null && !level.isClientSide) {
            Level world = level;
            BlockState blockState = this.getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            BlockPos posBottom = pastureBlock.getBasePosition(blockState, blockPos);
            BlockState stateBottom = world.getBlockState(posBottom);
            Intrinsics.checkNotNull((Object)stateBottom);
            BlockPos posTop = pastureBlock.getPositionOfOtherPart(stateBottom, posBottom);
            BlockState stateTop = world.getBlockState(posTop);
            try {
                if (!Intrinsics.areEqual((Object)stateBottom.getValue((Property)PastureBlock.Companion.getON()), (Object)on)) {
                    world.setBlockAndUpdate(posTop, (BlockState)stateTop.setValue((Property)PastureBlock.Companion.getON(), (Comparable)Boolean.valueOf(on)));
                    world.setBlockAndUpdate(posBottom, (BlockState)stateBottom.setValue((Property)PastureBlock.Companion.getON(), (Comparable)Boolean.valueOf(on)));
                }
            }
            catch (IllegalArgumentException exception) {
                boolean bl = world.getBlockState(this.getBlockPos().above()).getBlock() instanceof PastureBlock ? world.setBlockAndUpdate(this.getBlockPos().above(), Blocks.AIR.defaultBlockState()) : world.setBlockAndUpdate(this.getBlockPos().below(), Blocks.AIR.defaultBlockState());
                world.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
                world.addFreshEntity((Entity)new ItemEntity(world, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5, new ItemStack((ItemLike)CobblemonBlocks.PASTURE)));
            }
        }
    }

    public final boolean isSafeFloor(@NotNull Level world, @NotNull BlockPos pos, @NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        BlockState state = world.getBlockState(pos);
        return state.isAir() ? false : (state.entityCanStandOn((BlockGetter)world, pos, (Entity)entity) || state.entityCanStandOnFace((BlockGetter)world, pos, (Entity)entity, Direction.DOWN) ? true : ((entity.getBehaviour().getMoving().getSwim().getCanWalkOnWater() || entity.getBehaviour().getMoving().getSwim().getCanSwimInWater()) && state.getFluidState().is(FluidTags.WATER) ? true : (entity.getBehaviour().getMoving().getSwim().getCanWalkOnLava() || entity.getBehaviour().getMoving().getSwim().getCanSwimInLava()) && state.getFluidState().is(FluidTags.LAVA)));
    }

    @Nullable
    public final BlockPos makeSuitableY(@NotNull Level world, @NotNull BlockPos pos, @NotNull PokemonEntity entity, @NotNull AABB box) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        if (world.collidesWithSuffocatingBlock((Entity)entity, box)) {
            for (int i = 1; i < 16; ++i) {
                AABB newBox = box.move(0.5, (double)i, 0.5);
                if (world.collidesWithSuffocatingBlock((Entity)entity, newBox)) continue;
                BlockPos blockPos = pos.offset(0, i - 1, 0);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                if (!this.isSafeFloor(world, blockPos, entity)) continue;
                return pos.offset(0, i, 0);
            }
        } else {
            for (int i = 1; i < 16; ++i) {
                AABB newBox = box.move(0.5, -((double)i), 0.5);
                if (!world.collidesWithSuffocatingBlock((Entity)entity, newBox)) continue;
                BlockPos blockPos = pos.offset(0, -i, 0);
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                if (!this.isSafeFloor(world, blockPos, entity)) continue;
                return pos.offset(0, -i + 1, 0);
            }
        }
        return null;
    }

    public final void checkPokemon() {
        List deadLinks = new ArrayList();
        Iterable $this$forEach$iv = this.tetheredPokemon;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tethering it = (Tethering)element$iv;
            boolean bl = false;
            Pokemon pokemon = it.getPokemon();
            if (pokemon == null) {
                deadLinks.add(it.getPokemonId());
                continue;
            }
            if (pokemon.getTetheringId() != null && Intrinsics.areEqual((Object)pokemon.getTetheringId(), (Object)it.getTetheringId())) continue;
            deadLinks.add(it.getPokemonId());
        }
        $this$forEach$iv = deadLinks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID p0 = (UUID)element$iv;
            boolean bl = false;
            this.releasePokemon(p0);
        }
        this.ticksUntilCheck = Cobblemon.INSTANCE.getConfig().getPastureBlockUpdateTicks();
        this.setChanged();
    }

    public final void onBroken() {
        if (this.level instanceof ServerLevel) {
            Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.tetheredPokemon);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tethering it = (Tethering)element$iv;
                boolean bl = false;
                this.releasePokemon(it.getPokemonId());
            }
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            PastureLinkManager.removeAt(serverLevel, blockPos);
        }
    }

    public final void releasePokemon(@NotNull UUID pokemonId) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
            Iterable iterable = this.tetheredPokemon;
            for (Object t : iterable) {
                Tethering it = (Tethering)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPokemonId(), (Object)pokemonId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Tethering tethering = v0;
        if (tethering == null) {
            return;
        }
        Tethering tethering2 = tethering;
        Pokemon pokemon = tethering2.getPokemon();
        if (pokemon != null) {
            pokemon.setTetheringId(null);
        }
        this.tetheredPokemon.remove(tethering2);
        this.setChanged();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UUID> releaseAllPokemon(@NotNull UUID playerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        List unpastured = new ArrayList();
        Iterable $this$filter$iv = this.tetheredPokemon;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tethering it = (Tethering)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPlayerId(), (Object)playerId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tethering it = (Tethering)element$iv;
            boolean bl = false;
            Pokemon pokemon = it.getPokemon();
            if (pokemon != null) {
                pokemon.setTetheringId(null);
            }
            this.tetheredPokemon.remove(it);
            unpastured.add(it.getPokemonId());
        }
        this.setChanged();
        return unpastured;
    }

    private final int getInRangeViewerCount(Level world, BlockPos pos, double range) {
        AABB box = new AABB((double)pos.getX() - range, (double)pos.getY() - range, (double)pos.getZ() - range, (double)(pos.getX() + 1) + range, (double)(pos.getY() + 1) + range, (double)(pos.getZ() + 1) + range);
        return world.getEntities(EntityTypeTest.forClass(ServerPlayer.class), box, arg_0 -> PokemonPastureBlockEntity.getInRangeViewerCount$lambda$0((Function1)new Function1<ServerPlayer, Boolean>((Object)this){

            public final Boolean invoke(ServerPlayer p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return PokemonPastureBlockEntity.access$isPlayerViewing((PokemonPastureBlockEntity)((Object)this.receiver), p0);
            }
        }, arg_0)).size();
    }

    static /* synthetic */ int getInRangeViewerCount$default(PokemonPastureBlockEntity pokemonPastureBlockEntity, Level level, BlockPos blockPos, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 5.0;
        }
        return pokemonPastureBlockEntity.getInRangeViewerCount(level, blockPos, d);
    }

    private final boolean isPlayerViewing(ServerPlayer player) {
        PastureLink pastureLink = PastureLinkManager.getLinkByPlayer(player);
        return pastureLink != null && Intrinsics.areEqual((Object)pastureLink.getPos(), (Object)this.getBlockPos()) && Intrinsics.areEqual((Object)pastureLink.getDimension(), (Object)ResourceLocation.tryParse((String)player.level().dimensionTypeRegistration().getRegisteredName()));
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        void it;
        String string;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(nbt, registryLookup);
        ListTag list = nbt.getList("TetherPokemon", 10);
        this.ownerId = nbt.hasUUID("TetherOwnerId") ? nbt.getUUID("TetherOwnerId") : null;
        String string2 = string = nbt.getString("TetherOwnerName");
        PokemonPastureBlockEntity pokemonPastureBlockEntity = this;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        boolean bl2 = ((CharSequence)it).length() > 0;
        String string3 = bl2 ? string : null;
        if (string3 == null) {
            string3 = "";
        }
        pokemonPastureBlockEntity.ownerName = string3;
        Iterator iterator = list.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Tag tetheringNBT = (Tag)iterator2.next();
            Intrinsics.checkNotNull((Object)tetheringNBT, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            CompoundTag cfr_ignored_0 = (CompoundTag)tetheringNBT;
            UUID tetheringId = ((CompoundTag)tetheringNBT).getUUID("TetheringId");
            UUID pokemonId = ((CompoundTag)tetheringNBT).getUUID("UUID");
            UUID pcId = ((CompoundTag)tetheringNBT).getUUID("PCId");
            UUID playerId = ((CompoundTag)tetheringNBT).getUUID("PlayerId");
            int entityId = ((CompoundTag)tetheringNBT).getInt("EntityId");
            Intrinsics.checkNotNull((Object)playerId);
            Intrinsics.checkNotNull((Object)tetheringId);
            Intrinsics.checkNotNull((Object)pokemonId);
            Intrinsics.checkNotNull((Object)pcId);
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.tetheredPokemon.add(new Tethering(this.minRoamPos, this.maxRoamPos, playerId, this.ownerName, tetheringId, pokemonId, pcId, entityId, blockPos));
        }
        Object t = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"TetherMinRoamPos").get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        this.minRoamPos = (BlockPos)t;
        Object t2 = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"TetherMaxRoamPos").get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
        this.maxRoamPos = (BlockPos)t2;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(nbt, registryLookup);
        ListTag list = new ListTag();
        for (Tethering tethering : this.tetheredPokemon) {
            CompoundTag tetheringNBT = new CompoundTag();
            tetheringNBT.putUUID("TetheringId", tethering.getTetheringId());
            tetheringNBT.putUUID("PlayerId", tethering.getPlayerId());
            tetheringNBT.putUUID("UUID", tethering.getPokemonId());
            tetheringNBT.putUUID("PCId", tethering.getPcId());
            tetheringNBT.putInt("EntityId", tethering.getEntityId());
            list.add((Object)tetheringNBT);
        }
        nbt.put("TetherPokemon", (Tag)list);
        nbt.put("TetherMinRoamPos", NbtUtils.writeBlockPos((BlockPos)this.minRoamPos));
        nbt.put("TetherMaxRoamPos", NbtUtils.writeBlockPos((BlockPos)this.maxRoamPos));
        UUID uUID = this.ownerId;
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            nbt.putUUID("TetherOwnerId", it);
        }
        nbt.putString("TetherOwnerName", this.ownerName);
    }

    private static final boolean canAddPokemon$lambda$1(PokemonEntity it) {
        return true;
    }

    private static final boolean canAddPokemon$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit tether$lambda$0(PokemonEntity $entity) {
        if ($entity.getPokemon().getShiny()) {
            Object[] objectArray = new String[]{"shiny_particles", "middle"};
            NetworkPacket networkPacket = new SpawnSnowstormEntityParticlePacket(MiscUtilsKt.cobblemonResource("shiny_ring"), $entity.getId(), CollectionsKt.listOf((Object[])objectArray), null, null, 24, null);
            double d = $entity.getX();
            double d2 = $entity.getY();
            double d3 = $entity.getZ();
            ResourceKey resourceKey = $entity.level().dimension();
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
            NetworkPacket.sendToPlayersAround$default(networkPacket, d, d2, d3, 64.0, resourceKey, null, 32, null);
        }
        $entity.after(1.5f, (Function0<Unit>)((Function0)() -> PokemonPastureBlockEntity.tether$lambda$0$0($entity)));
        return Unit.INSTANCE;
    }

    private static final Unit tether$lambda$0$0(PokemonEntity $entity) {
        $entity.setBeamMode(0);
        return Unit.INSTANCE;
    }

    private static final boolean getInRangeViewerCount$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void TICKER$lambda$0(Level world, BlockPos blockPos, BlockState blockState, PokemonPastureBlockEntity blockEntity) {
        void $this$filterTo$iv$iv;
        if (world.isClientSide) {
            return;
        }
        int n = blockEntity.ticksUntilCheck;
        blockEntity.ticksUntilCheck = n + -1;
        if (blockEntity.ticksUntilCheck <= 0) {
            blockEntity.checkPokemon();
        }
        Iterable $this$filter$iv = blockEntity.tetheredPokemon;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tethering it = (Tethering)element$iv$iv;
            boolean bl = false;
            if (!(it.getPokemon() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tetheredPokemonList = (List)destination$iv$iv;
        for (Tethering tetheredPokemon : tetheredPokemonList) {
            Pokemon pokemon;
            Intrinsics.checkNotNull((Object)tetheredPokemon.getPokemon());
            if (pokemon.getCurrentFullness() > 0) {
                pokemon.tickMetabolism();
            }
            if (!MapsKt.any(pokemon.getInteractionCooldowns())) continue;
            pokemon.tickInteractionCooldown();
        }
        Intrinsics.checkNotNull((Object)((Object)blockEntity));
        Intrinsics.checkNotNull((Object)world);
        BlockPos blockPos2 = blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        blockEntity.togglePastureOn(PokemonPastureBlockEntity.getInRangeViewerCount$default(blockEntity, world, blockPos2, 0.0, 4, null) > 0);
    }

    public static final /* synthetic */ boolean access$isPlayerViewing(PokemonPastureBlockEntity $this, ServerPlayer player) {
        return $this.isPlayerViewing(player);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lcom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity;", "TICKER", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTICKER$common", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<PokemonPastureBlockEntity> getTICKER$common() {
            return TICKER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b \u0010\u001fR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010!\u001a\u0004\b'\u0010#R\u0017\u0010\n\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\n\u0010!\u001a\u0004\b(\u0010#R\u0017\u0010\u000b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010!\u001a\u0004\b)\u0010#R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001d\u001a\u0004\b-\u0010\u001fR\u0017\u0010/\u001a\u00020.8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"Lcom/cobblemon/mod/common/block/entity/PokemonPastureBlockEntity$Tethering;", "", "Lnet/minecraft/core/BlockPos;", "minRoamPos", "maxRoamPos", "Ljava/util/UUID;", "playerId", "", "playerName", "tetheringId", "pokemonId", "pcId", "", "entityId", "pasturePos", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Ljava/util/UUID;Ljava/lang/String;Ljava/util/UUID;Ljava/util/UUID;Ljava/util/UUID;ILnet/minecraft/core/BlockPos;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pos", "", "canRoamTo", "(Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cobblemon/mod/common/net/messages/client/pasture/OpenPasturePacket$PasturePokemonDataDTO;", "toDTO", "(Lnet/minecraft/server/level/ServerPlayer;)Lcom/cobblemon/mod/common/net/messages/client/pasture/OpenPasturePacket$PasturePokemonDataDTO;", "Lnet/minecraft/core/BlockPos;", "getMinRoamPos", "()Lnet/minecraft/core/BlockPos;", "getMaxRoamPos", "Ljava/util/UUID;", "getPlayerId", "()Ljava/util/UUID;", "Ljava/lang/String;", "getPlayerName", "()Ljava/lang/String;", "getTetheringId", "getPokemonId", "getPcId", "I", "getEntityId", "()I", "getPasturePos", "Lnet/minecraft/world/phys/AABB;", "box", "Lnet/minecraft/world/phys/AABB;", "getBox", "()Lnet/minecraft/world/phys/AABB;", "common"})
    public static class Tethering {
        @NotNull
        private final BlockPos minRoamPos;
        @NotNull
        private final BlockPos maxRoamPos;
        @NotNull
        private final UUID playerId;
        @NotNull
        private final String playerName;
        @NotNull
        private final UUID tetheringId;
        @NotNull
        private final UUID pokemonId;
        @NotNull
        private final UUID pcId;
        private final int entityId;
        @NotNull
        private final BlockPos pasturePos;
        @NotNull
        private final AABB box;

        public Tethering(@NotNull BlockPos minRoamPos, @NotNull BlockPos maxRoamPos, @NotNull UUID playerId, @NotNull String playerName, @NotNull UUID tetheringId, @NotNull UUID pokemonId, @NotNull UUID pcId, int entityId, @NotNull BlockPos pasturePos) {
            Intrinsics.checkNotNullParameter((Object)minRoamPos, (String)"minRoamPos");
            Intrinsics.checkNotNullParameter((Object)maxRoamPos, (String)"maxRoamPos");
            Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
            Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
            Intrinsics.checkNotNullParameter((Object)tetheringId, (String)"tetheringId");
            Intrinsics.checkNotNullParameter((Object)pokemonId, (String)"pokemonId");
            Intrinsics.checkNotNullParameter((Object)pcId, (String)"pcId");
            Intrinsics.checkNotNullParameter((Object)pasturePos, (String)"pasturePos");
            this.minRoamPos = minRoamPos;
            this.maxRoamPos = maxRoamPos;
            this.playerId = playerId;
            this.playerName = playerName;
            this.tetheringId = tetheringId;
            this.pokemonId = pokemonId;
            this.pcId = pcId;
            this.entityId = entityId;
            this.pasturePos = pasturePos;
            this.box = new AABB(BlockPosExtensionsKt.toVec3d(this.minRoamPos), BlockPosExtensionsKt.toVec3d(this.maxRoamPos));
        }

        @NotNull
        public final BlockPos getMinRoamPos() {
            return this.minRoamPos;
        }

        @NotNull
        public final BlockPos getMaxRoamPos() {
            return this.maxRoamPos;
        }

        @NotNull
        public final UUID getPlayerId() {
            return this.playerId;
        }

        @NotNull
        public final String getPlayerName() {
            return this.playerName;
        }

        @NotNull
        public final UUID getTetheringId() {
            return this.tetheringId;
        }

        @NotNull
        public final UUID getPokemonId() {
            return this.pokemonId;
        }

        @NotNull
        public final UUID getPcId() {
            return this.pcId;
        }

        public final int getEntityId() {
            return this.entityId;
        }

        @NotNull
        public final BlockPos getPasturePos() {
            return this.pasturePos;
        }

        @Nullable
        public final Pokemon getPokemon() {
            MinecraftServer minecraftServer = DistributionUtilsKt.server();
            if (minecraftServer == null) {
                return null;
            }
            MinecraftServer srv = minecraftServer;
            PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
            RegistryAccess.Frozen frozen = srv.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)frozen, (String)"registryAccess(...)");
            PCStore pc = pokemonStoreManager.getPC(this.pcId, (RegistryAccess)frozen);
            return pc.get(this.pokemonId);
        }

        @NotNull
        public final AABB getBox() {
            return this.box;
        }

        public boolean canRoamTo(@NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return this.box.contains(pos.getCenter());
        }

        @Nullable
        public final OpenPasturePacket.PasturePokemonDataDTO toDTO(@NotNull ServerPlayer player) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Pokemon pokemon = this.getPokemon();
            if (pokemon == null) {
                return null;
            }
            Pokemon pokemon2 = pokemon;
            PokemonEntity entity = pokemon2.getEntity();
            Object object2 = entity;
            if (object2 == null || (object2 = ((PokemonEntity)object2).getActiveBehaviourFlags()) == null) {
                object2 = SetsKt.emptySet();
            }
            Object behaviourFlags = object2;
            return new OpenPasturePacket.PasturePokemonDataDTO(this.pokemonId, this.playerId, (Component)(Intrinsics.areEqual((Object)this.playerId, (Object)player.getUUID()) ? Pokemon.getDisplayName$default(pokemon2, false, 1, null) : TextKt.italicise(Pokemon.getDisplayName$default(pokemon2, false, 1, null))), Intrinsics.areEqual((Object)this.playerId, (Object)player.getUUID()) ? null : this.playerName, pokemon2.getSpecies().getResourceIdentifier(), pokemon2.getAspects(), pokemon2.heldItem(), pokemon2.getLevel(), Intrinsics.areEqual((Object)((object = entity) != null && (object = ((PokemonEntity)object).getTethering()) != null ? ((Tethering)object).tetheringId : null), (Object)this.tetheringId), (Set<? extends PokemonBehaviourFlag>)behaviourFlags);
        }
    }
}

