/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.api.storage.pc.link.PCLink;
import com.cobblemon.mod.common.api.storage.pc.link.PCLinkManager;
import com.cobblemon.mod.common.api.storage.pc.link.ProximityPCLink;
import com.cobblemon.mod.common.block.PCBlock;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00022\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/block/entity/PCBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "on", "", "togglePCOn", "(Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "isPlayerViewing", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/world/level/Level;", "world", "pos", "", "range", "", "getInRangeViewerCount", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;D)I", "Companion", "common"})
public final class PCBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BlockEntityTicker<PCBlockEntity> TICKER = PCBlockEntity::TICKER$lambda$0;

    public PCBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(CobblemonBlockEntities.PC, blockPos, blockState);
    }

    private final void togglePCOn(boolean on) {
        Block block = this.getBlockState().getBlock();
        Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.PCBlock");
        PCBlock pcBlock = (PCBlock)block;
        Level world = this.level;
        if (world != null && !world.isClientSide) {
            BlockState blockState = this.getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            BlockPos posBottom = pcBlock.getBasePosition(blockState, blockPos);
            BlockState stateBottom = world.getBlockState(posBottom);
            Intrinsics.checkNotNull((Object)stateBottom);
            BlockPos posTop = pcBlock.getPositionOfOtherPart(stateBottom, posBottom);
            BlockState stateTop = world.getBlockState(posTop);
            try {
                if (!Intrinsics.areEqual((Object)stateBottom.getValue((Property)PCBlock.Companion.getON()), (Object)on)) {
                    world.setBlockAndUpdate(posTop, (BlockState)stateTop.setValue((Property)PCBlock.Companion.getON(), (Comparable)Boolean.valueOf(on)));
                    world.setBlockAndUpdate(posBottom, (BlockState)stateBottom.setValue((Property)PCBlock.Companion.getON(), (Comparable)Boolean.valueOf(on)));
                }
            }
            catch (IllegalArgumentException exception) {
                boolean bl = world.getBlockState(this.getBlockPos().above()).getBlock() instanceof PCBlock ? world.setBlockAndUpdate(this.getBlockPos().above(), Blocks.AIR.defaultBlockState()) : world.setBlockAndUpdate(this.getBlockPos().below(), Blocks.AIR.defaultBlockState());
                world.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
                world.addFreshEntity((Entity)new ItemEntity(world, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.0, (double)this.getBlockPos().getZ() + 0.5, new ItemStack((ItemLike)CobblemonBlocks.PC)));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPlayerViewing(Player player) {
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PCLink pcLink = PCLinkManager.INSTANCE.getLink(uUID);
        if (pcLink == null) return false;
        if (!(pcLink instanceof ProximityPCLink)) return false;
        if (!Intrinsics.areEqual((Object)((ProximityPCLink)pcLink).getPos(), (Object)this.getBlockPos())) return false;
        Level level = ((ProximityPCLink)pcLink).getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!Intrinsics.areEqual((Object)level.dimension(), (Object)player.level().dimension())) return false;
        return true;
    }

    private final int getInRangeViewerCount(Level world, BlockPos pos, double range) {
        AABB box = new AABB((double)pos.getX() - range, (double)pos.getY() - range, (double)pos.getZ() - range, (double)(pos.getX() + 1) + range, (double)(pos.getY() + 1) + range, (double)(pos.getZ() + 1) + range);
        return world.getEntities(EntityTypeTest.forClass(Player.class), box, arg_0 -> PCBlockEntity.getInRangeViewerCount$lambda$1(arg_0 -> PCBlockEntity.getInRangeViewerCount$lambda$0(this, arg_0), arg_0)).size();
    }

    static /* synthetic */ int getInRangeViewerCount$default(PCBlockEntity pCBlockEntity, Level level, BlockPos blockPos, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 5.0;
        }
        return pCBlockEntity.getInRangeViewerCount(level, blockPos, d);
    }

    private static final boolean getInRangeViewerCount$lambda$0(PCBlockEntity this$0, Player player) {
        Player player2 = player;
        Intrinsics.checkNotNull((Object)player2);
        return this$0.isPlayerViewing(player2);
    }

    private static final boolean getInRangeViewerCount$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void TICKER$lambda$0(Level world, BlockPos blockPos, BlockState blockState, PCBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        Intrinsics.checkNotNull((Object)((Object)blockEntity));
        Intrinsics.checkNotNull((Object)world);
        BlockPos blockPos2 = blockEntity.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        blockEntity.togglePCOn(PCBlockEntity.getInRangeViewerCount$default(blockEntity, world, blockPos2, 0.0, 4, null) > 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/block/entity/PCBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lcom/cobblemon/mod/common/block/entity/PCBlockEntity;", "TICKER", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTICKER$common", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<PCBlockEntity> getTICKER$common() {
            return TICKER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

