/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.HealingMachineBlock;
import com.cobblemon.mod.common.entity.npc.NPCEntity;
import com.cobblemon.mod.common.pokeball.PokeBall;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\u0018\u0000 U2\u00020\u0001:\u0002VUB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0013J\r\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0014\u00a2\u0006\u0004\b \u0010\u001fJ\u0017\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b(\u0010\u0019J\u000f\u0010)\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b)\u0010\u0019J\u000f\u0010*\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b*\u0010\u0019J\u001b\u0010,\u001a\u00020\u00112\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b.\u0010\u0019J\u000f\u0010/\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b/\u0010\u0019J\u000f\u00100\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b0\u0010\u0019J\u000f\u00101\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b1\u0010\u0019R(\u00103\u001a\u0004\u0018\u00010\r2\b\u00102\u001a\u0004\u0018\u00010\r8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\"\u00107\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\"\u0010>\u001a\u00020=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\"\u0010F\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u0010E\"\u0004\bI\u0010JR$\u0010K\u001a\u00020\t2\u0006\u00102\u001a\u00020\t8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bK\u00108\u001a\u0004\bL\u0010:R\"\u0010M\u001a\u00020=8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010?\u001a\u0004\bN\u0010A\"\u0004\bO\u0010CR\u0018\u0010Q\u001a\u0004\u0018\u00010P8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010RR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010T\u00a8\u0006W"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBalls", "()Ljava/util/Map;", "Ljava/util/UUID;", "user", "Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "party", "", "setUser", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/api/storage/party/PartyStore;)V", "", "canHeal", "(Lcom/cobblemon/mod/common/api/storage/party/PartyStore;)Z", "activate", "completeHealing", "()V", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "loadAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "saveAdditional", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "provider", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "setRemoved", "clearRemoved", "updateRedstoneSignal", "level", "updateBlockChargeLevel", "(Ljava/lang/Integer;)V", "markUpdated", "snapshotAndClearData", "clearData", "restoreSnapshot", "value", "currentUser", "Ljava/util/UUID;", "getCurrentUser", "()Ljava/util/UUID;", "healTimeLeft", "I", "getHealTimeLeft", "()I", "setHealTimeLeft", "(I)V", "", "healingCharge", "F", "getHealingCharge", "()F", "setHealingCharge", "(F)V", "isInUse", "()Z", "infinite", "Z", "getInfinite", "setInfinite", "(Z)V", "currentSignal", "getCurrentSignal", "maxCharge", "getMaxCharge", "setMaxCharge", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "dataSnapshot", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "", "Ljava/util/Map;", "Companion", "DataSnapshot", "common"})
@SourceDebugExtension(value={"SMAP\nHealingMachineBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealingMachineBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n1878#2,3:333\n1869#2,2:336\n216#3,2:338\n1#4:340\n*S KotlinDebug\n*F\n+ 1 HealingMachineBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity\n*L\n93#1:333,3\n138#1:336,2\n208#1:338,2\n*E\n"})
public final class HealingMachineBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID currentUser;
    private int healTimeLeft;
    private float healingCharge;
    private boolean infinite;
    private int currentSignal;
    private float maxCharge;
    @Nullable
    private DataSnapshot dataSnapshot;
    @NotNull
    private final Map<Integer, PokeBall> pokeBalls;
    @NotNull
    private static final HashSet<UUID> alreadyHealing = new HashSet();
    public static final int MAX_REDSTONE_SIGNAL = 10;
    @NotNull
    private static final BlockEntityTicker<HealingMachineBlockEntity> TICKER = HealingMachineBlockEntity::TICKER$lambda$0;

    public HealingMachineBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(CobblemonBlockEntities.HEALING_MACHINE, blockPos, blockState);
        this.maxCharge = 6.0f;
        this.pokeBalls = new HashMap();
        this.maxCharge = RangesKt.coerceAtLeast((float)Cobblemon.INSTANCE.getConfig().getMaxHealerCharge(), (float)6.0f);
        this.updateRedstoneSignal();
        HealingMachineBlockEntity.updateBlockChargeLevel$default(this, null, 1, null);
    }

    @Nullable
    public final UUID getCurrentUser() {
        return this.currentUser;
    }

    public final int getHealTimeLeft() {
        return this.healTimeLeft;
    }

    public final void setHealTimeLeft(int n) {
        this.healTimeLeft = n;
    }

    public final float getHealingCharge() {
        return this.healingCharge;
    }

    public final void setHealingCharge(float f) {
        this.healingCharge = f;
    }

    public final boolean isInUse() {
        return this.currentUser != null;
    }

    public final boolean getInfinite() {
        return this.infinite;
    }

    public final void setInfinite(boolean bl) {
        this.infinite = bl;
    }

    public final int getCurrentSignal() {
        return this.currentSignal;
    }

    public final float getMaxCharge() {
        return this.maxCharge;
    }

    public final void setMaxCharge(float f) {
        this.maxCharge = f;
    }

    @NotNull
    public final Map<Integer, PokeBall> pokeBalls() {
        return this.pokeBalls;
    }

    /*
     * WARNING - void declaration
     */
    public final void setUser(@NotNull UUID user, @NotNull PartyStore party) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        this.clearData();
        this.pokeBalls.clear();
        Iterable $this$forEachIndexed$iv = party.toGappyList();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pokemon;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pokemon pokemon2 = (Pokemon)item$iv;
            int index = n;
            boolean bl = false;
            if (pokemon == null) continue;
            this.pokeBalls.put(index, pokemon.getCaughtBall());
        }
        this.currentUser = user;
        this.healTimeLeft = 24;
        this.markUpdated();
    }

    public final boolean canHeal(@NotNull PartyStore party) {
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        if (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite) {
            return true;
        }
        float neededHealthPercent = party.getHealingRemainderPercent();
        return this.healingCharge >= neededHealthPercent;
    }

    public final void activate(@NotNull UUID user, @NotNull PartyStore party) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)party, (String)"party");
        if (!Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() && !(this.healingCharge == this.maxCharge)) {
            float neededHealthPercent = party.getHealingRemainderPercent();
            this.healingCharge = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(this.healingCharge - neededHealthPercent), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)this.maxCharge)))).floatValue();
            this.updateRedstoneSignal();
        }
        this.setUser(user, party);
        alreadyHealing.add(user);
        this.updateBlockChargeLevel(6);
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level world = level;
        if (!world.isClientSide) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            WorldExtensionsKt.playSoundServer$default(world, BlockPosExtensionsKt.toVec3d(blockPos), CobblemonSounds.HEALING_MACHINE_ACTIVE, null, 1.0f, 1.0f, 4, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void completeHealing() {
        block7: {
            block6: {
                v0 = this.currentUser;
                if (v0 == null) {
                    this.clearData();
                    return;
                }
                currentUser = v0;
                player = PlayerExtensionsKt.getPlayer(currentUser);
                if (player == null) break block6;
                party = PlayerExtensionsKt.party(player);
                party.heal();
                healPC = player.level().getGameRules().getBoolean(CobblemonGameRules.HEALERS_HEAL_PC);
                if (healPC) {
                    $this$forEach$iv = PlayerExtensionsKt.pc(player);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Pokemon)element$iv;
                        $i$a$-forEach-HealingMachineBlockEntity$completeHealing$1 = false;
                        it.heal();
                    }
                }
                v1 = LocalizationUtilsKt.lang("healingmachine.healed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"lang(...)");
                player.sendSystemMessage((Component)TextKt.green(v1), true);
                break block7;
            }
            var5_8 = this.level;
            if (var5_8 == null) ** GOTO lbl-1000
            v2 = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getBlockPos(...)");
            var6_10 = var5_8.getEntities(null, AABB.ofSize((Vec3)BlockPosExtensionsKt.toVec3d(v2), (double)10.0, (double)10.0, (double)10.0), (Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, completeHealing$lambda$2(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, completeHealing$lambda$1(java.util.UUID net.minecraft.world.entity.Entity ), (Lnet/minecraft/world/entity/Entity;)Ljava/lang/Boolean;)((UUID)currentUser)));
            if (var6_10 != null) {
                v3 = (Entity)CollectionsKt.firstOrNull((List)var6_10);
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            healPC = v3;
            v4 = npc = healPC instanceof NPCEntity != false ? (NPCEntity)healPC : null;
            v5 = party = v4 != null ? v4.getParty() : null;
            if (party != null) {
                party.heal();
                v6 = LocalizationUtilsKt.lang("healingmachine.healed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"lang(...)");
                npc.sendSystemMessage((Component)TextKt.green(v6));
            }
        }
        HealingMachineBlockEntity.updateBlockChargeLevel$default(this, null, 1, null);
        this.clearData();
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(compoundTag, registryLookup);
        this.pokeBalls.clear();
        if (compoundTag.hasUUID("MachineUser")) {
            this.currentUser = compoundTag.getUUID("MachineUser");
        }
        if (compoundTag.contains("MachinePokeBalls")) {
            CompoundTag pokeBallsTag = compoundTag.getCompound("MachinePokeBalls");
            int index = 0;
            for (String key : pokeBallsTag.getAllKeys()) {
                String pokeBallId = pokeBallsTag.getString(key);
                Intrinsics.checkNotNull((Object)pokeBallId);
                if (((CharSequence)pokeBallId).length() == 0) continue;
                Intrinsics.checkNotNull((Object)key);
                Integer n = StringsKt.toIntOrNull((String)key);
                int actualIndex = n != null ? n : index;
                ResourceLocation resourceLocation = ResourceLocation.parse((String)pokeBallId);
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"parse(...)");
                PokeBall pokeBall = PokeBalls.getPokeBall(resourceLocation);
                if (pokeBall != null) {
                    this.pokeBalls.put(actualIndex, pokeBall);
                }
                ++index;
            }
        }
        if (compoundTag.contains("MachineTimeLeft")) {
            this.healTimeLeft = compoundTag.getInt("MachineTimeLeft");
        }
        if (compoundTag.contains("MachineCharge")) {
            this.healingCharge = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(compoundTag.getFloat("MachineCharge")), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)this.maxCharge)))).floatValue();
        }
        if (compoundTag.contains("MachineInfinite")) {
            this.infinite = compoundTag.getBoolean("MachineInfinite");
        }
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(compoundTag, registryLookup);
        if (this.currentUser != null) {
            UUID uUID = this.currentUser;
            Intrinsics.checkNotNull((Object)uUID);
            compoundTag.putUUID("MachineUser", uUID);
        } else {
            compoundTag.remove("MachineUser");
        }
        if (!this.pokeBalls().isEmpty()) {
            CompoundTag pokeBallsTag = new CompoundTag();
            Map<Integer, PokeBall> $this$forEach$iv = this.pokeBalls();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Integer, PokeBall>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, PokeBall> element$iv;
                Map.Entry<Integer, PokeBall> entry = element$iv = iterator.next();
                boolean bl = false;
                int index = ((Number)entry.getKey()).intValue();
                PokeBall pokeBall = entry.getValue();
                pokeBallsTag.putString(String.valueOf(index), pokeBall.getName().toString());
            }
            compoundTag.put("MachinePokeBalls", (Tag)pokeBallsTag);
        } else {
            compoundTag.remove("MachinePokeBalls");
        }
        compoundTag.putInt("MachineTimeLeft", this.healTimeLeft);
        compoundTag.putFloat("MachineCharge", this.healingCharge);
        compoundTag.putBoolean("MachineInfinite", this.infinite);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        CompoundTag compoundTag = super.saveWithFullMetadata(provider);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithFullMetadata(...)");
        return compoundTag;
    }

    public void setRemoved() {
        this.snapshotAndClearData();
        super.setRemoved();
    }

    public void clearRemoved() {
        this.restoreSnapshot();
        super.clearRemoved();
    }

    private final void updateRedstoneSignal() {
        if (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite) {
            this.currentSignal = 10;
        }
        int remainder = (int)(this.healingCharge / this.maxCharge * (float)100) / 10;
        this.currentSignal = RangesKt.coerceAtMost((int)remainder, (int)10);
    }

    private final void updateBlockChargeLevel(Integer level) {
        Level level2 = this.level;
        if (level2 == null) {
            return;
        }
        Level world = level2;
        if (!world.isClientSide) {
            int currentCharge;
            Integer n = level;
            int chargeLevel = RangesKt.coerceIn((int)(n != null ? n : (Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge() || this.infinite ? 5 : (int)Math.floor(this.healingCharge / this.maxCharge * (float)5))), (ClosedRange)((ClosedRange)new IntRange(0, 6)));
            BlockState state = world.getBlockState(this.getBlockPos());
            if (state.getBlock() instanceof HealingMachineBlock && chargeLevel != (currentCharge = ((Number)((Object)state.getValue((Property)HealingMachineBlock.Companion.getCHARGE_LEVEL()))).intValue())) {
                world.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)HealingMachineBlock.Companion.getCHARGE_LEVEL(), (Comparable)Integer.valueOf(chargeLevel)));
            }
        }
    }

    static /* synthetic */ void updateBlockChargeLevel$default(HealingMachineBlockEntity healingMachineBlockEntity, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        healingMachineBlockEntity.updateBlockChargeLevel(n);
    }

    private final void markUpdated() {
        this.setChanged();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    private final void snapshotAndClearData() {
        this.dataSnapshot = new DataSnapshot(this.currentUser, this.pokeBalls(), this.healTimeLeft);
        this.clearData();
    }

    private final void clearData() {
        UUID uUID = this.currentUser;
        if (uUID != null) {
            UUID uUID2 = uUID;
            HashSet<UUID> hashSet = alreadyHealing;
            UUID p0 = uUID2;
            boolean bl = false;
            hashSet.remove(p0);
        }
        this.currentUser = null;
        this.pokeBalls.clear();
        this.healTimeLeft = 0;
        this.markUpdated();
    }

    private final void restoreSnapshot() {
        block0: {
            DataSnapshot dataSnapshot = this.dataSnapshot;
            if (dataSnapshot == null) break block0;
            DataSnapshot it = dataSnapshot;
            boolean bl = false;
            this.pokeBalls.clear();
            this.currentUser = it.getCurrentUser();
            this.pokeBalls.putAll(it.getPokeBalls());
            this.healTimeLeft = it.getHealTimeLeft();
        }
    }

    private static final boolean completeHealing$lambda$1(UUID $currentUser, Entity it) {
        return Intrinsics.areEqual((Object)it.getUUID(), (Object)$currentUser) && it instanceof NPCEntity;
    }

    private static final boolean completeHealing$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void TICKER$lambda$0(Level world, BlockPos blockPos, BlockState blockState, HealingMachineBlockEntity blockEntity) {
        if (world.isClientSide) {
            return;
        }
        if (blockEntity.isInUse()) {
            if (blockEntity.healTimeLeft > 0) {
                int n = blockEntity.healTimeLeft;
                blockEntity.healTimeLeft = n + -1;
            } else {
                blockEntity.completeHealing();
            }
        } else if (blockEntity.healingCharge < blockEntity.maxCharge) {
            double secondsToChargeHealingMachine = RangesKt.coerceAtLeast((double)Cobblemon.INSTANCE.getConfig().getSecondsToChargeHealingMachine(), (double)0.0);
            double totalTicks = secondsToChargeHealingMachine * (double)20;
            double chargePerTick = totalTicks > 0.0 ? (double)blockEntity.maxCharge / totalTicks : 0.0;
            blockEntity.healingCharge = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(blockEntity.healingCharge + (float)chargePerTick), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)blockEntity.maxCharge)))).floatValue();
            Intrinsics.checkNotNull((Object)((Object)blockEntity));
            HealingMachineBlockEntity.updateBlockChargeLevel$default(blockEntity, null, 1, null);
            blockEntity.updateRedstoneSignal();
            blockEntity.markUpdated();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "isUsingHealer", "(Lnet/minecraft/world/entity/player/Player;)Z", "Ljava/util/HashSet;", "Ljava/util/UUID;", "Lkotlin/collections/HashSet;", "alreadyHealing", "Ljava/util/HashSet;", "", "MAX_REDSTONE_SIGNAL", "I", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity;", "TICKER", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTICKER$common", "()Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntityTicker<HealingMachineBlockEntity> getTICKER$common() {
            return TICKER;
        }

        public final boolean isUsingHealer(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return alreadyHealing.contains(player.getUUID());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J<\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0010\u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "", "Ljava/util/UUID;", "currentUser", "", "", "Lcom/cobblemon/mod/common/pokeball/PokeBall;", "pokeBalls", "healTimeLeft", "<init>", "(Ljava/util/UUID;Ljava/util/Map;I)V", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/util/Map;", "component3", "()I", "copy", "(Ljava/util/UUID;Ljava/util/Map;I)Lcom/cobblemon/mod/common/block/entity/HealingMachineBlockEntity$DataSnapshot;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getCurrentUser", "Ljava/util/Map;", "getPokeBalls", "I", "getHealTimeLeft", "common"})
    private static final class DataSnapshot {
        @Nullable
        private final UUID currentUser;
        @NotNull
        private final Map<Integer, PokeBall> pokeBalls;
        private final int healTimeLeft;

        public DataSnapshot(@Nullable UUID currentUser, @NotNull Map<Integer, ? extends PokeBall> pokeBalls, int healTimeLeft) {
            Intrinsics.checkNotNullParameter(pokeBalls, (String)"pokeBalls");
            this.currentUser = currentUser;
            this.pokeBalls = pokeBalls;
            this.healTimeLeft = healTimeLeft;
        }

        @Nullable
        public final UUID getCurrentUser() {
            return this.currentUser;
        }

        @NotNull
        public final Map<Integer, PokeBall> getPokeBalls() {
            return this.pokeBalls;
        }

        public final int getHealTimeLeft() {
            return this.healTimeLeft;
        }

        @Nullable
        public final UUID component1() {
            return this.currentUser;
        }

        @NotNull
        public final Map<Integer, PokeBall> component2() {
            return this.pokeBalls;
        }

        public final int component3() {
            return this.healTimeLeft;
        }

        @NotNull
        public final DataSnapshot copy(@Nullable UUID currentUser, @NotNull Map<Integer, ? extends PokeBall> pokeBalls, int healTimeLeft) {
            Intrinsics.checkNotNullParameter(pokeBalls, (String)"pokeBalls");
            return new DataSnapshot(currentUser, pokeBalls, healTimeLeft);
        }

        public static /* synthetic */ DataSnapshot copy$default(DataSnapshot dataSnapshot, UUID uUID, Map map, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                uUID = dataSnapshot.currentUser;
            }
            if ((n2 & 2) != 0) {
                map = dataSnapshot.pokeBalls;
            }
            if ((n2 & 4) != 0) {
                n = dataSnapshot.healTimeLeft;
            }
            return dataSnapshot.copy(uUID, map, n);
        }

        @NotNull
        public String toString() {
            return "DataSnapshot(currentUser=" + this.currentUser + ", pokeBalls=" + this.pokeBalls + ", healTimeLeft=" + this.healTimeLeft + ")";
        }

        public int hashCode() {
            int result = this.currentUser == null ? 0 : this.currentUser.hashCode();
            result = result * 31 + ((Object)this.pokeBalls).hashCode();
            result = result * 31 + Integer.hashCode(this.healTimeLeft);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataSnapshot)) {
                return false;
            }
            DataSnapshot dataSnapshot = (DataSnapshot)other;
            if (!Intrinsics.areEqual((Object)this.currentUser, (Object)dataSnapshot.currentUser)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pokeBalls, dataSnapshot.pokeBalls)) {
                return false;
            }
            return this.healTimeLeft == dataSnapshot.healTimeLeft;
        }
    }
}

