/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.block.chest.GildedChestBlock;
import com.cobblemon.mod.common.block.chest.GildedState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.pose.Pose;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 V2\u00020\u00012\u00020\u0002:\u0001VB!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020!2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b$\u0010#J\u0017\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b(\u0010)J)\u0010.\u001a\u00020-2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0004\b.\u0010/J'\u00100\u001a\u00020-2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020%H\u0016\u00a2\u0006\u0004\b0\u0010/J\u0017\u00101\u001a\u00020-2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b1\u00102J\u001d\u00104\u001a\u00020!2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014\u00a2\u0006\u0004\b4\u00105J\u001f\u00107\u001a\u00020-2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b7\u00108J5\u0010=\u001a\u00020!2\u0006\u0010:\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e\u00a2\u0006\u0004\b=\u0010>J\u001f\u0010C\u001a\u00020!2\u0006\u0010@\u001a\u00020?2\u0006\u0010B\u001a\u00020AH\u0014\u00a2\u0006\u0004\bC\u0010DJ\u001f\u0010E\u001a\u00020!2\u0006\u0010@\u001a\u00020?2\u0006\u0010B\u001a\u00020AH\u0014\u00a2\u0006\u0004\bE\u0010DJ\r\u0010F\u001a\u00020!\u00a2\u0006\u0004\bF\u0010GR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010H\u001a\u0004\b\f\u0010IR(\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010\u001e\"\u0004\bM\u00105R\u0017\u0010O\u001a\u00020N8\u0006\u00a2\u0006\f\n\u0004\bO\u0010P\u001a\u0004\bQ\u0010RR\u0014\u0010T\u001a\u00020S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bT\u0010U\u00a8\u0006W"}, d2={"Lcom/cobblemon/mod/common/block/entity/GildedChestBlockEntity;", "Lnet/minecraft/world/level/block/entity/RandomizableContainerBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "type", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getType", "()Lnet/minecraft/world/level/block/entity/BlockEntityType;", "", "getContainerSize", "()I", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "getDefaultName", "()Lnet/minecraft/network/chat/MutableComponent;", "syncId", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "startOpen", "(Lnet/minecraft/world/entity/player/Player;)V", "stopOpen", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "slot", "stack", "dir", "", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "canTakeItemThroughFace", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "inventory", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "data", "triggerEvent", "(II)Z", "Lnet/minecraft/world/level/Level;", "world", "oldViewerCount", "newViewerCount", "onViewerCountUpdate", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)V", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "Lnet/minecraft/core/HolderLookup$Provider;", "registryLookup", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "tick", "()V", "Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "()Lcom/cobblemon/mod/common/block/chest/GildedChestBlock$Type;", "inventoryContents", "Lnet/minecraft/core/NonNullList;", "getInventoryContents", "setInventoryContents", "Lcom/cobblemon/mod/common/block/chest/GildedState;", "posableState", "Lcom/cobblemon/mod/common/block/chest/GildedState;", "getPosableState", "()Lcom/cobblemon/mod/common/block/chest/GildedState;", "Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "stateManager", "Lnet/minecraft/world/level/block/entity/ContainerOpenersCounter;", "Companion", "common"})
public final class GildedChestBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GildedChestBlock.Type type;
    @NotNull
    private NonNullList<ItemStack> inventoryContents;
    @NotNull
    private final GildedState posableState;
    @NotNull
    private final ContainerOpenersCounter stateManager;
    private static final int NUM_SLOTS = 27;

    public GildedChestBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull GildedChestBlock.Type type) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(CobblemonBlockEntities.GILDED_CHEST, pos, state);
        this.type = type;
        NonNullList nonNullList = NonNullList.withSize((int)NUM_SLOTS, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inventoryContents = nonNullList;
        this.posableState = new GildedState();
        this.stateManager = new ContainerOpenersCounter(this){
            final /* synthetic */ GildedChestBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            protected void onOpen(Level world, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                GildedChestBlockEntity.Companion.playSound(world, pos, state, CobblemonSounds.GILDED_CHEST_OPEN);
            }

            protected void onClose(Level world, BlockPos pos, BlockState state) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                GildedChestBlockEntity.Companion.playSound(world, pos, state, CobblemonSounds.GILDED_CHEST_CLOSE);
            }

            protected void openerCountChanged(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                this.this$0.onViewerCountUpdate(world, pos, state, oldViewerCount, newViewerCount);
            }

            protected boolean isOwnContainer(Player player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                if (player.containerMenu instanceof ChestMenu) {
                    AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                    Intrinsics.checkNotNull((Object)abstractContainerMenu, (String)"null cannot be cast to non-null type net.minecraft.world.inventory.ChestMenu");
                    Container inventory = ((ChestMenu)abstractContainerMenu).getContainer();
                    return inventory == this.this$0;
                }
                return false;
            }
        };
    }

    public /* synthetic */ GildedChestBlockEntity(BlockPos blockPos, BlockState blockState, GildedChestBlock.Type type, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            type = GildedChestBlock.Type.RED;
        }
        this(blockPos, blockState, type);
    }

    @NotNull
    public final GildedChestBlock.Type getType() {
        return this.type;
    }

    @NotNull
    public final NonNullList<ItemStack> getInventoryContents() {
        return this.inventoryContents;
    }

    public final void setInventoryContents(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.inventoryContents = nonNullList;
    }

    @NotNull
    public final GildedState getPosableState() {
        return this.posableState;
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return CobblemonBlockEntities.GILDED_CHEST;
    }

    public int getContainerSize() {
        return NUM_SLOTS;
    }

    protected MutableComponent getDefaultName() {
        return Component.translatable((String)"block.cobblemon.gilded_chest");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int syncId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        ChestMenu chestMenu = ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)((Container)this));
        Intrinsics.checkNotNullExpressionValue((Object)chestMenu, (String)"threeRows(...)");
        return (AbstractContainerMenu)chestMenu;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.inventoryContents;
    }

    public void startOpen(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.remove && !player.isSpectator() && this.type != GildedChestBlock.Type.FAKE) {
            this.stateManager.incrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.decrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (this.type == GildedChestBlock.Type.FAKE) {
            nArray = new int[]{};
        } else {
            int n = 0;
            int n2 = NUM_SLOTS;
            int[] nArray2 = new int[n2];
            while (n < n2) {
                int n3;
                nArray2[n3] = n3 = n++;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public boolean canPlaceItemThroughFace(int slot, @NotNull ItemStack stack, @Nullable Direction dir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.type == GildedChestBlock.Type.FAKE) {
            return false;
        }
        return dir != Direction.DOWN;
    }

    public boolean canTakeItemThroughFace(int slot, @NotNull ItemStack stack, @NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.type == GildedChestBlock.Type.FAKE) {
            return false;
        }
        return dir == Direction.DOWN;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return !player.isSpectator();
    }

    protected void setItems(@NotNull NonNullList<ItemStack> inventory) {
        Intrinsics.checkNotNullParameter(inventory, (String)"inventory");
        this.inventoryContents = inventory;
    }

    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            boolean isNowOpen = data > 0;
            boolean wasOpen = Intrinsics.areEqual((Object)this.posableState.getCurrentPose(), (Object)"open");
            PosableModel posableModel = this.posableState.getCurrentModel();
            if (posableModel == null) {
                return true;
            }
            PosableModel model = posableModel;
            if (isNowOpen && !wasOpen) {
                PosableState posableState = this.posableState;
                Pose pose = model.getPoses().get("open");
                Intrinsics.checkNotNull((Object)pose);
                model.moveToPose(posableState, pose);
            } else if (!isNowOpen && wasOpen) {
                PosableState posableState = this.posableState;
                Pose pose = model.getPoses().get("closed");
                Intrinsics.checkNotNull((Object)pose);
                model.moveToPose(posableState, pose);
            }
            return true;
        }
        return super.triggerEvent(type, data);
    }

    public final void onViewerCountUpdate(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int oldViewerCount, int newViewerCount) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Block block = state.getBlock();
        world.blockEvent(pos, block, 1, newViewerCount);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.saveAdditional(nbt, registryLookup);
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventoryContents, (HolderLookup.Provider)registryLookup);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        super.loadAdditional(nbt, registryLookup);
        NonNullList nonNullList = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inventoryContents = nonNullList;
        if (!this.tryLoadLootTable(nbt)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventoryContents, (HolderLookup.Provider)registryLookup);
        }
    }

    public final void tick() {
        if (!this.remove) {
            this.stateManager.recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u000f8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/block/entity/GildedChestBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/sounds/SoundEvent;", "sound", "", "playSound", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/sounds/SoundEvent;)V", "", "NUM_SLOTS", "I", "getNUM_SLOTS", "()I", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getNUM_SLOTS() {
            return NUM_SLOTS;
        }

        public final void playSound(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull SoundEvent sound) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
            double d = (double)pos.getX() + 0.5;
            double e = (double)pos.getY() + 0.5;
            double f = (double)pos.getZ() + 0.5;
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            world.playSound(null, d += (double)direction.getStepX() * 0.5, e, f += (double)direction.getStepZ() * 0.5, sound, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

