/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block.entity;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonRecipeTypes;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.cooking.FlavourColourHelperKt;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.api.snowstorm.BedrockParticleOptions;
import com.cobblemon.mod.common.block.campfirepot.CampfireBlock;
import com.cobblemon.mod.common.block.campfirepot.CookingPotMenu;
import com.cobblemon.mod.common.client.particle.BedrockParticleOptionsRepository;
import com.cobblemon.mod.common.client.particle.ParticleStorm;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.client.sound.BlockEntitySoundTracker;
import com.cobblemon.mod.common.client.sound.instances.CancellableSoundInstance;
import com.cobblemon.mod.common.item.CampfirePotItem;
import com.cobblemon.mod.common.item.components.PotComponent;
import com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase;
import com.cobblemon.mod.common.item.crafting.SeasoningProcessor;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u0090\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0002\u0090\u0001B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J5\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b\u001f\u0010\u001eJ\u000f\u0010!\u001a\u00020 H\u0014\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020#H\u0016\u00a2\u0006\u0004\b&\u0010%J\u0015\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0016\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010+\u001a\u00020\u00182\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0014\u00a2\u0006\u0004\b+\u0010,J\u001f\u00101\u001a\u0002002\u0006\u0010-\u001a\u00020#2\u0006\u0010/\u001a\u00020.H\u0014\u00a2\u0006\u0004\b1\u00102J\u000f\u00103\u001a\u00020#H\u0016\u00a2\u0006\u0004\b3\u0010%J\u0017\u00107\u001a\u0002062\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b7\u00108J\u001d\u0010:\u001a\u00020\u00182\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u000109H\u0016\u00a2\u0006\u0004\b:\u0010;J\u0011\u0010=\u001a\u0004\u0018\u00010<H\u0016\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010A\u001a\u00020\u00182\u0006\u0010@\u001a\u00020?H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\u001c2\u0006\u0010C\u001a\u00020#H\u0016\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010F\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010I\u001a\u00020\u00182\b\u0010H\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\bI\u0010JJ\u001f\u0010O\u001a\u00020\u00182\u0006\u0010L\u001a\u00020K2\u0006\u0010N\u001a\u00020MH\u0014\u00a2\u0006\u0004\bO\u0010PJ\u001f\u0010Q\u001a\u00020\u00182\u0006\u0010L\u001a\u00020K2\u0006\u0010N\u001a\u00020MH\u0014\u00a2\u0006\u0004\bQ\u0010PJ\u0017\u0010T\u001a\n\u0012\u0004\u0012\u00020S\u0018\u00010RH\u0016\u00a2\u0006\u0004\bT\u0010UJ\u0017\u0010W\u001a\u00020K2\u0006\u0010V\u001a\u00020MH\u0016\u00a2\u0006\u0004\bW\u0010XJ\u0017\u0010Y\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\bY\u0010ZJ\u000f\u0010[\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b[\u0010\\J\u0015\u0010_\u001a\u00020\u00182\u0006\u0010^\u001a\u00020]\u00a2\u0006\u0004\b_\u0010`J'\u0010c\u001a\u00020]2\u0006\u0010a\u001a\u00020#2\u0006\u0010H\u001a\u00020\u001c2\u0006\u0010b\u001a\u000204H\u0016\u00a2\u0006\u0004\bc\u0010dJ)\u0010f\u001a\u00020]2\u0006\u0010a\u001a\u00020#2\u0006\u0010e\u001a\u00020\u001c2\b\u0010b\u001a\u0004\u0018\u000104H\u0016\u00a2\u0006\u0004\bf\u0010dR\u0014\u0010h\u001a\u00020g8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bh\u0010iR\u0014\u0010j\u001a\u00020g8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bj\u0010iR\u0016\u0010k\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bk\u0010lR\u0016\u0010m\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bm\u0010lR\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010nR\u001a\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00100o8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u001e\u0010t\u001a\f\u0012\u0004\u0012\u00020s\u0012\u0002\b\u00030r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bt\u0010uR\u0018\u0010w\u001a\u0004\u0018\u00010v8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010xR\u0016\u0010y\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\by\u0010lR\"\u0010z\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bz\u0010l\u001a\u0004\b{\u0010%\"\u0004\b|\u0010}R#\u0010~\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0013\n\u0004\b~\u0010l\u001a\u0004\b\u007f\u0010%\"\u0005\b\u0080\u0001\u0010}R&\u0010\u0081\u0001\u001a\u00020#8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0081\u0001\u0010l\u001a\u0005\b\u0082\u0001\u0010%\"\u0005\b\u0083\u0001\u0010}R.\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u0084\u0001\u0010\u0085\u0001\u001a\u0005\b\u0086\u0001\u0010\u001e\"\u0006\b\u0087\u0001\u0010\u0088\u0001R*\u0010\u008a\u0001\u001a\u00030\u0089\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u008a\u0001\u0010\u008b\u0001\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001\"\u0006\b\u008e\u0001\u0010\u008f\u0001\u00a8\u0006\u0091\u0001"}, d2={"Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;", "Lnet/minecraft/world/level/block/entity/BaseContainerBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "Lnet/minecraft/world/inventory/RecipeCraftingHolder;", "Lnet/minecraft/world/inventory/StackedContentsCompatible;", "Lnet/minecraft/world/inventory/CraftingContainer;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lnet/minecraft/world/phys/Vec3;", "position", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/resources/ResourceLocation;", "particle", "Lcom/cobblemon/mod/common/client/particle/ParticleStorm;", "particleEntityHandler", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/client/particle/ParticleStorm;", "Lcom/cobblemon/mod/common/item/crafting/CookingPotRecipeBase;", "recipe", "campfireBlockEntity", "", "consumeCraftingIngredients", "(Lcom/cobblemon/mod/common/item/crafting/CookingPotRecipeBase;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;)V", "", "Lnet/minecraft/world/item/ItemStack;", "getSeasonings", "()Ljava/util/List;", "getIngredients", "Lnet/minecraft/network/chat/Component;", "getDefaultName", "()Lnet/minecraft/network/chat/Component;", "", "getWidth", "()I", "getHeight", "Lnet/minecraft/core/NonNullList;", "getItems", "()Lnet/minecraft/core/NonNullList;", "items", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "containerId", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "getContainerSize", "Lnet/minecraft/core/Direction;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "setRecipeUsed", "(Lnet/minecraft/world/item/crafting/RecipeHolder;)V", "", "getRecipeUsed", "()Ljava/lang/Void;", "Lnet/minecraft/world/entity/player/StackedContents;", "contents", "fillStackedContents", "(Lnet/minecraft/world/entity/player/StackedContents;)V", "slot", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "getPotItem", "()Lnet/minecraft/world/item/ItemStack;", "stack", "setPotItem", "(Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "registries", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "registryLookup", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "onItemUpdate", "(Lnet/minecraft/world/level/Level;)V", "setRemoved", "()V", "", "isOpen", "toggleLid", "(Z)V", "index", "direction", "canTakeItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "itemStack", "canPlaceItemThroughFace", "Lnet/minecraft/sounds/SoundEvent;", "runningSound", "Lnet/minecraft/sounds/SoundEvent;", "ambientSound", "cookingProgress", "I", "cookingTotalTime", "Lnet/minecraft/core/NonNullList;", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "recipesUsed", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;", "Lnet/minecraft/world/item/crafting/CraftingInput;", "quickCheck", "Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;", "Lcom/cobblemon/mod/common/item/components/PotComponent;", "potComponent", "Lcom/cobblemon/mod/common/item/components/PotComponent;", "particleCooldown", "brothColor", "getBrothColor", "setBrothColor", "(I)V", "bubbleColor", "getBubbleColor", "setBubbleColor", "time", "getTime", "setTime", "lastSeasoningStacks", "Ljava/util/List;", "getLastSeasoningStacks", "setLastSeasoningStacks", "(Ljava/util/List;)V", "Lnet/minecraft/world/inventory/ContainerData;", "dataAccess", "Lnet/minecraft/world/inventory/ContainerData;", "getDataAccess", "()Lnet/minecraft/world/inventory/ContainerData;", "setDataAccess", "(Lnet/minecraft/world/inventory/ContainerData;)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCampfireBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfireBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/CampfireBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,501:1\n1761#2,3:502\n774#2:505\n865#2,2:506\n774#2:508\n865#2,2:509\n1#3:511\n*S KotlinDebug\n*F\n+ 1 CampfireBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/CampfireBlockEntity\n*L\n325#1:502,3\n350#1:505\n350#1:506,2\n355#1:508\n355#1:509,2\n*E\n"})
public final class CampfireBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible,
CraftingContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SoundEvent runningSound;
    @NotNull
    private final SoundEvent ambientSound;
    private int cookingProgress;
    private int cookingTotalTime;
    @NotNull
    private NonNullList<ItemStack> items;
    @NotNull
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    @NotNull
    private final RecipeManager.CachedCheck<CraftingInput, ?> quickCheck;
    @Nullable
    private PotComponent potComponent;
    private int particleCooldown;
    private int brothColor;
    private int bubbleColor;
    private int time;
    @NotNull
    private List<ItemStack> lastSeasoningStacks;
    @NotNull
    private ContainerData dataAccess;
    public static final int RESULT_SLOT = 0;
    @NotNull
    private static final IntRange CRAFTING_GRID_SLOTS = new IntRange(1, 9);
    @NotNull
    private static final IntRange SEASONING_SLOTS = new IntRange(10, 12);
    public static final int ITEMS_SIZE = 13;
    @NotNull
    private static final IntRange PLAYER_INVENTORY_SLOTS = new IntRange(13, 39);
    @NotNull
    private static final IntRange PLAYER_HOTBAR_SLOTS = new IntRange(40, 48);
    public static final int CRAFTING_GRID_WIDTH = 3;
    public static final int PLAYER_INVENTORY_WIDTH = 9;
    public static final int COOKING_TOTAL_TIME = 200;
    public static final int COOKING_PROGRESS_PER_TICK = 2;
    public static final int COOKING_PROGRESS_INDEX = 0;
    public static final int COOKING_PROGRESS_TOTAL_TIME_INDEX = 1;
    public static final int IS_LID_OPEN_INDEX = 2;
    public static final int COOKING_POT_COLOR_INDEX = 3;
    public static final int BASE_BROTH_COLOR = 16644815;
    public static final int BASE_BROTH_BUBBLE_COLOR = -66076;

    public CampfireBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(CobblemonBlockEntities.CAMPFIRE, pos, state);
        this.runningSound = CobblemonSounds.CAMPFIRE_POT_ACTIVE;
        this.ambientSound = CobblemonSounds.CAMPFIRE_POT_AMBIENT;
        this.cookingTotalTime = 200;
        NonNullList nonNullList = NonNullList.withSize((int)13, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        this.recipesUsed = new Object2IntOpenHashMap();
        RecipeManager.CachedCheck cachedCheck = RecipeManager.createCheck(CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING());
        Intrinsics.checkNotNullExpressionValue((Object)cachedCheck, (String)"createCheck(...)");
        this.quickCheck = cachedCheck;
        this.brothColor = 16644815;
        this.bubbleColor = -66076;
        this.lastSeasoningStacks = CollectionsKt.emptyList();
        this.dataAccess = new ContainerData(this){
            final /* synthetic */ CampfireBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return switch (index) {
                    case 0 -> CampfireBlockEntity.access$getCookingProgress$p(this.this$0);
                    case 1 -> CampfireBlockEntity.access$getCookingTotalTime$p(this.this$0);
                    case 2 -> {
                        if (((Boolean)this.this$0.getBlockState().getValue((Property)CampfireBlock.Companion.getLID())).booleanValue()) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 3 -> {
                        ItemStack v1 = this.this$0.getPotItem();
                        Item var2_2 = v1 != null ? v1.getItem() : null;
                        Object v2 = var2_2 instanceof CampfirePotItem ? (CampfirePotItem)var2_2 : null;
                        if (v2 != null && (v2 = v2.getColor()) != null) {
                            yield ((Enum)v2).ordinal();
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        CampfireBlockEntity.access$setCookingProgress$p(this.this$0, value);
                        break;
                    }
                    case 1: {
                        CampfireBlockEntity.access$setCookingTotalTime$p(this.this$0, value);
                        break;
                    }
                    case 2: {
                        this.this$0.toggleLid(value == 1);
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
    }

    public final int getBrothColor() {
        return this.brothColor;
    }

    public final void setBrothColor(int n) {
        this.brothColor = n;
    }

    public final int getBubbleColor() {
        return this.bubbleColor;
    }

    public final void setBubbleColor(int n) {
        this.bubbleColor = n;
    }

    public final int getTime() {
        return this.time;
    }

    public final void setTime(int n) {
        this.time = n;
    }

    @NotNull
    public final List<ItemStack> getLastSeasoningStacks() {
        return this.lastSeasoningStacks;
    }

    public final void setLastSeasoningStacks(@NotNull List<ItemStack> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.lastSeasoningStacks = list;
    }

    @NotNull
    public final ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public final void setDataAccess(@NotNull ContainerData containerData) {
        Intrinsics.checkNotNullParameter((Object)containerData, (String)"<set-?>");
        this.dataAccess = containerData;
    }

    @NotNull
    public final ParticleStorm particleEntityHandler(@NotNull Vec3 position, @NotNull Level level, @NotNull ResourceLocation particle) {
        ParticleStorm particleStorm;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        MatrixWrapper wrapper = new MatrixWrapper();
        PoseStack matrix = new PoseStack();
        Matrix4f matrix4f = matrix.last().pose();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        wrapper.updateMatrix(matrix4f);
        wrapper.updatePosition(position);
        BedrockParticleOptions bedrockParticleOptions = BedrockParticleOptionsRepository.INSTANCE.getEffect(particle);
        if (bedrockParticleOptions == null) {
            throw new IllegalStateException("Particle with resource location " + particle + " not found");
        }
        BedrockParticleOptions effect = bedrockParticleOptions;
        ParticleStorm it = particleStorm = new ParticleStorm(effect, wrapper, wrapper, (ClientLevel)level, null, () -> CampfireBlockEntity.particleEntityHandler$lambda$0(this), () -> CampfireBlockEntity.particleEntityHandler$lambda$1(this), null, null, () -> CampfireBlockEntity.particleEntityHandler$lambda$2(this), null, null, 3472, null);
        boolean bl = false;
        it.spawn();
        ParticleStorm particleStorm2 = particleStorm;
        return particleStorm2;
    }

    public final void consumeCraftingIngredients(@NotNull CookingPotRecipeBase recipe, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull CampfireBlockEntity campfireBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)campfireBlockEntity), (String)"campfireBlockEntity");
        Map remainderItems = new LinkedHashMap();
        int i = CRAFTING_GRID_SLOTS.getFirst();
        int n = CRAFTING_GRID_SLOTS.getLast();
        if (i <= n) {
            while (true) {
                CampfireBlockEntity.consumeCraftingIngredients$consumeItem(this, remainderItems, i);
                if (i == n) break;
                ++i;
            }
        }
        if ((i = SEASONING_SLOTS.getFirst()) <= (n = SEASONING_SLOTS.getLast())) {
            while (true) {
                if (this.getItem(i).is(recipe.getSeasoningTag())) {
                    boolean bl;
                    block11: {
                        Iterable $this$any$iv = recipe.getSeasoningProcessors();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                SeasoningProcessor it = (SeasoningProcessor)element$iv;
                                boolean bl2 = false;
                                if (!it.consumesItem(this.getItem(i))) continue;
                                bl = true;
                                break block11;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        CampfireBlockEntity.consumeCraftingIngredients$consumeItem(this, remainderItems, i);
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
        Direction direction = (Direction)state.getValue((Property)CampfireBlock.Companion.getITEM_DIRECTION());
        Container container = HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos.relative(direction));
        for (Map.Entry remainder : remainderItems.entrySet()) {
            ItemStack remainderItem = new ItemStack((ItemLike)remainder.getKey(), ((Number)remainder.getValue()).intValue());
            if (container != null) {
                ItemStack itemStack = HopperBlockEntity.addItem((Container)((Container)campfireBlockEntity), (Container)container, (ItemStack)remainderItem, (Direction)direction.getOpposite());
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"addItem(...)");
                remainderItem = itemStack;
            }
            if (remainderItem.isEmpty()) continue;
            Vec3 spawnPos = Vec3.atCenterOf((Vec3i)((Vec3i)pos)).relative(direction, 0.7);
            ItemEntity itemEntity = new ItemEntity(level, spawnPos.x, spawnPos.y, spawnPos.z, remainderItem);
            itemEntity.setDeltaMovement((double)direction.getStepX() * 0.05, 0.0, (double)direction.getStepZ() * 0.05);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemStack> getSeasonings() {
        void $this$filterTo$iv$iv;
        List list = this.items.subList(SEASONING_SLOTS.getFirst(), SEASONING_SLOTS.getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"subList(...)");
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemStack> getIngredients() {
        void $this$filterTo$iv$iv;
        List list = this.items.subList(CRAFTING_GRID_SLOTS.getFirst(), CRAFTING_GRID_SLOTS.getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"subList(...)");
        Iterable $this$filter$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.translatable((String)"cobblemon.container.campfire_pot");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        block0: {
            Level level = this.level;
            if (level == null) break block0;
            Level it = level;
            boolean bl = false;
            this.onItemUpdate(it);
        }
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> items) {
        block0: {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items.clear();
            this.items.addAll((Collection)items);
            Level level = this.level;
            if (level == null) break block0;
            Level it = level;
            boolean bl = false;
            this.onItemUpdate(it);
        }
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        return (AbstractContainerMenu)new CookingPotMenu(containerId, inventory, this, this.dataAccess);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return CollectionsKt.toIntArray((Collection)CollectionsKt.toList((Iterable)((Iterable)new IntRange(0, 12))));
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourceLocation = recipe.id();
            this.recipesUsed.addTo((Object)resourceLocation, 1);
        }
    }

    @Nullable
    public Void getRecipeUsed() {
        return null;
    }

    public void fillStackedContents(@NotNull StackedContents contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Iterator iterator = this.items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator2.next();
            contents.accountSimpleStack(itemStack);
        }
    }

    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack;
        boolean bl = 0 <= slot ? slot < this.items.size() : false;
        if (bl) {
            Object object = this.items.get(slot);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            itemStack = (ItemStack)object;
        } else {
            ItemStack itemStack2 = ItemStack.EMPTY;
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        }
        return itemStack;
    }

    @Nullable
    public final ItemStack getPotItem() {
        PotComponent potComponent = this.potComponent;
        return potComponent != null ? potComponent.getPotItem() : null;
    }

    public final void setPotItem(@Nullable ItemStack stack) {
        block1: {
            ItemStack itemStack = stack;
            if (itemStack == null) {
                itemStack = ItemStack.EMPTY;
            }
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNull((Object)itemStack2);
            this.potComponent = new PotComponent(itemStack2);
            this.setChanged();
            Level level = this.level;
            if (level == null) break block1;
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            super.saveAdditional(tag, registries);
            tag.putInt("CookingProgress", this.cookingProgress);
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
            PotComponent potComponent = this.potComponent;
            if (potComponent == null) break block1;
            PotComponent component = potComponent;
            boolean bl = false;
            Optional optional = PotComponent.Companion.getCODEC().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)component).result();
            if (optional != null) {
                optional.ifPresent(arg_0 -> CampfireBlockEntity.saveAdditional$lambda$0$1(arg_0 -> CampfireBlockEntity.saveAdditional$lambda$0$0(tag, arg_0), arg_0));
            }
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.cookingProgress = tag.getInt("CookingProgress");
        this.clearContent();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains("PotComponent")) {
            PotComponent component;
            Optional optional = PotComponent.Companion.getCODEC().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("PotComponent")).result();
            this.potComponent = component = optional != null ? (PotComponent)optional.orElse(null) : null;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)((BlockEntity)this));
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registryLookup) {
        Intrinsics.checkNotNullParameter((Object)registryLookup, (String)"registryLookup");
        CompoundTag compoundTag = this.saveWithoutMetadata(registryLookup);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    private final void onItemUpdate(Level level) {
        BlockState oldState = level.getBlockState(this.getBlockPos());
        level.sendBlockUpdated(this.getBlockPos(), oldState, level.getBlockState(this.getBlockPos()), 3);
        level.updateNeighbourForOutputSignal(this.getBlockPos(), level.getBlockState(this.getBlockPos()).getBlock());
        this.setChanged();
        level.sendBlockUpdated(this.getBlockPos(), oldState, level.getBlockState(this.getBlockPos()), 3);
    }

    public void setRemoved() {
        this.cookingProgress = 0;
        super.setRemoved();
        Level level = this.level;
        boolean bl = level != null ? level.isClientSide : false;
        if (bl) {
            BlockPos blockPos = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            ResourceLocation resourceLocation = this.runningSound.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
            BlockEntitySoundTracker.INSTANCE.stop(blockPos, resourceLocation);
            BlockPos blockPos2 = this.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
            ResourceLocation resourceLocation2 = this.ambientSound.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"getLocation(...)");
            BlockEntitySoundTracker.INSTANCE.stop(blockPos2, resourceLocation2);
        }
    }

    public final void toggleLid(boolean isOpen) {
        Level level = this.level;
        if (level != null) {
            Level lvl = level;
            boolean bl = false;
            Vec3 vec3 = this.getBlockPos().getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            WorldExtensionsKt.playSoundServer$default(lvl, vec3, isOpen ? CobblemonSounds.CAMPFIRE_POT_OPEN : CobblemonSounds.CAMPFIRE_POT_CLOSE, null, 0.0f, 0.0f, 28, null);
            lvl.gameEvent(null, (Holder)(isOpen ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), this.getBlockPos());
            lvl.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CampfireBlock.Companion.getLID(), (Comparable)Boolean.valueOf(!isOpen)), 3);
        }
        this.setChanged();
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return index == 0;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return direction == Direction.UP && Seasonings.INSTANCE.isSeasoning(itemStack) ? SEASONING_SLOTS.contains(index) : CRAFTING_GRID_SLOTS.contains(index);
    }

    private static final boolean particleEntityHandler$lambda$0(CampfireBlockEntity this$0) {
        Comparable comparable = this$0.getBlockState().getValue((Property)CampfireBlock.Companion.getCOOKING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Boolean)comparable;
    }

    private static final boolean particleEntityHandler$lambda$1(CampfireBlockEntity this$0) {
        Comparable comparable = this$0.getBlockState().getValue((Property)CampfireBlock.Companion.getCOOKING());
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Boolean)comparable;
    }

    private static final Vector4f particleEntityHandler$lambda$2(CampfireBlockEntity this$0) {
        float red = (float)FastColor.ARGB32.red((int)this$0.bubbleColor) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)this$0.bubbleColor) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)this$0.bubbleColor) / 255.0f;
        float alpha = (float)FastColor.ARGB32.alpha((int)this$0.bubbleColor) / 255.0f;
        return new Vector4f(red, green, blue, alpha);
    }

    private static final void consumeCraftingIngredients$consumeItem(CampfireBlockEntity this$0, Map<Item, Integer> remainderItems, int slot) {
        ItemStack itemInSlot = this$0.getItem(slot);
        if (!itemInSlot.isEmpty()) {
            if (itemInSlot.getItem().hasCraftingRemainingItem()) {
                Map<Item, Integer> map = remainderItems;
                Item item = itemInSlot.getItem().getCraftingRemainingItem();
                Intrinsics.checkNotNull((Object)item);
                Item item2 = item;
                Item item3 = itemInSlot.getItem().getCraftingRemainingItem();
                Intrinsics.checkNotNull((Object)item3);
                Integer n = remainderItems.get(item3);
                Integer n2 = (n != null ? n : 0) + 1;
                map.put(item2, n2);
            }
            itemInSlot.shrink(1);
            if (itemInSlot.getCount() <= 0) {
                this$0.setItem(slot, ItemStack.EMPTY);
            }
        }
    }

    private static final Unit saveAdditional$lambda$0$0(CompoundTag $tag, Tag encoded) {
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        $tag.put("PotComponent", encoded);
        return Unit.INSTANCE;
    }

    private static final void saveAdditional$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setChanged$s-1295109088(Level level, BlockPos pos, BlockState state) {
        BaseContainerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public static final /* synthetic */ void access$setCookingTotalTime$p(CampfireBlockEntity $this, int n) {
        $this.cookingTotalTime = n;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0012R\u0017\u0010\u001b\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0015\u001a\u0004\b\u001c\u0010\u0017R\u0017\u0010\u001d\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001e\u0010\u0017R\u0014\u0010\u001f\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0012R\u0014\u0010 \u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u0012R\u0014\u0010!\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\u0012R\u0014\u0010\"\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0012R\u0014\u0010#\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010\u0012R\u0014\u0010$\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b$\u0010\u0012R\u0014\u0010%\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010\u0012R\u0014\u0010&\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010\u0012R\u0014\u0010'\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010\u0012R\u0014\u0010(\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;", "campfireBlockEntity", "", "clientTick", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/block/entity/CampfireBlockEntity;)V", "serverTick", "", "RESULT_SLOT", "I", "Lkotlin/ranges/IntRange;", "CRAFTING_GRID_SLOTS", "Lkotlin/ranges/IntRange;", "getCRAFTING_GRID_SLOTS", "()Lkotlin/ranges/IntRange;", "SEASONING_SLOTS", "getSEASONING_SLOTS", "ITEMS_SIZE", "PLAYER_INVENTORY_SLOTS", "getPLAYER_INVENTORY_SLOTS", "PLAYER_HOTBAR_SLOTS", "getPLAYER_HOTBAR_SLOTS", "CRAFTING_GRID_WIDTH", "PLAYER_INVENTORY_WIDTH", "COOKING_TOTAL_TIME", "COOKING_PROGRESS_PER_TICK", "COOKING_PROGRESS_INDEX", "COOKING_PROGRESS_TOTAL_TIME_INDEX", "IS_LID_OPEN_INDEX", "COOKING_POT_COLOR_INDEX", "BASE_BROTH_COLOR", "BASE_BROTH_BUBBLE_COLOR", "common"})
    @SourceDebugExtension(value={"SMAP\nCampfireBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfireBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/CampfireBlockEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,501:1\n1761#2,3:502\n774#2:505\n865#2,2:506\n*S KotlinDebug\n*F\n+ 1 CampfireBlockEntity.kt\ncom/cobblemon/mod/common/block/entity/CampfireBlockEntity$Companion\n*L\n115#1:502,3\n176#1:505\n176#1:506,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange getCRAFTING_GRID_SLOTS() {
            return CRAFTING_GRID_SLOTS;
        }

        @NotNull
        public final IntRange getSEASONING_SLOTS() {
            return SEASONING_SLOTS;
        }

        @NotNull
        public final IntRange getPLAYER_INVENTORY_SLOTS() {
            return PLAYER_INVENTORY_SLOTS;
        }

        @NotNull
        public final IntRange getPLAYER_HOTBAR_SLOTS() {
            return PLAYER_HOTBAR_SLOTS;
        }

        public final void clientTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull CampfireBlockEntity campfireBlockEntity) {
            Boolean isCooking;
            block20: {
                List<ItemStack> seasonings;
                block19: {
                    boolean bl;
                    block18: {
                        boolean containsItems;
                        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        Intrinsics.checkNotNullParameter((Object)((Object)campfireBlockEntity), (String)"campfireBlockEntity");
                        if (!level.isClientSide) {
                            return;
                        }
                        isCooking = (Boolean)state.getValue((Property)CampfireBlock.Companion.getCOOKING());
                        ResourceLocation resourceLocation = campfireBlockEntity.runningSound.getLocation();
                        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getLocation(...)");
                        boolean isRunningSoundActive = BlockEntitySoundTracker.INSTANCE.isActive(pos, resourceLocation);
                        ResourceLocation resourceLocation2 = campfireBlockEntity.ambientSound.getLocation();
                        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"getLocation(...)");
                        boolean isAmbientSoundActive = BlockEntitySoundTracker.INSTANCE.isActive(pos, resourceLocation2);
                        boolean bl2 = !((Collection)campfireBlockEntity.getSeasonings()).isEmpty() || !((Collection)campfireBlockEntity.getIngredients()).isEmpty() ? true : (containsItems = false);
                        if (containsItems) {
                            if (isCooking.booleanValue()) {
                                ResourceLocation resourceLocation3 = campfireBlockEntity.ambientSound.getLocation();
                                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"getLocation(...)");
                                BlockEntitySoundTracker.INSTANCE.stop(pos, resourceLocation3);
                                if (!isRunningSoundActive) {
                                    BlockEntitySoundTracker.INSTANCE.play(pos, (SoundInstance)new CancellableSoundInstance(campfireBlockEntity.runningSound, pos, true, 1.0f, 1.0f));
                                }
                            } else {
                                ResourceLocation resourceLocation4 = campfireBlockEntity.runningSound.getLocation();
                                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"getLocation(...)");
                                BlockEntitySoundTracker.INSTANCE.stop(pos, resourceLocation4);
                                if (!isAmbientSoundActive) {
                                    BlockEntitySoundTracker.INSTANCE.play(pos, (SoundInstance)new CancellableSoundInstance(campfireBlockEntity.ambientSound, pos, true, 1.0f, 1.0f));
                                }
                            }
                        } else {
                            ResourceLocation resourceLocation5 = campfireBlockEntity.runningSound.getLocation();
                            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"getLocation(...)");
                            BlockEntitySoundTracker.INSTANCE.stop(pos, resourceLocation5);
                            ResourceLocation resourceLocation6 = campfireBlockEntity.ambientSound.getLocation();
                            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"getLocation(...)");
                            BlockEntitySoundTracker.INSTANCE.stop(pos, resourceLocation6);
                        }
                        if ((seasonings = campfireBlockEntity.getSeasonings()).size() != campfireBlockEntity.getLastSeasoningStacks().size()) break block19;
                        Iterable $this$any$iv = seasonings;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                ItemStack it = (ItemStack)element$iv;
                                boolean bl3 = false;
                                if (!(!campfireBlockEntity.getLastSeasoningStacks().contains(it))) continue;
                                bl = true;
                                break block18;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block20;
                }
                campfireBlockEntity.setLastSeasoningStacks(seasonings);
                Integer n = FlavourColourHelperKt.getColourMixFromSeasonings$default(seasonings, false, 2, null);
                campfireBlockEntity.setBrothColor(n != null ? n : 16644815);
                Integer n2 = FlavourColourHelperKt.getColourMixFromSeasonings(seasonings, true);
                campfireBlockEntity.setBubbleColor(n2 != null ? n2 : -66076);
            }
            if (campfireBlockEntity.particleCooldown > 0) {
                int $this$any$iv = campfireBlockEntity.particleCooldown;
                campfireBlockEntity.particleCooldown = $this$any$iv + -1;
            } else {
                if (isCooking.booleanValue()) {
                    Vec3 position = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5375, (double)pos.getZ() + 0.5);
                    campfireBlockEntity.particleEntityHandler(position, level, new ResourceLocation("cobblemon", "broth_bubbles"));
                }
                campfireBlockEntity.particleCooldown = 20;
            }
            int n = campfireBlockEntity.getTime();
            campfireBlockEntity.setTime(n + 1);
        }

        /*
         * WARNING - void declaration
         */
        public final void serverTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull CampfireBlockEntity campfireBlockEntity) {
            boolean isCookingNow;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)campfireBlockEntity), (String)"campfireBlockEntity");
            if (level.isClientSide) {
                return;
            }
            boolean hasChanged = false;
            CraftingInput craftingInput = CraftingInput.of((int)3, (int)3, (List)campfireBlockEntity.items.subList(1, 10));
            boolean isCookingBefore = campfireBlockEntity.cookingProgress > 0;
            RecipeHolder optionalRecipe = com.cobblemon.mod.common.block.entity.CampfireBlockEntity$Companion.serverTick$fetchRecipe(level, craftingInput, CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_COOKING()).orElseGet(() -> Companion.serverTick$lambda$2(level, craftingInput));
            if (optionalRecipe == null) {
                campfireBlockEntity.cookingProgress = 0;
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                RecipeHolder cookingPotRecipe = optionalRecipe;
                CookingPotRecipeBase recipe = (CookingPotRecipeBase)cookingPotRecipe.value();
                Intrinsics.checkNotNull((Object)craftingInput);
                RegistryAccess registryAccess = level.registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
                ItemStack cookedItem = recipe.assemble(craftingInput, (HolderLookup.Provider)registryAccess);
                ItemStack resultSlotItem = campfireBlockEntity.getItem(0);
                Iterable iterable = campfireBlockEntity.getSeasonings();
                ItemStack itemStack = cookedItem;
                CookingPotRecipeBase cookingPotRecipeBase = recipe;
                boolean $i$f$filter = false;
                void var15_18 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ItemStack it = (ItemStack)element$iv$iv;
                    boolean bl = false;
                    if (!it.is(recipe.getSeasoningTag())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                cookingPotRecipeBase.applySeasoning(itemStack, list);
                if (!((Boolean)campfireBlockEntity.getBlockState().getValue((Property)CampfireBlock.Companion.getLID())).booleanValue()) {
                    campfireBlockEntity.cookingProgress = 0;
                } else {
                    if (!(resultSlotItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)resultSlotItem, (ItemStack)cookedItem) && resultSlotItem.getCount() + cookedItem.getCount() <= resultSlotItem.getMaxStackSize())) {
                        campfireBlockEntity.cookingProgress = 0;
                        return;
                    }
                    campfireBlockEntity.cookingProgress = campfireBlockEntity.cookingProgress + 2;
                    if (campfireBlockEntity.cookingProgress == campfireBlockEntity.cookingTotalTime) {
                        campfireBlockEntity.cookingProgress = 0;
                        if (!cookedItem.isEmpty()) {
                            ((RecipeCraftingHolder)campfireBlockEntity).setRecipeUsed(cookingPotRecipe);
                            if (resultSlotItem.isEmpty()) {
                                campfireBlockEntity.setItem(0, cookedItem);
                            } else {
                                resultSlotItem.grow(cookedItem.getCount());
                            }
                            Intrinsics.checkNotNull((Object)recipe);
                            campfireBlockEntity.consumeCraftingIngredients(recipe, level, pos, state, campfireBlockEntity);
                            Vec3 vec3 = pos.getBottomCenter();
                            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getBottomCenter(...)");
                            WorldExtensionsKt.playSoundServer$default(level, vec3, CobblemonSounds.CAMPFIRE_POT_COOK, null, 0.0f, 0.0f, 28, null);
                            hasChanged = true;
                        }
                    }
                }
            }
            boolean bl = isCookingNow = campfireBlockEntity.cookingProgress > 0;
            if (isCookingBefore != isCookingNow) {
                hasChanged = true;
                level.setBlock(pos, (BlockState)state.setValue((Property)CampfireBlock.Companion.getCOOKING(), (Comparable)Boolean.valueOf(isCookingNow)), 3);
            }
            if (hasChanged) {
                CampfireBlockEntity.access$setChanged$s-1295109088(level, pos, state);
            }
        }

        private static final <T extends CookingPotRecipeBase> Optional<RecipeHolder<CookingPotRecipeBase>> serverTick$fetchRecipe(Level $level, CraftingInput craftingInput, RecipeType<T> recipeType) {
            Optional optional = $level.getRecipeManager().getRecipeFor(recipeType, (RecipeInput)craftingInput, $level);
            Optional<RecipeHolder<CookingPotRecipeBase>> optional2 = optional.map(arg_0 -> Companion.serverTick$fetchRecipe$lambda$1(Companion::serverTick$fetchRecipe$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"map(...)");
            return optional2;
        }

        private static final RecipeHolder serverTick$fetchRecipe$lambda$0(RecipeHolder it) {
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.world.item.crafting.RecipeHolder<com.cobblemon.mod.common.item.crafting.CookingPotRecipeBase>");
            return it;
        }

        private static final RecipeHolder serverTick$fetchRecipe$lambda$1(Function1 $tmp0, Object p0) {
            return (RecipeHolder)$tmp0.invoke(p0);
        }

        private static final RecipeHolder serverTick$lambda$2(Level $level, CraftingInput $craftingInput) {
            return com.cobblemon.mod.common.block.entity.CampfireBlockEntity$Companion.serverTick$fetchRecipe($level, $craftingInput, CobblemonRecipeTypes.INSTANCE.getCOOKING_POT_SHAPELESS()).orElse(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

