/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.block.SaccharineLogSlatheredBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JG\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/block/SaccharineLogBlock;", "Lnet/minecraft/world/level/block/RotatedPillarBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hitResult", "Lnet/minecraft/world/ItemInteractionResult;", "useItemOn", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/ItemInteractionResult;", "Companion", "common"})
public final class SaccharineLogBlock
extends RotatedPillarBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SaccharineLogBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        FluidState fluidState;
        Direction facing;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide && itemStack.is(Items.HONEY_BOTTLE) && axis == Direction.Axis.Y && (facing = hitResult.getDirection()) != Direction.UP && facing != Direction.DOWN && (fluidState = level.getFluidState(pos.relative(facing))).getAmount() <= 3) {
            int randomType = Random.Default.nextInt(0, 6);
            BlockState newState = (BlockState)((BlockState)((BlockState)CobblemonBlocks.SACCHARINE_LOG_SLATHERED.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing)).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)SaccharineLogSlatheredBlock.Companion.getHONEY_TYPE(), (Comparable)Integer.valueOf(randomType));
            Intrinsics.checkNotNull((Object)newState);
            Companion.changeLogType(level, pos, newState, player, itemStack);
            level.playSound(null, pos, SoundEvents.HONEY_BLOCK_PLACE, SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J5\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J=\u0010\u0018\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/block/SaccharineLogBlock$Companion;", "", "<init>", "()V", "Lnet/minecraft/core/dispenser/DispenseItemBehavior;", "createBehavior", "()Lnet/minecraft/core/dispenser/DispenseItemBehavior;", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "newState", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/core/dispenser/BlockSource;", "source", "", "changeLogTypeDispenser", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/dispenser/BlockSource;)V", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/player/Player;", "player", "itemStack", "changeLogType", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DispenseItemBehavior createBehavior() {
            return Companion::createBehavior$lambda$0;
        }

        public final void changeLogTypeDispenser(@NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull BlockState newState, @NotNull ItemStack stack, @NotNull BlockSource source) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            level.setBlock(pos, newState, 3);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            stack.shrink(1);
            DispenserBlockEntity dispenserEntity = source.blockEntity();
            ItemStack glassBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            boolean added = false;
            int n = dispenserEntity.getContainerSize();
            for (int i = 0; i < n; ++i) {
                ItemStack slotStack = dispenserEntity.getItem(i);
                if (slotStack.isEmpty()) {
                    dispenserEntity.setItem(i, glassBottle.copy());
                    added = true;
                    break;
                }
                if (!slotStack.is(Items.GLASS_BOTTLE) || slotStack.getCount() >= slotStack.getMaxStackSize()) continue;
                slotStack.grow(1);
                added = true;
                break;
            }
            if (!added) {
                Containers.dropItemStack((Level)((Level)level), (double)source.pos().getX(), (double)source.pos().getY(), (double)source.pos().getZ(), (ItemStack)glassBottle);
            }
        }

        public final void changeLogType(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, @Nullable Player player, @Nullable ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            level.setBlock(pos, newState, 3);
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            if (player != null && !player.hasInfiniteMaterials() && itemStack != null) {
                itemStack.consume(1, (LivingEntity)player);
                ItemStack glassBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!player.addItem(glassBottle)) {
                    player.drop(glassBottle, false);
                }
            }
        }

        public static /* synthetic */ void changeLogType$default(Companion companion, Level level, BlockPos blockPos, BlockState blockState, Player player, ItemStack itemStack, int n, Object object) {
            if ((n & 8) != 0) {
                player = null;
            }
            if ((n & 0x10) != 0) {
                itemStack = null;
            }
            companion.changeLogType(level, blockPos, blockState, player, itemStack);
        }

        private static final ItemStack createBehavior$lambda$0(BlockSource source, ItemStack stack) {
            ServerLevel level = source.level();
            Direction facing = (Direction)source.state().getValue((Property)HorizontalDirectionalBlock.FACING);
            BlockPos pos = source.pos().relative(facing);
            BlockState blockState = level.getBlockState(pos);
            if (blockState.getBlock() instanceof SaccharineLogBlock) {
                BlockState newState = (BlockState)CobblemonBlocks.SACCHARINE_LOG_SLATHERED.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, blockState.getValue((Property)RotatedPillarBlock.AXIS));
                Intrinsics.checkNotNull((Object)level);
                Intrinsics.checkNotNull((Object)pos);
                Intrinsics.checkNotNull((Object)newState);
                Intrinsics.checkNotNull((Object)stack);
                Intrinsics.checkNotNull((Object)source);
                Companion.changeLogTypeDispenser(level, pos, newState, stack, source);
            }
            return stack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

