/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonBlocks;
import com.cobblemon.mod.common.block.entity.PokeSnackBlockEntity;
import com.cobblemon.mod.common.block.entity.TintBlockEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.VectorShapeExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 g2\u00020\u0001:\u0001gB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\bH\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0010\u001a\u00020\u000f2\u0016\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J1\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001aH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0019\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J9\u0010,\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b,\u0010-J'\u0010/\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b/\u00100J7\u00106\u001a\u0002052\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u00102\u001a\u0002012\u0006\u00104\u001a\u000203H\u0014\u00a2\u0006\u0004\b6\u00107JG\u0010;\u001a\u00020:2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u00102\u001a\u0002012\u0006\u00109\u001a\u0002082\u0006\u00104\u001a\u000203H\u0014\u00a2\u0006\u0004\b;\u0010<J/\u0010?\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010>\u001a\u00020=H\u0016\u00a2\u0006\u0004\b?\u0010@J/\u0010D\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010A\u001a\u0002032\u0006\u0010C\u001a\u00020BH\u0014\u00a2\u0006\u0004\bD\u0010EJ/\u0010G\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010F\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\r2\u0006\u00102\u001a\u000201H\u0016\u00a2\u0006\u0004\bG\u0010HJ1\u0010I\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010F\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\r2\b\u00102\u001a\u0004\u0018\u000101H\u0002\u00a2\u0006\u0004\bI\u0010JJ/\u0010K\u001a\u0002052\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\r2\u0006\u00102\u001a\u000201H\u0002\u00a2\u0006\u0004\bK\u0010LJ/\u0010M\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\r2\b\u00102\u001a\u0004\u0018\u000101\u00a2\u0006\u0004\bM\u0010JJ\u0017\u0010N\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bN\u0010OJ\u001f\u0010Q\u001a\n P*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0014\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bQ\u0010RJ\u0017\u0010S\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\rH\u0002\u00a2\u0006\u0004\bS\u0010OJ/\u0010V\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020T2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010U\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\bV\u0010WJ1\u0010X\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u0001012\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020T2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\bX\u0010YJ\u0017\u0010Z\u001a\u00020\u00042\u0006\u0010A\u001a\u000203H\u0002\u00a2\u0006\u0004\bZ\u0010[J\u001d\u0010]\u001a\u00020\\2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b]\u0010^J\u001d\u0010_\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b_\u0010`J\u0017\u0010a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\rH\u0014\u00a2\u0006\u0004\ba\u0010OJ/\u0010c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010>\u001a\u00020=H\u0014\u00a2\u0006\u0004\bc\u0010dR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010e\u001a\u0004\b\u0005\u0010f\u00a8\u0006h"}, d2={"Lcom/cobblemon/mod/common/block/PokeSnackBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "", "isLure", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Z)V", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/core/BlockPos;", "pos", "state", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/BlockGetter;", "level", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "blockState", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "Lnet/minecraft/world/item/ItemStack;", "stack", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/level/LevelReader;", "getCloneItemStack", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/ItemInteractionResult;", "useItemOn", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/ItemInteractionResult;", "Lnet/minecraft/util/RandomSource;", "random", "animateTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "hit", "Lnet/minecraft/world/entity/projectile/Projectile;", "projectile", "onProjectileHit", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/phys/BlockHitResult;Lnet/minecraft/world/entity/projectile/Projectile;)V", "blockPos", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;", "dropCandle", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)V", "playerEat", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/InteractionResult;", "eat", "hasCandle", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "kotlin.jvm.PlatformType", "isCandleLit", "(Lnet/minecraft/world/level/block/state/BlockState;)Ljava/lang/Boolean;", "canBeLit", "Lnet/minecraft/world/level/LevelAccessor;", "lit", "setCandleLit", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Z)V", "extinguishCandle", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;)V", "candleHit", "(Lnet/minecraft/world/phys/BlockHitResult;)Z", "", "getTint", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "spawnEatParticles", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V", "isRandomlyTicking", "Lnet/minecraft/server/level/ServerLevel;", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Z", "()Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPokeSnackBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeSnackBlock.kt\ncom/cobblemon/mod/common/block/PokeSnackBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,430:1\n13805#2,2:431\n*S KotlinDebug\n*F\n+ 1 PokeSnackBlock.kt\ncom/cobblemon/mod/common/block/PokeSnackBlock\n*L\n171#1:431,2\n*E\n"})
public final class PokeSnackBlock
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isLure;
    public static final int MAX_BITES = 8;
    public static final double CAKE_HEIGHT = 0.4375;
    @NotNull
    private static final Vec3 CANDLE_PARTICLE_POSITION = new Vec3(0.5, 0.9375, 0.5);
    @NotNull
    private static final IntegerProperty BITES;
    @NotNull
    private static final IntegerProperty CANDLE;
    @NotNull
    private static final Map<Integer, Block> idToCandleBlock;
    private static final VoxelShape CANDLE_SHAPE;
    @NotNull
    private static final List<VoxelShape> SOUTH_SHAPES;
    @NotNull
    private static final List<VoxelShape> NORTH_SHAPES;
    @NotNull
    private static final List<VoxelShape> WEST_SHAPES;
    @NotNull
    private static final List<VoxelShape> EAST_SHAPES;

    public PokeSnackBlock(@NotNull BlockBehaviour.Properties settings, boolean isLure) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.isLure = isLure;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)CANDLE, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    public final boolean isLure() {
        return this.isLure;
    }

    @NotNull
    protected MapCodec<PokeSnackBlock> codec() {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(PokeSnackBlock::codec$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        return mapCodec;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING, BITES, CANDLE, BlockStateProperties.LIT};
        builder.add(propertyArray);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new PokeSnackBlockEntity(pos, state);
    }

    @Nullable
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        List<VoxelShape> snackShapes = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> SOUTH_SHAPES;
            case 2 -> WEST_SHAPES;
            case 3 -> EAST_SHAPES;
            default -> NORTH_SHAPES;
        };
        Comparable comparable = state.getValue((Property)BITES);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        VoxelShape snackShape = snackShapes.get(((Number)((Object)comparable)).intValue());
        if (this.hasCandle(state)) {
            snackShape = Shapes.or((VoxelShape)snackShape, (VoxelShape)CANDLE_SHAPE);
        }
        return snackShape;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState = null;
        blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directionArray = ctx.getNearestLookingDirections();
        Intrinsics.checkNotNullExpressionValue((Object)directionArray, (String)"getNearestLookingDirections(...)");
        Object[] $this$forEach$iv = directionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Direction direction = (Direction)element$iv;
            boolean bl = false;
            if (!direction.getAxis().isHorizontal()) continue;
            Object object = blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            blockState = (BlockState)object;
            if (!blockState.canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        PokeSnackBlockEntity pokeSnackBlockEntity = blockEntity instanceof PokeSnackBlockEntity ? (PokeSnackBlockEntity)blockEntity : null;
        if (pokeSnackBlockEntity == null) {
            return;
        }
        PokeSnackBlockEntity blockEntity2 = pokeSnackBlockEntity;
        blockEntity2.initializeFromItemStack(stack);
        LivingEntity livingEntity = placer;
        blockEntity2.setPlacedBy(livingEntity != null ? livingEntity.getUUID() : null);
        blockEntity2.setChanged();
        level.sendBlockUpdated(pos, state, state, 2);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        PokeSnackBlockEntity pokeSnackBlockEntity = blockEntity instanceof PokeSnackBlockEntity ? (PokeSnackBlockEntity)blockEntity : null;
        if (pokeSnackBlockEntity == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        PokeSnackBlockEntity blockEntity2 = pokeSnackBlockEntity;
        return blockEntity2.toItemStack();
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!this.isLure) {
            if (!this.candleHit(hitResult)) {
                if (level.isClientSide) {
                    if (this.playerEat(level, pos, state, player).consumesAction()) {
                        return InteractionResult.SUCCESS;
                    }
                    if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                        return InteractionResult.CONSUME;
                    }
                }
                return this.playerEat(level, pos, state, player);
            }
            if (this.canBeLit(state) && player.getMainHandItem().isEmpty() && player.isCrouching()) {
                Comparable comparable = state.getValue((Property)CANDLE);
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
                player.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Companion.getCandleById(((Number)((Object)comparable)).intValue())));
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.4f + 0.8f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLE, (Comparable)Integer.valueOf(0)));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            }
        }
        InteractionResult interactionResult = super.useWithoutItem(state, level, pos, player, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!this.isLure) {
            Item item;
            Block candle;
            if (stack.is(ItemTags.CANDLES) && !this.hasCandle(state) && (candle = BaseEntityBlock.byItem((Item)(item = stack.getItem()))) instanceof CandleBlock) {
                stack.consume(1, (LivingEntity)player);
                level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CANDLE, (Comparable)Integer.valueOf(Companion.getIdByCandle((CandleBlock)candle))));
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                return ItemInteractionResult.SUCCESS;
            }
            if (this.candleHit(hitResult) && this.hasCandle(state)) {
                boolean isFlintAndSteel = stack.is(Items.FLINT_AND_STEEL);
                if (this.canBeLit(state) && (isFlintAndSteel || stack.is(Items.FIRE_CHARGE))) {
                    this.setCandleLit((LevelAccessor)level, state, pos, true);
                    level.playSound(player, pos, isFlintAndSteel ? SoundEvents.FLINTANDSTEEL_USE : SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.4f + 0.8f);
                    if (isFlintAndSteel) {
                        stack.hurtAndBreak(1, (LivingEntity)player, MiscUtilsKt.toEquipmentSlot(hand));
                    } else {
                        stack.consume(1, (LivingEntity)player);
                    }
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
                    return itemInteractionResult;
                }
                if (stack.isEmpty() && this.isCandleLit(state).booleanValue()) {
                    this.extinguishCandle(player, state, (LevelAccessor)level, pos);
                    ItemInteractionResult itemInteractionResult = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"sidedSuccess(...)");
                    return itemInteractionResult;
                }
            }
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (this.isCandleLit(state).booleanValue()) {
            AbstractCandleBlock.addParticlesAndSound((Level)level, (Vec3)new Vec3((double)pos.getX() + PokeSnackBlock.CANDLE_PARTICLE_POSITION.x, (double)pos.getY() + PokeSnackBlock.CANDLE_PARTICLE_POSITION.y, (double)pos.getZ() + PokeSnackBlock.CANDLE_PARTICLE_POSITION.z), (RandomSource)random);
        }
        if (this.isLure && random.nextInt(5) == 0) {
            int tint = this.getTint(level, pos);
            float red = (float)FastColor.ARGB32.red((int)tint) / 255.0f;
            float green = (float)FastColor.ARGB32.green((int)tint) / 255.0f;
            float blue = (float)FastColor.ARGB32.blue((int)tint) / 255.0f;
            int n = random.nextInt(1) + 1;
            for (int i = 0; i < n; ++i) {
                level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)red, (float)green, (float)blue), (double)pos.getX() + Random.Default.nextDouble(0.25, 0.76), (double)pos.getY() + 0.4375, (double)pos.getZ() + Random.Default.nextDouble(0.25, 0.76), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onProjectileHit(@NotNull Level level, @NotNull BlockState state, @NotNull BlockHitResult hit, @NotNull Projectile projectile) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter((Object)projectile, (String)"projectile");
        if (!level.isClientSide && projectile.isOnFire() && this.canBeLit(state)) {
            LevelAccessor levelAccessor = (LevelAccessor)level;
            BlockPos blockPos = hit.getBlockPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            this.setCandleLit(levelAccessor, state, blockPos, true);
        }
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.dropCandle(level, blockPos, blockState, player);
        BlockState blockState2 = super.playerWillDestroy(level, blockPos, blockState, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"playerWillDestroy(...)");
        return blockState2;
    }

    private final void dropCandle(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (this.hasCandle(blockState) && !level.isClientSide) {
            Player player2 = player;
            if (!(player2 != null ? player2.isCreative() : false)) {
                double d = (double)blockPos.getX() + 0.5;
                double d2 = (double)blockPos.getY() + 0.4375;
                double d3 = (double)blockPos.getZ() + 0.5;
                Comparable comparable = blockState.getValue((Property)CANDLE);
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
                ItemEntity itemEntity = new ItemEntity(level, d, d2, d3, new ItemStack((ItemLike)Companion.getCandleById(((Number)((Object)comparable)).intValue())));
                itemEntity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itemEntity);
            }
        }
    }

    private final InteractionResult playerEat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(2, 0.1f);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        this.eat(level, pos, state, player);
        return InteractionResult.SUCCESS;
    }

    public final void eat(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable Player player) {
        block6: {
            Player player2;
            int newBites;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Comparable comparable = state.getValue((Property)BITES);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
            int bites = (Integer)comparable;
            if (this.isLure) {
                PokeSnackBlockEntity pokeSnackBlockEntity = (PokeSnackBlockEntity)level.getBlockEntity(pos);
                if (pokeSnackBlockEntity == null) {
                    return;
                }
                PokeSnackBlockEntity pokeSnackBlockEntity2 = pokeSnackBlockEntity;
                pokeSnackBlockEntity2.setAmountSpawned(pokeSnackBlockEntity2.getAmountSpawned() + 1);
                v2 = (int)Math.floor((double)pokeSnackBlockEntity2.getAmountSpawned() / 1.0);
            } else {
                v2 = newBites = bites + 1;
            }
            if (newBites > 8) {
                this.dropCandle(level, pos, state, player);
                level.removeBlock(pos, false);
                level.removeBlockEntity(pos);
            } else {
                Object object = state.setValue((Property)BITES, (Comparable)Integer.valueOf(newBites));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
                level.setBlock(pos, (BlockState)object, 3);
            }
            if ((player2 = player) == null || (player2 = player2.blockPosition()) == null) {
                player2 = pos;
            }
            level.playSound(null, (BlockPos)player2, SoundEvents.GENERIC_EAT, player != null ? SoundSource.PLAYERS : SoundSource.NEUTRAL);
            this.spawnEatParticles(level, pos);
            Player player3 = player;
            if (player3 == null) break block6;
            Player it = player3;
            boolean bl = false;
            level.gameEvent((Entity)it, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
    }

    private final boolean hasCandle(BlockState state) {
        return ((Number)((Object)state.getValue((Property)CANDLE))).intValue() > 0;
    }

    private final Boolean isCandleLit(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LIT);
    }

    private final boolean canBeLit(BlockState state) {
        return this.hasCandle(state) && this.isCandleLit(state) == false;
    }

    private final void setCandleLit(LevelAccessor level, BlockState state, BlockPos pos, boolean lit) {
        Object object = state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(lit));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        level.setBlock(pos, (BlockState)object, 11);
    }

    private final void extinguishCandle(Player player, BlockState state, LevelAccessor level, BlockPos pos) {
        this.setCandleLit(level, state, pos, false);
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + CANDLE_PARTICLE_POSITION.x(), (double)pos.getY() + CANDLE_PARTICLE_POSITION.y(), (double)pos.getZ() + CANDLE_PARTICLE_POSITION.z(), 0.0, 0.1, 0.0);
        level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    private final boolean candleHit(BlockHitResult hit) {
        return hit.getLocation().y - (double)hit.getBlockPos().getY() > 0.4375;
    }

    public final int getTint(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Object object = blockEntity instanceof PokeSnackBlockEntity ? (PokeSnackBlockEntity)blockEntity : null;
        int tint = object != null && (object = ((TintBlockEntity)((Object)object)).getTint()) != null ? (Integer)object : 0xFFFFFF;
        return tint == 0xFFFFFF ? 16117160 : tint;
    }

    public final void spawnEatParticles(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        RandomSource random = level.random;
        int n = 5;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, CobblemonBlocks.POKE_SNACK.defaultBlockState()), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble() * 0.4375, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.isLure;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            if (level.isClientSide) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            PokeSnackBlockEntity pokeSnackBlockEntity = blockEntity instanceof PokeSnackBlockEntity ? (PokeSnackBlockEntity)blockEntity : null;
            if (pokeSnackBlockEntity == null) break block1;
            pokeSnackBlockEntity.randomTick();
        }
    }

    private static final App codec$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)BaseEntityBlock.propertiesCodec(), (App)PrimitiveCodec.BOOL.fieldOf("isLure").forGetter(PokeSnackBlock::codec$lambda$0$0)).apply((Applicative)it, PokeSnackBlock::new);
    }

    private static final Boolean codec$lambda$0$0(PokeSnackBlock it) {
        return it.isLure;
    }

    static {
        IntegerProperty integerProperty = IntegerProperty.create((String)"bites", (int)0, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        BITES = integerProperty;
        IntegerProperty integerProperty2 = IntegerProperty.create((String)"candle", (int)0, (int)(MapColor.MATERIAL_COLORS.length - 1));
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty2, (String)"create(...)");
        CANDLE = integerProperty2;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)MapColor.WOOL.id, (Object)Blocks.WHITE_CANDLE), TuplesKt.to((Object)MapColor.COLOR_ORANGE.id, (Object)Blocks.ORANGE_CANDLE), TuplesKt.to((Object)MapColor.COLOR_MAGENTA.id, (Object)Blocks.MAGENTA_CANDLE), TuplesKt.to((Object)MapColor.COLOR_LIGHT_BLUE.id, (Object)Blocks.LIGHT_BLUE_CANDLE), TuplesKt.to((Object)MapColor.COLOR_YELLOW.id, (Object)Blocks.YELLOW_CANDLE), TuplesKt.to((Object)MapColor.COLOR_LIGHT_GREEN.id, (Object)Blocks.LIME_CANDLE), TuplesKt.to((Object)MapColor.COLOR_PINK.id, (Object)Blocks.PINK_CANDLE), TuplesKt.to((Object)MapColor.COLOR_GRAY.id, (Object)Blocks.GRAY_CANDLE), TuplesKt.to((Object)MapColor.COLOR_LIGHT_GRAY.id, (Object)Blocks.LIGHT_GRAY_CANDLE), TuplesKt.to((Object)MapColor.COLOR_CYAN.id, (Object)Blocks.CYAN_CANDLE), TuplesKt.to((Object)MapColor.COLOR_PURPLE.id, (Object)Blocks.PURPLE_CANDLE), TuplesKt.to((Object)MapColor.COLOR_BLUE.id, (Object)Blocks.BLUE_CANDLE), TuplesKt.to((Object)MapColor.COLOR_BROWN.id, (Object)Blocks.BROWN_CANDLE), TuplesKt.to((Object)MapColor.COLOR_GREEN.id, (Object)Blocks.GREEN_CANDLE), TuplesKt.to((Object)MapColor.COLOR_RED.id, (Object)Blocks.RED_CANDLE), TuplesKt.to((Object)MapColor.COLOR_BLACK.id, (Object)Blocks.BLACK_CANDLE)};
        idToCandleBlock = MapsKt.mapOf((Pair[])objectArray);
        CANDLE_SHAPE = Shapes.box((double)0.4375, (double)0.4375, (double)0.4375, (double)0.5625, (double)0.8125, (double)0.5625);
        objectArray = new VoxelShape[]{Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.9375), Shapes.or((VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.9375), (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.4375, (double)0.9375)), Shapes.or((VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.3125), (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.4375, (double)0.9375)), Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.4375, (double)0.9375), Shapes.or((VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.625, (double)0.9375, (double)0.4375, (double)0.9375), (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.6875, (double)0.4375, (double)0.9375)), Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.6875, (double)0.4375, (double)0.9375), Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.6875, (double)0.375, (double)0.4375, (double)0.9375), (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.6875, (double)0.4375, (double)0.6875)), Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.6875, (double)0.4375, (double)0.6875), Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.4375, (double)0.6875)};
        SOUTH_SHAPES = CollectionsKt.listOf((Object[])objectArray);
        NORTH_SHAPES = PokeSnackBlock.Companion.createShapes(Direction.NORTH);
        WEST_SHAPES = PokeSnackBlock.Companion.createShapes(Direction.WEST);
        EAST_SHAPES = PokeSnackBlock.Companion.createShapes(Direction.EAST);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!R#\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001c\u0010*\u001a\n )*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\"\u0010,\u001a\u0010\u0012\f\u0012\n )*\u0004\u0018\u00010\u00100\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u0010-R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010-\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/block/PokeSnackBlock$Companion;", "", "<init>", "()V", "", "id", "Lnet/minecraft/world/level/block/Block;", "getCandleById", "(I)Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/CandleBlock;", "candle", "getIdByCandle", "(Lnet/minecraft/world/level/block/CandleBlock;)I", "Lnet/minecraft/core/Direction;", "to", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "createShapes", "(Lnet/minecraft/core/Direction;)Ljava/util/List;", "MAX_BITES", "I", "", "CAKE_HEIGHT", "D", "Lnet/minecraft/world/phys/Vec3;", "CANDLE_PARTICLE_POSITION", "Lnet/minecraft/world/phys/Vec3;", "getCANDLE_PARTICLE_POSITION", "()Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "BITES", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getBITES", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "CANDLE", "getCANDLE", "", "idToCandleBlock", "Ljava/util/Map;", "getIdToCandleBlock", "()Ljava/util/Map;", "kotlin.jvm.PlatformType", "CANDLE_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SOUTH_SHAPES", "Ljava/util/List;", "NORTH_SHAPES", "WEST_SHAPES", "EAST_SHAPES", "common"})
    @SourceDebugExtension(value={"SMAP\nPokeSnackBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokeSnackBlock.kt\ncom/cobblemon/mod/common/block/PokeSnackBlock$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,430:1\n1193#2,2:431\n1267#2,4:433\n1563#2:437\n1634#2,3:438\n*S KotlinDebug\n*F\n+ 1 PokeSnackBlock.kt\ncom/cobblemon/mod/common/block/PokeSnackBlock$Companion\n*L\n92#1:431,2\n92#1:433,4\n125#1:437\n125#1:438,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Vec3 getCANDLE_PARTICLE_POSITION() {
            return CANDLE_PARTICLE_POSITION;
        }

        @NotNull
        public final IntegerProperty getBITES() {
            return BITES;
        }

        @NotNull
        public final IntegerProperty getCANDLE() {
            return CANDLE;
        }

        @NotNull
        public final Map<Integer, Block> getIdToCandleBlock() {
            return idToCandleBlock;
        }

        @NotNull
        public final Block getCandleById(int id) {
            Block block = this.getIdToCandleBlock().get(id);
            if (block == null) {
                Block block2 = Blocks.CANDLE;
                block = block2;
                Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"CANDLE");
            }
            return block;
        }

        /*
         * WARNING - void declaration
         */
        public final int getIdByCandle(@NotNull CandleBlock candle) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)candle, (String)"candle");
            Iterable $this$associate$iv = this.getIdToCandleBlock().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                int id = ((Number)entry.getKey()).intValue();
                Block block = (Block)entry.getValue();
                entry = TuplesKt.to((Object)block, (Object)id);
                map.put(entry.getFirst(), entry.getSecond());
            }
            Integer n = (Integer)destination$iv$iv.get(candle);
            return n != null ? n : MapColor.SAND.id;
        }

        /*
         * WARNING - void declaration
         */
        private final List<VoxelShape> createShapes(Direction to) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = SOUTH_SHAPES;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VoxelShape voxelShape = (VoxelShape)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(VectorShapeExtensionsKt.rotateShape(Direction.SOUTH, to, (VoxelShape)it));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

