/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.api.storage.pc.link.PCLinkManager;
import com.cobblemon.mod.common.api.storage.pc.link.ProximityPCLink;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.entity.PCBlockEntity;
import com.cobblemon.mod.common.net.messages.client.storage.pc.OpenPCPacket;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.cobblemon.mod.common.util.WorldExtensionsKt;
import com.mojang.serialization.MapCodec;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 b2\u00020\u00012\u00020\u0002:\u0002bcB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ9\u0010$\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0019\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020&H\u0016\u00a2\u0006\u0004\b(\u0010)J'\u0010+\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b+\u0010,J/\u0010/\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b/\u00100J3\u00103\u001a&\u0012\f\u0012\n 2*\u0004\u0018\u00010\u00000\u0000 2*\u0012\u0012\f\u0012\n 2*\u0004\u0018\u00010\u00000\u0000\u0018\u00010101H\u0014\u00a2\u0006\u0004\b3\u00104J\u001f\u00107\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\t2\u0006\u00106\u001a\u000205H\u0015\u00a2\u0006\u0004\b7\u00108J#\u0010<\u001a\u00020#2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\t09H\u0014\u00a2\u0006\u0004\b<\u0010=J'\u0010@\u001a\n 2*\u0004\u0018\u00010\t0\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010?\u001a\u00020>H\u0015\u00a2\u0006\u0004\b@\u0010AJ\u001f\u0010C\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010C\u001a\u00020BH\u0015\u00a2\u0006\u0004\bC\u0010DJ7\u0010G\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\t2\u0006\u0010F\u001a\u00020\u001aH\u0014\u00a2\u0006\u0004\bG\u0010HJ7\u0010L\u001a\u00020K2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010.\u001a\u00020-2\u0006\u0010J\u001a\u00020IH\u0014\u00a2\u0006\u0004\bL\u0010MJG\u0010S\u001a\u0012\u0012\f\u0012\n 2*\u0004\u0018\u00018\u00008\u0000\u0018\u00010R\"\b\b\u0000\u0010O*\u00020N2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\t2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00028\u00000PH\u0016\u00a2\u0006\u0004\bS\u0010TJ\u0017\u0010V\u001a\u00020U2\u0006\u0010\n\u001a\u00020\tH\u0015\u00a2\u0006\u0004\bV\u0010WJ\u0019\u0010Y\u001a\u0004\u0018\u00010X2\u0006\u0010\u0015\u001a\u00020\tH\u0014\u00a2\u0006\u0004\bY\u0010ZJ?\u0010`\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\\\u001a\u00020[2\u0006\u0010]\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020^2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010_\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b`\u0010a\u00a8\u0006d"}, d2={"Lcom/cobblemon/mod/common/block/PCBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/core/BlockPos;", "blockPos", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "Lcom/cobblemon/mod/common/block/entity/PCBlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/cobblemon/mod/common/block/entity/PCBlockEntity;", "Lnet/minecraft/world/level/BlockGetter;", "blockGetter", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "collisionContext", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "pos", "getPositionOfOtherPart", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/BlockPos;", "getBasePosition", "", "isBase", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "blockPlaceContext", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/entity/player/Player;", "player", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;", "Lcom/mojang/serialization/MapCodec;", "kotlin.jvm.PlatformType", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "pathComputationType", "isPathfindable", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/pathfinder/PathComputationType;)Z", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Rotation;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/block/Mirror;", "mirror", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Mirror;)Lnet/minecraft/world/level/block/state/BlockState;", "newState", "moved", "onRemove", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "BlockWithEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lnet/minecraft/world/level/material/FluidState;", "getFluidState", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Companion", "PCPart", "common"})
@SourceDebugExtension(value={"SMAP\nPCBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PCBlock.kt\ncom/cobblemon/mod/common/block/PCBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1#2:335\n*E\n"})
public final class PCBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final MapCodec<PCBlock> CODEC = BaseEntityBlock.simpleCodec(PCBlock::new);
    private static final EnumProperty<PCPart> PART = EnumProperty.create((String)"part", PCPart.class);
    private static final BooleanProperty ON = BooleanProperty.create((String)"on");
    private static final BooleanProperty NATURAL = BooleanProperty.create((String)"natural");
    private static final VoxelShape NORTH_AABB_TOP;
    private static final VoxelShape SOUTH_AABB_TOP;
    private static final VoxelShape WEST_AABB_TOP;
    private static final VoxelShape EAST_AABB_TOP;
    private static final VoxelShape NORTH_AABB_BOTTOM;
    private static final VoxelShape SOUTH_AABB_BOTTOM;
    private static final VoxelShape WEST_AABB_BOTTOM;
    private static final VoxelShape EAST_AABB_BOTTOM;

    public PCBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)PART, (Comparable)((Object)PCPart.BOTTOM))).setValue((Property)ON, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public PCBlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return blockState.getValue((Property)PART) == PCPart.BOTTOM ? new PCBlockEntity(blockPos, blockState) : null;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)blockGetter, (String)"blockGetter");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)collisionContext, (String)"collisionContext");
        if (blockState.getValue((Property)PART) == PCPart.TOP) {
            Direction direction = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            VoxelShape voxelShape2 = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> SOUTH_AABB_TOP;
                case 2 -> WEST_AABB_TOP;
                case 3 -> EAST_AABB_TOP;
                default -> NORTH_AABB_TOP;
            };
            Intrinsics.checkNotNull((Object)voxelShape2);
            voxelShape = voxelShape2;
        } else {
            Direction direction = (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
            VoxelShape voxelShape3 = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> SOUTH_AABB_BOTTOM;
                case 2 -> WEST_AABB_BOTTOM;
                case 3 -> EAST_AABB_BOTTOM;
                default -> NORTH_AABB_BOTTOM;
            };
            Intrinsics.checkNotNull((Object)voxelShape3);
            voxelShape = voxelShape3;
        }
        return voxelShape;
    }

    @NotNull
    public final BlockPos getPositionOfOtherPart(@NotNull BlockState state, @NotNull BlockPos pos) {
        BlockPos blockPos;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (state.getValue((Property)PART) == PCPart.BOTTOM) {
            BlockPos blockPos2 = pos.above();
            Intrinsics.checkNotNull((Object)blockPos2);
            blockPos = blockPos2;
        } else {
            BlockPos blockPos3 = pos.below();
            Intrinsics.checkNotNull((Object)blockPos3);
            blockPos = blockPos3;
        }
        return blockPos;
    }

    @NotNull
    public final BlockPos getBasePosition(@NotNull BlockState state, @NotNull BlockPos pos) {
        BlockPos blockPos;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.isBase(state)) {
            blockPos = pos;
        } else {
            BlockPos blockPos2 = pos.below();
            Intrinsics.checkNotNull((Object)blockPos2);
            blockPos = blockPos2;
        }
        return blockPos;
    }

    private final boolean isBase(BlockState state) {
        return state.getValue((Property)PART) == PCPart.BOTTOM;
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        world.setBlock(pos.above(), (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)PCPart.TOP))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)world.getFluidState(pos.above()).getType(), (Object)Fluids.WATER))), 3);
        world.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        BlockPos abovePosition = blockPlaceContext.getClickedPos().above();
        Level world = blockPlaceContext.getLevel();
        if (world.getBlockState(abovePosition).canBeReplaced(blockPlaceContext) && !world.isOutsideBuildHeight(abovePosition)) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)blockPlaceContext.getHorizontalDirection())).setValue((Property)PART, (Comparable)((Object)PCPart.BOTTOM))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)blockPlaceContext.getLevel().getFluidState(blockPlaceContext.getClickedPos()).getType(), (Object)Fluids.WATER)));
        }
        return null;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos blockPos = pos.below();
        BlockState blockState = world.getBlockState(blockPos);
        return state.getValue((Property)PART) == PCPart.BOTTOM ? blockState.isFaceSturdy((BlockGetter)world, blockPos, Direction.UP) : blockState.is((Block)this);
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!world.isClientSide && player.isCreative()) {
            BlockPos blockPos = null;
            BlockPos blockPos2 = BlockPos.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"ZERO");
            blockPos = blockPos2;
            BlockState blockState = null;
            blockState = state;
            PCPart part = (PCPart)((Object)state.getValue((Property)PART));
            if (part == PCPart.TOP) {
                BlockPos it;
                BlockPos blockPos3;
                BlockPos blockPos4 = blockPos3 = pos.below();
                Level level = world;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                blockPos = it;
                it = blockPos3 = level.getBlockState(blockPos3);
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                blockState = it;
                if (blockPos3.is(state.getBlock()) && blockState.getValue((Property)PART) == PCPart.BOTTOM) {
                    BlockState blockState2 = blockState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                    world.setBlock(blockPos, blockState2, 35);
                    world.levelEvent(player, 2001, blockPos, BaseEntityBlock.getId((BlockState)blockState));
                }
            }
        }
        BlockState blockState = super.playerWillDestroy(world, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    protected MapCodec<PCBlock> codec() {
        return CODEC;
    }

    @Deprecated(message="Deprecated in Java")
    protected boolean isPathfindable(@NotNull BlockState blockState, @NotNull PathComputationType pathComputationType) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pathComputationType, (String)"pathComputationType");
        return false;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HorizontalDirectionalBlock.FACING, NATURAL};
        builder.add(propertyArray);
        propertyArray = new Property[]{PART};
        builder.add(propertyArray);
        propertyArray = new Property[]{ON};
        builder.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.WATERLOGGED};
        builder.add(propertyArray);
    }

    @Deprecated(message="Deprecated in Java")
    protected BlockState rotate(@NotNull BlockState blockState, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        return (BlockState)blockState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected BlockState mirror(@NotNull BlockState blockState, @NotNull Mirror mirror) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        BlockState blockState2 = blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)));
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"rotate(...)");
        return blockState2;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock())) {
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState blockState, @NotNull Level world, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos basePos = this.getBasePosition(blockState, blockPos);
        BlockEntity blockEntity = world.getBlockEntity(basePos.above());
        if (blockEntity != null) {
            blockEntity.setRemoved();
        }
        BlockEntity baseEntity = world.getBlockEntity(basePos);
        if (!(baseEntity instanceof PCBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        if (PlayerExtensionsKt.isInBattle((ServerPlayer)player)) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent mutableComponent = LocalizationUtilsKt.lang("pc.inbattle", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"lang(...)");
            serverPlayer.sendSystemMessage((Component)TextKt.red(mutableComponent));
            return InteractionResult.SUCCESS;
        }
        PCStore pCStore = Cobblemon.INSTANCE.getStorage().getPCForPlayer((ServerPlayer)player, (PCBlockEntity)baseEntity);
        if (pCStore == null) {
            return InteractionResult.SUCCESS;
        }
        PCStore pc = pCStore;
        UUID uUID = ((ServerPlayer)player).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        PCLinkManager.INSTANCE.addLink(new ProximityPCLink(pc, uUID, (PCBlockEntity)baseEntity, 0.0, 8, null));
        new OpenPCPacket(pc, null, 2, null).sendToPlayer((ServerPlayer)player);
        WorldExtensionsKt.playSoundServer$default(world, BlockPosExtensionsKt.toVec3d(blockPos), CobblemonSounds.PC_ON, null, 0.5f, 1.0f, 4, null);
        world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_OPEN, blockPos);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState blockState, @NotNull BlockEntityType<T> BlockWithEntityType) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter(BlockWithEntityType, (String)"BlockWithEntityType");
        BlockEntityTicker<PCBlockEntity> blockEntityTicker = PCBlockEntity.Companion.getTICKER$common();
        return BaseEntityBlock.createTickerHelper(BlockWithEntityType, CobblemonBlockEntities.PC, (BlockEntityTicker)new BlockEntityTicker(blockEntityTicker){
            final /* synthetic */ BlockEntityTicker<PCBlockEntity> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, PCBlockEntity p3) {
                this.$tmp0.tick(p0, p1, p2, (BlockEntity)p3);
            }
        });
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return RenderShape.MODEL;
    }

    @Nullable
    protected FluidState getFluidState(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        boolean isPC = neighborState.is((Block)this);
        PCPart part = (PCPart)((Object)state.getValue((Property)PART));
        if (!isPC && part == PCPart.TOP && Intrinsics.areEqual((Object)neighborPos, (Object)pos.below())) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        if (!isPC && part == PCPart.BOTTOM && Intrinsics.areEqual((Object)neighborPos, (Object)pos.above())) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        return state;
    }

    static {
        VoxelShape[] voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.8125, (double)0.125, (double)0.875, (double)0.9375, (double)0.6875), Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.8125, (double)0.625), Shapes.box((double)0.0625, (double)0.0, (double)0.125, (double)0.125, (double)0.9375, (double)0.6875), Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.6875), Shapes.box((double)0.875, (double)0.0, (double)0.125, (double)0.9375, (double)0.9375, (double)0.6875), Shapes.box((double)0.125, (double)0.0, (double)0.6875, (double)0.875, (double)0.0625, (double)0.875)};
        NORTH_AABB_TOP = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)0.875, (double)0.125), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.8125, (double)0.3125, (double)0.875, (double)0.9375, (double)0.875), Shapes.box((double)0.125, (double)0.125, (double)0.375, (double)0.875, (double)0.8125, (double)0.875), Shapes.box((double)0.875, (double)0.0, (double)0.3125, (double)0.9375, (double)0.9375, (double)0.875), Shapes.box((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)0.125, (double)0.875), Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.125, (double)0.9375, (double)0.875), Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.3125)};
        SOUTH_AABB_TOP = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.875, (double)0.8125, (double)0.875, (double)1.0), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.8125, (double)0.125, (double)0.6875, (double)0.9375, (double)0.875), Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.625, (double)0.8125, (double)0.875), Shapes.box((double)0.125, (double)0.0, (double)0.0625, (double)0.6875, (double)0.9375, (double)0.125), Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.6875, (double)0.125, (double)0.875), Shapes.box((double)0.125, (double)0.0, (double)0.875, (double)0.6875, (double)0.9375, (double)0.9375), Shapes.box((double)0.6875, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875)};
        WEST_AABB_TOP = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)0.875, (double)0.8125), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.3125, (double)0.8125, (double)0.125, (double)0.875, (double)0.9375, (double)0.875), Shapes.box((double)0.375, (double)0.125, (double)0.125, (double)0.875, (double)0.8125, (double)0.875), Shapes.box((double)0.3125, (double)0.0, (double)0.0625, (double)0.875, (double)0.9375, (double)0.125), Shapes.box((double)0.3125, (double)0.0, (double)0.125, (double)0.875, (double)0.125, (double)0.875), Shapes.box((double)0.3125, (double)0.0, (double)0.875, (double)0.875, (double)0.9375, (double)0.9375), Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.3125, (double)0.0625, (double)0.875)};
        EAST_AABB_TOP = Shapes.or((VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)0.875, (double)0.8125), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875), Shapes.box((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)1.0, (double)0.125)};
        NORTH_AABB_BOTTOM = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.125, (double)0.9375, (double)1.0, (double)0.9375), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875), Shapes.box((double)0.1875, (double)0.0, (double)0.875, (double)0.8125, (double)1.0, (double)1.0)};
        SOUTH_AABB_BOTTOM = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)1.0, (double)0.875), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875), Shapes.box((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)0.8125)};
        WEST_AABB_BOTTOM = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0625, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), (VoxelShape[])voxelShapeArray);
        voxelShapeArray = new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.875), Shapes.box((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)0.8125)};
        EAST_AABB_BOTTOM = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0625, (double)0.0625, (double)0.875, (double)1.0, (double)0.9375), (VoxelShape[])voxelShapeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR;\u0010\r\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0012\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001f\u0010\u0016\u001a\n \u0006*\u0004\u0018\u00010\u00110\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u001c\u0010\u0019\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u001c\u0010\u001c\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\u001c\u0010\u001d\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001aR\u001c\u0010\u001e\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001aR\u001c\u0010\u001f\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001aR\u001c\u0010 \u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001aR\u001c\u0010!\u001a\n \u0006*\u0004\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\u001a\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/block/PCBlock$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/PCBlock;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lcom/cobblemon/mod/common/block/PCBlock$PCPart;", "PART", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "getPART", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "ON", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getON", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "NATURAL", "getNATURAL", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "NORTH_AABB_TOP", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SOUTH_AABB_TOP", "WEST_AABB_TOP", "EAST_AABB_TOP", "NORTH_AABB_BOTTOM", "SOUTH_AABB_BOTTOM", "WEST_AABB_BOTTOM", "EAST_AABB_BOTTOM", "common"})
    public static final class Companion {
        private Companion() {
        }

        public final MapCodec<PCBlock> getCODEC() {
            return CODEC;
        }

        public final EnumProperty<PCPart> getPART() {
            return PART;
        }

        public final BooleanProperty getON() {
            return ON;
        }

        public final BooleanProperty getNATURAL() {
            return NATURAL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/block/PCBlock$PCPart;", "Lnet/minecraft/util/StringRepresentable;", "", "", "label", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSerializedName", "()Ljava/lang/String;", "Ljava/lang/String;", "TOP", "BOTTOM", "common"})
    public static final class PCPart
    extends Enum<PCPart>
    implements StringRepresentable {
        @NotNull
        private final String label;
        public static final /* enum */ PCPart TOP = new PCPart("top");
        public static final /* enum */ PCPart BOTTOM = new PCPart("bottom");
        private static final /* synthetic */ PCPart[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PCPart(String label) {
            this.label = label;
        }

        @NotNull
        public String getSerializedName() {
            return this.label;
        }

        public static PCPart[] values() {
            return (PCPart[])$VALUES.clone();
        }

        public static PCPart valueOf(String value) {
            return Enum.valueOf(PCPart.class, value);
        }

        @NotNull
        public static EnumEntries<PCPart> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pCPartArray = new PCPart[]{PCPart.TOP, PCPart.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

