/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b&\u0018\u0000 C2\u00020\u0001:\u0001CB1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u0019\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J'\u0010&\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020%2\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b&\u0010'J?\u0010-\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020+2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b-\u0010.J/\u00102\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u00100\u001a\u00020/H\u0014\u00a2\u0006\u0004\b2\u00103R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00104\u001a\u0004\b5\u00106R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00104\u001a\u0004\b7\u00106R\u0017\u0010\u0007\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u00104\u001a\u0004\b8\u00106R\u0019\u0010\t\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00109\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010>\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010=R\u0014\u0010?\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010=R\u0014\u0010@\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010=R\u0014\u0010A\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010=R\u0014\u0010B\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010=\u00a8\u0006D"}, d2={"Lcom/cobblemon/mod/common/block/GrowableStoneBlock;", "Lnet/minecraft/world/level/block/DirectionalBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "", "stage", "height", "xzOffset", "Lnet/minecraft/world/level/block/Block;", "nextStage", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;IIILnet/minecraft/world/level/block/Block;)V", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/BlockGetter;", "world", "", "canGrow", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockGetter;)Z", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "state", "isRandomlyTicking", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "ctx", "getStateForPlacement", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "I", "getStage", "()I", "getHeight", "getXzOffset", "Lnet/minecraft/world/level/block/Block;", "getNextStage", "()Lnet/minecraft/world/level/block/Block;", "upShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "downShape", "northShape", "southShape", "eastShape", "westShape", "Companion", "common"})
public abstract class GrowableStoneBlock
extends DirectionalBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int stage;
    private final int height;
    private final int xzOffset;
    @Nullable
    private final Block nextStage;
    @NotNull
    private final VoxelShape upShape;
    @NotNull
    private final VoxelShape downShape;
    @NotNull
    private final VoxelShape northShape;
    @NotNull
    private final VoxelShape southShape;
    @NotNull
    private final VoxelShape eastShape;
    @NotNull
    private final VoxelShape westShape;
    public static final int STAGE_0 = 0;
    public static final int STAGE_1 = 1;
    public static final int STAGE_2 = 2;
    public static final int STAGE_3 = 3;
    public static final int MAX_STAGE = 3;
    public static final int MIN_STAGE = 0;

    public GrowableStoneBlock(@NotNull BlockBehaviour.Properties settings, int stage, int height, int xzOffset, @Nullable Block nextStage) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.stage = stage;
        this.height = height;
        this.xzOffset = xzOffset;
        this.nextStage = nextStage;
        VoxelShape voxelShape = Block.box((double)this.xzOffset, (double)0.0, (double)this.xzOffset, (double)(16 - this.xzOffset), (double)this.height, (double)(16 - this.xzOffset));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        this.upShape = voxelShape;
        VoxelShape voxelShape2 = DirectionalBlock.box((double)this.xzOffset, (double)(16 - this.height), (double)this.xzOffset, (double)(16 - this.xzOffset), (double)16.0, (double)(16 - this.xzOffset));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        this.downShape = voxelShape2;
        VoxelShape voxelShape3 = DirectionalBlock.box((double)this.xzOffset, (double)this.xzOffset, (double)(16 - this.height), (double)(16 - this.xzOffset), (double)(16 - this.xzOffset), (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        this.northShape = voxelShape3;
        VoxelShape voxelShape4 = DirectionalBlock.box((double)this.xzOffset, (double)this.xzOffset, (double)0.0, (double)(16 - this.xzOffset), (double)(16 - this.xzOffset), (double)this.height);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"box(...)");
        this.southShape = voxelShape4;
        VoxelShape voxelShape5 = DirectionalBlock.box((double)0.0, (double)this.xzOffset, (double)this.xzOffset, (double)this.height, (double)(16 - this.xzOffset), (double)(16 - this.xzOffset));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"box(...)");
        this.eastShape = voxelShape5;
        VoxelShape voxelShape6 = DirectionalBlock.box((double)(16 - this.height), (double)this.xzOffset, (double)this.xzOffset, (double)16.0, (double)(16 - this.xzOffset), (double)(16 - this.xzOffset));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape6, (String)"box(...)");
        this.westShape = voxelShape6;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.DOWN));
    }

    public final int getStage() {
        return this.stage;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getXzOffset() {
        return this.xzOffset;
    }

    @Nullable
    public final Block getNextStage() {
        return this.nextStage;
    }

    public abstract boolean canGrow(@NotNull BlockPos var1, @NotNull BlockGetter var2);

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{DirectionalBlock.FACING};
        builder.add(propertyArray);
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.stage < 3;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Block block;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (world.random.nextInt(5) == 0 && this.canGrow(pos, (BlockGetter)world) && (block = this.nextStage) != null) {
            Object object = block.defaultBlockState().setValue((Property)DirectionalBlock.FACING, state.getValue((Property)DirectionalBlock.FACING));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
            BlockState newState = (BlockState)object;
            world.setBlockAndUpdate(pos, newState);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Object object = blockState.setValue((Property)DirectionalBlock.FACING, (Comparable)ctx.getClickedFace());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        blockState = (BlockState)object;
        if (blockState.canSurvive((LevelReader)worldView, blockPos)) {
            return blockState;
        }
        return null;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Comparable comparable = state.getValue((Property)DirectionalBlock.FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        Direction direction = (Direction)comparable;
        BlockState blockState = world.getBlockState(pos.relative(direction.getOpposite()));
        return blockState.isFaceSturdy((BlockGetter)world, pos, direction);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (direction == ((Direction)state.getValue((Property)DirectionalBlock.FACING)).getOpposite() && !state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Comparable comparable = state.getValue((Property)DirectionalBlock.FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        Direction direction = (Direction)comparable;
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> this.northShape;
            case 2 -> this.southShape;
            case 3 -> this.eastShape;
            case 4 -> this.westShape;
            case 5 -> this.downShape;
            case 6 -> this.upShape;
            default -> this.upShape;
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/cobblemon/mod/common/block/GrowableStoneBlock$Companion;", "", "<init>", "()V", "", "STAGE_0", "I", "STAGE_1", "STAGE_2", "STAGE_3", "MAX_STAGE", "MIN_STAGE", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

