/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ/\u0010!\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J'\u0010%\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b%\u0010&J/\u0010(\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020'2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b(\u0010)J/\u0010*\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b*\u0010+J'\u0010,\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b.\u0010/J'\u00100\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020'H\u0014\u00a2\u0006\u0004\b2\u00103\u00a8\u00065"}, d2={"Lcom/cobblemon/mod/common/block/BugwortBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAgeProperty", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "", "getMaxAge", "()I", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "state", "Lnet/minecraft/world/level/BlockGetter;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/world/level/LevelReader;", "", "isValidBonemealTarget", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/Level;", "isBonemealSuccess", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "performBonemeal", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "isWild", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "mayPlaceOn", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z", "getBonemealAgeIncrease", "(Lnet/minecraft/world/level/Level;)I", "Companion", "common"})
public final class BugwortBlock
extends CropBlock
implements BonemealableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MATURE_AGE = 3;
    @NotNull
    private static final IntegerProperty AGE;
    @NotNull
    private static final BooleanProperty IS_WILD;
    @NotNull
    private static final VoxelShape[] AGE_TO_SHAPE;

    public BugwortBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_WILD, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{this.getAgeProperty()};
        builder.add(propertyArray);
        propertyArray = new Property[]{IS_WILD};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = AGE_TO_SHAPE[this.getAge(state)];
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"get(...)");
        return voxelShape;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (this.isMaxAge(state) || random.nextInt(4) != 0) {
            return;
        }
        this.growCrops((Level)world, pos, state);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((Number)((Object)state.getValue((Property)AGE))).intValue() < 3;
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(((Number)((Object)state.getValue((Property)AGE))).intValue() + 1)), 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState floor = world.getBlockState(pos.below());
        if (world.getRawBrightness(pos, 0) < 8) {
            if (!world.canSeeSky(pos)) return false;
        }
        if (this.isWild(state)) {
            if (floor.is(BlockTags.DIRT)) return true;
            if (floor.is(Blocks.FARMLAND)) return true;
        }
        Intrinsics.checkNotNull((Object)floor);
        if (!this.mayPlaceOn(floor, (BlockGetter)world, pos)) return false;
        return true;
    }

    public final boolean isWild(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.getValue((Property)IS_WILD);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        return (Boolean)comparable;
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos blockPos = pos.below();
        BlockPos down = pos.below();
        BlockState floor = world.getBlockState(down);
        return floor.is(BlockTags.DIRT) || floor.is(Blocks.FARMLAND);
    }

    protected int getBonemealAgeIncrease(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return 1;
    }

    static {
        IntegerProperty integerProperty = BlockStateProperties.AGE_3;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"AGE_3");
        AGE = integerProperty;
        BooleanProperty booleanProperty = BooleanProperty.create((String)"is_wild");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        IS_WILD = booleanProperty;
        VoxelShape[] voxelShapeArray = new VoxelShape[]{CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), CropBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0)};
        AGE_TO_SHAPE = voxelShapeArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R%\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/block/BugwortBlock$Companion;", "", "<init>", "()V", "", "MATURE_AGE", "I", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "IS_WILD", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getIS_WILD", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "AGE_TO_SHAPE", "[Lnet/minecraft/world/phys/shapes/VoxelShape;", "getAGE_TO_SHAPE", "()[Lnet/minecraft/world/phys/shapes/VoxelShape;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntegerProperty getAGE() {
            return AGE;
        }

        @NotNull
        public final BooleanProperty getIS_WILD() {
            return IS_WILD;
        }

        @NotNull
        public final VoxelShape[] getAGE_TO_SHAPE() {
            return AGE_TO_SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

