/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.block;

import com.cobblemon.mod.common.CobblemonBlockEntities;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.berry.Berries;
import com.cobblemon.mod.common.api.berry.Berry;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.berry.BerryMutationOfferEvent;
import com.cobblemon.mod.common.api.events.berry.BerryMutationResultEvent;
import com.cobblemon.mod.common.api.mulch.MulchVariant;
import com.cobblemon.mod.common.api.mulch.Mulchable;
import com.cobblemon.mod.common.api.reactive.EventObservable;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.cobblemon.mod.common.block.BerryBlock;
import com.cobblemon.mod.common.block.ShearableBlock;
import com.cobblemon.mod.common.block.entity.BerryBlockEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 m2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001mB\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ/\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ/\u0010!\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b!\u0010\"J?\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010(\"\b\b\u0000\u0010$*\u00020#2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0016\u00a2\u0006\u0004\b)\u0010*J/\u0010-\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020+2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b-\u0010.J7\u00100\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020+2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010/\u001a\u00020\u001c\u00a2\u0006\u0004\b0\u00101J-\u00102\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b2\u00103J/\u00106\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b6\u00107J7\u00108\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020+2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b8\u00109J7\u0010=\u001a\u00020<2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010;\u001a\u00020:H\u0014\u00a2\u0006\u0004\b=\u0010>J'\u0010?\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0015\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010AH\u0014\u00a2\u0006\u0004\bB\u0010CJ?\u0010I\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020G2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010H\u001a\u00020\u0010H\u0015\u00a2\u0006\u0004\bI\u0010JJ9\u0010O\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010L\u001a\u0004\u0018\u00010K2\u0006\u0010N\u001a\u00020MH\u0016\u00a2\u0006\u0004\bO\u0010PJ#\u0010T\u001a\u00020,2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020\u00120QH\u0014\u00a2\u0006\u0004\bT\u0010UJ'\u0010V\u001a\u00020M2\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\bV\u0010WJ/\u0010\\\u001a\u00020[2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020X2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010Z\u001a\u00020YH\u0015\u00a2\u0006\u0004\b\\\u0010]J\u0017\u0010^\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b^\u0010_J\u0017\u0010a\u001a\u00020`2\u0006\u0010%\u001a\u00020\u0012H\u0015\u00a2\u0006\u0004\ba\u0010bJ5\u0010e\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010d\u001a\b\u0012\u0004\u0012\u00020,0cH\u0016\u00a2\u0006\u0004\be\u0010fJ3\u0010g\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\bg\u0010hR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010iR\u001a\u0010k\u001a\b\u0012\u0004\u0012\u00020D0j8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bk\u0010l\u00a8\u0006n"}, d2={"Lcom/cobblemon/mod/common/block/BerryBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "Lcom/cobblemon/mod/common/api/mulch/Mulchable;", "Lcom/cobblemon/mod/common/block/ShearableBlock;", "Lnet/minecraft/resources/ResourceLocation;", "berryIdentifier", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "settings", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lcom/cobblemon/mod/common/api/berry/Berry;", "berry", "()Lcom/cobblemon/mod/common/api/berry/Berry;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/entity/player/Player;", "player", "playerWillDestroy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;", "Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;", "Lnet/minecraft/world/level/LevelReader;", "", "isValidBonemealTarget", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/util/RandomSource;", "random", "isBonemealSuccess", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "T", "blockState", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockWithEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lnet/minecraft/server/level/ServerLevel;", "", "performBonemeal", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "boneMealed", "growHelper", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "determineMutation", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "variant", "canHaveMulchApplied", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/mulch/MulchVariant;)Z", "applyMulch", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/cobblemon/mod/common/api/mulch/MulchVariant;)V", "Lnet/minecraft/world/phys/BlockHitResult;", "blockHitResult", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "Lcom/mojang/serialization/MapCodec;", "codec", "()Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/entity/LivingEntity;", "placer", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "setPlacedBy", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "getCloneItemStack", "(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "isMaxAge", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/level/block/RenderShape;", "getRenderShape", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/RenderShape;", "Lkotlin/Function0;", "successCallback", "attemptShear", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lkotlin/jvm/functions/Function0;)Z", "harvestBerry", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/resources/ResourceLocation;", "", "lookupDirections", "Ljava/util/Set;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nBerryBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BerryBlock.kt\ncom/cobblemon/mod/common/block/BerryBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n1869#2,2:358\n1869#2,2:371\n17#3,2:360\n17#3,2:363\n19#3:368\n19#3:370\n13805#4:362\n13805#4:365\n13806#4:367\n13806#4:369\n1#5:366\n*S KotlinDebug\n*F\n+ 1 BerryBlock.kt\ncom/cobblemon/mod/common/block/BerryBlock\n*L\n73#1:358,2\n348#1:371,2\n130#1:360,2\n139#1:363,2\n139#1:368\n130#1:370\n130#1:362\n139#1:365\n139#1:367\n130#1:369\n*E\n"})
public final class BerryBlock
extends BaseEntityBlock
implements BonemealableBlock,
Mulchable,
ShearableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation berryIdentifier;
    @NotNull
    private final Set<Direction> lookupDirections;
    @NotNull
    private static final MapCodec<BerryBlock> CODEC;
    public static final int MATURE_AGE = 3;
    public static final int FLOWER_AGE = 4;
    public static final int FRUIT_AGE = 5;
    @NotNull
    private static final IntegerProperty AGE;
    @NotNull
    private static final EnumProperty<MulchVariant> MULCH;
    @NotNull
    private static final BooleanProperty WAS_GENERATED;
    @NotNull
    private static final BooleanProperty IS_ROOTED;
    private static final VoxelShape PLANTED_SHAPE;
    @NotNull
    private static final List<AABB> STANDARD_SPROUT;
    @NotNull
    private static final List<AABB> STANDARD_MATURE;
    @NotNull
    private static final List<AABB> SHORT_SPROUT;
    @NotNull
    private static final List<AABB> SHORT_MATURE;
    @NotNull
    private static final List<AABB> VOLCANO_SPROUT;
    @NotNull
    private static final List<AABB> VOLCANO_MATURE;
    @NotNull
    private static final List<AABB> NEST_SPROUT;
    @NotNull
    private static final List<AABB> NEST_MATURE;
    @NotNull
    private static final List<AABB> FRILL_SPROUT;
    @NotNull
    private static final List<AABB> FRILL_MATURE;
    @NotNull
    private static final List<AABB> BLOCK_SPROUT;
    @NotNull
    private static final List<AABB> BLOCK_MATURE;
    @NotNull
    private static final List<AABB> PYRAMID_SPROUT;
    @NotNull
    private static final List<AABB> PYRAMID_MATURE;
    @NotNull
    private static final List<AABB> TAIL_SPROUT;
    @NotNull
    private static final List<AABB> TAIL_MATURE;
    @NotNull
    private static final List<AABB> SWORD_SPROUT;
    @NotNull
    private static final List<AABB> SWORD_MATURE;
    @NotNull
    private static final List<AABB> PLATFORM_SPROUT;
    @NotNull
    private static final List<AABB> PLATFORM_MATURE;
    @NotNull
    private static final List<AABB> STAND_SPROUT;
    @NotNull
    private static final List<AABB> STAND_MATURE;
    @NotNull
    private static final List<AABB> CONE_SPROUT;
    @NotNull
    private static final List<AABB> CONE_MATURE;
    @NotNull
    private static final List<AABB> SQUAT_SPROUT;
    @NotNull
    private static final List<AABB> SQUAT_MATURE;
    @NotNull
    private static final List<AABB> LANTERN_SPROUT;
    @NotNull
    private static final List<AABB> LANTERN_MATURE;
    @NotNull
    private static final List<AABB> BOX_SPROUT;
    @NotNull
    private static final List<AABB> BOX_MATURE;
    @NotNull
    private static final List<AABB> BLOSSOM_SPROUT;
    @NotNull
    private static final List<AABB> BLOSSOM_MATURE;
    @NotNull
    private static final List<AABB> LILYPAD_SPROUT;
    @NotNull
    private static final List<AABB> LILYPAD_MATURE;
    @NotNull
    private static final List<AABB> TALL_SPROUT;
    @NotNull
    private static final List<AABB> TALL_MATURE;

    public BerryBlock(@NotNull ResourceLocation berryIdentifier, @NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)berryIdentifier, (String)"berryIdentifier");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.berryIdentifier = berryIdentifier;
        Object[] objectArray = new Direction[]{Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH};
        this.lookupDirections = SetsKt.setOf((Object[])objectArray);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WAS_GENERATED, (Comparable)Boolean.valueOf(false))).setValue((Property)MULCH, (Comparable)((Object)MulchVariant.NONE))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_ROOTED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public final Berry berry() {
        return Berries.getByIdentifier(this.berryIdentifier);
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.isCreative()) {
            Integer n = (Integer)state.getValue((Property)AGE);
            int n2 = 5;
            if (n != null && n == n2) {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
                BerryBlockEntity treeEntity = (BerryBlockEntity)blockEntity;
                Iterable $this$forEach$iv = treeEntity.harvest(world, state, pos, player);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ItemStack drop = (ItemStack)element$iv;
                    boolean bl = false;
                    Block.popResource((Level)world, (BlockPos)pos, (ItemStack)drop);
                }
            }
        }
        BlockState blockState = super.playerWillDestroy(world, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    @NotNull
    public BerryBlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new BerryBlockEntity(pos, state, this.berryIdentifier);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !this.isMaxAge(state);
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !this.isMaxAge(state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockWithEntityType) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter(blockWithEntityType, (String)"blockWithEntityType");
        return BaseEntityBlock.createTickerHelper(blockWithEntityType, CobblemonBlockEntities.BERRY, BerryBlockEntity.Companion.getTICKER$common());
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.growHelper(world, random, pos, state, true);
    }

    public final void growHelper(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state, boolean boneMealed) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Berry berry = this.berry();
        if (berry == null) {
            return;
        }
        Berry berry2 = berry;
        if (boneMealed && random.nextFloat() > berry2.getBoneMealChance()) {
            return;
        }
        Integer curAge = (Integer)state.getValue((Property)AGE);
        int newAge = curAge + 1;
        if (newAge > 5) {
            return;
        }
        BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(newAge));
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
        BerryBlockEntity treeEntity = (BerryBlockEntity)blockEntity;
        Integer n = curAge;
        int n2 = 3;
        if (n != null && n == n2) {
            Level level = (Level)world;
            Intrinsics.checkNotNull((Object)newState);
            treeEntity.generateGrowthPoints(level, newState, pos, null);
            this.determineMutation((Level)world, random, pos, newState);
        }
        world.setBlock(pos, newState, 2);
        Intrinsics.checkNotNull((Object)newState);
        Companion.convertMulchToEntity(world, newState, pos);
        Intrinsics.checkNotNull((Object)curAge);
        treeEntity.goToNextStageTimer(5 - curAge);
        treeEntity.setChanged();
    }

    public static /* synthetic */ void growHelper$default(BerryBlock berryBlock, ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        berryBlock.growHelper(serverLevel, randomSource, blockPos, blockState, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void determineMutation(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        block4: {
            void this_$iv;
            Object berry;
            Object berryBlock;
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            HashSet mutations = new HashSet();
            BlockEntity blockEntity = world.getBlockEntity(pos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
            BerryBlockEntity treeEntity = (BerryBlockEntity)blockEntity;
            for (Direction direction : this.lookupDirections) {
                Berry berry2;
                BlockPos redirectedPos = pos.offset(direction.getNormal());
                BlockState redirectedState = world.getBlockState(redirectedPos);
                Block block = redirectedState.getBlock();
                BerryBlock berryBlock2 = block instanceof BerryBlock ? (BerryBlock)block : null;
                if (berryBlock2 == null || ((BerryBlock)(berryBlock = berryBlock2)).berry() == null || (berry2 = this.berry()) == null || (berry2 = berry2.mutationWith((Berry)berry)) == null) continue;
                Berry mutation = berry2;
                ((Collection)mutations).add(mutation);
            }
            Berry berry3 = this.berry();
            if (berry3 == null) break block4;
            Berry berry4 = berry3;
            boolean bl = false;
            berryBlock = CobblemonEvents.BERRY_MUTATION_OFFER;
            berry = new BerryMutationOfferEvent[]{new BerryMutationOfferEvent(berry4, world, state, pos, mutations)};
            BerryMutationOfferEvent[] events$iv = berry;
            boolean $i$f$post = false;
            this_$iv.emit(Arrays.copyOf(events$iv, events$iv.length));
            BerryMutationOfferEvent[] $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                void this_$iv2;
                BerryBlockEntity blockEntity2;
                BerryMutationOfferEvent element$iv$iv;
                BerryMutationOfferEvent berryMutationOffer = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl2 = false;
                if (!(!((Collection)berryMutationOffer.getMutations()).isEmpty())) continue;
                int mutateChance = 125;
                if (Companion.getMulch(treeEntity) == MulchVariant.SURPRISE) {
                    mutateChance *= 4;
                    treeEntity.decrementMulchDuration(world, pos, state);
                }
                Berry mutation = random.nextInt(1000) < mutateChance ? (Berry)CollectionsKt.random((Collection)mutations, (Random)((Random)Random.Default)) : null;
                BlockEntity blockEntity3 = world.getBlockEntity(pos);
                if ((blockEntity3 instanceof BerryBlockEntity ? (BerryBlockEntity)blockEntity3 : null) == null) continue;
                blockEntity2 = blockEntity2;
                boolean bl3 = false;
                EventObservable<BerryMutationResultEvent> eventObservable = CobblemonEvents.BERRY_MUTATION_RESULT;
                BerryMutationResultEvent[] berryMutationResultEventArray = new BerryMutationResultEvent[]{new BerryMutationResultEvent(berry4, world, state, pos, berryMutationOffer.getMutations(), mutation)};
                BerryMutationResultEvent[] events$iv2 = berryMutationResultEventArray;
                boolean $i$f$post2 = false;
                this_$iv2.emit(Arrays.copyOf(events$iv2, events$iv2.length));
                BerryMutationResultEvent[] $this$forEach$iv$iv2 = events$iv2;
                boolean $i$f$forEach2 = false;
                int n2 = $this$forEach$iv$iv2.length;
                for (int j = 0; j < n2; ++j) {
                    Berry mutation2;
                    BerryMutationResultEvent element$iv$iv2;
                    BerryMutationResultEvent berryMutationResult = element$iv$iv2 = $this$forEach$iv$iv2[j];
                    boolean bl4 = false;
                    if (berryMutationResult.getPickedMutation() == null) continue;
                    boolean bl5 = false;
                    blockEntity2.mutate$common(mutation2);
                }
            }
        }
    }

    @Override
    public boolean canHaveMulchApplied(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull MulchVariant variant) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        BlockState underBlockState = world.getBlockState(pos.below());
        boolean validSoil = (Boolean)state.getValue((Property)IS_ROOTED) != false || underBlockState.is(CobblemonBlockTags.BERRY_SOIL);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BerryBlockEntity berryBlockEntity = blockEntity instanceof BerryBlockEntity ? (BerryBlockEntity)blockEntity : null;
        if (berryBlockEntity == null) {
            return false;
        }
        BerryBlockEntity treeEntity = berryBlockEntity;
        return Companion.getMulch(treeEntity) == MulchVariant.NONE && ((Number)((Object)state.getValue((Property)AGE))).intValue() < 4 && validSoil;
    }

    @Override
    public void applyMulch(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull MulchVariant variant) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
        BerryBlockEntity treeEntity = (BerryBlockEntity)blockEntity;
        treeEntity.setMulch(variant, (Level)world, state, pos);
        world.playSound(null, pos, CobblemonSounds.MULCH_PLACE, SoundSource.BLOCKS, 0.6f, 1.0f);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult blockHitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)blockHitResult, (String)"blockHitResult");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.block.entity.BerryBlockEntity");
        BerryBlockEntity treeEntity = (BerryBlockEntity)blockEntity;
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ShovelItem && Companion.getMulch(treeEntity) != MulchVariant.NONE) {
            treeEntity.setChanged();
            world.playSound(null, pos, CobblemonSounds.MULCH_REMOVE, SoundSource.BLOCKS, 0.6f, 1.0f);
            this.spawnDestroyParticles(world, player, pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            return InteractionResult.SUCCESS;
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is(Items.BONE_MEAL) && !this.isMaxAge(state)) {
            return InteractionResult.PASS;
        }
        if (this.isMaxAge(state)) {
            InteractionResult interactionResult;
            if (this.harvestBerry(world, state, pos, player)) {
                InteractionResult interactionResult2 = InteractionResult.sidedSuccess((boolean)world.isClientSide);
                Intrinsics.checkNotNull((Object)interactionResult2);
                interactionResult = interactionResult2;
            } else {
                interactionResult = InteractionResult.PASS;
            }
            return interactionResult;
        }
        InteractionResult interactionResult = super.useWithoutItem(state, world, pos, player, blockHitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    @Deprecated(message="Deprecated in Java")
    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockState below = world.getBlockState(pos.below());
        return (Boolean)state.getValue((Property)WAS_GENERATED) != false && below.is(CobblemonBlockTags.BERRY_WILD_SOIL) || below.is(CobblemonBlockTags.BERRY_SOIL) || (Boolean)state.getValue((Property)IS_ROOTED) != false;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"updateShape(...)");
        } else {
            BlockState blockState3 = Blocks.AIR.defaultBlockState();
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"defaultBlockState(...)");
        }
        return blockState;
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AGE};
        builder.add(propertyArray);
        propertyArray = new Property[]{WAS_GENERATED};
        builder.add(propertyArray);
        propertyArray = new Property[]{MULCH};
        builder.add(propertyArray);
        propertyArray = new Property[]{IS_ROOTED};
        builder.add(propertyArray);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.berry();
        if (object == null || (object = object.item()) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        Object berryItem = object;
        return new ItemStack((ItemLike)berryItem);
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Berry berry = this.berry();
        if (berry == null) {
            VoxelShape voxelShape2 = Shapes.block();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"block(...)");
            return voxelShape2;
        }
        Berry berry2 = berry;
        Integer n2 = n = (Integer)state.getValue((Property)AGE);
        if (n2 != null && n2 == 0) {
            VoxelShape voxelShape3 = PLANTED_SHAPE;
            voxelShape = voxelShape3;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"PLANTED_SHAPE");
        } else {
            Integer n3 = n;
            int n4 = 1;
            if (n3 != null && n3 == n4) {
                VoxelShape voxelShape4 = PLANTED_SHAPE;
                voxelShape = voxelShape4;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"PLANTED_SHAPE");
            } else {
                Integer n5 = n;
                n4 = 2;
                voxelShape = n5 != null && n5 == n4 ? berry2.getSproutShape() : berry2.getMatureShape();
            }
        }
        return voxelShape;
    }

    private final boolean isMaxAge(BlockState state) {
        Integer n = (Integer)state.getValue((Property)AGE);
        int n2 = 5;
        return n != null && n == n2;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return RenderShape.MODEL;
    }

    @Override
    public boolean attemptShear(@NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Function0<Unit> successCallback) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(successCallback, (String)"successCallback");
        return this.isMaxAge(state) ? BerryBlock.harvestBerry$default(this, world, state, pos, null, 8, null) : false;
    }

    private final boolean harvestBerry(Level world, BlockState state, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BerryBlockEntity berryBlockEntity = blockEntity instanceof BerryBlockEntity ? (BerryBlockEntity)blockEntity : null;
        if (berryBlockEntity == null) {
            return false;
        }
        BerryBlockEntity blockEntity2 = berryBlockEntity;
        Iterable $this$forEach$iv = blockEntity2.harvest(world, state, pos, player);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack drop = (ItemStack)element$iv;
            boolean bl = false;
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)drop);
        }
        SoundEvent sound = player != null ? CobblemonSounds.BERRY_HARVEST : SoundEvents.SHEEP_SHEAR;
        world.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    static /* synthetic */ boolean harvestBerry$default(BerryBlock berryBlock, Level level, BlockState blockState, BlockPos blockPos, Player player, int n, Object object) {
        if ((n & 8) != 0) {
            player = null;
        }
        return berryBlock.harvestBerry(level, blockState, blockPos, player);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance it) {
        return it.group((App)ResourceLocation.CODEC.fieldOf("berry").forGetter(arg_0 -> BerryBlock.CODEC$lambda$0$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)BaseEntityBlock.propertiesCodec()).apply((Applicative)it, BerryBlock::new);
    }

    private static final ResourceLocation CODEC$lambda$0$0(KProperty1 $tmp0, BerryBlock p0) {
        return (ResourceLocation)((Function1)$tmp0).invoke((Object)p0);
    }

    public static final /* synthetic */ ResourceLocation access$getBerryIdentifier$p(BerryBlock $this) {
        return $this.berryIdentifier;
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(BerryBlock::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
        IntegerProperty integerProperty = IntegerProperty.create((String)"age", (int)0, (int)5);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        AGE = integerProperty;
        EnumProperty enumProperty = EnumProperty.create((String)"mulch", MulchVariant.class);
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"create(...)");
        MULCH = enumProperty;
        BooleanProperty booleanProperty = BooleanProperty.create((String)"generated");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        WAS_GENERATED = booleanProperty;
        BooleanProperty booleanProperty2 = BooleanProperty.create((String)"rooted");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty2, (String)"create(...)");
        IS_ROOTED = booleanProperty2;
        PLANTED_SHAPE = Shapes.box((double)0.0, (double)-0.1, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
        STANDARD_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        STANDARD_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        SHORT_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 12.0, 16.0));
        SHORT_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        VOLCANO_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 6.0, 16.0));
        VOLCANO_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        NEST_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 6.0, 16.0));
        NEST_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 20.0, 16.0));
        FRILL_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 8.0, 16.0));
        FRILL_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 14.0, 16.0));
        BLOCK_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 17.0, 16.0));
        BLOCK_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        PYRAMID_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 17.0, 16.0));
        PYRAMID_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        TAIL_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        TAIL_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, 1.0, 0.0, 16.0, 24.0, 16.0));
        SWORD_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 5.0, 16.0));
        SWORD_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        PLATFORM_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 7.0, 16.0));
        PLATFORM_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 22.0, 16.0));
        STAND_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 13.0, 16.0));
        STAND_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        CONE_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        CONE_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 23.0, 16.0));
        SQUAT_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 12.0, 16.0));
        SQUAT_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 22.0, 16.0));
        LANTERN_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 20.0, 16.0));
        LANTERN_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        BOX_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        BOX_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
        BLOSSOM_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 4.0, 16.0));
        BLOSSOM_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 6.0, 16.0));
        LILYPAD_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 11.0, 16.0));
        LILYPAD_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        TALL_SPROUT = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 16.0, 16.0));
        TALL_MATURE = CollectionsKt.listOf((Object)new AABB(0.0, -1.0, 0.0, 16.0, 24.0, 16.0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\bK\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u00188\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010(\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b-\u0010+R\u001f\u00100\u001a\n /*\u0004\u0018\u00010.0.8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u001d\u00106\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u001d\u0010:\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b:\u00107\u001a\u0004\b;\u00109R\u001d\u0010<\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b<\u00107\u001a\u0004\b=\u00109R\u001d\u0010>\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b>\u00107\u001a\u0004\b?\u00109R\u001d\u0010@\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b@\u00107\u001a\u0004\bA\u00109R\u001d\u0010B\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bB\u00107\u001a\u0004\bC\u00109R\u001d\u0010D\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bD\u00107\u001a\u0004\bE\u00109R\u001d\u0010F\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bF\u00107\u001a\u0004\bG\u00109R\u001d\u0010H\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bH\u00107\u001a\u0004\bI\u00109R\u001d\u0010J\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bJ\u00107\u001a\u0004\bK\u00109R\u001d\u0010L\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bL\u00107\u001a\u0004\bM\u00109R\u001d\u0010N\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bN\u00107\u001a\u0004\bO\u00109R\u001d\u0010P\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bP\u00107\u001a\u0004\bQ\u00109R\u001d\u0010R\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bR\u00107\u001a\u0004\bS\u00109R\u001d\u0010T\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bT\u00107\u001a\u0004\bU\u00109R\u001d\u0010V\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bV\u00107\u001a\u0004\bW\u00109R\u001d\u0010X\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bX\u00107\u001a\u0004\bY\u00109R\u001d\u0010Z\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bZ\u00107\u001a\u0004\b[\u00109R\u001d\u0010\\\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b\\\u00107\u001a\u0004\b]\u00109R\u001d\u0010^\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b^\u00107\u001a\u0004\b_\u00109R\u001d\u0010`\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b`\u00107\u001a\u0004\ba\u00109R\u001d\u0010b\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bb\u00107\u001a\u0004\bc\u00109R\u001d\u0010d\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bd\u00107\u001a\u0004\be\u00109R\u001d\u0010f\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bf\u00107\u001a\u0004\bg\u00109R\u001d\u0010h\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bh\u00107\u001a\u0004\bi\u00109R\u001d\u0010j\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bj\u00107\u001a\u0004\bk\u00109R\u001d\u0010l\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bl\u00107\u001a\u0004\bm\u00109R\u001d\u0010n\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bn\u00107\u001a\u0004\bo\u00109R\u001d\u0010p\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bp\u00107\u001a\u0004\bq\u00109R\u001d\u0010r\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\br\u00107\u001a\u0004\bs\u00109R\u001d\u0010t\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bt\u00107\u001a\u0004\bu\u00109R\u001d\u0010v\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bv\u00107\u001a\u0004\bw\u00109R\u001d\u0010x\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bx\u00107\u001a\u0004\by\u00109R\u001d\u0010z\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\bz\u00107\u001a\u0004\b{\u00109R\u001d\u0010|\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b|\u00107\u001a\u0004\b}\u00109R\u001d\u0010~\u001a\b\u0012\u0004\u0012\u000205048\u0006\u00a2\u0006\f\n\u0004\b~\u00107\u001a\u0004\b\u007f\u00109\u00a8\u0006\u0080\u0001"}, d2={"Lcom/cobblemon/mod/common/block/BerryBlock$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;", "entity", "Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "getMulch", "(Lcom/cobblemon/mod/common/block/entity/BerryBlockEntity;)Lcom/cobblemon/mod/common/api/mulch/MulchVariant;", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/core/BlockPos;", "pos", "", "convertMulchToEntity", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)V", "Lcom/mojang/serialization/MapCodec;", "Lcom/cobblemon/mod/common/block/BerryBlock;", "CODEC", "Lcom/mojang/serialization/MapCodec;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "", "MATURE_AGE", "I", "FLOWER_AGE", "FRUIT_AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "MULCH", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "getMULCH", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "WAS_GENERATED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWAS_GENERATED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "IS_ROOTED", "getIS_ROOTED", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "PLANTED_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getPLANTED_SHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "", "Lnet/minecraft/world/phys/AABB;", "STANDARD_SPROUT", "Ljava/util/List;", "getSTANDARD_SPROUT", "()Ljava/util/List;", "STANDARD_MATURE", "getSTANDARD_MATURE", "SHORT_SPROUT", "getSHORT_SPROUT", "SHORT_MATURE", "getSHORT_MATURE", "VOLCANO_SPROUT", "getVOLCANO_SPROUT", "VOLCANO_MATURE", "getVOLCANO_MATURE", "NEST_SPROUT", "getNEST_SPROUT", "NEST_MATURE", "getNEST_MATURE", "FRILL_SPROUT", "getFRILL_SPROUT", "FRILL_MATURE", "getFRILL_MATURE", "BLOCK_SPROUT", "getBLOCK_SPROUT", "BLOCK_MATURE", "getBLOCK_MATURE", "PYRAMID_SPROUT", "getPYRAMID_SPROUT", "PYRAMID_MATURE", "getPYRAMID_MATURE", "TAIL_SPROUT", "getTAIL_SPROUT", "TAIL_MATURE", "getTAIL_MATURE", "SWORD_SPROUT", "getSWORD_SPROUT", "SWORD_MATURE", "getSWORD_MATURE", "PLATFORM_SPROUT", "getPLATFORM_SPROUT", "PLATFORM_MATURE", "getPLATFORM_MATURE", "STAND_SPROUT", "getSTAND_SPROUT", "STAND_MATURE", "getSTAND_MATURE", "CONE_SPROUT", "getCONE_SPROUT", "CONE_MATURE", "getCONE_MATURE", "SQUAT_SPROUT", "getSQUAT_SPROUT", "SQUAT_MATURE", "getSQUAT_MATURE", "LANTERN_SPROUT", "getLANTERN_SPROUT", "LANTERN_MATURE", "getLANTERN_MATURE", "BOX_SPROUT", "getBOX_SPROUT", "BOX_MATURE", "getBOX_MATURE", "BLOSSOM_SPROUT", "getBLOSSOM_SPROUT", "BLOSSOM_MATURE", "getBLOSSOM_MATURE", "LILYPAD_SPROUT", "getLILYPAD_SPROUT", "LILYPAD_MATURE", "getLILYPAD_MATURE", "TALL_SPROUT", "getTALL_SPROUT", "TALL_MATURE", "getTALL_MATURE", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<BerryBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final IntegerProperty getAGE() {
            return AGE;
        }

        @NotNull
        public final EnumProperty<MulchVariant> getMULCH() {
            return MULCH;
        }

        @NotNull
        public final BooleanProperty getWAS_GENERATED() {
            return WAS_GENERATED;
        }

        @NotNull
        public final BooleanProperty getIS_ROOTED() {
            return IS_ROOTED;
        }

        public final VoxelShape getPLANTED_SHAPE() {
            return PLANTED_SHAPE;
        }

        @NotNull
        public final List<AABB> getSTANDARD_SPROUT() {
            return STANDARD_SPROUT;
        }

        @NotNull
        public final List<AABB> getSTANDARD_MATURE() {
            return STANDARD_MATURE;
        }

        @NotNull
        public final List<AABB> getSHORT_SPROUT() {
            return SHORT_SPROUT;
        }

        @NotNull
        public final List<AABB> getSHORT_MATURE() {
            return SHORT_MATURE;
        }

        @NotNull
        public final List<AABB> getVOLCANO_SPROUT() {
            return VOLCANO_SPROUT;
        }

        @NotNull
        public final List<AABB> getVOLCANO_MATURE() {
            return VOLCANO_MATURE;
        }

        @NotNull
        public final List<AABB> getNEST_SPROUT() {
            return NEST_SPROUT;
        }

        @NotNull
        public final List<AABB> getNEST_MATURE() {
            return NEST_MATURE;
        }

        @NotNull
        public final List<AABB> getFRILL_SPROUT() {
            return FRILL_SPROUT;
        }

        @NotNull
        public final List<AABB> getFRILL_MATURE() {
            return FRILL_MATURE;
        }

        @NotNull
        public final List<AABB> getBLOCK_SPROUT() {
            return BLOCK_SPROUT;
        }

        @NotNull
        public final List<AABB> getBLOCK_MATURE() {
            return BLOCK_MATURE;
        }

        @NotNull
        public final List<AABB> getPYRAMID_SPROUT() {
            return PYRAMID_SPROUT;
        }

        @NotNull
        public final List<AABB> getPYRAMID_MATURE() {
            return PYRAMID_MATURE;
        }

        @NotNull
        public final List<AABB> getTAIL_SPROUT() {
            return TAIL_SPROUT;
        }

        @NotNull
        public final List<AABB> getTAIL_MATURE() {
            return TAIL_MATURE;
        }

        @NotNull
        public final List<AABB> getSWORD_SPROUT() {
            return SWORD_SPROUT;
        }

        @NotNull
        public final List<AABB> getSWORD_MATURE() {
            return SWORD_MATURE;
        }

        @NotNull
        public final List<AABB> getPLATFORM_SPROUT() {
            return PLATFORM_SPROUT;
        }

        @NotNull
        public final List<AABB> getPLATFORM_MATURE() {
            return PLATFORM_MATURE;
        }

        @NotNull
        public final List<AABB> getSTAND_SPROUT() {
            return STAND_SPROUT;
        }

        @NotNull
        public final List<AABB> getSTAND_MATURE() {
            return STAND_MATURE;
        }

        @NotNull
        public final List<AABB> getCONE_SPROUT() {
            return CONE_SPROUT;
        }

        @NotNull
        public final List<AABB> getCONE_MATURE() {
            return CONE_MATURE;
        }

        @NotNull
        public final List<AABB> getSQUAT_SPROUT() {
            return SQUAT_SPROUT;
        }

        @NotNull
        public final List<AABB> getSQUAT_MATURE() {
            return SQUAT_MATURE;
        }

        @NotNull
        public final List<AABB> getLANTERN_SPROUT() {
            return LANTERN_SPROUT;
        }

        @NotNull
        public final List<AABB> getLANTERN_MATURE() {
            return LANTERN_MATURE;
        }

        @NotNull
        public final List<AABB> getBOX_SPROUT() {
            return BOX_SPROUT;
        }

        @NotNull
        public final List<AABB> getBOX_MATURE() {
            return BOX_MATURE;
        }

        @NotNull
        public final List<AABB> getBLOSSOM_SPROUT() {
            return BLOSSOM_SPROUT;
        }

        @NotNull
        public final List<AABB> getBLOSSOM_MATURE() {
            return BLOSSOM_MATURE;
        }

        @NotNull
        public final List<AABB> getLILYPAD_SPROUT() {
            return LILYPAD_SPROUT;
        }

        @NotNull
        public final List<AABB> getLILYPAD_MATURE() {
            return LILYPAD_MATURE;
        }

        @NotNull
        public final List<AABB> getTALL_SPROUT() {
            return TALL_SPROUT;
        }

        @NotNull
        public final List<AABB> getTALL_MATURE() {
            return TALL_MATURE;
        }

        @NotNull
        public final MulchVariant getMulch(@NotNull BerryBlockEntity entity) {
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            return entity.getMulchVariant();
        }

        public final void convertMulchToEntity(@NotNull ServerLevel world, @NotNull BlockState state, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockEntity blockEntity = world.getBlockEntity(pos);
            BerryBlockEntity berryBlockEntity = blockEntity instanceof BerryBlockEntity ? (BerryBlockEntity)blockEntity : null;
            if (berryBlockEntity == null) {
                return;
            }
            BerryBlockEntity entity = berryBlockEntity;
            if (state.getValue((Property)this.getMULCH()) != MulchVariant.NONE && state.getValue((Property)this.getMULCH()) != entity.getMulchVariant()) {
                Comparable comparable = state.getValue((Property)this.getMULCH());
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
                entity.setMulchVariant((MulchVariant)((Object)comparable));
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getMULCH(), (Comparable)((Object)MulchVariant.NONE)));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

