/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.dispatch.CauserInstruction;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.MoveInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/ResistedInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "publicMessage", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "instructionSet", "<init>", "(Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPublicMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "getInstructionSet", "()Lcom/cobblemon/mod/common/battles/dispatch/InstructionSet;", "common"})
public final class ResistedInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleMessage publicMessage;
    @NotNull
    private final InstructionSet instructionSet;

    public ResistedInstruction(@NotNull BattleMessage publicMessage, @NotNull InstructionSet instructionSet) {
        Intrinsics.checkNotNullParameter((Object)publicMessage, (String)"publicMessage");
        Intrinsics.checkNotNullParameter((Object)instructionSet, (String)"instructionSet");
        this.publicMessage = publicMessage;
        this.instructionSet = instructionSet;
    }

    @NotNull
    public final BattleMessage getPublicMessage() {
        return this.publicMessage;
    }

    @NotNull
    public final InstructionSet getInstructionSet() {
        return this.instructionSet;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        BattlePokemon battlePokemon = this.publicMessage.battlePokemon(0, battle);
        if (battlePokemon == null) {
            return;
        }
        CauserInstruction lastCauser = this.instructionSet.getMostRecentCauser(this);
        battle.dispatchGo((Function0<Unit>)((Function0)() -> ResistedInstruction.invoke$lambda$0(lastCauser, battlePokemon, battle, this)));
    }

    private static final Unit invoke$lambda$0(CauserInstruction $lastCauser, BattlePokemon $battlePokemon, PokemonBattle $battle, ResistedInstruction this$0) {
        if ($lastCauser instanceof MoveInstruction && !((Collection)((MoveInstruction)$lastCauser).getSpreadTargets()).isEmpty()) {
            MutableComponent pokemonName = $battlePokemon.getName();
            Object[] objectArray = new Object[]{pokemonName};
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("resisted_spread", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            $battle.broadcastChatMessage((Component)mutableComponent);
        } else {
            MutableComponent mutableComponent = LocalizationUtilsKt.battleLang("resisted", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"battleLang(...)");
            $battle.broadcastChatMessage((Component)mutableComponent);
        }
        ((Map)$battle.getMinorBattleActions()).put($battlePokemon.getUuid(), this$0.publicMessage);
        return Unit.INSTANCE;
    }
}

