/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattlePersistentStatusPacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/CureStatusInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "<init>", "(Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "common"})
@SourceDebugExtension(value={"SMAP\nCureStatusInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CureStatusInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/CureStatusInstruction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class CureStatusInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleMessage message;

    public CureStatusInstruction(@NotNull BattleMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Object object;
        BattlePokemon pokemon;
        BattlePokemon maybeActivePokemon;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
                Object object2 = this.message.actorAndActivePokemon(0, battle);
                maybeActivePokemon = object2 != null && (object2 = (ActiveBattlePokemon)object2.getSecond()) != null ? ((ActiveBattlePokemon)object2).getBattlePokemon() : null;
                BattlePokemon maybePartyPokemon = this.message.battlePokemon(0, battle);
                BattlePokemon battlePokemon = maybeActivePokemon;
                if (battlePokemon == null && (battlePokemon = maybePartyPokemon) == null) {
                    return;
                }
                pokemon = battlePokemon;
                object = this.message.argumentAt(1);
                if (object == null) break block4;
                String p0 = object;
                boolean bl = false;
                Status status = Statuses.getStatus(p0);
                object = status;
                if (status != null) break block5;
            }
            return;
        }
        Object status = object;
        Effect effect = BattleMessage.effect$default(this.message, null, 1, null);
        ShowdownInterpreter.INSTANCE.broadcastOptionalAbility(battle, effect, pokemon);
        PokemonBattle.dispatchWaiting$default(battle, 0.0f, () -> CureStatusInstruction.invoke$lambda$0(pokemon, maybeActivePokemon, this, effect, (Status)status, battle), 1, null);
    }

    private static final Unit invoke$lambda$0(BattlePokemon $pokemon, BattlePokemon $maybeActivePokemon, CureStatusInstruction this$0, Effect $effect, Status $status, PokemonBattle $battle) {
        MutableComponent mutableComponent;
        MutableComponent pokemonName = $pokemon.getName();
        $pokemon.getEffectedPokemon().setStatus(null);
        $pokemon.sendUpdate();
        if ($maybeActivePokemon != null) {
            Pair<String, String> pair = this$0.message.pnxAndUuid(0);
            if (pair != null) {
                Pair<String, String> it = pair;
                boolean bl = false;
                $battle.sendUpdate(new BattlePersistentStatusPacket((String)it.getFirst(), null));
            }
        }
        Effect effect = $effect;
        Effect.Type type = effect != null ? effect.getType() : null;
        if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 1) {
            var9_9 = new Object[]{pokemonName};
            mutableComponent = LocalizationUtilsKt.battleLang("curestatus." + $effect.getId(), var9_9);
        } else {
            var9_9 = new Object[]{pokemonName};
            mutableComponent = MiscUtilsKt.asTranslated($status.getRemoveMessage(), var9_9);
        }
        MutableComponent lang = mutableComponent;
        Intrinsics.checkNotNull((Object)lang);
        $battle.broadcastChatMessage((Component)lang);
        $pokemon.getContextManager().remove($status.getShowdownName(), BattleContext.Type.STATUS);
        ((Map)$battle.getMinorBattleActions()).put($pokemon.getUuid(), this$0.message);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Effect.Type.values().length];
            try {
                nArray[Effect.Type.ABILITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

