/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.cobblemon.mod.common.api.battles.interpreter.BattleContext;
import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.InvalidInstructionException;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectContext;
import com.cobblemon.mod.common.api.moves.animations.ActionEffectTimeline;
import com.cobblemon.mod.common.api.moves.animations.ActionEffects;
import com.cobblemon.mod.common.api.moves.animations.UsersProvider;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.ShowdownInterpreter;
import com.cobblemon.mod.common.battles.dispatch.ActionEffectInstruction;
import com.cobblemon.mod.common.battles.dispatch.DispatchResult;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 @2\u00020\u0001:\u0001@B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0007\u0010\u0018R&\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00198\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010)\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010.\u001a\u00020-8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u0017\u00102\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0017\u00107\u001a\u0002068\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u0017\u0010<\u001a\u00020;8\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/BoostInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/ActionEffectInstruction;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "", "isBoost", "<init>", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;Z)V", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "runtime", "", "addMolangQueries", "(Lcom/bedrockk/molang/runtime/MoLangRuntime;)V", "preActionEffect", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "runActionEffect", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;Lcom/bedrockk/molang/runtime/MoLangRuntime;)V", "postActionEffect", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "Z", "()Z", "Ljava/util/concurrent/CompletableFuture;", "future", "Ljava/util/concurrent/CompletableFuture;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "setFuture", "(Ljava/util/concurrent/CompletableFuture;)V", "", "", "holds", "Ljava/util/Set;", "getHolds", "()Ljava/util/Set;", "setHolds", "(Ljava/util/Set;)V", "Lnet/minecraft/resources/ResourceLocation;", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemon", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "statKey", "Ljava/lang/String;", "getStatKey", "()Ljava/lang/String;", "", "stages", "I", "getStages", "()I", "Lnet/minecraft/network/chat/Component;", "stat", "Lnet/minecraft/network/chat/Component;", "getStat", "()Lnet/minecraft/network/chat/Component;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nBoostInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoostInstruction.kt\ncom/cobblemon/mod/common/battles/interpreter/instructions/BoostInstruction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class BoostInstruction
implements ActionEffectInstruction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BattleMessage message;
    private final boolean isBoost;
    @NotNull
    private CompletableFuture<?> future;
    @NotNull
    private Set<String> holds;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final BattlePokemon pokemon;
    @NotNull
    private final String statKey;
    private final int stages;
    @NotNull
    private final Component stat;
    @NotNull
    private static final ActionEffectTimeline BOOST_EFFECT;
    @NotNull
    private static final ActionEffectTimeline UNBOOST_EFFECT;

    public BoostInstruction(@NotNull PokemonBattle battle, @NotNull BattleMessage message, boolean isBoost) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.message = message;
        this.isBoost = isBoost;
        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        this.future = completableFuture;
        this.holds = new LinkedHashSet();
        this.id = MiscUtilsKt.cobblemonResource("boost");
        BattlePokemon battlePokemon = this.message.battlePokemon(0, battle);
        if (battlePokemon == null) {
            throw new InvalidInstructionException(this.message);
        }
        this.pokemon = battlePokemon;
        String string = this.message.argumentAt(1);
        if (string == null) {
            throw new InvalidInstructionException(this.message);
        }
        this.statKey = string;
        String string2 = this.message.argumentAt(2);
        if (string2 == null) {
            throw new InvalidInstructionException(this.message);
        }
        this.stages = Integer.parseInt(string2);
        this.stat = Stats.Companion.getStat(this.statKey).getDisplayName();
    }

    public /* synthetic */ BoostInstruction(PokemonBattle pokemonBattle, BattleMessage battleMessage, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(pokemonBattle, battleMessage, bl);
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    public final boolean isBoost() {
        return this.isBoost;
    }

    @Override
    @NotNull
    public CompletableFuture<?> getFuture() {
        return this.future;
    }

    @Override
    public void setFuture(@NotNull CompletableFuture<?> completableFuture) {
        Intrinsics.checkNotNullParameter(completableFuture, (String)"<set-?>");
        this.future = completableFuture;
    }

    @Override
    @NotNull
    public Set<String> getHolds() {
        return this.holds;
    }

    @Override
    public void setHolds(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.holds = set;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public final BattlePokemon getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final String getStatKey() {
        return this.statKey;
    }

    public final int getStages() {
        return this.stages;
    }

    @NotNull
    public final Component getStat() {
        return this.stat;
    }

    @Override
    public void addMolangQueries(@NotNull MoLangRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        ActionEffectInstruction.super.addMolangQueries(runtime);
        QueryStruct queryStruct = runtime.getEnvironment().query;
        Intrinsics.checkNotNullExpressionValue((Object)queryStruct, (String)"query");
        MoLangFunctions.INSTANCE.addBattleMessageFunctions(queryStruct, this.message);
    }

    @Override
    public void preActionEffect(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
    }

    @Override
    public void runActionEffect(@NotNull PokemonBattle battle, @NotNull MoLangRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        if (this.stages == 0) {
            return;
        }
        battle.dispatch((Function0<? extends DispatchResult>)((Function0)() -> BoostInstruction.runActionEffect$lambda$0(this, battle, runtime)));
    }

    @Override
    public void postActionEffect(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        String severity = Stats.Companion.getSeverity(this.stages);
        String rootKey = this.isBoost ? "boost" : "unboost";
        battle.dispatch((Function0<? extends DispatchResult>)((Function0)() -> BoostInstruction.postActionEffect$lambda$0(this, rootKey, severity, battle)));
    }

    private static final DispatchResult runActionEffect$lambda$0(BoostInstruction this$0, PokemonBattle $battle, MoLangRuntime $runtime) {
        ActionEffectTimeline actionEffect = this$0.isBoost ? BOOST_EFFECT : UNBOOST_EFFECT;
        Object[] objectArray = new Object[]{$battle};
        List providers = CollectionsKt.mutableListOf((Object[])objectArray);
        PokemonEntity pokemonEntity = this$0.pokemon.getEffectedPokemon().getEntity();
        if (pokemonEntity != null) {
            PokemonEntity it = pokemonEntity;
            boolean bl = false;
            Entity[] entityArray = new Entity[]{it};
            UsersProvider p0 = new UsersProvider(entityArray);
            boolean bl2 = false;
            providers.add(p0);
        }
        ServerPlayer serverPlayer = (ServerPlayer)CollectionsKt.firstOrNull($battle.getPlayers());
        Level level = serverPlayer != null ? serverPlayer.level() : null;
        ActionEffectContext context = new ActionEffectContext(actionEffect, null, providers, $runtime, false, false, null, level, 114, null);
        this$0.setFuture(actionEffect.run(context));
        this$0.setHolds(context.getHolds());
        this$0.getFuture().thenApply(arg_0 -> BoostInstruction.runActionEffect$lambda$0$2(arg_0 -> BoostInstruction.runActionEffect$lambda$0$1(this$0, arg_0), arg_0));
        return DispatchResultKt.getGO();
    }

    private static final Unit runActionEffect$lambda$0$1(BoostInstruction this$0, Object it) {
        this$0.getHolds().clear();
        return Unit.INSTANCE;
    }

    private static final Unit runActionEffect$lambda$0$2(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final DispatchResult postActionEffect$lambda$0(BoostInstruction this$0, String $rootKey, String $severity, PokemonBattle $battle) {
        MutableComponent mutableComponent;
        if (this$0.message.hasOptionalArgument("zeffect")) {
            var5_4 = new Object[]{this$0.pokemon.getName(), this$0.stat};
            mutableComponent = LocalizationUtilsKt.battleLang($rootKey + "." + $severity + ".zeffect", var5_4);
        } else {
            var5_4 = new Object[]{this$0.pokemon.getName(), this$0.stat};
            mutableComponent = LocalizationUtilsKt.battleLang($rootKey + "." + $severity, var5_4);
        }
        MutableComponent lang = mutableComponent;
        Intrinsics.checkNotNull((Object)lang);
        $battle.broadcastChatMessage((Component)lang);
        BattleContext.Type boostBucket = this$0.isBoost ? BattleContext.Type.BOOST : BattleContext.Type.UNBOOST;
        BattleContext context = ShowdownInterpreter.INSTANCE.getContextFromAction(this$0.message, boostBucket, $battle);
        int n = this$0.stages;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            BattleContext[] battleContextArray = new BattleContext[]{context};
            this$0.pokemon.getContextManager().add(battleContextArray);
        }
        ((Map)$battle.getMinorBattleActions()).put(this$0.pokemon.getUuid(), this$0.message);
        return new UntilDispatch((Function0<Boolean>)((Function0)() -> BoostInstruction.postActionEffect$lambda$0$1(this$0)));
    }

    private static final boolean postActionEffect$lambda$0$1(BoostInstruction this$0) {
        return !this$0.getHolds().contains("effects");
    }

    static {
        ActionEffectTimeline actionEffectTimeline = ActionEffects.INSTANCE.getActionEffects().get(MiscUtilsKt.cobblemonResource("boost"));
        Intrinsics.checkNotNull((Object)actionEffectTimeline);
        BOOST_EFFECT = actionEffectTimeline;
        ActionEffectTimeline actionEffectTimeline2 = ActionEffects.INSTANCE.getActionEffects().get(MiscUtilsKt.cobblemonResource("unboost"));
        Intrinsics.checkNotNull((Object)actionEffectTimeline2);
        UNBOOST_EFFECT = actionEffectTimeline2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/BoostInstruction$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/moves/animations/ActionEffectTimeline;", "BOOST_EFFECT", "Lcom/cobblemon/mod/common/api/moves/animations/ActionEffectTimeline;", "getBOOST_EFFECT", "()Lcom/cobblemon/mod/common/api/moves/animations/ActionEffectTimeline;", "UNBOOST_EFFECT", "getUNBOOST_EFFECT", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionEffectTimeline getBOOST_EFFECT() {
            return BOOST_EFFECT;
        }

        @NotNull
        public final ActionEffectTimeline getUNBOOST_EFFECT() {
            return UNBOOST_EFFECT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

