/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.actor;

import com.cobblemon.mod.common.api.battles.model.actor.AIBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.ActorType;
import com.cobblemon.mod.common.api.battles.model.actor.EntityBackedBattleActor;
import com.cobblemon.mod.common.api.battles.model.actor.FleeableBattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.battle.BattleEndPacket;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B)\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001e\u001a\u00020\u001d2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010\n\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010#\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010\u00188\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0016\u0010,\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010.\u001a\u00020-8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/battles/actor/PokemonBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/AIBattleActor;", "Lcom/cobblemon/mod/common/api/battles/model/actor/EntityBackedBattleActor;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lcom/cobblemon/mod/common/api/battles/model/actor/FleeableBattleActor;", "Ljava/util/UUID;", "uuid", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "pokemon", "", "fleeDistance", "Lcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;", "artificialDecider", "<init>", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;FLcom/cobblemon/mod/common/api/battles/model/ai/BattleAI;)V", "Lnet/minecraft/network/chat/MutableComponent;", "getName", "()Lnet/minecraft/network/chat/MutableComponent;", "", "name", "nameOwned", "(Ljava/lang/String;)Lnet/minecraft/network/chat/MutableComponent;", "Lkotlin/Pair;", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/world/phys/Vec3;", "getWorldAndPosition", "()Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "packet", "", "sendUpdate", "(Lcom/cobblemon/mod/common/api/net/NetworkPacket;)V", "Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/battles/pokemon/BattlePokemon;", "F", "getFleeDistance", "()F", "initialPos", "Lnet/minecraft/world/phys/Vec3;", "getInitialPos", "()Lnet/minecraft/world/phys/Vec3;", "getEntity", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "type", "Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "getType", "()Lcom/cobblemon/mod/common/api/battles/model/actor/ActorType;", "common"})
public final class PokemonBattleActor
extends AIBattleActor
implements EntityBackedBattleActor<PokemonEntity>,
FleeableBattleActor {
    @NotNull
    private final BattlePokemon pokemon;
    private final float fleeDistance;
    @Nullable
    private final Vec3 initialPos;
    @NotNull
    private final ActorType type;

    public PokemonBattleActor(@NotNull UUID uuid, @NotNull BattlePokemon pokemon, float fleeDistance, @NotNull BattleAI artificialDecider) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)artificialDecider, (String)"artificialDecider");
        super(uuid, CollectionsKt.listOf((Object)pokemon), artificialDecider);
        this.pokemon = pokemon;
        this.fleeDistance = fleeDistance;
        PokemonEntity pokemonEntity = this.getEntity();
        this.initialPos = pokemonEntity != null ? pokemonEntity.position() : null;
        this.type = ActorType.WILD;
    }

    public /* synthetic */ PokemonBattleActor(UUID uUID, BattlePokemon battlePokemon, float f, BattleAI battleAI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            battleAI = new RandomBattleAI();
        }
        this(uUID, battlePokemon, f, battleAI);
    }

    @NotNull
    public final BattlePokemon getPokemon() {
        return this.pokemon;
    }

    @Override
    public float getFleeDistance() {
        return this.fleeDistance;
    }

    @Override
    @Nullable
    public Vec3 getInitialPos() {
        return this.initialPos;
    }

    @Override
    @NotNull
    public MutableComponent getName() {
        return this.pokemon.getEffectedPokemon().getSpecies().getTranslatedName();
    }

    @Override
    @NotNull
    public MutableComponent nameOwned(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MutableComponent mutableComponent = Component.literal((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return mutableComponent;
    }

    @Override
    @Nullable
    public Pair<ServerLevel, Vec3> getWorldAndPosition() {
        ServerPlayer ownerPlayer = this.pokemon.getEffectedPokemon().getOwnerPlayer();
        if (ownerPlayer != null) {
            return TuplesKt.to((Object)ownerPlayer.serverLevel(), (Object)ownerPlayer.position());
        }
        PokemonEntity pokemonEntity = this.getEntity();
        if (pokemonEntity == null) {
            return null;
        }
        PokemonEntity entity = pokemonEntity;
        Level level = entity.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return null;
        }
        ServerLevel world = serverLevel;
        return TuplesKt.to((Object)world, (Object)entity.position());
    }

    @Override
    public void sendUpdate(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        super.sendUpdate(packet);
        if (packet instanceof BattleEndPacket) {
            PokemonEntity pokemonEntity = this.getEntity();
            if (pokemonEntity == null) {
                return;
            }
            PokemonEntity entity = pokemonEntity;
            entity.setBattleId(null);
        }
    }

    @Override
    @Nullable
    public PokemonEntity getEntity() {
        return this.pokemon.getEntity();
    }

    @Override
    @NotNull
    public ActorType getType() {
        return this.type;
    }
}

