/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.player;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerAdvancementData;
import com.cobblemon.mod.common.api.storage.player.PlayerDataExtension;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import com.cobblemon.mod.common.api.storage.player.client.ClientGeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.client.ClientInstancedPlayerData;
import com.cobblemon.mod.common.net.messages.client.SetClientPlayerDataPacket;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b!\u0010 J\u0010\u0010\"\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010 J\u0012\u0010#\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b#\u0010\u001eJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0012\u0010&\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0004\b&\u0010'J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u00c6\u0003\u00a2\u0006\u0004\b(\u0010)Jv\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00022\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u00c6\u0001\u00a2\u0006\u0004\b*\u0010+J\u001a\u0010.\u001a\u00020\u00042\b\u0010-\u001a\u0004\u0018\u00010,H\u00d6\u0003\u00a2\u0006\u0004\b.\u0010/J\u0010\u00101\u001a\u000200H\u00d6\u0001\u00a2\u0006\u0004\b1\u00102J\u0010\u00103\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b3\u00104R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00105\u001a\u0004\b6\u0010\u001eR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u00107\u001a\u0004\b8\u0010 \"\u0004\b9\u0010:R\"\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u00107\u001a\u0004\b;\u0010 \"\u0004\b<\u0010:R\"\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u00107\u001a\u0004\b=\u0010 \"\u0004\b>\u0010:R$\u0010\b\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u00105\u001a\u0004\b?\u0010\u001e\"\u0004\b@\u0010AR(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010B\u001a\u0004\bC\u0010%\"\u0004\bD\u0010ER$\u0010\f\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010F\u001a\u0004\bG\u0010'\"\u0004\bH\u0010IR#\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010J\u001a\u0004\bK\u0010)R\"\u0010M\u001a\u00020L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bM\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010R\u00a8\u0006S"}, d2={"Lcom/cobblemon/mod/common/api/storage/player/GeneralPlayerData;", "Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "Ljava/util/UUID;", "uuid", "", "starterPrompted", "starterLocked", "starterSelected", "starterUUID", "", "Lnet/minecraft/resources/ResourceLocation;", "keyItems", "battleTheme", "", "", "Lcom/cobblemon/mod/common/api/storage/player/PlayerDataExtension;", "extraData", "<init>", "(Ljava/util/UUID;ZZZLjava/util/UUID;Ljava/util/Set;Lnet/minecraft/resources/ResourceLocation;Ljava/util/Map;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "", "sendToPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)V", "initialize", "()V", "Lcom/cobblemon/mod/common/api/storage/player/client/ClientInstancedPlayerData;", "toClientData", "()Lcom/cobblemon/mod/common/api/storage/player/client/ClientInstancedPlayerData;", "component1", "()Ljava/util/UUID;", "component2", "()Z", "component3", "component4", "component5", "component6", "()Ljava/util/Set;", "component7", "()Lnet/minecraft/resources/ResourceLocation;", "component8", "()Ljava/util/Map;", "copy", "(Ljava/util/UUID;ZZZLjava/util/UUID;Ljava/util/Set;Lnet/minecraft/resources/ResourceLocation;Ljava/util/Map;)Lcom/cobblemon/mod/common/api/storage/player/GeneralPlayerData;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getUuid", "Z", "getStarterPrompted", "setStarterPrompted", "(Z)V", "getStarterLocked", "setStarterLocked", "getStarterSelected", "setStarterSelected", "getStarterUUID", "setStarterUUID", "(Ljava/util/UUID;)V", "Ljava/util/Set;", "getKeyItems", "setKeyItems", "(Ljava/util/Set;)V", "Lnet/minecraft/resources/ResourceLocation;", "getBattleTheme", "setBattleTheme", "(Lnet/minecraft/resources/ResourceLocation;)V", "Ljava/util/Map;", "getExtraData", "Lcom/cobblemon/mod/common/api/storage/player/PlayerAdvancementData;", "advancementData", "Lcom/cobblemon/mod/common/api/storage/player/PlayerAdvancementData;", "getAdvancementData", "()Lcom/cobblemon/mod/common/api/storage/player/PlayerAdvancementData;", "setAdvancementData", "(Lcom/cobblemon/mod/common/api/storage/player/PlayerAdvancementData;)V", "common"})
@SourceDebugExtension(value={"SMAP\nGeneralPlayerData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralPlayerData.kt\ncom/cobblemon/mod/common/api/storage/player/GeneralPlayerData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1869#2,2:61\n*S KotlinDebug\n*F\n+ 1 GeneralPlayerData.kt\ncom/cobblemon/mod/common/api/storage/player/GeneralPlayerData\n*L\n41#1:61,2\n*E\n"})
public final class GeneralPlayerData
implements InstancedPlayerData {
    @NotNull
    private final UUID uuid;
    private boolean starterPrompted;
    private boolean starterLocked;
    private boolean starterSelected;
    @Nullable
    private UUID starterUUID;
    @NotNull
    private Set<ResourceLocation> keyItems;
    @Nullable
    private ResourceLocation battleTheme;
    @NotNull
    private final Map<String, PlayerDataExtension> extraData;
    @NotNull
    private PlayerAdvancementData advancementData;

    public GeneralPlayerData(@NotNull UUID uuid, boolean starterPrompted, boolean starterLocked, boolean starterSelected, @Nullable UUID starterUUID, @NotNull Set<ResourceLocation> keyItems, @Nullable ResourceLocation battleTheme, @NotNull Map<String, PlayerDataExtension> extraData) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(keyItems, (String)"keyItems");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        this.uuid = uuid;
        this.starterPrompted = starterPrompted;
        this.starterLocked = starterLocked;
        this.starterSelected = starterSelected;
        this.starterUUID = starterUUID;
        this.keyItems = keyItems;
        this.battleTheme = battleTheme;
        this.extraData = extraData;
        this.advancementData = new PlayerAdvancementData();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public final boolean getStarterPrompted() {
        return this.starterPrompted;
    }

    public final void setStarterPrompted(boolean bl) {
        this.starterPrompted = bl;
    }

    public final boolean getStarterLocked() {
        return this.starterLocked;
    }

    public final void setStarterLocked(boolean bl) {
        this.starterLocked = bl;
    }

    public final boolean getStarterSelected() {
        return this.starterSelected;
    }

    public final void setStarterSelected(boolean bl) {
        this.starterSelected = bl;
    }

    @Nullable
    public final UUID getStarterUUID() {
        return this.starterUUID;
    }

    public final void setStarterUUID(@Nullable UUID uUID) {
        this.starterUUID = uUID;
    }

    @NotNull
    public final Set<ResourceLocation> getKeyItems() {
        return this.keyItems;
    }

    public final void setKeyItems(@NotNull Set<ResourceLocation> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.keyItems = set;
    }

    @Nullable
    public final ResourceLocation getBattleTheme() {
        return this.battleTheme;
    }

    public final void setBattleTheme(@Nullable ResourceLocation resourceLocation) {
        this.battleTheme = resourceLocation;
    }

    @NotNull
    public final Map<String, PlayerDataExtension> getExtraData() {
        return this.extraData;
    }

    @NotNull
    public final PlayerAdvancementData getAdvancementData() {
        return this.advancementData;
    }

    public final void setAdvancementData(@NotNull PlayerAdvancementData playerAdvancementData) {
        Intrinsics.checkNotNullParameter((Object)playerAdvancementData, (String)"<set-?>");
        this.advancementData = playerAdvancementData;
    }

    public final void sendToPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        CobblemonNetwork.INSTANCE.sendPacket(player, new SetClientPlayerDataPacket(PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL(), this.toClientData(), false, 4, null));
    }

    @Override
    public void initialize() {
        Iterable $this$forEach$iv = Cobblemon.INSTANCE.getConfig().getDefaultKeyItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResourceLocation it = (ResourceLocation)element$iv;
            boolean bl = false;
            if (this.keyItems.contains(it)) continue;
            this.keyItems.add(it);
        }
    }

    @Override
    @NotNull
    public ClientInstancedPlayerData toClientData() {
        return new ClientGeneralPlayerData(false, Cobblemon.INSTANCE.getStarterConfig().getPromptStarterOnceOnly() ? !this.starterPrompted : true, this.starterLocked, this.starterSelected, this.starterUUID, this.advancementData.getTotalBattleVictoryCount() == 0, this.battleTheme);
    }

    @NotNull
    public final UUID component1() {
        return this.uuid;
    }

    public final boolean component2() {
        return this.starterPrompted;
    }

    public final boolean component3() {
        return this.starterLocked;
    }

    public final boolean component4() {
        return this.starterSelected;
    }

    @Nullable
    public final UUID component5() {
        return this.starterUUID;
    }

    @NotNull
    public final Set<ResourceLocation> component6() {
        return this.keyItems;
    }

    @Nullable
    public final ResourceLocation component7() {
        return this.battleTheme;
    }

    @NotNull
    public final Map<String, PlayerDataExtension> component8() {
        return this.extraData;
    }

    @NotNull
    public final GeneralPlayerData copy(@NotNull UUID uuid, boolean starterPrompted, boolean starterLocked, boolean starterSelected, @Nullable UUID starterUUID, @NotNull Set<ResourceLocation> keyItems, @Nullable ResourceLocation battleTheme, @NotNull Map<String, PlayerDataExtension> extraData) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(keyItems, (String)"keyItems");
        Intrinsics.checkNotNullParameter(extraData, (String)"extraData");
        return new GeneralPlayerData(uuid, starterPrompted, starterLocked, starterSelected, starterUUID, keyItems, battleTheme, extraData);
    }

    public static /* synthetic */ GeneralPlayerData copy$default(GeneralPlayerData generalPlayerData, UUID uUID, boolean bl, boolean bl2, boolean bl3, UUID uUID2, Set set, ResourceLocation resourceLocation, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = generalPlayerData.uuid;
        }
        if ((n & 2) != 0) {
            bl = generalPlayerData.starterPrompted;
        }
        if ((n & 4) != 0) {
            bl2 = generalPlayerData.starterLocked;
        }
        if ((n & 8) != 0) {
            bl3 = generalPlayerData.starterSelected;
        }
        if ((n & 0x10) != 0) {
            uUID2 = generalPlayerData.starterUUID;
        }
        if ((n & 0x20) != 0) {
            set = generalPlayerData.keyItems;
        }
        if ((n & 0x40) != 0) {
            resourceLocation = generalPlayerData.battleTheme;
        }
        if ((n & 0x80) != 0) {
            map = generalPlayerData.extraData;
        }
        return generalPlayerData.copy(uUID, bl, bl2, bl3, uUID2, set, resourceLocation, map);
    }

    @NotNull
    public String toString() {
        return "GeneralPlayerData(uuid=" + this.uuid + ", starterPrompted=" + this.starterPrompted + ", starterLocked=" + this.starterLocked + ", starterSelected=" + this.starterSelected + ", starterUUID=" + this.starterUUID + ", keyItems=" + this.keyItems + ", battleTheme=" + this.battleTheme + ", extraData=" + this.extraData + ")";
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        result = result * 31 + Boolean.hashCode(this.starterPrompted);
        result = result * 31 + Boolean.hashCode(this.starterLocked);
        result = result * 31 + Boolean.hashCode(this.starterSelected);
        result = result * 31 + (this.starterUUID == null ? 0 : this.starterUUID.hashCode());
        result = result * 31 + ((Object)this.keyItems).hashCode();
        result = result * 31 + (this.battleTheme == null ? 0 : this.battleTheme.hashCode());
        result = result * 31 + ((Object)this.extraData).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneralPlayerData)) {
            return false;
        }
        GeneralPlayerData generalPlayerData = (GeneralPlayerData)other;
        if (!Intrinsics.areEqual((Object)this.uuid, (Object)generalPlayerData.uuid)) {
            return false;
        }
        if (this.starterPrompted != generalPlayerData.starterPrompted) {
            return false;
        }
        if (this.starterLocked != generalPlayerData.starterLocked) {
            return false;
        }
        if (this.starterSelected != generalPlayerData.starterSelected) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.starterUUID, (Object)generalPlayerData.starterUUID)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyItems, generalPlayerData.keyItems)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.battleTheme, (Object)generalPlayerData.battleTheme)) {
            return false;
        }
        return Intrinsics.areEqual(this.extraData, generalPlayerData.extraData);
    }
}

