/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.pc.search;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.pc.search.PokemonFilter;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0010R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/cobblemon/mod/common/api/storage/pc/search/Search;", "", "", "Lcom/cobblemon/mod/common/api/storage/pc/search/PokemonFilter;", "filters", "", "Ljava/util/UUID;", "passed", "failed", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "passes", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Z", "Ljava/util/Set;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Search.kt\ncom/cobblemon/mod/common/api/storage/pc/search/Search\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1740#2,3:86\n*S KotlinDebug\n*F\n+ 1 Search.kt\ncom/cobblemon/mod/common/api/storage/pc/search/Search\n*L\n80#1:86,3\n*E\n"})
public final class Search {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PokemonFilter> filters;
    @NotNull
    private final Set<UUID> passed;
    @NotNull
    private final Set<UUID> failed;
    @NotNull
    private static final Search DEFAULT = new Search(SetsKt.emptySet(), null, null, 6, null);

    public Search(@NotNull Set<? extends PokemonFilter> filters, @NotNull Set<UUID> passed, @NotNull Set<UUID> failed) {
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter(passed, (String)"passed");
        Intrinsics.checkNotNullParameter(failed, (String)"failed");
        this.filters = filters;
        this.passed = passed;
        this.failed = failed;
    }

    public /* synthetic */ Search(Set set, Set set2, Set set3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set2 = new HashSet();
        }
        if ((n & 4) != 0) {
            set3 = new HashSet();
        }
        this(set, set2, set3);
    }

    public final boolean passes(@Nullable Pokemon pokemon) {
        boolean bl;
        UUID uuid;
        block6: {
            if (pokemon == null) {
                return false;
            }
            uuid = pokemon.getUuid();
            if (this.passed.contains(uuid)) {
                return true;
            }
            if (this.failed.contains(uuid)) {
                return false;
            }
            Iterable $this$all$iv = this.filters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PokemonFilter it = (PokemonFilter)element$iv;
                    boolean bl2 = false;
                    if (it.test(pokemon)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        boolean passes = bl;
        Set<UUID> set = passes ? this.passed : this.failed;
        Intrinsics.checkNotNull((Object)uuid);
        set.add(uuid);
        return passes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/cobblemon/mod/common/api/storage/pc/search/Search$Companion;", "", "<init>", "()V", "", "search", "Lcom/cobblemon/mod/common/api/storage/pc/search/Search;", "of", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/storage/pc/search/Search;", "DEFAULT", "Lcom/cobblemon/mod/common/api/storage/pc/search/Search;", "getDEFAULT", "()Lcom/cobblemon/mod/common/api/storage/pc/search/Search;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Search getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final Search of(@NotNull String search) {
            Intrinsics.checkNotNullParameter((Object)search, (String)"search");
            if (StringsKt.isBlank((CharSequence)((CharSequence)search))) {
                return this.getDEFAULT();
            }
            String[] stringArray = search;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string = stringArray.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            stringArray = new String[]{" "};
            List split = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            HashSet<PokemonFilter> filters = new HashSet<PokemonFilter>();
            for (String piece : split) {
                Ref.ObjectRef filter = new Ref.ObjectRef();
                filter.element = piece;
                boolean inverted = StringsKt.startsWith$default((String)((String)filter.element), (String)"!", (boolean)false, (int)2, null);
                if (inverted) {
                    Intrinsics.checkNotNullExpressionValue((Object)((String)filter.element).substring(1), (String)"substring(...)");
                    filter.element = filter.element;
                }
                String string2 = (String)filter.element;
                Locale locale2 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(locale2), (String)"toLowerCase(...)");
                filter.element = filter.element;
                PokemonFilter pokemonFilter = switch ((String)filter.element) {
                    case "holding", "helditem", "held_item" -> Companion::of$lambda$0;
                    case "fainted" -> Companion::of$lambda$1;
                    case "legendary" -> Companion::of$lambda$2;
                    case "mythical" -> Companion::of$lambda$3;
                    case "ultra_beast", "ultrabeast" -> Companion::of$lambda$4;
                    default -> arg_0 -> Companion.of$lambda$5(filter, arg_0);
                };
                boolean bl = inverted ? filters.add(pokemonFilter.inverted()) : filters.add(pokemonFilter);
            }
            return new Search(filters, null, null, 6, null);
        }

        private static final boolean of$lambda$0(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return !pokemon.heldItem().isEmpty();
        }

        private static final boolean of$lambda$1(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return pokemon.isFainted();
        }

        private static final boolean of$lambda$2(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return pokemon.isLegendary();
        }

        private static final boolean of$lambda$3(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return pokemon.isMythical();
        }

        private static final boolean of$lambda$4(Pokemon pokemon) {
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            return pokemon.isUltraBeast();
        }

        private static final boolean of$lambda$5(Ref.ObjectRef $filter, Pokemon pokemon) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
            if (((CharSequence)$filter.element).length() == 0) {
                bl = true;
            } else {
                String string = pokemon.getSpecies().getTranslatedName().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                String string2 = string;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String species = string3;
                String string4 = Pokemon.getDisplayName$default(pokemon, false, 1, null).getString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                String string5 = string4;
                Locale locale2 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
                String string6 = string5.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                String name = string6;
                PokemonProperties props = PokemonProperties.Companion.parse$default(PokemonProperties.Companion, (String)$filter.element, null, null, 6, null);
                bl = StringsKt.contains$default((CharSequence)species, (CharSequence)((CharSequence)$filter.element), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)name, (CharSequence)((CharSequence)$filter.element), (boolean)false, (int)2, null) || props.matches(pokemon) && ((CharSequence)PokemonProperties.asString$default(props, null, 1, null)).length() > 0;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

