/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.position;

import com.cobblemon.mod.common.api.spawning.fishing.FishingSpawnCause;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.BasicSpawnablePosition;
import com.cobblemon.mod.common.item.interactive.PokerodItem;
import com.cobblemon.mod.common.util.BlockPosExtensionsKt;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fR;\u0010\u0010\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\r8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010!\u001a\u0004\u0018\u00010 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b%\u0010\u001d\u001a\u0004\b&\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/api/spawning/position/FishingSpawnablePosition;", "Lcom/cobblemon/mod/common/api/spawning/position/BasicSpawnablePosition;", "Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause;", "cause", "Lnet/minecraft/server/level/ServerLevel;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "influences", "<init>", "(Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/List;)V", "Ljava/util/stream/Stream;", "Lnet/minecraft/world/level/block/state/BlockState;", "kotlin.jvm.PlatformType", "nearbyBlocks", "Ljava/util/stream/Stream;", "getNearbyBlocks", "()Ljava/util/stream/Stream;", "", "Lnet/minecraft/world/level/block/Block;", "nearbyBlockTypes$delegate", "Lkotlin/Lazy;", "getNearbyBlockTypes", "()Ljava/util/List;", "nearbyBlockTypes", "Lnet/minecraft/world/item/ItemStack;", "rodStack", "Lnet/minecraft/world/item/ItemStack;", "getRodStack", "()Lnet/minecraft/world/item/ItemStack;", "Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "rodItem", "Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "getRodItem", "()Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "baitStack", "getBaitStack", "common"})
public final class FishingSpawnablePosition
extends BasicSpawnablePosition {
    private final Stream<BlockState> nearbyBlocks;
    @NotNull
    private final Lazy nearbyBlockTypes$delegate;
    @NotNull
    private final ItemStack rodStack;
    @Nullable
    private final PokerodItem rodItem;
    @NotNull
    private final ItemStack baitStack;

    public FishingSpawnablePosition(@NotNull FishingSpawnCause cause, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull List<SpawningInfluence> influences) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(influences, (String)"influences");
        super(cause, world, pos, world.getMaxLocalRawBrightness(pos), world.getMaxLocalRawBrightness(pos.above()), world.canSeeSkyFromBelowWater(pos), influences);
        this.nearbyBlocks = world.getBlockStates(AABB.ofSize((Vec3)BlockPosExtensionsKt.toVec3d(pos), (double)10.0, (double)10.0, (double)10.0));
        this.nearbyBlockTypes$delegate = LazyKt.lazy(() -> FishingSpawnablePosition.nearbyBlockTypes_delegate$lambda$0(this));
        this.rodStack = cause.getRodStack();
        this.rodItem = cause.getRodItem();
        this.baitStack = PokerodItem.Companion.getBaitStackOnRod(cause.getRodStack());
    }

    public final Stream<BlockState> getNearbyBlocks() {
        return this.nearbyBlocks;
    }

    @NotNull
    public final List<Block> getNearbyBlockTypes() {
        Lazy lazy = this.nearbyBlockTypes$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (List)object;
    }

    @NotNull
    public final ItemStack getRodStack() {
        return this.rodStack;
    }

    @Nullable
    public final PokerodItem getRodItem() {
        return this.rodItem;
    }

    @NotNull
    public final ItemStack getBaitStack() {
        return this.baitStack;
    }

    private static final List nearbyBlockTypes_delegate$lambda$0(FishingSpawnablePosition this$0) {
        return this$0.nearbyBlocks.map(arg_0 -> FishingSpawnablePosition.nearbyBlockTypes_delegate$lambda$0$1(FishingSpawnablePosition::nearbyBlockTypes_delegate$lambda$0$0, arg_0)).distinct().toList();
    }

    private static final Block nearbyBlockTypes_delegate$lambda$0$0(BlockState it) {
        return it.getBlock();
    }

    private static final Block nearbyBlockTypes_delegate$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Block)$tmp0.invoke(p0);
    }
}

