/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.influence;

import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\f\u001a\u00020\u000b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bH\u0016\u00a2\u0006\u0004\b\f\u0010\u0007R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cobblemon/mod/common/api/spawning/influence/BucketMultiplyingInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "", "", "", "multipliers", "<init>", "(Ljava/util/Map;)V", "", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucketWeights", "", "affectBucketWeights", "Ljava/util/Map;", "getMultipliers", "()Ljava/util/Map;", "common"})
public final class BucketMultiplyingInfluence
implements SpawningInfluence {
    @NotNull
    private final Map<String, Float> multipliers;

    public BucketMultiplyingInfluence(@NotNull Map<String, Float> multipliers) {
        Intrinsics.checkNotNullParameter(multipliers, (String)"multipliers");
        this.multipliers = multipliers;
    }

    @NotNull
    public final Map<String, Float> getMultipliers() {
        return this.multipliers;
    }

    @Override
    public void affectBucketWeights(@NotNull Map<SpawnBucket, Float> bucketWeights) {
        SpawnBucket bucket;
        Intrinsics.checkNotNullParameter(bucketWeights, (String)"bucketWeights");
        Map updates = new LinkedHashMap();
        for (Map.Entry<SpawnBucket, Float> entry : bucketWeights.entrySet()) {
            bucket = entry.getKey();
            float weight = ((Number)entry.getValue()).floatValue();
            Float multiplier = this.multipliers.get(bucket.getName());
            if (multiplier == null) continue;
            updates.put(bucket, Float.valueOf(weight * multiplier.floatValue()));
        }
        for (Map.Entry<SpawnBucket, Float> entry : updates.entrySet()) {
            bucket = entry.getKey();
            float newWeight = ((Number)entry.getValue()).floatValue();
            bucketWeights.put(bucket, Float.valueOf(newWeight));
        }
        this.normalizeBucketWeights(bucketWeights);
    }
}

