/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.fishing;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.fishing.BobberSpawnPokemonEvent;
import com.cobblemon.mod.common.api.fishing.SpawnBait;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.SpawnBaitInfluence;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.interactive.PokerodItem;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0001)B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u000f\u001a\u00020\u000e2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0019\u0010 \u001a\u0004\u0018\u00010\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010%\u001a\u00020$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause;", "Lcom/cobblemon/mod/common/api/spawning/SpawnCause;", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/world/item/ItemStack;", "rodStack", "", "lureLevel", "<init>", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;I)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "", "affectSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Lnet/minecraft/world/entity/Entity;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "detail", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "weight", "affectWeight", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;F)F", "Lnet/minecraft/world/item/ItemStack;", "getRodStack", "()Lnet/minecraft/world/item/ItemStack;", "I", "getLureLevel", "()I", "Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "rodItem", "Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "getRodItem", "()Lcom/cobblemon/mod/common/item/interactive/PokerodItem;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawnBaitInfluence;", "baitEffects", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawnBaitInfluence;", "getBaitEffects", "()Lcom/cobblemon/mod/common/api/spawning/influence/SpawnBaitInfluence;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nFishingSpawnCause.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingSpawnCause.kt\ncom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause\n+ 2 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 EventObservables.kt\ncom/cobblemon/mod/common/api/reactive/EventObservable$post$1\n*L\n1#1,167:1\n14#2,5:168\n19#2:176\n13805#3:173\n13806#3:175\n14#4:174\n*S KotlinDebug\n*F\n+ 1 FishingSpawnCause.kt\ncom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause\n*L\n153#1:168,5\n153#1:176\n153#1:173\n153#1:175\n153#1:174\n*E\n"})
public final class FishingSpawnCause
extends SpawnCause {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack rodStack;
    private final int lureLevel;
    @Nullable
    private final PokerodItem rodItem;
    @NotNull
    private final SpawnBaitInfluence baitEffects;
    @NotNull
    public static final String FISHED_ASPECT = "fished";
    @NotNull
    public static final String DROPS_REROLL_ASPECT = "drops_reroll";

    public FishingSpawnCause(@NotNull Spawner spawner, @Nullable Entity entity, @NotNull ItemStack rodStack, int lureLevel) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)rodStack, (String)"rodStack");
        super(spawner, entity);
        this.rodStack = rodStack;
        this.lureLevel = lureLevel;
        Item item = this.rodStack.getItem();
        this.rodItem = item instanceof PokerodItem ? (PokerodItem)item : null;
        this.baitEffects = new SpawnBaitInfluence(SpawnBaitEffects.getEffectsFromRodItemStack(this.rodStack), null, 2, null);
    }

    @NotNull
    public final ItemStack getRodStack() {
        return this.rodStack;
    }

    public final int getLureLevel() {
        return this.lureLevel;
    }

    @Nullable
    public final PokerodItem getRodItem() {
        return this.rodItem;
    }

    @NotNull
    public final SpawnBaitInfluence getBaitEffects() {
        return this.baitEffects;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void affectSpawn(@NotNull SpawnAction<?> action, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.affectSpawn(action, entity);
        if (entity instanceof PokemonEntity) {
            void events$iv;
            void $this$iv;
            Object object = ((PokemonEntity)entity).getPokemon();
            ((Pokemon)object).setForcedAspects(SetsKt.plus(((Pokemon)object).getForcedAspects(), (Object)FISHED_ASPECT));
            this.baitEffects.affectSpawn(action, entity);
            ((PokemonEntity)entity).getEntityData().set(PokemonEntity.Companion.getASPECTS(), ((PokemonEntity)entity).getPokemon().getAspects());
            object = CobblemonEvents.BOBBER_SPAWN_POKEMON_MODIFY;
            BobberSpawnPokemonEvent.Modify[] modifyArray = new BobberSpawnPokemonEvent.Modify[]{new BobberSpawnPokemonEvent.Modify(action, this.rodStack, (PokemonEntity)entity)};
            boolean $i$f$post = false;
            $this$iv.emit(Arrays.copyOf(events$iv, ((void)events$iv).length));
            void $this$forEach$iv$iv = events$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void var11_11 = element$iv$iv = $this$forEach$iv$iv[i];
                boolean bl = false;
                void it = var11_11;
            }
        }
    }

    @Override
    public float affectWeight(@NotNull SpawnDetail detail, @NotNull SpawnablePosition spawnablePosition, float weight) {
        Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
        Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
        float weight2 = this.baitEffects.affectWeight(detail, spawnablePosition, weight);
        return super.affectWeight(detail, spawnablePosition, weight2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001d\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\nJ\u001d\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\nJ\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\nJ\u001d\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\nJ\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "pokemonEntity", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "effect", "", "shinyReroll", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;)V", "saveDropsReroll", "alterNatureAttempt", "alterIVAttempt", "alterGenderAttempt", "alterLevelAttempt", "alterHAAttempt", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "alterFriendshipAttempt", "", "FISHED_ASPECT", "Ljava/lang/String;", "DROPS_REROLL_ASPECT", "common"})
    @SourceDebugExtension(value={"SMAP\nFishingSpawnCause.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingSpawnCause.kt\ncom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n774#3:169\n865#3,2:170\n1761#3,3:172\n1869#3:175\n808#3,11:176\n1870#3:187\n*S KotlinDebug\n*F\n+ 1 FishingSpawnCause.kt\ncom/cobblemon/mod/common/api/spawning/fishing/FishingSpawnCause$Companion\n*L\n76#1:169\n76#1:170,2\n77#1:172,3\n116#1:175\n117#1:176,11\n116#1:187\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void shinyReroll(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            if (pokemonEntity.getPokemon().getShiny()) {
                return;
            }
            int shinyOdds = (int)Cobblemon.INSTANCE.getConfig().getShinyRate();
            if (shinyOdds <= 0) {
                return;
            }
            int randomNumber = Random.Default.nextInt(0, shinyOdds + 1);
            if (randomNumber <= (int)effect.getValue()) {
                pokemonEntity.getPokemon().setShiny(true);
            }
        }

        public final void saveDropsReroll(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Pokemon pokemon = pokemonEntity.getPokemon();
            pokemon.setForcedAspects(SetsKt.plus(pokemon.getForcedAspects(), (Object)FishingSpawnCause.DROPS_REROLL_ASPECT));
        }

        /*
         * WARNING - void declaration
         */
        public final void alterNatureAttempt(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            List possibleNatures;
            block17: {
                block16: {
                    boolean bl;
                    block13: {
                        void $this$filterTo$iv$iv;
                        Object $this$alterNatureAttempt_u24lambda_u241;
                        ResourceLocation resourceLocation;
                        block15: {
                            block14: {
                                Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
                                Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
                                resourceLocation = effect.getSubcategory();
                                if (resourceLocation == null) break block14;
                                ResourceLocation it1 = resourceLocation;
                                boolean bl2 = false;
                                String string = it1.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                ResourceLocation resourceLocation2 = Stats.Companion.getStat(string).getIdentifier();
                                resourceLocation = resourceLocation2;
                                if (resourceLocation2 != null) break block15;
                            }
                            $this$alterNatureAttempt_u24lambda_u241 = this;
                            boolean bl3 = false;
                            Cobblemon.LOGGER.warn("One of your nature baits is missing a subcategory and failed to effect a fished Pokemon");
                            return;
                        }
                        ResourceLocation baitStat = resourceLocation;
                        Iterable $this$filter$iv = Natures.all();
                        boolean $i$f$filter = false;
                        $this$alterNatureAttempt_u24lambda_u241 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Nature it = (Nature)element$iv$iv;
                            boolean bl4 = false;
                            Stat stat = it.getIncreasedStat();
                            if (!Intrinsics.areEqual((Object)(stat != null ? stat.getIdentifier() : null), (Object)baitStat)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        possibleNatures = (List)destination$iv$iv;
                        if (possibleNatures.isEmpty()) break block16;
                        Iterable $this$any$iv = possibleNatures;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Nature it = (Nature)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)pokemonEntity.getPokemon().getNature())) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block17;
                }
                return;
            }
            Nature takenNature = (Nature)CollectionsKt.random((Collection)possibleNatures, (Random)((Random)Random.Default));
            Pokemon pokemon = pokemonEntity.getPokemon();
            String string = takenNature.getName().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Nature nature = Natures.getNature(string);
            if (nature == null) {
                return;
            }
            pokemon.setNature(nature);
        }

        public final void alterIVAttempt(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            ResourceLocation resourceLocation = effect.getSubcategory();
            if (resourceLocation == null) {
                return;
            }
            ResourceLocation iv = resourceLocation;
            IVs iVs = pokemonEntity.getPokemon().getIvs();
            String string = iv.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Integer n = iVs.get(Stats.Companion.getStat(string));
            int n2 = n != null ? n : 0;
            if ((double)n2 + effect.getValue() > 31.0) {
                IVs iVs2 = pokemonEntity.getPokemon().getIvs();
                String string2 = iv.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                iVs2.set(Stats.Companion.getStat(string2), 31);
            } else {
                IVs iVs3 = pokemonEntity.getPokemon().getIvs();
                String string3 = iv.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                Stat stat = Stats.Companion.getStat(string3);
                IVs iVs4 = pokemonEntity.getPokemon().getIvs();
                String string4 = iv.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                Integer n3 = iVs4.get(Stats.Companion.getStat(string4));
                iVs3.set(stat, (n3 != null ? n3 : 0) + (int)effect.getValue());
            }
        }

        public final void alterGenderAttempt(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            if (pokemonEntity.getPokemon().getSpecies().getMaleRatio() > 0.0f && pokemonEntity.getPokemon().getSpecies().getMaleRatio() < 1.0f) {
                ResourceLocation resourceLocation = effect.getSubcategory();
                if (Intrinsics.areEqual((Object)resourceLocation, (Object)MiscUtilsKt.cobblemonResource("male"))) {
                    if (pokemonEntity.getPokemon().getGender() != Gender.MALE) {
                        pokemonEntity.getPokemon().setGender(Gender.MALE);
                    }
                } else if (Intrinsics.areEqual((Object)resourceLocation, (Object)MiscUtilsKt.cobblemonResource("female")) && pokemonEntity.getPokemon().getGender() != Gender.FEMALE) {
                    pokemonEntity.getPokemon().setGender(Gender.FEMALE);
                }
            }
        }

        public final void alterLevelAttempt(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            int level = pokemonEntity.getPokemon().getLevel() + (int)effect.getValue();
            if (level > Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel()) {
                level = Cobblemon.INSTANCE.getConfig().getMaxPokemonLevel();
            }
            pokemonEntity.getPokemon().setLevel(level);
        }

        /*
         * WARNING - void declaration
         */
        public final void alterHAAttempt(@NotNull PokemonEntity pokemonEntity) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Iterable $this$forEach$iv = pokemonEntity.getPokemon().getForm().getAbilities().getMapping().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$filterIsInstanceTo$iv$iv;
                List abilities = (List)element$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = abilities;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof HiddenAbility)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                HiddenAbility hiddenAbility = (HiddenAbility)CollectionsKt.randomOrNull((Collection)((List)destination$iv$iv), (Random)((Random)Random.Default));
                if (hiddenAbility == null) continue;
                HiddenAbility ability = hiddenAbility;
                boolean bl2 = false;
                pokemonEntity.getPokemon().setAbility$common(ability.getTemplate().create(false, ability.getPriority()));
                return;
            }
        }

        public final void alterFriendshipAttempt(@NotNull PokemonEntity pokemonEntity, @NotNull SpawnBait.Effect effect) {
            Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            boolean bl = (double)pokemonEntity.getPokemon().getFriendship() + effect.getValue() > (double)Cobblemon.INSTANCE.getConfig().getMaxPokemonFriendship() ? Pokemon.setFriendship$default(pokemonEntity.getPokemon(), Cobblemon.INSTANCE.getConfig().getMaxPokemonFriendship(), false, 2, null) : Pokemon.setFriendship$default(pokemonEntity.getPokemon(), pokemonEntity.getPokemon().getFriendship() + (int)effect.getValue(), false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

