/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawningZone;
import com.cobblemon.mod.common.api.spawning.SpawningZoneGenerator;
import com.cobblemon.mod.common.api.spawning.influence.detector.SpawningInfluenceDetector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/cobblemon/mod/common/api/spawning/CobblemonSpawningZoneGenerator;", "Lcom/cobblemon/mod/common/api/spawning/SpawningZoneGenerator;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;", "input", "Lcom/cobblemon/mod/common/api/spawning/SpawningZone;", "generate", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/spawner/SpawningZoneInput;)Lcom/cobblemon/mod/common/api/spawning/SpawningZone;", "common"})
@SourceDebugExtension(value={"SMAP\nCobblemonSpawningZoneGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonSpawningZoneGenerator.kt\ncom/cobblemon/mod/common/api/spawning/CobblemonSpawningZoneGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n808#2,11:131\n1563#2:142\n1634#2,3:143\n1374#2:146\n1460#2,5:147\n*S KotlinDebug\n*F\n+ 1 CobblemonSpawningZoneGenerator.kt\ncom/cobblemon/mod/common/api/spawning/CobblemonSpawningZoneGenerator\n*L\n74#1:131,11\n75#1:142\n75#1:143,3\n103#1:146\n103#1:147,5\n*E\n"})
public final class CobblemonSpawningZoneGenerator
implements SpawningZoneGenerator {
    @NotNull
    public static final CobblemonSpawningZoneGenerator INSTANCE = new CobblemonSpawningZoneGenerator();

    private CobblemonSpawningZoneGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpawningZone generate(@NotNull Spawner spawner, @NotNull SpawningZoneInput input) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        int difference;
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ServerLevel world = input.getWorld();
        int baseY = input.getBaseY();
        int height = input.getHeight();
        if (baseY < world.getMinBuildHeight()) {
            difference = world.getMinBuildHeight() - baseY;
            baseY += difference;
            if ((height -= difference) < 1) {
                throw new IllegalStateException("World slice was attempted with totally awful base and dimensions");
            }
        }
        if (baseY + height >= world.getMaxBuildHeight() && (height -= (difference = baseY + height - 1 - world.getMaxBuildHeight())) < 1) {
            throw new IllegalStateException("World slice was attempted with totally awful base and dimensions");
        }
        double minimumDistanceBetweenEntities = Cobblemon.INSTANCE.getConfig().getMinimumDistanceBetweenEntities();
        List list = input.getWorld().getEntities(input.getCause().getEntity(), AABB.ofSize((Vec3)new Vec3((double)input.getBaseX() + (double)input.getLength() / 2.0, (double)baseY + (double)height / 2.0, (double)input.getBaseZ() + (double)input.getWidth() / 2.0), (double)((double)input.getLength() + minimumDistanceBetweenEntities), (double)((double)height + minimumDistanceBetweenEntities), (double)((double)input.getWidth() + minimumDistanceBetweenEntities)));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
        Iterable iterable = list;
        boolean $i$f$filterIsInstance = false;
        void var11_11 = $this$filterIsInstance$iv;
        SpawningZone.BlockData[][][] destination$iv$iv = (SpawningZone.BlockData[][][])new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LivingEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LivingEntity livingEntity = (LivingEntity)item$iv$iv;
            object = destination$iv$iv;
            n4 = 0;
            object.add(it.position());
        }
        List nearbyEntityPositions = (List)destination$iv$iv;
        BlockState defaultState = Blocks.STONE.defaultBlockState();
        Intrinsics.checkNotNull((Object)defaultState);
        SpawningZone.BlockData defaultBlockData = new SpawningZone.BlockData(defaultState, 0, 0);
        $i$f$mapTo = input.getLength();
        SpawningZone.BlockData[][][] blockDataArray = new SpawningZone.BlockData[$i$f$mapTo][][];
        for (int destination$iv$iv2 = 0; destination$iv$iv2 < $i$f$mapTo; ++destination$iv$iv2) {
            int item$iv$iv = destination$iv$iv2;
            n4 = height;
            SpawningZone.BlockData[][] blockDataArrayArray = new SpawningZone.BlockData[n4][];
            n3 = item$iv$iv;
            object = blockDataArray;
            for (int it = 0; it < n4; ++it) {
                int n5 = it;
                n2 = 0;
                n = input.getWidth();
                SpawningZone.BlockData[] blockDataArray2 = new SpawningZone.BlockData[n];
                int n6 = n5;
                SpawningZone.BlockData[][] blockDataArrayArray2 = blockDataArrayArray;
                while (n2 < n) {
                    int n7 = n2++;
                    blockDataArray2[n7] = defaultBlockData;
                }
                blockDataArrayArray2[n6] = blockDataArray2;
            }
            object[n3] = blockDataArrayArray;
        }
        SpawningZone.BlockData[][][] blocks = blockDataArray;
        int n8 = input.getLength();
        Integer[][] item$iv$iv = new Integer[n8][];
        for ($i$f$mapTo = 0; $i$f$mapTo < n8; ++$i$f$mapTo) {
            int it = $i$f$mapTo;
            n4 = 0;
            int n9 = input.getWidth();
            Integer[] integerArray = new Integer[n9];
            n3 = it;
            object = item$iv$iv;
            while (n4 < n9) {
                n2 = n4++;
                integerArray[n2] = world.getMaxBuildHeight();
            }
            object[n3] = integerArray;
        }
        Integer[][] skyLevel = item$iv$iv;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        List spawningZoneInfluences = new ArrayList();
        Map chunks = new LinkedHashMap();
        IntProgression yRange = RangesKt.reversed((IntProgression)((IntProgression)RangesKt.until((int)baseY, (int)(baseY + height))));
        LevelLightEngine lightingProvider = world.getLightEngine();
        int n10 = input.getBaseX() + input.getLength();
        for (int x = input.getBaseX(); x < n10; ++x) {
            n = input.getBaseZ() + input.getWidth();
            block8: for (int z = input.getBaseZ(); z < n; ++z) {
                if (chunks.computeIfAbsent(new Pair((Object)SectionPos.blockToSectionCoord((int)x), (Object)SectionPos.blockToSectionCoord((int)z)), arg_0 -> CobblemonSpawningZoneGenerator.generate$lambda$2(arg_0 -> CobblemonSpawningZoneGenerator.generate$lambda$1(world, arg_0), arg_0)) == null) continue;
                boolean canSeeSky = world.canSeeSkyFromBelowWater((BlockPos)pos.set(x, yRange.getFirst(), z));
                int y = yRange.getFirst();
                int n11 = yRange.getLast();
                int n12 = yRange.getStep();
                if ((n12 <= 0 || y > n11) && (n12 >= 0 || n11 > y)) continue;
                while (true) {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    ChunkAccess query;
                    int skyLight = lightingProvider.getLayerListener(LightLayer.SKY).getLightValue((BlockPos)pos.set(x, y, z));
                    BlockState state = query.getBlockState((BlockPos)pos.set(x, y, z));
                    SpawningZone.BlockData[] blockDataArray3 = blocks[x - input.getBaseX()][y - baseY];
                    int n13 = z - input.getBaseZ();
                    Intrinsics.checkNotNull((Object)state);
                    blockDataArray3[n13] = new SpawningZone.BlockData(state, world.getMaxLocalRawBrightness((BlockPos)pos), skyLight);
                    Iterable iterable2 = SpawningInfluenceDetector.Companion.getDetectors();
                    object = spawningZoneInfluences;
                    boolean $i$f$flatMap = false;
                    void var31_53 = $this$flatMap$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        SpawningInfluenceDetector it = (SpawningInfluenceDetector)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = it.detectFromBlock(world, (BlockPos)pos, state);
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    object.addAll((List)destination$iv$iv3);
                    if (canSeeSky) {
                        skyLevel[x - input.getBaseX()][z - input.getBaseZ()] = y;
                    }
                    if (state.getFluidState().isEmpty() && !state.is(CobblemonBlockTags.SEES_SKY)) {
                        canSeeSky = false;
                    }
                    if (y == n11) continue block8;
                    y += n12;
                }
            }
        }
        for (SpawningInfluenceDetector spawningZoneGenerator : SpawningInfluenceDetector.Companion.getDetectors()) {
            spawningZoneInfluences.addAll((Collection)spawningZoneGenerator.detectFromInput(spawner, input));
        }
        return new SpawningZone(input.getCause(), world, input.getBaseX(), baseY, input.getBaseZ(), blocks, skyLevel, nearbyEntityPositions, spawningZoneInfluences);
    }

    private static final ChunkAccess generate$lambda$1(ServerLevel $world, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $world.getChunk(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue(), ChunkStatus.FULL, false);
    }

    private static final ChunkAccess generate$lambda$2(Function1 $tmp0, Object p0) {
        return (ChunkAccess)$tmp0.invoke(p0);
    }
}

