/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.spawning.condition.BiomePrecalculation;
import com.cobblemon.mod.common.api.spawning.condition.BucketPrecalculation;
import com.cobblemon.mod.common.api.spawning.condition.SpawnablePositionTypePrecalculation;
import com.cobblemon.mod.common.api.spawning.condition.SpawningPrecalculation;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.data.CobblemonDataProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/api/spawning/CobblemonSpawnPools;", "", "<init>", "()V", "", "load", "Lnet/minecraft/server/MinecraftServer;", "server", "onServerLoad", "(Lnet/minecraft/server/MinecraftServer;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "WORLD_SPAWN_POOL", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "getWORLD_SPAWN_POOL", "()Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;", "setWORLD_SPAWN_POOL", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnPool;)V", "common"})
public final class CobblemonSpawnPools {
    @NotNull
    public static final CobblemonSpawnPools INSTANCE = new CobblemonSpawnPools();
    public static SpawnPool WORLD_SPAWN_POOL;

    private CobblemonSpawnPools() {
    }

    @NotNull
    public final SpawnPool getWORLD_SPAWN_POOL() {
        SpawnPool spawnPool = WORLD_SPAWN_POOL;
        if (spawnPool != null) {
            return spawnPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"WORLD_SPAWN_POOL");
        return null;
    }

    public final void setWORLD_SPAWN_POOL(@NotNull SpawnPool spawnPool) {
        Intrinsics.checkNotNullParameter((Object)spawnPool, (String)"<set-?>");
        WORLD_SPAWN_POOL = spawnPool;
    }

    public final void load() {
        SpawningPrecalculation[] spawningPrecalculationArray = new SpawningPrecalculation[]{SpawnablePositionTypePrecalculation.INSTANCE, BucketPrecalculation.INSTANCE, BiomePrecalculation.INSTANCE};
        this.setWORLD_SPAWN_POOL((SpawnPool)CobblemonDataProvider.INSTANCE.register((DataRegistry)new SpawnPool("world").addPrecalculators(spawningPrecalculationArray), true));
    }

    public final void onServerLoad(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Cobblemon.LOGGER.info("Optimizing spawn pools...");
        this.getWORLD_SPAWN_POOL().onServerLoad(server);
    }
}

