/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.snowstorm;

import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.api.snowstorm.ParticleEmitterShape;
import com.cobblemon.mod.common.api.snowstorm.ParticleEmitterShapeType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJG\u0010\u0013\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00018\u00008\u0000 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u00120\u0012\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00150\u00152\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0005R\u001a\u0010#\u001a\u00020\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcom/cobblemon/mod/common/api/snowstorm/EntityBoundingBoxParticleEmitterShape;", "Lcom/cobblemon/mod/common/api/snowstorm/ParticleEmitterShape;", "", "surfaceOnly", "<init>", "(Z)V", "Lcom/bedrockk/molang/runtime/MoLangRuntime;", "runtime", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/world/phys/Vec3;", "getNewParticlePosition", "(Lcom/bedrockk/molang/runtime/MoLangRuntime;Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "getCenter", "T", "Lcom/mojang/serialization/DynamicOps;", "ops", "Lcom/mojang/serialization/DataResult;", "encode", "(Lcom/mojang/serialization/DynamicOps;)Lcom/mojang/serialization/DataResult;", "Lnet/minecraft/world/phys/AABB;", "getBox", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/AABB;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buffer", "", "readFromBuffer", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "writeToBuffer", "Z", "getSurfaceOnly", "()Z", "setSurfaceOnly", "Lcom/cobblemon/mod/common/api/snowstorm/ParticleEmitterShapeType;", "type", "Lcom/cobblemon/mod/common/api/snowstorm/ParticleEmitterShapeType;", "getType", "()Lcom/cobblemon/mod/common/api/snowstorm/ParticleEmitterShapeType;", "Companion", "common"})
public final class EntityBoundingBoxParticleEmitterShape
implements ParticleEmitterShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean surfaceOnly;
    @NotNull
    private final ParticleEmitterShapeType type;
    @NotNull
    private static final Codec<EntityBoundingBoxParticleEmitterShape> CODEC;

    public EntityBoundingBoxParticleEmitterShape(boolean surfaceOnly) {
        this.surfaceOnly = surfaceOnly;
        this.type = ParticleEmitterShapeType.ENTITY_BOUNDING_BOX;
    }

    public /* synthetic */ EntityBoundingBoxParticleEmitterShape(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getSurfaceOnly() {
        return this.surfaceOnly;
    }

    public final void setSurfaceOnly(boolean bl) {
        this.surfaceOnly = bl;
    }

    @Override
    @NotNull
    public ParticleEmitterShapeType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Vec3 getNewParticlePosition(@NotNull MoLangRuntime runtime, @Nullable Entity entity) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        AABB box = this.getBox(entity);
        Vec3 center = this.getCenter(runtime, entity);
        Vec3 sizes = new Vec3(box.maxX - box.minX, box.maxY - box.minY, box.maxZ - box.minZ);
        if (this.surfaceOnly) {
            switch (Random.Default.nextInt(6)) {
                case 0: {
                    vec3 = new Vec3(-0.5 * sizes.x, Random.Default.nextDouble(sizes.y) - sizes.y / 2.0, Random.Default.nextDouble(sizes.z) - sizes.z / 2.0);
                    break;
                }
                case 1: {
                    vec3 = new Vec3(0.5 * sizes.x, Random.Default.nextDouble(sizes.y) - sizes.y / 2.0, Random.Default.nextDouble(sizes.z) - sizes.z / 2.0);
                    break;
                }
                case 2: {
                    vec3 = new Vec3(Random.Default.nextDouble(sizes.x) - sizes.x / 2.0, -0.5 * sizes.y, Random.Default.nextDouble(sizes.z) - sizes.z / 2.0);
                    break;
                }
                case 3: {
                    vec3 = new Vec3(Random.Default.nextDouble(sizes.x) - sizes.x / 2.0, 0.5 * sizes.y, Random.Default.nextDouble(sizes.z) - sizes.z / 2.0);
                    break;
                }
                case 4: {
                    vec3 = new Vec3(Random.Default.nextDouble(sizes.x) - sizes.x / 2.0, Random.Default.nextDouble(sizes.y) - sizes.y / 2.0, -0.5 * sizes.z);
                    break;
                }
                default: {
                    vec3 = new Vec3(Random.Default.nextDouble(sizes.x) - sizes.x / 2.0, Random.Default.nextDouble(sizes.y) - sizes.y / 2.0, 0.5 * sizes.z);
                    break;
                }
            }
        } else {
            vec3 = new Vec3(Random.Default.nextDouble(sizes.x) - sizes.x / (double)2, Random.Default.nextDouble(sizes.y) - sizes.y / (double)2, Random.Default.nextDouble(sizes.z) - sizes.z / (double)2);
        }
        Vec3 disposition = vec3;
        Vec3 vec32 = center.add(disposition);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        return vec32;
    }

    @Override
    public Vec3 getCenter(@NotNull MoLangRuntime runtime, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        return this.getBox(entity).getCenter();
    }

    @Override
    public <T> DataResult<T> encode(@NotNull DynamicOps<T> ops) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        return CODEC.encodeStart(ops, (Object)this);
    }

    public final AABB getBox(@Nullable Entity entity) {
        Entity entity2 = entity;
        if (entity2 == null || (entity2 = entity2.getBoundingBox()) == null) {
            entity2 = AABB.ofSize((Vec3)new Vec3(0.0, 0.0, 0.0), (double)1.0, (double)2.0, (double)1.0);
        }
        return entity2;
    }

    @Override
    public void readFromBuffer(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.surfaceOnly = buffer.readBoolean();
    }

    @Override
    public void writeToBuffer(@NotNull RegistryFriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.writeBoolean(this.surfaceOnly);
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)PrimitiveCodec.STRING.fieldOf("type").forGetter(EntityBoundingBoxParticleEmitterShape::CODEC$lambda$0$0), (App)PrimitiveCodec.BOOL.fieldOf("surfaceOnly").forGetter(EntityBoundingBoxParticleEmitterShape::CODEC$lambda$0$1)).apply((Applicative)instance, EntityBoundingBoxParticleEmitterShape::CODEC$lambda$0$2);
    }

    private static final String CODEC$lambda$0$0(EntityBoundingBoxParticleEmitterShape it) {
        return it.getType().name();
    }

    private static final Boolean CODEC$lambda$0$1(EntityBoundingBoxParticleEmitterShape it) {
        return it.surfaceOnly;
    }

    private static final EntityBoundingBoxParticleEmitterShape CODEC$lambda$0$2(String string, Boolean surfaceOnly) {
        Intrinsics.checkNotNull((Object)surfaceOnly);
        return new EntityBoundingBoxParticleEmitterShape(surfaceOnly);
    }

    public EntityBoundingBoxParticleEmitterShape() {
        this(false, 1, null);
    }

    static {
        Codec codec = RecordCodecBuilder.create(EntityBoundingBoxParticleEmitterShape::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/api/snowstorm/EntityBoundingBoxParticleEmitterShape$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/api/snowstorm/EntityBoundingBoxParticleEmitterShape;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<EntityBoundingBoxParticleEmitterShape> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

