/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.util;

import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0018\u0010\u0015\"\u0004\b\u0019\u0010\u0017R\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u000f8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "", "Lnet/minecraft/world/phys/Vec3;", "value", "velocity", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)V", "target", "", "stiffness", "damping", "", "update", "(Lnet/minecraft/world/phys/Vec3;DD)V", "partialTick", "", "lookBackTick", "getInterpolated", "(DI)Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/world/phys/Vec3;", "getValue", "()Lnet/minecraft/world/phys/Vec3;", "setValue", "(Lnet/minecraft/world/phys/Vec3;)V", "getVelocity", "setVelocity", "Lkotlin/collections/ArrayDeque;", "history", "Lkotlin/collections/ArrayDeque;", "getHistory", "()Lkotlin/collections/ArrayDeque;", "lookBackSize", "I", "getLookBackSize", "()I", "common"})
public final class Vec3Spring {
    @NotNull
    private Vec3 value;
    @NotNull
    private Vec3 velocity;
    @NotNull
    private final ArrayDeque<Vec3> history;
    private final int lookBackSize;

    public Vec3Spring(@NotNull Vec3 value, @NotNull Vec3 velocity) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        this.value = value;
        this.velocity = velocity;
        this.history = new ArrayDeque();
        this.lookBackSize = 20;
    }

    public /* synthetic */ Vec3Spring(Vec3 vec3, Vec3 vec32, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Vec3 vec33 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
            vec3 = vec33;
        }
        if ((n & 2) != 0) {
            Vec3 vec34 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"ZERO");
            vec32 = vec34;
        }
        this(vec3, vec32);
    }

    @NotNull
    public final Vec3 getValue() {
        return this.value;
    }

    public final void setValue(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.value = vec3;
    }

    @NotNull
    public final Vec3 getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.velocity = vec3;
    }

    @NotNull
    public final ArrayDeque<Vec3> getHistory() {
        return this.history;
    }

    public final int getLookBackSize() {
        return this.lookBackSize;
    }

    public final void update(@NotNull Vec3 target, double stiffness, double damping) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Vec3 force = target.subtract(this.value).scale(stiffness);
        Vec3 accel = force.subtract(this.velocity.scale(damping));
        Vec3 vec3 = this.velocity.add(accel.scale(0.05));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        this.velocity = vec3;
        Vec3 vec32 = this.value.add(this.velocity.scale(0.05));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        this.value = vec32;
        this.history.addFirst((Object)this.value);
        if (this.history.size() > this.lookBackSize + 1) {
            this.history.removeLast();
        }
    }

    @NotNull
    public final Vec3 getInterpolated(double partialTick, int lookBackTick) {
        if (this.history.size() < 2) {
            return this.value;
        }
        int tick = Math.min(lookBackTick, this.history.size() - 2);
        Vec3 ret = Vec3.ZERO;
        int i = 0;
        if (i <= tick) {
            while (true) {
                Vec3 older = ((Vec3)this.history.get(i + 1)).scale(1.0);
                Vec3 newer = ((Vec3)this.history.get(i)).scale(1.0);
                ret = ret.add(older.add(newer.subtract(older).scale(partialTick)));
                if (i == tick) break;
                ++i;
            }
        }
        Vec3 vec3 = ret.scale(1.0 / (double)(tick + 1));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        return vec3;
    }

    public Vec3Spring() {
        this(null, null, 3, null);
    }
}

