/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.liquid;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangMath;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.BirdBehaviourKt;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.DolphinSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.DolphinState;
import com.cobblemon.mod.common.api.riding.posing.PoseOption;
import com.cobblemon.mod.common.api.riding.posing.PoseProvider;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 _2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001_B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J7\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010#\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J7\u0010%\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b%\u0010&J7\u0010)\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b)\u0010*J?\u0010-\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b-\u0010.J_\u00105\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020'2\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u0002012\u0006\u00104\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b5\u00106J/\u00107\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b7\u00108J/\u00109\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b9\u0010\u0017J7\u0010<\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010;\u001a\u00020:H\u0016\u00a2\u0006\u0004\b<\u0010=J/\u0010?\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020'H\u0016\u00a2\u0006\u0004\b?\u0010@J/\u0010A\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\bA\u0010\u0017J'\u0010B\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bB\u0010\u000fJ'\u0010C\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bC\u0010DJ'\u0010E\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bE\u0010\u000fJ'\u0010F\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bF\u0010\u000fJ'\u0010G\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bG\u0010\u000fJ'\u0010H\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bH\u0010\u000fJ'\u0010I\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bI\u0010\u000fJ'\u0010K\u001a\u00020J2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bK\u0010LJ\u0017\u0010M\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bM\u0010NJ9\u0010P\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010O2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bP\u0010QR\u001a\u0010S\u001a\u00020R8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bS\u0010T\u001a\u0004\bU\u0010VR\u0011\u0010Y\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR#\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030Z8\u0006\u00a2\u0006\f\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^\u00a8\u0006`"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;", "<init>", "()V", "settings", "state", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "isActive", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lcom/cobblemon/mod/common/entity/PoseType;", "pose", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/entity/PoseType;", "Lnet/minecraft/world/entity/player/Player;", "driver", "", "speed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)F", "Lnet/minecraft/world/phys/Vec3;", "input", "", "tick", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "handleBoosting", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "tickStamina", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/phys/Vec2;", "rotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "velocity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "", "deltaTime", "angRollVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Lnet/minecraft/world/phys/Vec3;", "Lcom/cobblemon/mod/common/api/orientation/OrientationController;", "controller", "correctOrientation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/orientation/OrientationController;Lnet/minecraft/world/entity/player/Player;D)V", "mouseY", "mouseX", "Lnet/minecraft/util/SmoothDouble;", "mouseYSmoother", "mouseXSmoother", "sensitivity", "rotationOnMouseXY", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;DDLnet/minecraft/util/SmoothDouble;Lnet/minecraft/util/SmoothDouble;DD)Lnet/minecraft/world/phys/Vec3;", "canJump", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "setRideBar", "", "jumpStrength", "jumpForce", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/phys/Vec3;", "regularGravity", "gravity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;D)D", "rideFovMultiplier", "useAngVelSmoothing", "inertia", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)D", "shouldRoll", "turnOffOnGround", "dismountOnShift", "shouldRotatePokemonHead", "shouldRotateRiderHead", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "getRideSounds", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "createDefaultState", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "asMoLangValue", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "getGlobalDolphin", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinSettings;", "globalDolphin", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "poseProvider", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "getPoseProvider", "()Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "Companion", "common"})
public final class DolphinBehaviour
implements RidingBehaviour<DolphinSettings, DolphinState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation key = KEY;
    @NotNull
    private final PoseProvider<DolphinSettings, DolphinState> poseProvider = new PoseProvider(PoseType.FLOAT).with(new PoseOption(PoseType.SWIM, DolphinBehaviour::poseProvider$lambda$0));
    @NotNull
    private static final ResourceLocation KEY = MiscUtilsKt.cobblemonResource("liquid/dolphin");

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @NotNull
    public final DolphinSettings getGlobalDolphin() {
        return CobblemonRideSettings.INSTANCE.getDolphin();
    }

    @Override
    @NotNull
    public RidingStyle getRidingStyle(@NotNull DolphinSettings settings, @NotNull DolphinState state) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RidingStyle.LIQUID;
    }

    @NotNull
    public final PoseProvider<DolphinSettings, DolphinState> getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public boolean isActive(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        if (vehicle.isInWater() || vehicle.isUnderWater()) {
            return true;
        }
        BlockPos blockPosBelow = vehicle.blockPosition().below();
        BlockState blockState = vehicle.level().getBlockState(blockPosBelow);
        boolean isOnSolidGround = !blockState.isAir() && blockState.getFluidState().isEmpty();
        return !isOnSolidGround;
    }

    @Override
    @NotNull
    public PoseType pose(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return this.poseProvider.select((DolphinSettings)((RidingBehaviourSettings)settings), (DolphinState)((RidingBehaviourState)state), vehicle);
    }

    @Override
    public float speed(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return (float)((Number)state.getSpeed().get()).doubleValue();
    }

    @Override
    public void tick(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (vehicle.level().isClientSide) {
            this.handleBoosting(state, vehicle);
            this.tickStamina(settings, state, vehicle);
        }
    }

    public final void handleBoosting(@NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        if (Minecraft.getInstance().options.keyUp.isDown() && !(((Number)state.getStamina().get()).floatValue() == 0.0f) && (vehicle.isInWater() || vehicle.isUnderWater())) {
            boolean boostKeyPressed = Minecraft.getInstance().options.keySprint.isDown();
            if (((Number)state.getStamina().get()).floatValue() >= 0.25f) {
                if (state.getBoostIsToggleable().get().booleanValue() && boostKeyPressed) {
                    SidedRidingState.set$default(state.getBoosting(), state.getBoosting().get() == false, false, 2, null);
                }
                SidedRidingState.set$default(state.getBoostIsToggleable(), !boostKeyPressed, false, 2, null);
            }
        } else {
            SidedRidingState.set$default(state.getBoostIsToggleable(), true, false, 2, null);
            SidedRidingState.set$default(state.getBoosting(), false, false, 2, null);
        }
    }

    public final void tickStamina(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        float stam = ((Number)state.getStamina().get()).floatValue();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getInfiniteStamina();
        if (expression == null) {
            Expression expression2 = this.getGlobalDolphin().getInfiniteStamina();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        if (MoLangExtensionsKt.resolveBoolean$default(moLangRuntime, expression, null, 2, null)) {
            return;
        }
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getStaminaExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalDolphin().getStaminaExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double boostTime = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * (double)20.0f;
        float stamDrainRate = (float)((double)1.0f / boostTime);
        float newStam = state.getBoosting().get() != false ? Math.max(0.0f, stam - stamDrainRate) : Math.min(1.0f, stam + stamDrainRate);
        SidedRidingState.set$default(state.getStamina(), Float.valueOf(newStam), false, 2, null);
    }

    @Override
    @NotNull
    public Vec2 rotation(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return new Vec2(driver.getXRot() * 0.5f, driver.getYRot());
    }

    @Override
    @NotNull
    public Vec3 velocity(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        double d;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(vehicle instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        OrientationController controller = ((OrientationControllable)((Object)vehicle)).getOrientationController();
        Matrix3f matrix3f = controller.getOrientation();
        if (matrix3f == null) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        Matrix3f orientation = matrix3f;
        MoLangRuntime runtime = vehicle.getRuntime();
        if (state.getBoosting().get().booleanValue()) {
            Expression expression = settings.getJumpExpr();
            if (expression == null) {
                Expression expression2 = this.getGlobalDolphin().getJumpExpr();
                expression = expression2;
                Intrinsics.checkNotNull((Object)expression2);
            }
            d = MoLangExtensionsKt.resolveDouble$default(runtime, expression, null, 2, null);
        } else {
            d = 1.0;
        }
        double boostMod = d;
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression3 = this.getGlobalDolphin().getSpeedExpr();
            expression = expression3;
            Intrinsics.checkNotNull((Object)expression3);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) / 20.0 * boostMod;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression4 = settings.getAccelerationExpr();
        if (expression4 == null) {
            Expression expression5 = this.getGlobalDolphin().getAccelerationExpr();
            expression4 = expression5;
            Intrinsics.checkNotNull((Object)expression5);
        }
        double accel = topSpeed / (MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression4, null, 2, null) * 20.0) * boostMod;
        Expression expression6 = settings.getStrafeFactor();
        if (expression6 == null) {
            Expression expression7 = this.getGlobalDolphin().getStrafeFactor();
            expression6 = expression7;
            Intrinsics.checkNotNull((Object)expression7);
        }
        double strafeFactor = MoLangExtensionsKt.resolveDouble$default(runtime, expression6, null, 2, null);
        Expression expression8 = settings.getReverseDriveFactor();
        if (expression8 == null) {
            Expression expression9 = this.getGlobalDolphin().getReverseDriveFactor();
            expression8 = expression9;
            Intrinsics.checkNotNull((Object)expression9);
        }
        double reverseDriveFactor = MoLangExtensionsKt.resolveDouble$default(runtime, expression8, null, 2, null);
        Vec3 currVel = state.getRideVelocity().get();
        if (!((Entity)vehicle).isInWater() && !((Entity)vehicle).isUnderWater()) {
            Vec3 prevVel = state.getLastVelocity().get();
            double breachBoost = 0.3;
            SidedRidingState.set$default(state.getClearMouseSmoothers(), false, false, 2, null);
            if (!state.getHasBreached().get().booleanValue()) {
                if (state.getBoosting().get().booleanValue()) {
                    prevVel = new Vec3(prevVel.x, prevVel.y + breachBoost * Math.pow((double)RangesKt.coerceIn((float)((float)Math.sin(-AngleExtensionsKt.toRadians(Float.valueOf(controller.getPitch())))), (float)0.0f, (float)0.5f) * 2.0, 2), prevVel.z);
                }
                SidedRidingState.set$default(state.getHasBreached(), true, false, 2, null);
            } else {
                double gravity = 0.03920000000000001;
                double terminalVel = 2.0;
                prevVel = new Vec3(prevVel.x, Math.max(-terminalVel, prevVel.y - gravity), prevVel.z);
            }
            SidedRidingState.set$default(state.getLastVelocity(), prevVel, false, 2, null);
            Vec3 vec3 = state.getLastVelocity().get().yRot(AngleExtensionsKt.toRadians(Float.valueOf(((Entity)vehicle).getYRot())));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"yRot(...)");
            return vec3;
        }
        if (state.getHasBreached().get().booleanValue()) {
            SidedRidingState.set$default(state.getClearMouseSmoothers(), true, false, 2, null);
        }
        SidedRidingState.set$default(state.getHasBreached(), false, false, 2, null);
        currVel = new Vec3(currVel.x, 0.0, currVel.z);
        if (vehicle.horizontalCollision || vehicle.verticalCollision) {
            double frictionLimit = 0.1;
            double postColSpeed = Math.min(Math.max(state.getRideVelocity().get().length(), frictionLimit), ((Number)state.getSpeed().get()).doubleValue());
            SidedRidingState.set$default(state.getSpeed(), postColSpeed, false, 2, null);
        }
        double currZVel = state.getRideVelocity().get().z;
        double newZVel = (double)driver.zza > 0.0 ? Math.min(topSpeed, currZVel + accel) : ((double)driver.zza < 0.0 ? Math.max(-topSpeed * reverseDriveFactor, currZVel - accel) : MoLangMath.lerp(currZVel, 0.0, 0.05));
        SidedRidingState.set$default(state.getRideVelocity(), new Vec3(currVel.x, currVel.y, newZVel), false, 2, null);
        Vector3f localVelVec = new Vector3f((float)state.getRideVelocity().get().x, (float)state.getRideVelocity().get().y, (float)state.getRideVelocity().get().z * -1.0f);
        Vector3f vector3f = localVelVec.mul((Matrix3fc)orientation);
        Intrinsics.checkNotNullExpressionValue((Object)vector3f, (String)"mul(...)");
        Vec3 worldVelVec = Vec3ExtensionsKt.toVec3d(vector3f);
        SidedRidingState.set$default(state.getLastVelocity(), worldVelVec, false, 2, null);
        Vec3 vec3 = worldVelVec.yRot(AngleExtensionsKt.toRadians(Float.valueOf(((Entity)vehicle).getYRot())));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"yRot(...)");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 angRollVel(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (!(vehicle instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        OrientationController controller = ((OrientationControllable)((Object)vehicle)).getOrientationController();
        double currSpeed = ((Entity)vehicle).getDeltaMovement().length();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getHandlingExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalDolphin().getHandlingExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double handling = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getSpeedExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalDolphin().getSpeedExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) / 20.0;
        double yawDeltaDeg = deltaTime * handling * Math.pow(Math.sin(Math.toRadians(controller.getRoll())), 2) * Math.signum(Math.sin(Math.toRadians(controller.getRoll())));
        double trueYawDelt = yawDeltaDeg * RangesKt.coerceIn((double)Math.abs(Math.cos(Math.toRadians(controller.getPitch())) * (double)2), (double)-1.0, (double)1.0) * Math.sqrt(RidingBehaviour.Companion.scaleToRange$common(currSpeed, 0.0, topSpeed));
        float yawDampen = 1.0f - Math.abs(Math.min((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll()))), 0.0f));
        controller.applyGlobalYaw((float)trueYawDelt * yawDampen);
        Intrinsics.checkNotNull((Object)controller);
        this.correctOrientation(settings, state, vehicle, controller, driver, deltaTime);
        return new Vec3(0.0, ((Number)state.getCurrPitchCorrectionForce().get()).doubleValue(), ((Number)state.getCurrRollCorrectionForce().get()).doubleValue());
    }

    private final void correctOrientation(DolphinSettings settings, DolphinState state, PokemonEntity vehicle, OrientationController controller, Player driver, double deltaTime) {
        if (state.getHasBreached().get().booleanValue()) {
            SidedRidingState.set$default(state.getCurrRollCorrectionForce(), MoLangMath.lerp(((Number)state.getCurrRollCorrectionForce().get()).doubleValue(), 0.0, deltaTime * 0.98), false, 2, null);
            SidedRidingState.set$default(state.getCurrPitchCorrectionForce(), MoLangMath.lerp(((Number)state.getCurrPitchCorrectionForce().get()).doubleValue(), 0.0, deltaTime * 0.98), false, 2, null);
            return;
        }
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getTimeToRollCorrect();
        if (expression == null) {
            Expression expression2 = this.getGlobalDolphin().getTimeToRollCorrect();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double rollCorrectionTimer = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        float howRolledAmI = (float)Math.sqrt(Math.abs(((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll()))) - 1.0f) * 0.5f));
        float maxRollCorrectionRate = state.getRideVelocity().get().length() < 0.2 ? 10.0f * Math.abs((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getPitch())))) : 10.0f * (float)Math.pow((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getPitch()))), 2) * (howRolledAmI * 1.0f + (float)Math.pow(RangesKt.coerceIn((double)(((Number)state.getNoInputTime().get()).doubleValue() - rollCorrectionTimer), (double)0.0, (double)1.0), 2) * 0.5f);
        float maxRollForce = maxRollCorrectionRate / 40.0f;
        float rollArrivalDeg = 60.0f;
        float desiredRoll = 0.0f;
        float rollError = Mth.wrapDegrees((float)BirdBehaviourKt.angleDifference(desiredRoll, controller.getRoll()));
        float influenceMagnitude = Math.min(rollArrivalDeg, Math.abs(rollError)) / rollArrivalDeg;
        float desiredRollForce = maxRollCorrectionRate * influenceMagnitude * -Math.signum(rollError);
        double steeredRollForce = (double)desiredRollForce - ((Number)state.getCurrRollCorrectionForce().get()).doubleValue();
        if (Math.abs(steeredRollForce) > (double)maxRollForce) {
            steeredRollForce = Math.signum(steeredRollForce) * (double)maxRollForce;
        }
        SidedRidingState.set$default(state.getCurrRollCorrectionForce(), ((Number)state.getCurrRollCorrectionForce().get()).doubleValue() + steeredRollForce, false, 2, null);
        float maxPitchCorrectionRate = 5.0f * (float)Math.pow(RangesKt.coerceIn((double)(((Number)state.getNoInputTime().get()).doubleValue() - rollCorrectionTimer), (double)0.0, (double)1.0), 2) * 0.5f;
        float maxPitchForce = maxPitchCorrectionRate / 40.0f;
        float pitchArrivalDeg = 45.0f;
        float desiredPitch = 0.0f;
        if (state.getRideVelocity().get().length() < 0.1 && ((Number)state.getNoInputTime().get()).doubleValue() > rollCorrectionTimer) {
            float pitchErrror = Mth.wrapDegrees((float)BirdBehaviourKt.angleDifference(desiredPitch, controller.getPitch()));
            float arrivalInfluence = Math.min(pitchArrivalDeg, Math.abs(pitchErrror)) / pitchArrivalDeg;
            float desiredPitchForce = maxPitchCorrectionRate * arrivalInfluence * -Math.signum(pitchErrror);
            double steeredPitchForce = (double)desiredPitchForce - ((Number)state.getCurrPitchCorrectionForce().get()).doubleValue();
            if (Math.abs(steeredPitchForce) > (double)maxPitchForce) {
                steeredPitchForce = Math.signum(steeredPitchForce) * (double)maxPitchForce;
            }
            SidedRidingState.set$default(state.getCurrPitchCorrectionForce(), ((Number)state.getCurrPitchCorrectionForce().get()).doubleValue() + steeredPitchForce, false, 2, null);
        } else {
            SidedRidingState.set$default(state.getCurrPitchCorrectionForce(), MoLangMath.lerp(((Number)state.getCurrPitchCorrectionForce().get()).doubleValue(), 0.0, deltaTime * 0.98), false, 2, null);
        }
    }

    @Override
    @NotNull
    public Vec3 rotationOnMouseXY(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double mouseY, double mouseX, @NotNull SmoothDouble mouseYSmoother, @NotNull SmoothDouble mouseXSmoother, double sensitivity, double deltaTime) {
        double mouseModForce;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)mouseYSmoother, (String)"mouseYSmoother");
        Intrinsics.checkNotNullParameter((Object)mouseXSmoother, (String)"mouseXSmoother");
        if (Math.abs(mouseX) < 1.0 && Math.abs(mouseY) < 1.0 && (vehicle.isInWater() || vehicle.isUnderWater())) {
            SidedRidingState.set$default(state.getNoInputTime(), ((Number)state.getNoInputTime().get()).doubleValue() + deltaTime, false, 2, null);
        } else {
            SidedRidingState.set$default(state.getNoInputTime(), 0.0, false, 2, null);
        }
        if (!(vehicle instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        OrientationController controller = ((OrientationControllable)((Object)vehicle)).getOrientationController();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalDolphin().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) / 20.0;
        double boostingHandleDebuff = state.getBoosting().get() != false ? 0.5 : 1.0;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getMouseInputMult();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalDolphin().getMouseInputMult();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double mouseInputMult = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * boostingHandleDebuff;
        float rollDegreeDebuff = (float)Math.signum(mouseX) == Math.signum(controller.getRoll()) ? 1.0f - 0.9f * (float)Math.sqrt(Math.abs((float)Math.sin(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll()))))) * (float)Math.sqrt(Math.abs((float)Math.cos(controller.getPitch()))) : 1.0f;
        float smoothingSpeed = state.getHasBreached().get() != false ? 1.0f : 2.0f;
        float rolledOverPitchCorrection = (float)-8 * (float)Math.sqrt(Math.abs(Math.min((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll()))), 0.0f))) * (float)Math.pow((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getPitch()))), 2);
        double mouseXc = RangesKt.coerceIn((double)mouseX, (double)-45.0, (double)45.0) * mouseInputMult * (double)rollDegreeDebuff;
        double mouseYc = RangesKt.coerceIn((double)mouseY, (double)-45.0, (double)45.0) * mouseInputMult + (double)rolledOverPitchCorrection;
        double d = mouseModForce = state.getHasBreached().get() != false ? 0.15 : 0.1;
        if (state.getClearMouseSmoothers().get().booleanValue()) {
            mouseXSmoother.reset();
            mouseYSmoother.reset();
            SidedRidingState.set$default(state.getClearMouseSmoothers(), false, false, 2, null);
        }
        double xInput = mouseXSmoother.getNewDeltaValue(mouseXc * mouseModForce, deltaTime * (double)smoothingSpeed);
        double yInput = mouseYSmoother.getNewDeltaValue(mouseYc * mouseModForce, deltaTime * (double)smoothingSpeed);
        double currSpeed = state.getRideVelocity().get().length();
        double currHorzSpeed = state.getRideVelocity().get().horizontalDistance();
        double hoverSpeed = 0.2;
        float pitchDamping = (float)Math.pow(Math.abs((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getPitch())))), 2);
        double globalYaw = xInput * RangesKt.coerceIn((double)(1.0 - Math.sqrt(RidingBehaviour.Companion.scaleToRange$common(currSpeed, 0.0, topSpeed))), (double)0.0, (double)1.0);
        controller.rotateYaw(pitchDamping * (float)globalYaw);
        controller.rotateRoll((1.0f - pitchDamping) * (float)globalYaw);
        MoLangRuntime moLangRuntime3 = vehicle.getRuntime();
        Expression expression5 = settings.getHorizontalPitchExpr();
        if (expression5 == null) {
            Expression expression6 = this.getGlobalDolphin().getHorizontalPitchExpr();
            expression5 = expression6;
            Intrinsics.checkNotNull((Object)expression6);
        }
        double p = 1.0 - MoLangExtensionsKt.resolveDouble$default(moLangRuntime3, expression5, null, 2, null);
        double localPitch = yInput * (1.0 - (double)((float)Math.pow(Math.abs((float)Math.sin(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll())))), 2)) * p * (double)((float)Math.hypot(controller.getForwardVector().x, controller.getForwardVector().z)));
        double localYawForce = 0.0;
        double rollForce = 0.0;
        if (state.getHasBreached().get().booleanValue()) {
            localYawForce = xInput;
        } else {
            double pitchInfluencedRollCorrection = 0.0;
            float howRolledAmI = RangesKt.coerceIn((float)((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll()))) - 1.0f), (float)-1.0f, (float)0.0f) * (float)-2;
            double isInputtingTowardsRoll = Math.signum(xInput) == (double)Math.signum(controller.getRoll()) ? 1.0 : 0.0;
            double inputInRolledDir = isInputtingTowardsRoll == 1.0 ? 1.0 : -((double)RangesKt.coerceIn((float)((float)Math.cos(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll())))), (float)-1.0f, (float)0.0f));
            double rollDampen = 1.0 - (double)(RangesKt.coerceIn((float)howRolledAmI, (float)0.0f, (float)0.5f) * pitchDamping) * inputInRolledDir;
            rollForce = xInput * Math.sqrt(RangesKt.coerceIn((double)Math.abs(RidingBehaviour.Companion.scaleToRange$common(currHorzSpeed, 0.0, topSpeed)), (double)0.0, (double)1.0)) * rollDampen + pitchInfluencedRollCorrection;
            localYawForce = rollForce * (double)((float)Math.pow(Math.abs((float)Math.sin(AngleExtensionsKt.toRadians(Float.valueOf(controller.getRoll())))), 2)) * (double)pitchDamping * isInputtingTowardsRoll;
        }
        return new Vec3(localYawForce, localPitch, rollForce);
    }

    @Override
    public boolean canJump(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return false;
    }

    @Override
    public float setRideBar(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return ((Number)state.getStamina().get()).floatValue() / 1.0f;
    }

    @Override
    @NotNull
    public Vec3 jumpForce(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, int jumpStrength) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public double gravity(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, double regularGravity) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.0;
    }

    @Override
    public float rideFovMultiplier(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return state.getBoosting().get() != false ? 1.2f : 1.0f;
    }

    @Override
    public boolean useAngVelSmoothing(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public double inertia(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return !vehicle.isInWater() && !vehicle.isUnderWater() ? 1.0 : 0.1;
    }

    @Override
    public boolean shouldRoll(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    public boolean turnOffOnGround(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean dismountOnShift(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotatePokemonHead(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotateRiderHead(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    @NotNull
    public RideSoundSettingsList getRideSounds(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return settings.getRideSounds();
    }

    @Override
    @NotNull
    public DolphinState createDefaultState(@NotNull DolphinSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new DolphinState();
    }

    @Override
    @NotNull
    public ObjectValue<RidingBehaviour<DolphinSettings, DolphinState>> asMoLangValue(@NotNull DolphinSettings settings, @NotNull DolphinState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        ObjectValue<RidingBehaviour<DolphinSettings, DolphinState>> value = RidingBehaviour.super.asMoLangValue((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle);
        value.functions.put("boosting", arg_0 -> DolphinBehaviour.asMoLangValue$lambda$0(state, arg_0));
        value.functions.put("has_breached", arg_0 -> DolphinBehaviour.asMoLangValue$lambda$1(state, arg_0));
        return value;
    }

    private static final boolean poseProvider$lambda$0(DolphinSettings dolphinSettings, DolphinState state, PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)dolphinSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return Math.abs(state.getRideVelocity().get().length()) > 0.05;
    }

    private static final Object asMoLangValue$lambda$0(DolphinState $state, MoParams it) {
        return new DoubleValue($state.getBoosting().get());
    }

    private static final Object asMoLangValue$lambda$1(DolphinState $state, MoParams it) {
        return new DoubleValue($state.getHasBreached().get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/liquid/DolphinBehaviour$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "KEY", "Lnet/minecraft/resources/ResourceLocation;", "getKEY", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

