/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.land;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangMath;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.land.MinekartSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.land.MinekartState;
import com.cobblemon.mod.common.api.riding.posing.PoseOption;
import com.cobblemon.mod.common.api.riding.posing.PoseProvider;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 Y2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001YB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ7\u0010!\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J/\u0010#\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b#\u0010$J7\u0010'\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b'\u0010(J_\u0010/\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b/\u00100J/\u00101\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b1\u00102J/\u00103\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b3\u0010\u0017J7\u00106\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b6\u00107J/\u00109\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u00108\u001a\u00020%H\u0016\u00a2\u0006\u0004\b9\u0010:J/\u0010;\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b;\u0010\u0017J'\u0010<\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b<\u0010\u000fJ'\u0010=\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b=\u0010>J'\u0010?\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b?\u0010\u000fJ'\u0010@\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b@\u0010\u000fJ'\u0010A\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bA\u0010\u000fJ'\u0010B\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bB\u0010\u000fJ'\u0010C\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bC\u0010\u000fJ'\u0010E\u001a\u00020D2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010G\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bG\u0010HJ9\u0010J\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010I2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bJ\u0010KR\u001a\u0010M\u001a\u00020L8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bO\u0010PR\u0011\u0010S\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR#\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030T8\u0006\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\u00a8\u0006Z"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;", "<init>", "()V", "settings", "state", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "isActive", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lcom/cobblemon/mod/common/entity/PoseType;", "pose", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/entity/PoseType;", "Lnet/minecraft/world/entity/player/Player;", "driver", "", "speed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)F", "", "inAirCheck", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/phys/Vec2;", "rotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "Lnet/minecraft/world/phys/Vec3;", "input", "velocity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "calculateRideSpaceVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/phys/Vec3;", "", "deltaTime", "angRollVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Lnet/minecraft/world/phys/Vec3;", "mouseY", "mouseX", "Lnet/minecraft/util/SmoothDouble;", "mouseYSmoother", "mouseXSmoother", "sensitivity", "rotationOnMouseXY", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;DDLnet/minecraft/util/SmoothDouble;Lnet/minecraft/util/SmoothDouble;DD)Lnet/minecraft/world/phys/Vec3;", "canJump", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "setRideBar", "", "jumpStrength", "jumpForce", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/phys/Vec3;", "regularGravity", "gravity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;D)D", "rideFovMultiplier", "useAngVelSmoothing", "inertia", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)D", "shouldRoll", "turnOffOnGround", "dismountOnShift", "shouldRotatePokemonHead", "shouldRotateRiderHead", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "getRideSounds", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "createDefaultState", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "asMoLangValue", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "getGlobalMinekart", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartSettings;", "globalMinekart", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "poseProvider", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "getPoseProvider", "()Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nMinekartBehaviour.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinekartBehaviour.kt\ncom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartBehaviour\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,585:1\n1761#2,3:586\n*S KotlinDebug\n*F\n+ 1 MinekartBehaviour.kt\ncom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartBehaviour\n*L\n77#1:586,3\n*E\n"})
public final class MinekartBehaviour
implements RidingBehaviour<MinekartSettings, MinekartState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation key = KEY;
    @NotNull
    private final PoseProvider<MinekartSettings, MinekartState> poseProvider = new PoseProvider(PoseType.STAND).with(new PoseOption(PoseType.WALK, MinekartBehaviour::poseProvider$lambda$0));
    @NotNull
    private static final ResourceLocation KEY = MiscUtilsKt.cobblemonResource("land/minekart");

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @NotNull
    public final MinekartSettings getGlobalMinekart() {
        return CobblemonRideSettings.INSTANCE.getMinekart();
    }

    @Override
    @NotNull
    public RidingStyle getRidingStyle(@NotNull MinekartSettings settings, @NotNull MinekartState state) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RidingStyle.LAND;
    }

    @NotNull
    public final PoseProvider<MinekartSettings, MinekartState> getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public boolean isActive(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
            VoxelShape voxelShape = Shapes.create((AABB)vehicle.getBoundingBox());
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"create(...)");
            Iterable $this$any$iv = MiscUtilsKt.blockPositionsAsListRounded(voxelShape);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockState blockState;
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = vehicle.isInWater() || vehicle.isUnderWater() ? false : ((double)it.getY() == vehicle.position().y ? !(blockState = vehicle.level().getBlockState(it.below())).isAir() && blockState.getFluidState().isEmpty() : true);
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public PoseType pose(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return this.poseProvider.select((MinekartSettings)((RidingBehaviourSettings)settings), (MinekartState)((RidingBehaviourState)state), vehicle);
    }

    @Override
    public float speed(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getBoostLimit();
        if (expression == null) {
            Expression expression2 = this.getGlobalMinekart().getBoostLimit();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        float boostMax = MoLangExtensionsKt.resolveFloat$default(moLangRuntime, expression, null, 2, null);
        float boostPerSecond = 20.0f;
        float boostLoss = 40.0f;
        if (driver.jumping && driver.zza > 0.0f) {
            if (!state.getDrifting().get().booleanValue()) {
                if (!(driver.xxa == 0.0f)) {
                    SidedRidingState.set$default(state.getClockwiseDrift(), (double)Math.signum(driver.xxa) > 0.0, false, 2, null);
                    SidedRidingState.set$default(state.getTurnMomentum(), Float.valueOf(0.0f), false, 2, null);
                    SidedRidingState.set$default(state.getDrifting(), true, false, 2, null);
                    SidedRidingState.set$default(state.getBoost(), Float.valueOf(0.0f), false, 2, null);
                }
            } else {
                SidedRidingState.set$default(state.getBoost(), Float.valueOf(RangesKt.coerceIn((float)(((Number)state.getBoost().get()).floatValue() + boostPerSecond / 20.0f), (float)0.0f, (float)boostMax)), false, 2, null);
            }
        } else {
            if ((double)driver.zza <= 0.0 && !(((Number)state.getBoost().get()).floatValue() == 0.0f)) {
                SidedRidingState.set$default(state.getBoost(), Float.valueOf(0.0f), false, 2, null);
            } else if (((Number)state.getBoost().get()).floatValue() > 0.0f) {
                SidedRidingState.set$default(state.getBoost(), Float.valueOf(Math.max(((Number)state.getBoost().get()).floatValue() - boostLoss, 0.0f)), false, 2, null);
            }
            SidedRidingState.set$default(state.getDrifting(), false, false, 2, null);
        }
        this.inAirCheck(state, vehicle);
        return (float)driver.getDeltaMovement().length();
    }

    public final void inAirCheck(@NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        BlockPos posBelow = vehicle.blockPosition().below();
        BlockState blockStateBelow = vehicle.level().getBlockState(posBelow);
        boolean isAirOrLiquid = blockStateBelow.isAir() || !blockStateBelow.getFluidState().isEmpty();
        boolean canSupportEntity = blockStateBelow.isFaceSturdy((BlockGetter)vehicle.level(), posBelow, Direction.UP);
        boolean standingOnSolid = canSupportEntity && !isAirOrLiquid;
        boolean inAir = !(vehicle.getDeltaMovement().y == 0.0) && !standingOnSolid;
        SidedRidingState.set$default(state.getInAir(), inAir, false, 2, null);
    }

    @Override
    @NotNull
    public Vec2 rotation(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        double newMomentum = ((Number)state.getTurnMomentum().get()).floatValue();
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalMinekart().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getHandlingExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalMinekart().getHandlingExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double turningAcceleration = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * 1.5 / (double)20.0f / (double)20.0f * 4.0;
        double turnInput = (double)(driver.xxa * -1.0f) * turningAcceleration;
        double driftInput = turnInput * (double)0.25f;
        double lowSpeedTurnBoost = (Math.pow(RidingBehaviour.Companion.scaleToRange$common(vehicle.getDeltaMovement().horizontalDistance(), 0.0, topSpeed), 0.5) - (double)2.0f) * (double)-1.0f;
        double forcedDriftTurnMomentum = (double)4.0f * lowSpeedTurnBoost;
        double maxTurnMomentum = (double)3.0f * lowSpeedTurnBoost;
        double maxDriftMomentum = forcedDriftTurnMomentum * (double)0.6f;
        if (!state.getDrifting().get().booleanValue()) {
            if (Math.abs(newMomentum) <= maxTurnMomentum && !(turnInput == 0.0)) {
                newMomentum += turnInput;
                newMomentum = Math.min(Math.max(newMomentum, maxTurnMomentum * -1.0), maxTurnMomentum);
            } else {
                newMomentum = MoLangMath.lerp(newMomentum, 0.0, 0.15);
            }
            SidedRidingState.set$default(state.getTurnMomentum(), Float.valueOf((float)newMomentum), false, 2, null);
            driver.setYRot(driver.getYRot() + (float)newMomentum);
            return new Vec2(driver.getXRot(), vehicle.getYRot() + (float)newMomentum);
        }
        if (Math.abs(newMomentum) <= maxDriftMomentum && !(driftInput == 0.0)) {
            newMomentum += driftInput;
            newMomentum = Math.min(Math.max(newMomentum, maxDriftMomentum * -1.0), maxDriftMomentum);
        } else {
            newMomentum = MoLangMath.lerp(newMomentum, 0.0, 0.15);
        }
        double signedDriftTurn = state.getClockwiseDrift().get() != false ? forcedDriftTurnMomentum * (double)-1.0f : forcedDriftTurnMomentum;
        SidedRidingState.set$default(state.getTurnMomentum(), Float.valueOf((float)newMomentum), false, 2, null);
        driver.setYRot(driver.getYRot() + ((float)newMomentum + (float)signedDriftTurn));
        return new Vec2(driver.getXRot(), vehicle.getYRot() + (float)newMomentum + (float)signedDriftTurn);
    }

    @Override
    @NotNull
    public Vec3 velocity(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        SidedRidingState.set$default(state.getRideVelocity(), this.calculateRideSpaceVel(settings, state, vehicle, driver), false, 2, null);
        return state.getRideVelocity().get();
    }

    private final Vec3 calculateRideSpaceVel(MinekartSettings settings, MinekartState state, PokemonEntity vehicle, Player driver) {
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalMinekart().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double rideTopSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) * 0.6 * 2.0;
        double topSpeed = state.getDrifting().get() != false ? rideTopSpeed * 0.7 : rideTopSpeed;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getAccelerationExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalMinekart().getAccelerationExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double accel = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * 0.3 * (double)3 * 2.0;
        float driftAngle = 20.0f;
        Vec3 newVelocity = vehicle.getDeltaMovement();
        newVelocity = newVelocity.yRot(AngleExtensionsKt.toRadians(Float.valueOf(vehicle.getYRot())));
        if (state.getDrifting().get().booleanValue()) {
            float signedDriftAngle = state.getClockwiseDrift().get() != false ? driftAngle : driftAngle * -1.0f;
            newVelocity = newVelocity.yRot(AngleExtensionsKt.toRadians(Float.valueOf(signedDriftAngle)));
        }
        if (!(driver.zza == 0.0f) && (double)((Number)state.getStamina().get()).floatValue() > 0.0 && !state.getInAir().get().booleanValue()) {
            Double forwardInput;
            Number number = driver.zza > 0.0f && newVelocity.z > topSpeed ? Double.valueOf(0.0) : (forwardInput = driver.zza < 0.0f && newVelocity.z <= 0.0 ? (Number)0.0 : (Number)Float.valueOf(Math.signum(driver.zza)));
            if (!state.getDrifting().get().booleanValue() && !(((Number)state.getBoost().get()).floatValue() == 0.0f)) {
                forwardInput = 2.0;
            }
            double driftAccelBoost = state.getDrifting().get() != false ? 1.5 : 1.0;
            newVelocity = new Vec3(newVelocity.x, newVelocity.y, newVelocity.z + accel * ((Number)forwardInput).doubleValue() * driftAccelBoost);
        }
        if (vehicle.onGround()) {
            newVelocity = new Vec3(newVelocity.x, 0.0, newVelocity.z);
        } else {
            double gravity = 0.07350000000000001;
            double terminalVel = 2.0;
            double fallingForce = gravity - Math.signum(newVelocity.z) * gravity * (Math.abs(newVelocity.z) / 2.0);
            newVelocity = new Vec3(newVelocity.x, Math.max(newVelocity.y - fallingForce, -terminalVel), newVelocity.z);
        }
        double friction = 0.006;
        if (state.getDrifting().get().booleanValue()) {
            friction *= 0.5;
        }
        if (!state.getInAir().get().booleanValue()) {
            newVelocity = newVelocity.subtract(Math.min(friction, Math.abs(newVelocity.x)) * Math.signum(newVelocity.x), 0.0, Math.min(friction, Math.abs(newVelocity.z)) * Math.signum(newVelocity.z));
            if (!state.getDrifting().get().booleanValue()) {
                newVelocity = newVelocity.subtract(Math.min(friction * (double)10, Math.abs(newVelocity.x)) * Math.signum(newVelocity.x), 0.0, 0.0);
            }
        }
        if (state.getDrifting().get().booleanValue()) {
            float inverseSignedDriftAngle = state.getClockwiseDrift().get() != false ? driftAngle * -1.0f : driftAngle;
            newVelocity = newVelocity.yRot(AngleExtensionsKt.toRadians(Float.valueOf(inverseSignedDriftAngle)));
        }
        Vec3 vec3 = newVelocity;
        Intrinsics.checkNotNull((Object)vec3);
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 angRollVel(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 rotationOnMouseXY(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double mouseY, double mouseX, @NotNull SmoothDouble mouseYSmoother, @NotNull SmoothDouble mouseXSmoother, double sensitivity, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)mouseYSmoother, (String)"mouseYSmoother");
        Intrinsics.checkNotNullParameter((Object)mouseXSmoother, (String)"mouseXSmoother");
        if (!(driver instanceof OrientationControllable)) {
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            return vec3;
        }
        return new Vec3(0.0, mouseY, mouseX);
    }

    @Override
    public boolean canJump(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getCanJump();
        if (expression == null) {
            Expression expression2 = this.getGlobalMinekart().getCanJump();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        return MoLangExtensionsKt.resolveBoolean$default(moLangRuntime, expression, null, 2, null);
    }

    @Override
    public float setRideBar(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return 0.0f;
    }

    @Override
    @NotNull
    public Vec3 jumpForce(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, int jumpStrength) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public double gravity(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, double regularGravity) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.0;
    }

    @Override
    public float rideFovMultiplier(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        float fov = 1.0f;
        if (!state.getDrifting().get().booleanValue() && !(((Number)state.getBoost().get()).floatValue() == 0.0f)) {
            fov = 1.2f;
        }
        return fov;
    }

    @Override
    public boolean useAngVelSmoothing(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public double inertia(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 1.0;
    }

    @Override
    public boolean shouldRoll(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean turnOffOnGround(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean dismountOnShift(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotatePokemonHead(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotateRiderHead(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    @NotNull
    public RideSoundSettingsList getRideSounds(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return settings.getRideSounds();
    }

    @Override
    @NotNull
    public MinekartState createDefaultState(@NotNull MinekartSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new MinekartState();
    }

    @Override
    @NotNull
    public ObjectValue<RidingBehaviour<MinekartSettings, MinekartState>> asMoLangValue(@NotNull MinekartSettings settings, @NotNull MinekartState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        ObjectValue<RidingBehaviour<MinekartSettings, MinekartState>> value = RidingBehaviour.super.asMoLangValue((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle);
        value.functions.put("drifiting", arg_0 -> MinekartBehaviour.asMoLangValue$lambda$0(state, arg_0));
        value.functions.put("clockwise_drift", arg_0 -> MinekartBehaviour.asMoLangValue$lambda$1(state, arg_0));
        value.functions.put("boosting", arg_0 -> MinekartBehaviour.asMoLangValue$lambda$2(state, arg_0));
        value.functions.put("in_air", arg_0 -> MinekartBehaviour.asMoLangValue$lambda$3(state, arg_0));
        return value;
    }

    private static final boolean poseProvider$lambda$0(MinekartSettings minekartSettings, MinekartState state, PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)minekartSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"<unused var>");
        return Math.abs(state.getRideVelocity().get().horizontalDistance()) > 0.0;
    }

    private static final Object asMoLangValue$lambda$0(MinekartState $state, MoParams it) {
        return new DoubleValue($state.getDrifting().get());
    }

    private static final Object asMoLangValue$lambda$1(MinekartState $state, MoParams it) {
        return new DoubleValue($state.getClockwiseDrift().get());
    }

    private static final Object asMoLangValue$lambda$2(MinekartState $state, MoParams it) {
        return new DoubleValue($state.getBoost().get());
    }

    private static final Object asMoLangValue$lambda$3(MinekartState $state, MoParams it) {
        return new DoubleValue($state.getInAir().get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/land/MinekartBehaviour$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "KEY", "Lnet/minecraft/resources/ResourceLocation;", "getKEY", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

