/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviours;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeState;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies.CompositeRidingStrategy;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004JG\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/strategies/JumpStrategy;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/strategies/CompositeRidingStrategy;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeSettings;", "<init>", "()V", "settings", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeState;", "state", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "defaultState", "alternateState", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "Lnet/minecraft/world/entity/player/Player;", "driver", "Lnet/minecraft/world/phys/Vec3;", "input", "", "tick", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeState;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;", "defaultSettings", "", "shouldTransitionToDefault", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeState;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "alternativeSettings", "shouldTransitionToAlternative", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeState;Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourSettings;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
public final class JumpStrategy
implements CompositeRidingStrategy<CompositeSettings> {
    @NotNull
    public static final JumpStrategy INSTANCE = new JumpStrategy();
    @NotNull
    private static final ResourceLocation key = MiscUtilsKt.cobblemonResource("strategy/jump");

    private JumpStrategy() {
    }

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return key;
    }

    @Override
    public void tick(@NotNull CompositeSettings settings, @NotNull CompositeState state, @NotNull RidingBehaviourState defaultState, @NotNull RidingBehaviourState alternateState, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)defaultState, (String)"defaultState");
        Intrinsics.checkNotNullParameter((Object)alternateState, (String)"alternateState");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.shouldTransitionToDefault(state, settings.getDefaultBehaviour(), vehicle)) {
            this.transition(vehicle, settings, state, alternateState, defaultState, settings.getDefaultBehaviour());
        } else if (this.shouldTransitionToAlternative(state, settings.getAlternateBehaviour(), vehicle, driver)) {
            this.transition(vehicle, settings, state, defaultState, alternateState, settings.getAlternateBehaviour());
        }
    }

    private final boolean shouldTransitionToDefault(CompositeState state, RidingBehaviourSettings defaultSettings, PokemonEntity vehicle) {
        if (Intrinsics.areEqual((Object)state.getActiveBehaviour().get(), (Object)defaultSettings.getKey())) {
            return false;
        }
        if (!vehicle.onGround()) {
            return false;
        }
        if (((Number)state.getLastTransition().get()).longValue() + (long)5 >= vehicle.level().getGameTime()) {
            return false;
        }
        RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState> defaultBehaviour = RidingBehaviours.get(defaultSettings.getKey());
        return defaultBehaviour.isActive(defaultSettings, state.getDefaultBehaviourState(), vehicle);
    }

    private final boolean shouldTransitionToAlternative(CompositeState state, RidingBehaviourSettings alternativeSettings, PokemonEntity vehicle, Player driver) {
        if (Intrinsics.areEqual((Object)state.getActiveBehaviour().get(), (Object)alternativeSettings.getKey())) {
            return false;
        }
        if (!driver.jumping) {
            return false;
        }
        if (((Number)state.getLastTransition().get()).longValue() + (long)5 >= vehicle.level().getGameTime()) {
            return false;
        }
        RidingBehaviour<RidingBehaviourSettings, RidingBehaviourState> alternativeBehaviour = RidingBehaviours.get(alternativeSettings.getKey());
        return alternativeBehaviour.isActive(alternativeSettings, state.getAlternateBehaviourState(), vehicle);
    }
}

