/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies;

import com.cobblemon.mod.common.api.riding.behaviour.types.composite.CompositeSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies.CompositeRidingStrategy;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies.FallStrategy;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies.JumpStrategy;
import com.cobblemon.mod.common.api.riding.behaviour.types.composite.strategies.RunStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rR+\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/strategies/CompositeRidingStrategies;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/strategies/CompositeRidingStrategy;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/CompositeSettings;", "strategy", "", "register", "(Lnet/minecraft/resources/ResourceLocation;Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/strategies/CompositeRidingStrategy;)V", "get", "(Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/composite/strategies/CompositeRidingStrategy;", "", "strategies", "Ljava/util/Map;", "getStrategies", "()Ljava/util/Map;", "common"})
public final class CompositeRidingStrategies {
    @NotNull
    public static final CompositeRidingStrategies INSTANCE = new CompositeRidingStrategies();
    @NotNull
    private static final Map<ResourceLocation, CompositeRidingStrategy<? extends CompositeSettings>> strategies = new LinkedHashMap();

    private CompositeRidingStrategies() {
    }

    @NotNull
    public final Map<ResourceLocation, CompositeRidingStrategy<? extends CompositeSettings>> getStrategies() {
        return strategies;
    }

    public final void register(@NotNull ResourceLocation key, @NotNull CompositeRidingStrategy<? extends CompositeSettings> strategy) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(strategy, (String)"strategy");
        if (strategies.containsKey(key)) {
            throw new IllegalStateException(("Strategy already registered to key " + key).toString());
        }
        strategies.put(key, strategy);
    }

    @NotNull
    public final CompositeRidingStrategy<CompositeSettings> get(@NotNull ResourceLocation key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!strategies.containsKey(key)) {
            throw new IllegalStateException(("Strategy not registered to key " + key).toString());
        }
        CompositeRidingStrategy<CompositeSettings> compositeRidingStrategy = strategies.get(key);
        Intrinsics.checkNotNull(compositeRidingStrategy);
        return compositeRidingStrategy;
    }

    static {
        INSTANCE.register(RunStrategy.INSTANCE.getKey(), RunStrategy.INSTANCE);
        INSTANCE.register(JumpStrategy.INSTANCE.getKey(), JumpStrategy.INSTANCE);
        INSTANCE.register(FallStrategy.INSTANCE.getKey(), FallStrategy.INSTANCE);
    }
}

