/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.air;

import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourStateKt;
import com.cobblemon.mod.common.api.riding.behaviour.Side;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R0\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001e\u0010\u0016\"\u0004\b\u001f\u0010\u0018R(\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0014\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010\u0018R(\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010\u0014\u001a\u0004\b%\u0010\u0016\"\u0004\b&\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;", "<init>", "()V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "", "encode", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "decode", "reset", "copy", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;", "previous", "", "shouldSync", "(Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviourState;)Z", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "", "speed", "Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "getSpeed", "()Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;", "setSpeed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/SidedRidingState;)V", "isBoosting", "setBoosting", "Lnet/minecraft/world/phys/Vec3;", "kotlin.jvm.PlatformType", "boostVec", "getBoostVec", "setBoostVec", "", "boostTicks", "getBoostTicks", "setBoostTicks", "tooHigh", "getTooHigh", "setTooHigh", "common"})
public final class HoverState
extends RidingBehaviourState {
    @NotNull
    private SidedRidingState<Double> speed = RidingBehaviourStateKt.ridingState(0.0, Side.CLIENT);
    @NotNull
    private SidedRidingState<Boolean> isBoosting = RidingBehaviourStateKt.ridingState(false, Side.BOTH);
    @NotNull
    private SidedRidingState<Vec3> boostVec = RidingBehaviourStateKt.ridingState(Vec3.ZERO, Side.CLIENT);
    @NotNull
    private SidedRidingState<Integer> boostTicks = RidingBehaviourStateKt.ridingState(0, Side.CLIENT);
    @NotNull
    private SidedRidingState<Boolean> tooHigh = RidingBehaviourStateKt.ridingState(false, Side.CLIENT);

    @NotNull
    public final SidedRidingState<Double> getSpeed() {
        return this.speed;
    }

    public final void setSpeed(@NotNull SidedRidingState<Double> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.speed = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> isBoosting() {
        return this.isBoosting;
    }

    public final void setBoosting(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.isBoosting = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Vec3> getBoostVec() {
        return this.boostVec;
    }

    public final void setBoostVec(@NotNull SidedRidingState<Vec3> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.boostVec = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Integer> getBoostTicks() {
        return this.boostTicks;
    }

    public final void setBoostTicks(@NotNull SidedRidingState<Integer> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.boostTicks = sidedRidingState;
    }

    @NotNull
    public final SidedRidingState<Boolean> getTooHigh() {
        return this.tooHigh;
    }

    public final void setTooHigh(@NotNull SidedRidingState<Boolean> sidedRidingState) {
        Intrinsics.checkNotNullParameter(sidedRidingState, (String)"<set-?>");
        this.tooHigh = sidedRidingState;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.encode(buffer);
        buffer.writeDouble(((Number)this.speed.get()).doubleValue());
        buffer.writeBoolean(this.isBoosting.get().booleanValue());
        buffer.writeBoolean(this.tooHigh.get().booleanValue());
    }

    @Override
    public void decode(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.decode(buffer);
        this.speed.set(buffer.readDouble(), true);
        this.isBoosting.set(buffer.readBoolean(), true);
        this.tooHigh.set(buffer.readBoolean(), true);
    }

    @Override
    public void reset() {
        super.reset();
        this.speed.set(0.0, true);
        this.isBoosting.set(false, true);
        this.boostVec.set(Vec3.ZERO, true);
        this.boostTicks.set(0, true);
        this.tooHigh.set(false, true);
    }

    @Override
    @NotNull
    public HoverState copy() {
        HoverState hoverState;
        HoverState it = hoverState = new HoverState();
        boolean bl = false;
        it.getRideVelocity().set(this.getRideVelocity().get(), true);
        it.getStamina().set(this.getStamina().get(), true);
        it.isBoosting.set(this.isBoosting.get(), true);
        it.boostVec.set(this.boostVec.get(), true);
        it.boostTicks.set(this.boostTicks.get(), true);
        it.tooHigh.set(this.tooHigh.get(), true);
        return hoverState;
    }

    @Override
    public boolean shouldSync(@NotNull RidingBehaviourState previous) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        if (!(previous instanceof HoverState)) {
            return false;
        }
        if (((HoverState)previous).isBoosting.get().booleanValue() != this.isBoosting.get().booleanValue()) {
            return true;
        }
        return super.shouldSync(previous);
    }
}

