/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.behaviour.types.air;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.cobblemon.mod.common.CobblemonRideSettings;
import com.cobblemon.mod.common.api.molang.ObjectValue;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.SidedRidingState;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.HoverSettings;
import com.cobblemon.mod.common.api.riding.behaviour.types.air.HoverState;
import com.cobblemon.mod.common.api.riding.posing.PoseOption;
import com.cobblemon.mod.common.api.riding.posing.PoseProvider;
import com.cobblemon.mod.common.api.riding.sound.RideSoundSettingsList;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.MoLangExtensionsKt;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 a2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001aB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J7\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001f\u0010\u001eJ/\u0010!\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J/\u0010#\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020 H\u0016\u00a2\u0006\u0004\b#\u0010\"J/\u0010%\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020 H\u0016\u00a2\u0006\u0004\b%\u0010&J-\u0010'\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020 \u00a2\u0006\u0004\b'\u0010(J7\u0010)\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b)\u0010*J/\u0010+\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b+\u0010,J7\u0010/\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b/\u00100J_\u00107\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-2\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b7\u00108J/\u00109\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b9\u0010:J/\u0010;\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b;\u0010\u0017J7\u0010>\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010=\u001a\u00020<H\u0016\u00a2\u0006\u0004\b>\u0010?J/\u0010A\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020-H\u0016\u00a2\u0006\u0004\bA\u0010BJ/\u0010C\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\bC\u0010\u0017J'\u0010D\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bD\u0010\u000fJ'\u0010E\u001a\u00020-2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bE\u0010FJ'\u0010G\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bG\u0010\u000fJ'\u0010H\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bH\u0010\u000fJ'\u0010I\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bI\u0010\u000fJ'\u0010J\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bJ\u0010\u000fJ'\u0010K\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bK\u0010\u000fJ'\u0010M\u001a\u00020L2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010O\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bO\u0010PJ9\u0010R\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00010Q2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\bR\u0010SR\u001a\u0010U\u001a\u00020T8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010XR\u0011\u0010[\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR#\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\\8\u0006\u00a2\u0006\f\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`\u00a8\u0006b"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/RidingBehaviour;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;", "Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;", "<init>", "()V", "settings", "state", "Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "getRidingStyle", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;)Lcom/cobblemon/mod/common/api/riding/RidingStyle;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "vehicle", "", "isActive", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "Lcom/cobblemon/mod/common/entity/PoseType;", "pose", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/entity/PoseType;", "Lnet/minecraft/world/entity/player/Player;", "driver", "", "speed", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)F", "Lnet/minecraft/world/phys/Vec3;", "input", "", "tick", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)V", "checkTooHigh", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "tickStamina", "Lnet/minecraft/world/entity/LivingEntity;", "updatePassengerRotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)V", "clampPassengerRotation", "Lnet/minecraft/world/phys/Vec2;", "rotation", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec2;", "calcRotAmount", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/LivingEntity;)F", "velocity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "calculateRideSpaceVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/phys/Vec3;", "", "deltaTime", "angRollVel", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;D)Lnet/minecraft/world/phys/Vec3;", "mouseY", "mouseX", "Lnet/minecraft/util/SmoothDouble;", "mouseYSmoother", "mouseXSmoother", "sensitivity", "rotationOnMouseXY", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;DDLnet/minecraft/util/SmoothDouble;Lnet/minecraft/util/SmoothDouble;DD)Lnet/minecraft/world/phys/Vec3;", "canJump", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;)Z", "setRideBar", "", "jumpStrength", "jumpForce", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/phys/Vec3;", "regularGravity", "gravity", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;D)D", "rideFovMultiplier", "useAngVelSmoothing", "inertia", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)D", "shouldRoll", "turnOffOnGround", "dismountOnShift", "shouldRotatePokemonHead", "shouldRotateRiderHead", "Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "getRideSounds", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/riding/sound/RideSoundSettingsList;", "createDefaultState", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;)Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;", "Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "asMoLangValue", "(Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverState;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Lcom/cobblemon/mod/common/api/molang/ObjectValue;", "Lnet/minecraft/resources/ResourceLocation;", "key", "Lnet/minecraft/resources/ResourceLocation;", "getKey", "()Lnet/minecraft/resources/ResourceLocation;", "getGlobalHover", "()Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverSettings;", "globalHover", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "poseProvider", "Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "getPoseProvider", "()Lcom/cobblemon/mod/common/api/riding/posing/PoseProvider;", "Companion", "common"})
public final class HoverBehaviour
implements RidingBehaviour<HoverSettings, HoverState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation key = KEY;
    @NotNull
    private final PoseProvider<HoverSettings, HoverState> poseProvider = new PoseProvider(PoseType.STAND).with(new PoseOption(PoseType.WALK, HoverBehaviour::poseProvider$lambda$0));
    @NotNull
    private static final ResourceLocation KEY = MiscUtilsKt.cobblemonResource("air/hover");

    @Override
    @NotNull
    public ResourceLocation getKey() {
        return this.key;
    }

    @NotNull
    public final HoverSettings getGlobalHover() {
        return CobblemonRideSettings.INSTANCE.getHover();
    }

    @Override
    @NotNull
    public RidingStyle getRidingStyle(@NotNull HoverSettings settings, @NotNull HoverState state) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RidingStyle.AIR;
    }

    @NotNull
    public final PoseProvider<HoverSettings, HoverState> getPoseProvider() {
        return this.poseProvider;
    }

    @Override
    public boolean isActive(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return !vehicle.isUnderWater();
    }

    @Override
    @NotNull
    public PoseType pose(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return this.poseProvider.select((HoverSettings)((RidingBehaviourSettings)settings), (HoverState)((RidingBehaviourState)state), vehicle);
    }

    @Override
    public float speed(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return (float)((Number)state.getSpeed().get()).doubleValue();
    }

    @Override
    public void tick(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (vehicle.level().isClientSide) {
            this.tickStamina(settings, state, vehicle);
            this.checkTooHigh(settings, state, vehicle);
        }
    }

    public final void checkTooHigh(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getJumpExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalHover().getJumpExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double heightLimit = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null);
        Vec3 pos = vehicle.position();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null || (localPlayer = localPlayer.level()) == null) {
            return;
        }
        LocalPlayer level = localPlayer;
        BlockHitResult hit = level.clip(new ClipContext(pos, pos.subtract(0.0, heightLimit, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)vehicle));
        SidedRidingState.set$default(state.getTooHigh(), hit.getType() == HitResult.Type.MISS, false, 2, null);
    }

    public final void tickStamina(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getInfiniteStamina();
        if (expression == null) {
            Expression expression2 = this.getGlobalHover().getInfiniteStamina();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        if (MoLangExtensionsKt.resolveBoolean$default(moLangRuntime, expression, null, 2, null)) {
            return;
        }
        float stam = ((Number)state.getStamina().get()).floatValue();
        double d = 1.0f;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getStaminaExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalHover().getStaminaExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        float stamDrainRate = (float)(d / MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null)) / 20.0f;
        double d2 = 1.0f;
        MoLangRuntime moLangRuntime3 = vehicle.getRuntime();
        Expression expression5 = settings.getStamReplenishTimeSeconds();
        if (expression5 == null) {
            Expression expression6 = this.getGlobalHover().getStamReplenishTimeSeconds();
            expression5 = expression6;
            Intrinsics.checkNotNull((Object)expression6);
        }
        float stamReplenishRate = (float)(d2 / MoLangExtensionsKt.resolveDouble$default(moLangRuntime3, expression5, null, 2, null)) / 20.0f;
        float newStam = state.getTooHigh().get() != false ? Math.max(0.0f, stam - stamDrainRate) : Math.min(1.0f, stam + stamReplenishRate);
        SidedRidingState.set$default(state.getStamina(), Float.valueOf(newStam), false, 2, null);
    }

    @Override
    public void updatePassengerRotation(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
    }

    @Override
    public void clampPassengerRotation(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
    }

    @Override
    @NotNull
    public Vec2 rotation(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        float turnAmount = this.calcRotAmount(settings, state, vehicle, driver);
        SidedRidingState<Vec3> sidedRidingState = state.getRideVelocity();
        Vec3 vec3 = state.getRideVelocity().get().yRot(AngleExtensionsKt.toRadians(Float.valueOf(turnAmount)));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"yRot(...)");
        SidedRidingState.set$default(sidedRidingState, vec3, false, 2, null);
        return new Vec2(driver.getXRot(), vehicle.getYRot() + turnAmount);
    }

    public final float calcRotAmount(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull LivingEntity driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalHover().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) / 20.0;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getHandlingExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalHover().getHandlingExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double handling = MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) / 20.0;
        float maxYawDiff = 90.0f;
        float rotDiff = RangesKt.coerceIn((float)Mth.wrapDegrees((float)(driver.getYRot() - vehicle.getYRot())), (float)(-maxYawDiff), (float)maxYawDiff);
        float rotDiffInfl = (float)Math.sqrt(Math.abs(rotDiff / maxYawDiff)) * Math.signum(rotDiff);
        float turnRate = (float)handling * rotDiffInfl;
        turnRate -= turnRate * 0.5f * (float)Math.pow(RangesKt.coerceIn((double)RidingBehaviour.Companion.scaleToRange$common(vehicle.getDeltaMovement().length(), 0.0, topSpeed), (double)0.0, (double)1.0), 2);
        float turnSpeed = turnRate;
        float rotAmount = RangesKt.coerceIn((float)turnSpeed, (float)(-Math.abs(rotDiff)), (float)Math.abs(rotDiff));
        return rotAmount;
    }

    @Override
    @NotNull
    public Vec3 velocity(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, @NotNull Vec3 input) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Vec3 retVel = this.calculateRideSpaceVel(settings, state, vehicle, driver);
        SidedRidingState.set$default(state.getRideVelocity(), retVel, false, 2, null);
        return retVel;
    }

    private final Vec3 calculateRideSpaceVel(HoverSettings settings, HoverState state, PokemonEntity vehicle, Player driver) {
        Vec3 vec3;
        MoLangRuntime moLangRuntime = vehicle.getRuntime();
        Expression expression = settings.getSpeedExpr();
        if (expression == null) {
            Expression expression2 = this.getGlobalHover().getSpeedExpr();
            expression = expression2;
            Intrinsics.checkNotNull((Object)expression2);
        }
        double topSpeed = MoLangExtensionsKt.resolveDouble$default(moLangRuntime, expression, null, 2, null) / 20.0;
        MoLangRuntime moLangRuntime2 = vehicle.getRuntime();
        Expression expression3 = settings.getAccelerationExpr();
        if (expression3 == null) {
            Expression expression4 = this.getGlobalHover().getAccelerationExpr();
            expression3 = expression4;
            Intrinsics.checkNotNull((Object)expression4);
        }
        double accel = topSpeed / (MoLangExtensionsKt.resolveDouble$default(moLangRuntime2, expression3, null, 2, null) * 20.0);
        Vec3 newVelocity = state.getRideVelocity().get();
        if (vehicle.verticalCollision || vehicle.horizontalCollision) {
            SidedRidingState.set$default(state.getSpeed(), vehicle.getDeltaMovement().length(), false, 2, null);
        }
        double vertInput = ((Number)state.getStamina().get()).floatValue() == 0.0f ? -1.0 : (driver.jumping ? 1.0 : (driver.isShiftKeyDown() ? -1.0 : 0.0));
        Vec3 inputVel = new Vec3((double)Math.signum(driver.xxa), vertInput, (double)Math.signum(driver.zza)).normalize();
        double frictionConst = 0.02;
        Vec3 frictionForce = newVelocity.scale(-1.0).scale(frictionConst);
        double frictionApplied = !(inputVel.lengthSqr() == 0.0) ? 1.0 - 0.5 * (1.0 + -1.0 * inputVel.normalize().dot(frictionForce.normalize())) : 1.0;
        frictionForce = frictionForce.scale(frictionApplied);
        Vec3 vec32 = newVelocity.add(frictionForce);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        newVelocity = vec32;
        double strafeDebuff = 0.5;
        Vec3 vehicleForwardVec = new Vec3(0.0, 0.0, 1.0);
        Vec3 playerForwardVec = inputVel;
        double inputStrength = accel - accel * strafeDebuff * (1.0 - RangesKt.coerceIn((double)vehicleForwardVec.dot(playerForwardVec), (double)0.0, (double)1.0));
        inputVel = inputVel.scale(inputStrength);
        Vec3 vec33 = newVelocity.add(inputVel);
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
        newVelocity = vec33;
        SidedRidingState.set$default(state.getSpeed(), Math.min(topSpeed, newVelocity.length()), false, 2, null);
        if (newVelocity.length() > topSpeed) {
            Vec3 vec34 = newVelocity.normalize().scale(topSpeed);
            vec3 = vec34;
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"scale(...)");
        } else {
            vec3 = newVelocity;
        }
        newVelocity = vec3;
        return newVelocity;
    }

    @Override
    @NotNull
    public Vec3 angRollVel(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 rotationOnMouseXY(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, double mouseY, double mouseX, @NotNull SmoothDouble mouseYSmoother, @NotNull SmoothDouble mouseXSmoother, double sensitivity, double deltaTime) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)mouseYSmoother, (String)"mouseYSmoother");
        Intrinsics.checkNotNullParameter((Object)mouseXSmoother, (String)"mouseXSmoother");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public boolean canJump(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return false;
    }

    @Override
    public float setRideBar(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return ((Number)state.getStamina().get()).floatValue() / 1.0f;
    }

    @Override
    @NotNull
    public Vec3 jumpForce(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver, int jumpStrength) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        return vec3;
    }

    @Override
    public double gravity(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, double regularGravity) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 0.0;
    }

    @Override
    public float rideFovMultiplier(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle, @NotNull Player driver) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        return state.isBoosting().get() != false ? 1.1f : 1.0f;
    }

    @Override
    public boolean useAngVelSmoothing(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public double inertia(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return 1.0;
    }

    @Override
    public boolean shouldRoll(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean turnOffOnGround(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean dismountOnShift(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotatePokemonHead(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return false;
    }

    @Override
    public boolean shouldRotateRiderHead(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return true;
    }

    @Override
    @NotNull
    public RideSoundSettingsList getRideSounds(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        return settings.getRideSounds();
    }

    @Override
    @NotNull
    public HoverState createDefaultState(@NotNull HoverSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new HoverState();
    }

    @Override
    @NotNull
    public ObjectValue<RidingBehaviour<HoverSettings, HoverState>> asMoLangValue(@NotNull HoverSettings settings, @NotNull HoverState state, @NotNull PokemonEntity vehicle) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        ObjectValue<RidingBehaviour<HoverSettings, HoverState>> value = RidingBehaviour.super.asMoLangValue((RidingBehaviourSettings)settings, (RidingBehaviourState)state, vehicle);
        value.functions.put("boosting", arg_0 -> HoverBehaviour.asMoLangValue$lambda$0(state, arg_0));
        value.functions.put("boost_ticks", arg_0 -> HoverBehaviour.asMoLangValue$lambda$1(state, arg_0));
        value.functions.put("too_high", arg_0 -> HoverBehaviour.asMoLangValue$lambda$2(state, arg_0));
        return value;
    }

    private static final boolean poseProvider$lambda$0(HoverSettings hoverSettings, HoverState state, PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)hoverSettings, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"<unused var>");
        return Math.abs(state.getRideVelocity().get().length()) > 0.01;
    }

    private static final Object asMoLangValue$lambda$0(HoverState $state, MoParams it) {
        return new DoubleValue($state.isBoosting().get());
    }

    private static final Object asMoLangValue$lambda$1(HoverState $state, MoParams it) {
        return new DoubleValue($state.getBoostTicks().get());
    }

    private static final Object asMoLangValue$lambda$2(HoverState $state, MoParams it) {
        return new DoubleValue($state.getTooHigh().get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/cobblemon/mod/common/api/riding/behaviour/types/air/HoverBehaviour$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "KEY", "Lnet/minecraft/resources/ResourceLocation;", "getKEY", "()Lnet/minecraft/resources/ResourceLocation;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

