/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.pokeball.catching.calculators;

import com.cobblemon.mod.common.api.pokeball.catching.CaptureContext;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.PokedexManager;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J'\u0010\b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/cobblemon/mod/common/api/pokeball/catching/calculators/PokedexStatusCaptureInfluencer;", "", "Lnet/minecraft/world/entity/LivingEntity;", "thrower", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "target", "Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "context", "influence", "(Lnet/minecraft/world/entity/LivingEntity;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;)Lcom/cobblemon/mod/common/api/pokeball/catching/CaptureContext;", "common"})
public interface PokedexStatusCaptureInfluencer {
    @NotNull
    default public CaptureContext influence(@NotNull LivingEntity thrower, @NotNull PokemonEntity target, @NotNull CaptureContext context) {
        Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.isSuccessfulCapture()) {
            return context;
        }
        ServerPlayer serverPlayer = thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null;
        if (serverPlayer == null) {
            return context;
        }
        ServerPlayer player = serverPlayer;
        PokedexManager pokedex = PlayerExtensionsKt.pokedex(player);
        ResourceLocation speciesId = target.getPokemon().getSpecies().getResourceIdentifier();
        String formName = target.getPokemon().getForm().getName();
        boolean hasCaughtStatus = pokedex.getOrCreateSpeciesRecord(speciesId).getOrCreateFormRecord(formName).getKnowledge() == PokedexEntryProgress.CAUGHT;
        return hasCaughtStatus ? new CaptureContext(1, true, true) : context;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static CaptureContext influence(@NotNull PokedexStatusCaptureInfluencer $this, @NotNull LivingEntity thrower, @NotNull PokemonEntity target, @NotNull CaptureContext context) {
            Intrinsics.checkNotNullParameter((Object)thrower, (String)"thrower");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return $this.influence(thrower, target, context);
        }
    }
}

