/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.npc;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.value.MoValue;
import com.cobblemon.mod.common.api.ai.SleepDepth;
import com.cobblemon.mod.common.api.ai.config.BehaviourConfig;
import com.cobblemon.mod.common.api.ai.config.task.TaskConfig;
import com.cobblemon.mod.common.api.conditional.RegistryLikeCondition;
import com.cobblemon.mod.common.api.data.JsonDataRegistry;
import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.ItemDropMethod;
import com.cobblemon.mod.common.api.entity.EntityDimensionsAdapter;
import com.cobblemon.mod.common.api.molang.ExpressionLike;
import com.cobblemon.mod.common.api.npc.NPCClass;
import com.cobblemon.mod.common.api.npc.NPCPartyProvider;
import com.cobblemon.mod.common.api.npc.configuration.MoLangConfigVariable;
import com.cobblemon.mod.common.api.npc.configuration.NPCInteractConfiguration;
import com.cobblemon.mod.common.api.npc.variation.NPCVariationProvider;
import com.cobblemon.mod.common.api.npc.variation.WeightedAspect;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.api.spawning.TimeRange;
import com.cobblemon.mod.common.net.messages.client.data.NPCRegistrySyncPacket;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.adapters.ActivityAdapter;
import com.cobblemon.mod.common.util.adapters.BehaviourConfigAdapter;
import com.cobblemon.mod.common.util.adapters.BiomeLikeConditionAdapter;
import com.cobblemon.mod.common.util.adapters.BlockLikeConditionAdapter;
import com.cobblemon.mod.common.util.adapters.BoxAdapter;
import com.cobblemon.mod.common.util.adapters.DropEntryAdapter;
import com.cobblemon.mod.common.util.adapters.ExpressionAdapter;
import com.cobblemon.mod.common.util.adapters.ExpressionLikeAdapter;
import com.cobblemon.mod.common.util.adapters.ExpressionOrEntityVariableAdapter;
import com.cobblemon.mod.common.util.adapters.IdentifierAdapter;
import com.cobblemon.mod.common.util.adapters.IntRangeAdapter;
import com.cobblemon.mod.common.util.adapters.IntRangesAdapter;
import com.cobblemon.mod.common.util.adapters.ItemLikeConditionAdapter;
import com.cobblemon.mod.common.util.adapters.MemoryModuleTypeAdapter;
import com.cobblemon.mod.common.util.adapters.MoValueAdapter;
import com.cobblemon.mod.common.util.adapters.NPCClassAdapter;
import com.cobblemon.mod.common.util.adapters.NPCInteractConfigurationAdapter;
import com.cobblemon.mod.common.util.adapters.NPCPartyProviderAdapter;
import com.cobblemon.mod.common.util.adapters.NPCScriptAdapter;
import com.cobblemon.mod.common.util.adapters.NPCVariationProviderAdapter;
import com.cobblemon.mod.common.util.adapters.NbtCompoundAdapter;
import com.cobblemon.mod.common.util.adapters.PokemonPropertiesAdapterKt;
import com.cobblemon.mod.common.util.adapters.SensorTypeAdapter;
import com.cobblemon.mod.common.util.adapters.TaskConfigAdapter;
import com.cobblemon.mod.common.util.adapters.TranslatedTextAdapter;
import com.cobblemon.mod.common.util.adapters.WeightedAspectAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J#\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\u00020 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020%8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R \u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u00058\u0016X\u0096D\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R \u00104\u001a\b\u0012\u0004\u0012\u00020\u0000038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R0\u0010:\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000208j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0002`98\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R \u0010@\u001a\b\u0012\u0004\u0012\u00020\u00020<8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b?\u0010\u0004\u001a\u0004\b=\u0010>\u00a8\u0006A"}, d2={"Lcom/cobblemon/mod/common/api/npc/NPCClasses;", "Lcom/cobblemon/mod/common/api/data/JsonDataRegistry;", "Lcom/cobblemon/mod/common/api/npc/NPCClass;", "<init>", "()V", "", "name", "getByName", "(Ljava/lang/String;)Lcom/cobblemon/mod/common/api/npc/NPCClass;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "getByIdentifier", "(Lnet/minecraft/resources/ResourceLocation;)Lcom/cobblemon/mod/common/api/npc/NPCClass;", "", "count", "()I", "random", "()Lcom/cobblemon/mod/common/api/npc/NPCClass;", "dummy", "", "data", "", "reload", "(Ljava/util/Map;)V", "Lnet/minecraft/server/level/ServerPlayer;", "player", "sync", "(Lnet/minecraft/server/level/ServerPlayer;)V", "id", "Lnet/minecraft/resources/ResourceLocation;", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/server/packs/PackType;", "type", "Lnet/minecraft/server/packs/PackType;", "getType", "()Lnet/minecraft/server/packs/PackType;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Lcom/google/gson/reflect/TypeToken;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "getTypeToken", "()Lcom/google/gson/reflect/TypeToken;", "resourcePath", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "observable", "Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "getObservable", "()Lcom/cobblemon/mod/common/api/reactive/SimpleObservable;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "npcClassesByIdentifier", "Ljava/util/HashMap;", "", "getClasses", "()Ljava/util/Collection;", "getClasses$annotations", "classes", "common"})
@SourceDebugExtension(value={"SMAP\nNPCClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCClasses.kt\ncom/cobblemon/mod/common/api/npc/NPCClasses\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,162:1\n216#2,2:163\n*S KotlinDebug\n*F\n+ 1 NPCClasses.kt\ncom/cobblemon/mod/common/api/npc/NPCClasses\n*L\n149#1:163,2\n*E\n"})
public final class NPCClasses
implements JsonDataRegistry<NPCClass> {
    @NotNull
    public static final NPCClasses INSTANCE = new NPCClasses();
    @NotNull
    private static final ResourceLocation id = MiscUtilsKt.cobblemonResource("npc");
    @NotNull
    private static final PackType type = PackType.SERVER_DATA;
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final TypeToken<NPCClass> typeToken;
    @NotNull
    private static final String resourcePath;
    @NotNull
    private static final SimpleObservable<NPCClasses> observable;
    @NotNull
    private static final HashMap<ResourceLocation, NPCClass> npcClassesByIdentifier;

    private NPCClasses() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return id;
    }

    @Override
    @NotNull
    public PackType getType() {
        return type;
    }

    @Override
    @NotNull
    public Gson getGson() {
        return gson;
    }

    @Override
    @NotNull
    public TypeToken<NPCClass> getTypeToken() {
        return typeToken;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        return resourcePath;
    }

    @NotNull
    public SimpleObservable<NPCClasses> getObservable() {
        return observable;
    }

    @NotNull
    public static final Collection<NPCClass> getClasses() {
        Collection<NPCClass> collection = npcClassesByIdentifier.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @JvmStatic
    public static /* synthetic */ void getClasses$annotations() {
    }

    @Nullable
    public final NPCClass getByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return NPCClasses.getByIdentifier(MiscUtilsKt.cobblemonResource(name));
    }

    @JvmStatic
    @Nullable
    public static final NPCClass getByIdentifier(@NotNull ResourceLocation identifier2) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        return npcClassesByIdentifier.get(identifier2);
    }

    @JvmStatic
    public static final int count() {
        return npcClassesByIdentifier.size();
    }

    @JvmStatic
    @NotNull
    public static final NPCClass random() {
        Collection<NPCClass> collection = npcClassesByIdentifier.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return (NPCClass)CollectionsKt.random(collection, (Random)((Random)Random.Default));
    }

    @NotNull
    public final NPCClass dummy() {
        NPCClass dummy2 = new NPCClass();
        dummy2.setId(MiscUtilsKt.cobblemonResource("dummy"));
        return dummy2;
    }

    @Override
    public void reload(@NotNull Map<ResourceLocation, NPCClass> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        npcClassesByIdentifier.clear();
        Map<ResourceLocation, NPCClass> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, NPCClass>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, NPCClass> element$iv;
            Map.Entry<ResourceLocation, NPCClass> entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation identifier2 = entry.getKey();
            NPCClass species = entry.getValue();
            species.setId(identifier2);
            if (Intrinsics.areEqual((Object)species.getResourceIdentifier().getPath(), (Object)"dummy")) {
                species.setResourceIdentifier(identifier2);
            }
            ((Map)npcClassesByIdentifier).put(identifier2, species);
        }
    }

    @Override
    public void sync(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Collection<NPCClass> collection = npcClassesByIdentifier.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        new NPCRegistrySyncPacket(CollectionsKt.toList((Iterable)collection)).sendToPlayer(player);
    }

    private static final TimeRange gson$lambda$0(IntRange[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TimeRange(Arrays.copyOf(it, it.length));
    }

    static {
        Type[] typeArray = new Type[]{Expression.class, MoLangConfigVariable.class};
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter((Type)((Object)EntityDimensions.class), (Object)EntityDimensionsAdapter.INSTANCE).registerTypeAdapter((Type)((Object)AABB.class), (Object)BoxAdapter.INSTANCE).registerTypeAdapter((Type)((Object)IntRange.class), (Object)IntRangeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)PokemonProperties.class), (Object)PokemonPropertiesAdapterKt.getPokemonPropertiesShortAdapter()).registerTypeAdapter((Type)((Object)ResourceLocation.class), (Object)IdentifierAdapter.INSTANCE).registerTypeAdapter((Type)((Object)TimeRange.class), new IntRangesAdapter<TimeRange>(TimeRange.Companion.getTimeRanges(), NPCClasses::gson$lambda$0)).registerTypeAdapter((Type)((Object)ItemDropMethod.class), ItemDropMethod.Companion.getAdapter()).registerTypeAdapter((Type)((Object)SleepDepth.class), SleepDepth.Companion.getAdapter()).registerTypeAdapter((Type)((Object)DropEntry.class), (Object)DropEntryAdapter.INSTANCE).registerTypeAdapter((Type)((Object)CompoundTag.class), (Object)NbtCompoundAdapter.INSTANCE).registerTypeAdapter((Type)((Object)NPCPartyProvider.class), (Object)NPCPartyProviderAdapter.INSTANCE).registerTypeAdapter((Type)((Object)NPCInteractConfiguration.class), (Object)NPCInteractConfigurationAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Expression.class), (Object)ExpressionAdapter.INSTANCE).registerTypeAdapter((Type)((Object)ExpressionLike.class), (Object)ExpressionLikeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)NPCVariationProvider.class), (Object)NPCVariationProviderAdapter.INSTANCE).registerTypeAdapter((Type)((Object)MoValue.class), (Object)MoValueAdapter.INSTANCE).registerTypeAdapter((Type)((Object)NPCClass.class), (Object)NPCClassAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Activity.class), (Object)ActivityAdapter.INSTANCE).registerTypeAdapter((Type)((Object)Component.class), (Object)TranslatedTextAdapter.INSTANCE).registerTypeAdapter((Type)((Object)WeightedAspect.class), (Object)WeightedAspectAdapter.INSTANCE).registerTypeAdapter((Type)((Object)MemoryModuleType.class), (Object)MemoryModuleTypeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)SensorType.class), (Object)SensorTypeAdapter.INSTANCE).registerTypeAdapter((Type)((Object)BehaviourConfig.class), (Object)BehaviourConfigAdapter.INSTANCE).registerTypeAdapter((Type)((Object)TaskConfig.class), (Object)TaskConfigAdapter.INSTANCE).registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)Either.class)), (Type[])typeArray).getType(), (Object)ExpressionOrEntityVariableAdapter.INSTANCE);
        typeArray = new Type[]{Biome.class};
        GsonBuilder gsonBuilder2 = gsonBuilder.registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)RegistryLikeCondition.class)), (Type[])typeArray).getType(), (Object)BiomeLikeConditionAdapter.INSTANCE);
        typeArray = new Type[]{Block.class};
        GsonBuilder gsonBuilder3 = gsonBuilder2.registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)RegistryLikeCondition.class)), (Type[])typeArray).getType(), (Object)BlockLikeConditionAdapter.INSTANCE);
        typeArray = new Type[]{Item.class};
        GsonBuilder gsonBuilder4 = gsonBuilder3.registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)RegistryLikeCondition.class)), (Type[])typeArray).getType(), (Object)ItemLikeConditionAdapter.INSTANCE);
        typeArray = new Type[]{ResourceLocation.class, ExpressionLike.class};
        Gson gson2 = gsonBuilder4.registerTypeAdapter(TypeToken.getParameterized((Type)((Type)((Object)Either.class)), (Type[])typeArray).getType(), (Object)NPCScriptAdapter.INSTANCE).disableHtmlEscaping().enableComplexMapKeySerialization().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson2, (String)"create(...)");
        gson = gson2;
        TypeToken typeToken = TypeToken.get(NPCClass.class);
        Intrinsics.checkNotNullExpressionValue((Object)typeToken, (String)"get(...)");
        NPCClasses.typeToken = typeToken;
        resourcePath = "npcs";
        observable = new SimpleObservable();
        npcClassesByIdentifier = new HashMap();
    }
}

