/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.fossil;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0014\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR*\u0010\u0003\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u00028\u0006@@X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/cobblemon/mod/common/api/fossil/Fossil;", "Lnet/minecraft/util/StringRepresentable;", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "result", "", "Lnet/minecraft/advancements/critereon/ItemPredicate;", "fossils", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;Ljava/util/List;)V", "", "getSerializedName", "()Ljava/lang/String;", "Lnet/minecraft/network/chat/MutableComponent;", "getName", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/world/item/ItemStack;", "ingredients", "", "matchesIngredients", "(Ljava/util/List;)Z", "matchesIngredientsSubSet", "itemStack", "isIngredient", "(Lnet/minecraft/world/item/ItemStack;)Z", "Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "getResult", "()Lcom/cobblemon/mod/common/api/pokemon/PokemonProperties;", "Ljava/util/List;", "getFossils", "()Ljava/util/List;", "value", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "setIdentifier$common", "(Lnet/minecraft/resources/ResourceLocation;)V", "common"})
@SourceDebugExtension(value={"SMAP\nFossil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fossil.kt\ncom/cobblemon/mod/common/api/fossil/Fossil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1740#2,2:80\n1761#2,3:82\n1742#2:85\n1740#2,2:86\n1788#2,4:88\n1788#2,4:92\n1742#2:96\n1761#2,3:97\n*S KotlinDebug\n*F\n+ 1 Fossil.kt\ncom/cobblemon/mod/common/api/fossil/Fossil\n*L\n49#1:80,2\n50#1:82,3\n49#1:85\n64#1:86,2\n65#1:88,4\n66#1:92,4\n64#1:96\n76#1:97,3\n*E\n"})
public final class Fossil
implements StringRepresentable {
    @NotNull
    private final PokemonProperties result;
    @NotNull
    private final List<ItemPredicate> fossils;
    @NotNull
    private transient ResourceLocation identifier;

    public Fossil(@NotNull ResourceLocation identifier2, @NotNull PokemonProperties result, @NotNull List<ItemPredicate> fossils) {
        Intrinsics.checkNotNullParameter((Object)identifier2, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(fossils, (String)"fossils");
        this.result = result;
        this.fossils = fossils;
        this.identifier = identifier2;
    }

    @NotNull
    public final PokemonProperties getResult() {
        return this.result;
    }

    @NotNull
    public final List<ItemPredicate> getFossils() {
        return this.fossils;
    }

    @NotNull
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public final void setIdentifier$common(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.identifier = resourceLocation;
    }

    @NotNull
    public String getSerializedName() {
        String string = this.identifier.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final MutableComponent getName() {
        MutableComponent mutableComponent = Component.translatable((String)(this.identifier.getNamespace() + ".fossil." + this.identifier.getPath() + ".name"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return mutableComponent;
    }

    public final boolean matchesIngredients(@NotNull List<ItemStack> ingredients) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
            if (this.fossils.size() != ingredients.size()) {
                return false;
            }
            Iterable $this$all$iv = this.fossils;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block7: {
                        ItemPredicate fossil = (ItemPredicate)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = ingredients;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                ItemStack it = (ItemStack)element$iv2;
                                boolean bl4 = false;
                                if (!fossil.test(it)) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean matchesIngredientsSubSet(@NotNull List<ItemStack> ingredients) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
            if (this.fossils.size() < ingredients.size()) {
                return false;
            }
            Iterable $this$all$iv = ingredients;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int n;
                    int count$iv;
                    int n2;
                    ItemStack ingredient = (ItemStack)element$iv;
                    boolean bl2 = false;
                    Iterable $this$count$iv = ingredients;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n2 = 0;
                    } else {
                        count$iv = 0;
                        for (Object element$iv2 : $this$count$iv) {
                            ItemStack item = (ItemStack)element$iv2;
                            boolean bl3 = false;
                            if (!ingredient.is(item.getItemHolder()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n2 = count$iv;
                    }
                    $this$count$iv = this.fossils;
                    int n3 = n2;
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        v2 = 0;
                    } else {
                        count$iv = 0;
                        for (Object element$iv2 : $this$count$iv) {
                            ItemPredicate fossil = (ItemPredicate)element$iv2;
                            boolean bl4 = false;
                            if (!fossil.test(ingredient) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        v2 = n = count$iv;
                    }
                    if (n3 <= n) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isIngredient(@NotNull ItemStack itemStack) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Iterable $this$any$iv = this.fossils;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ItemPredicate it = (ItemPredicate)element$iv;
                    boolean bl2 = false;
                    if (!it.test(itemStack)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

